/* ----- encode/761x4591, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_761x4591_checksums[] = {
  "a4335af893b0527c4fc259b93b8660d5f29b012ee4111218c11654b27fc6c61b",
  "263487954e950086897d620987560480180d05b8564ad7744b53b24c5e0f7aaa",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_761x4591_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_761x4591_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_761x4591_ITEMBYTES

static void *storage_encode_761x4591_s;
static unsigned char *test_encode_761x4591_s;
static void *storage_encode_761x4591_x;
static unsigned char *test_encode_761x4591_x;
static void *storage_encode_761x4591_s2;
static unsigned char *test_encode_761x4591_s2;
static void *storage_encode_761x4591_x2;
static unsigned char *test_encode_761x4591_x2;

#define precomputed_encode_761x4591_NUM 4

static const unsigned char precomputed_encode_761x4591_s[precomputed_encode_761x4591_NUM][crypto_encode_STRBYTES] = {
  {168,250,236,177,67,17,240,45,61,118,74,195,241,65,119,231,136,228,199,34,8,77,249,114,86,91,248,98,240,69,50,182,138,169,208,140,103,247,132,104,59,1,214,179,34,244,24,224,208,66,16,26,164,64,239,14,20,219,8,210,246,229,163,163,138,148,154,219,182,85,188,153,177,147,254,174,198,49,80,16,187,50,2,171,203,14,149,107,203,179,143,52,226,254,250,90,34,208,165,87,69,184,42,81,168,129,34,240,165,170,243,189,149,189,123,99,116,73,231,66,148,65,107,8,24,255,58,38,36,82,106,112,59,29,238,145,4,121,125,205,182,253,163,189,53,150,242,110,64,69,64,243,229,73,91,120,247,152,88,237,126,164,81,69,5,38,65,48,50,251,50,113,221,33,28,163,205,244,162,212,50,128,208,255,131,97,167,246,59,144,173,55,97,70,136,221,185,182,159,104,139,22,97,28,60,224,18,98,144,26,162,122,139,13,153,30,5,243,146,232,140,1,226,57,36,29,207,28,93,228,201,154,110,183,161,15,42,97,127,17,125,229,4,88,88,28,58,19,6,238,186,238,145,30,135,234,243,8,115,242,17,115,181,88,188,193,243,132,13,20,243,138,192,171,153,206,251,215,169,174,147,36,8,75,78,60,234,86,116,164,132,177,35,166,193,86,54,111,254,129,126,179,94,58,59,193,219,88,62,109,134,149,86,125,121,46,242,127,220,183,53,246,115,174,16,148,64,188,235,203,179,225,108,110,186,97,123,103,233,129,152,154,158,101,242,250,168,2,200,74,243,180,172,88,96,192,252,156,55,225,38,136,115,115,102,20,170,213,227,215,177,62,25,58,73,98,108,157,9,32,159,110,233,17,116,183,236,191,182,3,62,210,30,234,53,188,202,148,33,129,64,161,75,202,27,29,70,235,101,176,100,138,208,147,57,24,169,243,27,142,154,188,22,24,239,125,65,250,130,189,236,202,53,56,139,210,13,198,121,33,231,21,9,9,243,199,221,103,236,211,88,69,129,2,152,210,247,116,28,182,69,19,159,111,244,103,181,12,78,230,48,82,111,0,252,95,254,251,46,175,188,66,3,91,116,122,117,101,24,59,197,236,206,205,196,219,226,98,181,107,171,230,233,112,16,208,88,53,40,165,85,45,70,181,114,139,191,211,96,124,74,211,237,209,254,9,230,13,237,212,235,5,218,209,28,32,47,242,17,145,46,117,111,121,79,182,99,224,227,197,193,202,167,56,227,25,222,60,125,66,102,5,41,251,100,104,166,11,202,72,46,234,140,137,30,164,161,13,253,249,112,151,188,207,81,178,111,71,197,49,136,150,254,51,253,8,255,250,76,212,83,188,172,199,196,103,242,55,6,172,176,63,232,127,170,218,212,48,90,127,169,158,89,137,85,42,43,112,210,61,56,39,167,52,194,228,186,68,239,34,92,20,49,188,125,36,173,81,216,148,167,239,162,43,181,76,24,233,184,136,96,134,17,4,185,69,105,114,109,18,155,188,187,56,216,121,118,181,35,183,102,63,9,16,130,173,165,194,255,65,69,207,153,43,224,106,110,255,37,161,162,64,250,254,205,34,145,191,195,145,14,206,103,3,71,6,72,119,243,125,33,45,26,71,83,89,13,147,248,65,95,250,133,121,174,41,148,244,98,194,105,112,180,215,129,193,111,64,59,20,235,92,93,49,156,138,117,22,249,47,60,49,255,223,25,33,83,103,133,146,169,80,0,219,220,142,113,244,142,95,145,1,112,23,208,38,81,241,50,210,180,163,8,30,18,133,255,15,147,144,53,196,36,248,244,142,217,106,203,81,158,114,150,149,179,27,240,157,138,120,200,240,95,94,194,66,98,167,151,173,245,148,149,80,1,88,196,57,208,121,170,26,109,174,14,241,152,115,146,84,194,145,199,72,130,15,182,202,203,191,12,207,3,192,188,108,107,182,10,152,192,10,151,184,189,3,136,212,219,191,220,109,43,91,247,41,16,143,45,122,123,240,6,105,67,5,196,196,96,232,62,221,168,216,172,31,127,16,247,88,167,11,219,126,126,44,183,190,179,45,255,21,115,119,97,84,85,47,101,173,245,86,138,229,196,219,140,105,242,234,203,202,76,204,32,148,237,26,234,244,17,172,9,199,32,208,222,158,152,123,200,132,129,126,199,46,208,88,57,111,114,204,147,64,232,52,78,59,150,183,106,252,138,128,236,17,123,82,54,11,51,219,111,116,73,118,191,83,114,42,43,143,20,211,30,78,143,37,185,245,69,195,133,182,187,34,40,114,158,203,127,124,231,105,124,113,197,217,4,108,150,187,229,16,13,94,209,47,247,93,183,144,63,150,108,32,221,5,19,13,94,131,115,106,171,38,150,33,147,206,19,97,70,107,101,191,214,239,9,111,123,41,174,162,250,47,14,117,165,208,156,177,198,113,28,100,177,215,15,140,204,41,98,16,128,222,81,32,251,129,63,178,131,95,202,25,86,160,241,54,22,144,13,227,58,169,121,106,116,54,131,162,7,50,72,225,178,164,34,190,73,238,231,63,138,53,142,141,114,15,23,232,83,64,30,194,2,98,137,201,105,186,179,198,111,197,153,14},
  {78,120,221,48,93,30,217,143,79,35,98,91,191,214,47,201,190,118,64,171,156,35,172,104,119,25,52,41,3,201,181,193,68,0,105,42,2,226,89,106,7,76,201,157,60,101,198,67,255,49,21,202,230,20,254,156,165,196,149,96,203,212,133,212,115,137,1,186,214,22,147,8,105,223,247,68,126,73,91,245,4,108,231,54,89,40,29,181,225,83,189,62,32,51,90,219,110,147,230,221,53,57,27,205,250,184,34,142,23,57,152,187,242,167,104,183,182,10,102,167,25,151,139,78,242,183,197,61,185,57,120,134,54,214,164,132,172,142,238,173,190,157,187,180,236,122,149,170,73,150,183,38,99,151,35,70,140,240,37,87,245,8,9,98,54,235,106,20,157,133,224,13,121,111,221,118,125,120,203,220,239,144,224,6,126,6,188,3,128,166,221,114,80,145,133,141,139,0,140,74,226,21,18,250,222,114,195,135,247,187,75,141,2,247,88,247,189,186,84,61,109,60,24,94,17,169,226,222,41,140,130,44,66,7,254,160,1,106,224,94,227,190,190,21,63,229,52,129,99,236,206,92,196,63,27,202,222,134,72,180,35,143,20,113,44,227,160,136,162,122,31,100,152,98,55,62,13,43,54,129,86,99,78,134,41,41,9,207,194,44,49,144,98,207,106,213,69,33,172,142,131,92,192,120,119,111,112,3,129,46,249,98,157,58,105,229,180,226,221,65,59,39,44,236,93,246,214,38,185,21,15,48,148,148,77,139,70,9,210,60,221,200,123,12,56,23,228,91,195,113,249,34,27,144,166,79,108,247,249,203,110,84,210,8,240,176,221,66,80,88,254,213,121,39,204,6,49,19,152,30,12,244,206,11,87,150,220,111,71,105,127,210,60,170,94,117,166,98,177,9,12,248,52,202,20,25,34,201,250,164,173,140,55,151,245,154,154,153,250,29,34,92,196,173,25,219,208,3,109,244,177,222,27,214,66,134,123,212,215,234,182,187,180,96,45,253,177,242,157,142,130,53,239,178,237,253,143,247,101,38,119,98,13,51,78,30,89,57,106,101,118,224,236,206,58,62,236,123,56,34,165,190,3,72,168,161,103,144,154,218,12,236,236,228,125,227,98,153,213,37,215,91,42,81,112,128,69,15,250,116,226,157,3,122,14,253,83,224,28,49,167,196,113,230,202,1,123,60,49,231,169,95,84,62,16,136,214,187,98,166,89,141,83,209,87,12,36,18,61,217,163,124,187,226,119,168,188,195,231,33,114,209,73,178,53,170,84,77,235,216,3,178,71,217,226,119,224,56,153,184,135,69,127,168,204,207,124,25,11,139,224,108,104,158,248,89,143,137,144,197,0,181,4,238,231,144,139,134,205,77,103,217,74,245,125,12,189,58,93,142,134,75,103,207,143,204,202,21,31,115,223,233,208,155,21,210,65,135,120,220,40,104,218,25,79,62,15,143,194,28,102,86,215,11,225,129,108,164,174,39,30,74,65,246,89,80,221,175,58,198,18,49,188,168,93,89,4,153,224,72,190,218,32,153,145,210,66,132,47,201,111,129,25,204,20,149,80,210,11,183,165,117,75,149,193,18,202,97,122,25,56,13,116,97,17,252,198,178,10,176,139,236,149,7,41,200,122,38,158,19,78,51,201,37,243,221,112,115,58,165,92,77,35,189,149,46,159,125,124,210,169,186,41,60,110,82,105,238,0,203,232,147,208,241,95,157,26,138,31,236,181,186,252,242,153,211,222,178,167,135,72,210,57,106,183,194,196,218,211,119,5,126,110,144,202,236,68,111,16,246,228,49,11,99,187,169,78,93,218,116,119,42,91,231,201,183,124,68,153,121,146,128,216,79,96,227,76,24,185,171,11,10,251,39,212,63,170,157,186,254,247,40,108,66,192,102,33,89,113,63,185,7,94,90,188,222,214,215,65,59,68,143,162,213,243,135,16,177,219,80,206,1,230,195,38,30,220,12,184,173,9,58,60,37,45,97,8,240,247,39,84,14,29,254,16,70,102,192,193,21,110,100,67,180,121,114,157,247,234,242,246,80,224,45,53,91,35,160,58,165,47,176,166,6,251,108,65,94,252,122,218,64,235,121,158,199,43,65,113,182,119,134,120,78,222,94,0,254,211,156,8,188,193,68,20,187,254,21,118,111,189,174,109,181,172,180,229,112,203,179,141,221,167,82,102,245,31,254,116,109,4,125,125,106,22,62,135,202,8,94,174,243,233,87,142,164,174,37,165,131,235,107,146,16,224,99,7,113,174,109,252,244,211,5,203,78,38,70,31,13,133,43,248,96,198,194,122,29,242,245,73,93,138,45,147,63,60,70,122,7,239,48,209,161,85,37,40,49,218,34,135,149,164,16,82,28,13,222,18,105,12,32,17,206,145,121,249,255,121,104,58,223,148,174,108,32,214,75,150,127,154,26,138,25,166,158,114,132,172,20,214,141,206,99,126,55,241,75,25,189,208,168,167,227,252,244,247,178,183,76,221,217,212,218,69,106,59,198,122,66,18,25,254,126,31,130,8,158,153,48,216,67,228,53,98,80,133,196,82,194,73,31,206,190,213,183,199,243,152,29,161,51,253,153,120,33,34,3},
  {167,76,52,119,125,238,198,24,138,172,185,3,160,3,129,99,121,218,86,183,176,140,155,194,203,151,76,52,167,61,219,89,55,9,105,168,183,101,212,248,16,179,44,241,169,74,182,182,137,203,37,236,193,106,114,189,79,131,10,222,41,181,251,19,6,17,74,173,101,163,135,132,177,20,171,162,7,74,103,175,165,98,177,15,92,201,155,114,3,65,243,194,169,47,253,97,178,68,91,241,205,71,221,202,187,88,216,41,47,63,242,21,130,242,2,138,185,241,85,19,174,192,66,174,221,112,81,139,239,96,71,189,128,187,180,187,229,159,171,2,71,210,28,116,156,24,140,250,57,16,195,171,90,80,92,217,46,4,143,122,144,227,90,22,96,44,173,204,197,73,162,70,192,141,17,192,150,18,237,6,202,117,52,102,208,187,160,138,164,156,34,239,22,144,5,191,164,78,114,240,129,221,100,24,1,50,146,223,65,129,132,231,190,92,99,159,111,52,167,8,202,253,255,194,5,233,29,243,47,222,234,230,70,83,98,227,79,225,64,42,226,146,98,14,2,84,226,173,179,110,17,44,228,85,247,174,47,210,183,66,201,170,20,86,192,58,51,193,91,127,219,145,196,215,92,196,208,34,104,35,76,124,123,182,134,40,98,50,111,72,90,65,239,253,208,87,77,170,111,207,83,174,239,197,97,200,227,184,27,77,252,207,158,164,105,103,65,230,174,240,180,154,148,71,151,58,211,250,69,3,199,242,70,43,235,132,14,19,194,197,155,125,5,124,98,70,201,87,175,235,130,167,115,195,31,99,121,60,247,230,7,144,111,99,99,168,87,3,86,110,40,244,47,220,31,144,144,134,124,148,67,107,42,235,116,120,239,21,95,17,243,105,100,26,205,191,117,218,7,215,213,152,233,19,61,234,133,176,127,87,120,252,190,152,228,167,71,46,219,192,45,174,235,237,1,252,103,130,163,59,89,86,185,249,14,50,180,57,4,42,89,156,116,192,171,119,249,46,153,207,133,31,63,175,254,177,41,151,225,82,142,170,79,89,235,177,65,129,155,72,127,236,111,166,209,36,57,79,20,159,113,149,27,241,134,244,59,52,25,4,25,156,139,2,8,206,194,214,130,188,62,168,176,39,67,183,244,9,225,110,72,173,0,187,115,245,201,12,206,153,196,126,74,16,37,255,145,198,73,84,84,77,56,37,184,143,176,211,184,205,219,239,225,177,177,194,210,163,144,172,105,174,22,146,38,166,116,97,149,115,151,59,180,164,229,157,22,222,172,221,168,152,123,214,38,254,53,130,40,104,248,175,54,64,241,243,131,15,156,51,125,22,253,9,139,106,149,198,167,122,29,26,178,97,3,192,36,168,185,183,243,181,135,147,61,202,126,231,60,55,144,57,166,97,116,153,255,0,9,132,161,34,207,138,22,2,64,237,117,32,203,185,170,235,111,110,119,111,192,244,202,240,172,162,28,223,252,33,112,111,89,33,109,159,156,59,0,231,74,3,32,4,255,102,90,11,172,36,153,72,60,76,41,111,107,165,170,205,237,236,230,135,101,145,82,245,73,141,21,34,217,224,124,91,188,202,220,224,219,237,18,172,229,242,225,237,40,99,233,151,159,235,224,216,123,145,197,48,139,79,224,38,29,205,163,48,102,251,253,245,184,117,72,223,88,193,84,52,237,189,79,161,102,220,143,242,152,126,5,206,51,136,227,215,21,220,149,17,65,185,108,149,207,181,145,171,156,167,42,59,140,27,171,31,214,141,191,40,34,146,38,208,211,195,104,43,79,144,180,70,100,6,71,207,234,228,213,87,187,185,158,143,104,238,123,48,139,31,118,205,97,155,27,114,212,254,58,78,144,166,230,126,57,38,158,11,48,55,242,74,206,197,158,14,156,69,7,172,74,19,217,155,1,174,204,103,129,165,59,243,167,251,205,201,215,85,100,102,45,117,205,227,207,27,255,219,90,242,89,13,97,40,209,254,32,138,20,228,8,51,77,161,150,211,24,31,147,76,16,124,165,49,151,253,170,69,148,67,131,242,132,215,7,18,33,54,32,208,120,82,251,190,87,223,185,118,112,43,150,19,62,59,82,95,106,157,175,105,35,254,152,15,72,138,77,145,139,192,189,224,243,146,28,46,232,235,128,221,193,134,202,231,199,68,166,48,64,146,122,1,199,140,72,149,100,166,251,167,220,104,205,59,213,114,108,43,89,12,53,184,96,68,164,50,89,131,217,118,68,13,143,33,191,23,127,100,111,156,55,239,36,234,237,222,183,107,127,45,231,87,71,213,37,185,236,190,148,210,137,244,80,245,30,177,99,19,243,250,1,80,200,30,172,14,67,148,231,173,250,105,198,172,80,109,107,165,184,157,217,60,95,73,176,40,81,238,128,47,170,25,192,28,141,183,146,110,158,218,66,227,20,187,26,238,223,18,106,124,197,44,37,125,27,191,50,143,211,185,136,26,39,112,24,222,161,109,5,245,182,228,54,116,45,63,220,74,198,17,110,244,204,60,54,55,38,182,138,148,27,97,187,214,63,125,171,53,43,79,85,191,7,143,152,86,148,177,175,140,156,0,110,124,178,135,189,197,8,4},
  {188,87,56,102,238,173,212,87,178,242,25,53,255,143,221,67,219,226,226,94,221,58,51,255,221,44,222,247,193,103,130,1,9,132,166,219,186,124,153,244,153,48,162,26,248,105,82,168,22,120,49,151,52,166,163,9,117,247,196,83,142,123,250,248,196,222,215,179,43,246,204,234,132,118,102,65,27,148,113,12,217,156,186,120,32,40,174,42,12,131,40,198,38,251,254,211,138,116,53,207,101,109,172,216,89,91,187,101,239,52,170,47,145,130,47,189,77,189,23,116,158,29,205,50,172,214,58,117,165,76,117,101,17,26,14,2,254,160,76,106,237,191,191,230,195,175,163,127,116,175,74,25,78,137,199,158,119,32,118,85,42,108,33,143,177,167,145,203,18,195,75,120,43,4,165,132,82,81,67,53,4,120,97,220,54,39,251,188,202,72,140,73,190,41,48,31,196,157,83,20,91,7,245,121,130,234,85,14,63,176,167,87,50,165,212,48,3,35,111,46,107,84,54,164,10,141,22,204,93,78,34,157,161,235,35,114,156,75,65,244,39,230,94,209,212,253,187,80,179,245,41,157,173,222,62,237,98,81,225,135,38,92,83,43,48,130,71,199,210,128,228,193,47,63,96,229,143,162,192,158,35,69,183,245,117,113,252,127,98,73,180,110,62,147,165,51,117,53,212,166,30,34,228,214,7,31,154,131,166,146,31,67,209,164,254,86,90,218,81,169,205,101,192,83,176,163,255,176,164,32,104,27,29,208,92,222,162,36,120,63,93,89,30,114,208,37,90,229,250,100,146,232,148,252,93,211,218,162,15,65,89,165,245,183,58,32,98,89,41,151,37,66,63,210,41,188,147,254,22,255,186,117,146,125,229,109,214,171,139,216,145,2,251,45,8,129,40,176,220,131,150,68,186,222,129,97,49,253,130,203,40,41,251,149,233,29,148,222,133,208,248,131,242,83,21,106,177,198,122,227,227,81,124,16,41,90,138,155,108,58,105,102,186,130,240,116,26,227,155,99,165,134,206,201,194,137,217,57,115,244,53,210,13,84,90,24,241,214,232,8,212,213,157,218,130,3,39,16,111,105,157,172,228,77,253,12,204,63,173,122,13,83,193,157,1,195,69,180,253,213,106,238,12,184,107,98,186,145,255,77,202,152,85,94,97,232,188,134,76,52,1,255,144,145,157,142,41,165,184,1,14,135,166,92,244,187,150,202,197,172,212,176,75,13,245,145,21,16,20,48,182,243,85,232,36,45,108,173,10,115,172,180,1,93,184,140,185,180,50,234,130,3,86,160,109,82,120,200,53,170,88,136,23,44,201,150,128,62,139,195,220,15,147,151,150,214,90,195,6,133,230,104,40,49,255,123,26,69,241,105,158,103,65,222,223,244,77,36,248,92,234,84,119,44,12,24,92,2,201,31,24,67,23,30,169,142,45,131,171,24,238,165,89,61,5,224,142,62,176,45,16,92,63,108,184,177,137,94,61,146,217,118,77,137,193,103,247,244,178,0,57,212,39,197,252,43,230,218,152,106,155,46,174,224,2,35,67,95,240,100,20,150,59,186,192,254,65,10,149,177,126,26,124,64,180,86,35,102,227,215,90,18,70,243,22,173,194,55,121,223,89,53,121,208,118,136,73,135,47,217,187,124,21,43,240,141,253,237,101,67,109,206,1,22,86,175,194,95,32,210,2,40,178,148,240,227,83,19,172,95,142,16,121,142,193,28,134,200,235,102,129,211,8,221,33,208,68,48,244,125,133,146,205,49,168,188,213,51,27,207,97,177,157,77,247,126,238,70,203,196,72,107,156,201,215,171,3,73,195,10,136,78,213,189,242,220,221,131,58,62,98,147,111,198,77,55,52,214,161,255,229,84,224,168,238,14,231,199,149,113,184,124,218,65,47,54,181,69,179,33,5,148,250,167,112,107,62,64,28,5,174,102,52,0,237,113,241,77,241,123,193,1,181,153,109,73,238,189,204,106,95,207,234,210,155,206,86,56,32,201,127,24,190,113,4,56,16,35,96,44,237,144,140,161,83,161,214,128,88,201,131,10,154,244,100,58,36,188,174,109,205,188,170,125,91,214,26,122,139,61,99,124,76,223,206,90,146,154,13,106,39,138,204,43,28,205,84,103,245,240,223,43,138,10,137,171,190,112,71,101,171,120,191,66,135,203,68,13,215,244,81,156,229,215,38,237,155,64,158,174,134,134,169,25,188,0,254,110,237,91,14,43,42,75,249,46,157,27,244,113,14,204,239,54,192,1,76,98,22,3,115,197,94,142,201,240,76,45,147,108,224,42,245,136,48,101,218,245,19,95,192,131,48,151,88,219,65,26,165,220,124,187,160,186,22,113,133,59,142,220,3,34,9,136,12,174,63,142,55,138,244,219,87,77,120,176,49,165,46,170,143,201,134,242,246,85,201,163,253,181,111,8,123,75,213,227,58,46,69,187,126,199,83,30,176,197,211,184,171,40,111,94,112,202,205,131,49,72,181,222,155,242,141,135,93,80,61,12,86,100,116,178,136,3,101,86,23,60,48,63,103,51,116,140,115,173,58,53,239,44,227,1,193,182,117,71,199,237,103,234,240,199,194,199,224,154,49,22},
} ;

static const int16_t precomputed_encode_761x4591_x[precomputed_encode_761x4591_NUM][crypto_encode_ITEMS] = {
  {-2396,17868,7883,4479,-12168,117,27840,-26784,-6796,30295,7126,-13988,-32597,22186,-19937,-21064,-1185,-31753,27595,23124,-11680,-12952,-24435,26084,1792,-15206,28762,13010,22823,6743,-13063,21735,-31744,10918,18331,-15189,-32430,-15925,32542,20618,-11161,14844,32726,24976,-28261,1657,30824,22752,13588,28564,4142,974,12894,22954,-29413,13564,-21070,22606,-24363,-8563,-14252,-5106,-17324,-2511,8365,2179,29813,12731,18413,18775,-15318,8990,18109,-17444,-4006,-10964,-14503,19187,11280,13648,-15939,14962,-13034,-28060,23070,9395,-11037,-27650,9171,23832,-3812,-20403,-12496,19198,-24851,-19629,-9710,20608,-32571,19632,18223,-19494,-204,-32518,15361,-2727,-26388,-28742,-10163,-24392,-16336,-21763,68,14927,-25013,4960,-5401,-1837,24767,-25112,-3472,-13140,15761,10838,-8954,-24930,241,27095,10213,4673,-31488,-23866,5028,-8087,29317,-3657,14416,-31716,26473,-27460,20387,20397,12085,-7166,-16204,-27361,-20242,-21556,16740,15220,-12602,-30026,-30653,-30706,20108,23473,110,-21865,30381,2197,-8925,13029,15490,-21327,20006,7841,-29834,-25483,-27204,-6790,10549,-27037,25881,22796,-6314,-15318,-28048,-32253,-15229,-5535,-9819,-3885,10645,12805,7867,-6328,-3258,9535,-20391,-12850,28312,-24885,19947,-15750,19469,-21819,22364,-11005,-30925,-14620,18111,24196,-18467,-21172,-31787,2713,-9518,-32176,-31286,15146,24406,-13564,11427,-29912,12732,8067,9794,19453,6004,15442,-4154,20010,6774,26852,6405,-2463,5427,-19532,32454,-31639,25694,-31531,3746,21892,-27495,13064,-5868,-8998,10485,22438,18576,-16269,-28552,8900,17135,-26697,22335,26693,-10309,-15627,-5916,-5350,20375,-14282,-20528,8521,-19369,14004,3669,-9902,-15544,18263,-29721,11170,23162,-9106,-14341,16408,-15614,-19403,-29529,-10236,2454,-10234,-30600,-29057,8067,-872,29235,-16774,28063,29148,-27817,-31249,10748,-3490,-20327,-24241,7307,4407,-13104,24604,-21827,-8566,-19055,14176,-22295,-13037,17514,-19140,-15461,15069,3846,22456,27771,-13104,24522,31375,24152,-31990,-6895,19819,21941,1279,16577,-9384,28252,-9382,-2604,7176,31190,-15839,11270,13043,-6921,-29433,32314,26090,-30137,16940,-4001,15740,-16058,-30518,8383,-3259,-31813,28112,31903,1766,25758,20790,-29464,9786,-32634,-540,3973,11165,-2107,10685,-8061,-18400,10619,1647,18802,-31870,-20338,9730,-19298,-22649,-31579,-30945,-17404,-30703,-28450,-19832,-27458,8036,-104,-24331,30070,-4347,-12833,32502,-22523,29580,-21437,-17417,-18403,10340,18065,-15262,-31539,-14796,-24081,2395,8532,6264,20502,15344,-15094,32668,1800,-7718,27588,-18129,-6400,-6554,-21947,22644,-10103,29513,-6895,22006,20504,-28739,-15198,11564,-30039,6036,27358,7274,25447,-20297,23677,-24172,-10648,2399,23009,14070,32165,9963,11237,6511,-8196,-563,15678,-8259,-24653,-6223,23351,-32213,-31114,-32063,-11567,-23690,13065,9932,24276,-12741,-13639,29506,-19539,-32268,8419,28544,32094,5633,-23904,-27388,-25454,-6358,22759,30614,27910,-27874,-14371,27670,-28098,-27246,-9067,31200,-19935,-2574,-31658,-11822,24565,-19248,1923,17013,-16733,21459,24752,-19263,-28566,18718,11789,-27729,26902,26872,10608,27908,-27194,-4829,-26511,2749,-6555,22400,-24803,18501,-11221,30870,18261,-13401,8545,22621,4441,-32361,-1799,23188,-3979,-24390,3927,-10466,891,-11445,13939,-10757,-19369,-305,32363,5958,9102,30552,32243,-7423,19308,-26259,13956,22900,2115,9721,-26369,24962,-6726,27020,-25544,13506,-3154,19265,-6125,3384,-30065,25077,15843,-5145,22983,2984,-19724,16963,-2103,32635,-6346,31719,9857,6306,-10564,12633,29286,-32029,-8156,15811,6333,30278,-3961,28148,-1182,14292,-24244,-2961,7006,29704,6968,-7761,-31009,15707,9835,-27899,5232,6358,9388,8750,16413,5649,17219,-3739,-3313,-4578,10676,-20777,-3403,19333,14415,-21005,-17494,21593,3849,-3702,-26955,31616,-9128,-4512,17801,-4245,-19522,-26815,2335,25008,28723,-6137,27496,21077,-30268,32296,-14748,27184,23,-30107,-26756,-21594,17185,13553,6483,6475,-20220,21578,-10137,15603,27521,-3001,1166,19493,-20124,-8725,-28474,-22543,-11536,23301,-8560,25710,-27166,-26726,15191,-32448,-30881,-23203,-2105,32461,-7066,-23401,2170,8654,-11306,25061,-2069,15390,22377,-19572,30353,18105,-3494,-31213,-24283,31715,31200,-3829,18258,-16854,-25538,17078,6001,-14191,-6075,21124,11306,10225,-7423,-31576,-30166,-14211,-15556,-27359,9335,-18036,-11834,-1890,-30507,-12289,1009,16254,19518,23784,-22628,27891,-23609,-2427,-21770,11217,1313,-13166,1573,32368,10438,-30995,-11180,-31804,21787,-26771,-21860,-4969,1391,13453,6792,-24002,5632,-4461,27332,26259,15439,-17572,9974,-10248,24066,-10373,26798,-31097,-15300,28484,-2545,24556,27524,-26941,21461,18331,-1595,-15134,30509,6064,-13699,25797,-21285,-11188,3280,-27349,-10362,11752,-18923,513,-6929,13901,-3512,5759,18514,22094,11080,30695,-1381,-3844,-19696,-14827,26065,-32234,-1968,1619,-32635,-22551,-23759,-30068,3214,-22571,-8052},
  {8046,10928,9895,-29510,-9775,30148,20173,324,-27471,5842,4630,-764,-32657,-3008,4564,741,22487,-20455,-2106,-5194,-21239,3885,-13853,2135,-31215,-14710,-6962,-6774,-18685,9104,21989,14016,-697,2915,-1291,348,-27459,-12901,29343,-5258,-22611,-22314,23506,3593,19976,21916,22114,-28052,-1932,-11339,-24432,13659,-25009,-15511,-6505,20633,911,-7206,-14625,13626,790,-16341,9457,-7364,11484,15721,-2382,23089,-9844,-12570,-4451,-1798,6862,2469,-15053,-14836,9970,-18492,-15166,-7289,-31968,20204,21670,-27553,-2193,-2746,-22806,20877,-9927,3432,21047,-8342,-28294,-9142,9303,17853,17786,-29988,7196,-28058,12358,-12655,-12095,-12074,-5752,26430,-25012,8474,-14806,-13709,-28170,8206,24593,-22337,-18388,22036,-5758,-21604,296,6450,-7771,-25764,21144,-51,19511,-19323,-2104,-1949,32428,-7085,27671,32319,11773,-14873,24033,4605,12385,15093,23224,5050,-6439,-25093,12698,24959,-17869,30055,31808,-29301,23011,11658,-17636,21157,26283,-30632,18698,-8441,21008,10964,21715,606,-14374,21797,2605,-6284,27139,-29043,-717,3273,-18356,-5553,-17257,-16937,23851,-16862,-27912,-16133,-12999,21132,-28023,26990,-19532,-25851,-19422,-19278,-11286,20540,16344,-7188,6171,32379,-28345,19290,28707,-32717,23774,31321,29472,-25131,-10534,-30978,-19550,-26800,-31408,26350,2743,15065,-25129,-14748,5817,-13774,-23231,4134,5268,-12286,738,-14726,358,11433,6897,-4003,2759,-13238,22835,28667,27681,-26720,4433,-20977,-1755,-22836,-8002,-1524,15938,-9072,-24226,-20496,10209,21872,6618,3818,2183,-3852,-29862,-14996,-17269,7196,19614,-6054,-11927,31798,32156,-27778,29130,14646,-30689,16212,2119,-17559,1573,8349,-13507,24074,-19641,-12909,28376,27260,4979,-21453,27345,-12337,-8105,13896,-28267,-29763,-5763,7798,-9285,-15010,19008,-5126,-25650,-20856,-14485,-25635,-11509,1874,11261,32580,28871,-6075,22894,-15875,-5210,31124,4429,15427,-7383,-6860,10775,15179,-3399,10854,22481,-18799,-6995,22886,-7691,-9531,-22907,-9900,-23684,-10525,10391,20970,23436,-11645,3504,17612,-26412,25111,18907,-20944,3416,-6148,6139,-18610,12682,4356,-31653,-16366,-20694,13307,-20959,15693,-13147,18792,20437,24623,13841,-2081,19868,-29857,22092,-2735,-24558,7882,10445,-12567,23397,2834,4716,26323,-21790,-26393,1319,30209,-3262,-10746,11022,-32171,18013,30095,-21821,27505,-28697,10775,-12359,-5972,10393,15433,32380,28718,15456,-28409,-2877,-14057,8420,24851,-10483,9653,-25231,6053,-1118,-15324,27730,31963,-22964,29952,-12935,-29534,15219,19268,-25541,-7009,-13563,1479,9479,-11039,6923,8010,26702,1970,16546,-4322,16739,26095,-22976,15054,10673,29655,-20261,-16162,-5217,-9352,-16216,-1773,10189,22931,12812,-8574,-30538,-2844,-5469,24959,10797,28516,16062,-21602,30202,-6835,30202,-27831,5457,17254,15491,27329,-22885,9648,-3359,-17670,-18108,-7106,969,-31147,12381,26048,13018,-12759,15869,-4368,2418,31360,26513,9746,15046,20441,27013,-13786,30595,11982,-12889,24000,-1985,-25182,-5400,9866,-583,29680,3365,-19813,2502,23008,-3467,7049,-18154,30380,28614,-9782,16492,27780,-5437,-26162,9507,176,-8221,-7909,-14327,-18158,-16648,3598,-30956,-10216,-23720,28988,-26590,-20763,12405,29811,22797,-696,6126,5431,-27824,-22698,9873,31905,22865,-7460,24639,7045,4149,-9293,-212,809,18819,14773,2098,-9089,-28495,-1323,-14314,12047,5509,3940,24861,-1869,-22532,19457,29787,-29158,29743,13238,15563,4503,15031,-11577,28302,17608,15707,10233,2549,7276,21845,8050,-17319,2930,-26621,23167,21058,-12987,-26099,23130,2517,-9974,-25218,20263,7273,27245,-7082,-16881,2411,30969,-11628,21035,-21150,-21267,21277,22985,7435,-2128,26646,25459,-1094,-5677,-31831,14823,-15498,-1850,23175,-7522,6007,-10112,17950,-18881,-31912,29788,-7426,-13070,-19648,22901,-15213,-29933,5059,17979,-7291,-21171,-13681,1680,-13091,3853,-32181,28459,10295,17811,19738,10131,18587,9888,-16175,25684,-16075,-21890,-136,-14626,-20760,-11701,-5592,-28853,32219,-14546,-13429,9285,20791,-21920,-782,26819,18044,-28382,-1649,17664,2404,19397,26778,-19526,-15697,2698,12137,29496,-24408,-6464,-26877,10171,-1073,30517,27897,6042,24516,31221,14948,-238,21272,23842,-29169,-25528,7470,-23795,-23213,-761,-19568,-30382,-16682,-22840,27861,24292,21128,-32305,4643,-23178,-29313,30597,-14507,-28509,18162,-3482,-22605,16518,14461,26745,-24084,16860,-21823,11875,-25745,8175,-27396,-19893,13542,-6156,-30204,18453,-12789,27756,-8877,298,1581,-32743,5882,3482,-7932,-29959,-11576,-30333,19864,28685,9457,-27456,-22926,1976,27570,-21432,27636,15500,-32328,15764,15392,431,-26474,20064,12717,9731,-3095,-32498,22210,-1811,197,-10132,-5572,-7374,13133,18255,-84,-2546,31915,-23470,-14965,19368,18774,-16618,28840,29726,-26521,-12053,22291,-8064,-18163,8328,21439,10672,23928,-6964,-9811,20564,-22849,-26426,-5841,-31935,-18264,30943,15585,3169,-34},
  {-3543,-22286,26580,-9168,9166,-5935,24946,22396,-23630,-11720,30378,-21391,10062,18526,-28332,-24781,19626,-2127,-4117,-15403,-21537,3791,-24513,-15116,21330,28071,29422,20498,24442,21299,15508,30649,32064,-7159,-3284,-17117,7782,-12209,22437,-1455,27947,32507,328,14316,-6514,-24027,-29198,11532,-11587,17796,-12459,-27200,26890,-13751,-9044,28458,-15235,-29218,-24924,6794,-9068,18251,-11573,-10400,-5194,-10944,31151,-30043,-381,6350,6656,15993,24358,-26699,11676,-31631,2031,-4872,7154,23147,-24678,25141,24529,17328,-16433,-16941,11686,235,-54,31975,-18920,17765,-15577,-5330,-17510,-5027,-31397,18089,-26226,-11373,17175,-1478,-27556,-31713,22993,-30906,756,28908,-6186,10439,-8252,-1982,-3027,32139,-20609,6717,15570,14873,-22216,13891,-21396,-16530,5997,11531,10435,-16106,10402,4305,-21443,-27138,-8575,-11990,21126,-29130,9473,20749,-15049,23490,-14483,-11214,850,-26901,24199,-9653,-18957,-7561,694,-26342,-5646,16057,21809,12830,15137,26855,-22625,-30557,-18975,1299,11248,-27679,-13193,-23289,29043,18969,-453,-25925,-21302,2781,-328,-27565,9627,-4103,-13694,3122,-3052,21091,-1303,29107,22322,12421,463,-20411,10980,-8384,-10656,-18656,19607,-8937,-19298,23530,-853,25993,23483,-10779,-26576,-25333,4110,15962,-27935,-8689,6378,21865,23410,-11842,7634,-18607,-5720,-16314,10413,19004,19694,25178,-16119,-27093,19614,8219,20170,-25797,31082,803,-16864,21126,11466,-31829,-10421,29046,-22904,-27829,-488,-19991,11424,-24090,-1668,31334,-5059,-24133,16097,4098,24988,11052,-26001,2893,3839,-7331,-9508,31946,3960,8134,25208,23557,-21258,30501,-8268,-3488,-329,10576,29356,-23235,10545,17002,-17745,6422,12080,12524,-21323,1845,2625,-18498,-24808,-20355,-19455,18262,-23415,25861,25176,1996,-1199,10497,-5272,-8816,11248,-2316,25744,8533,-18146,-23384,15092,-29950,22674,19587,12875,-13711,30326,-9561,15395,11699,24136,31451,-26424,21593,-18143,23934,-15025,-272,9427,-32542,6953,-23178,-15506,-24653,510,28018,11353,21147,29145,18688,24834,26433,5568,24450,8316,5848,-6099,-18535,25100,-6987,31315,-8944,-30336,10523,19433,-32110,-19864,-28526,-17070,-889,26061,-18081,-26679,7207,19264,-18459,-8368,-23253,28253,11995,-25366,-5215,-4435,25262,-23153,-9779,-13422,30911,-676,-15619,-29435,-32420,-27544,16113,-26141,21932,16928,7217,-29980,-11519,31763,-18804,19518,-29448,32669,-30539,18739,-428,3364,4421,22835,26371,-26530,-16046,-8117,-11752,-2694,-5408,9372,-2248,1806,20927,-13847,-23686,-14558,11471,-13395,19785,3331,-3738,13484,12631,-13052,-23875,8671,11258,26426,26321,1584,-29869,-15250,26089,-4817,24640,1442,-13798,-7308,-10522,-17954,-2582,25457,30234,5723,-27888,-14504,7435,-31404,-20119,-26083,26092,-31277,26172,-26840,1989,18299,-9582,23839,29846,29171,-31195,-23310,18158,-32202,16546,-25146,18221,-5921,-18357,835,12200,13268,-25157,11857,-3896,-6468,20055,-6650,-19225,-10982,6892,26426,-26735,-23737,-28266,-6270,-8380,-27395,-24482,26073,5278,3285,9188,24361,-21186,-13140,31213,22307,5892,7117,-28468,-8516,30179,26851,12143,-12337,17422,14317,25922,-23310,828,5118,-15837,-9497,-22146,17359,-23578,691,-13512,-2965,-16701,26117,31139,24528,-20994,31959,-5223,5047,22055,1292,-7735,4869,-32623,-1855,-24208,4620,-1516,11352,-1688,15433,-3834,-9784,3999,-12759,21819,-12172,7232,-26973,-16039,-9939,-22760,-28719,-30000,16425,-7312,15391,-1877,23482,-5646,-3580,14108,22027,-15557,-711,-28671,5835,23936,-13485,28130,20409,10776,28481,30479,24400,7248,-31197,-24662,-29983,-7509,31847,-30015,6267,-3801,8401,25356,-4678,20099,-6950,1366,-14328,-14717,13227,-12075,26373,5209,-20192,-12664,21039,-19964,-14416,-23430,-26103,27684,9841,-13751,-12112,-11576,-14530,17432,-2878,-943,-3158,27719,-5807,-12555,20554,22925,-6098,-23631,-17047,-11122,18961,-27316,-31596,1965,1777,12580,-23047,27239,13477,-23022,-22362,-27662,3305,26560,31456,-27987,28536,-31375,6699,-20322,-21284,-8434,-26068,22912,-11591,5929,26915,23613,-448,-11876,18654,-17281,-21593,23886,-19620,2971,-9479,24858,22748,20982,11646,19438,-23794,31129,-31893,9520,6095,-4507,15379,29940,44,-17931,-1989,21083,15658,-1040,6281,-15203,19651,24007,-32757,-16465,20144,-32560,9210,20769,-25419,22104,19043,-13081,29012,-2396,-25090,24836,1268,-15068,7213,-32290,-20472,31070,2719,-2733,27730,-5959,16951,-8997,-4830,7929,-12788,-26847,1753,-14129,21586,-2651,-12685,23117,671,-7894,-19392,-20578,27818,8673,18030,32601,24851,-16342,16809,24557,10659,-17657,340,-10616,-21223,23278,17843,14369,14679,2786,-22366,10049,-6217,-16849,-5961,894,-5310,1027,-23730,17182,-15523,3922,-7478,-2491,12915,-15880,3552,3216,-1818,24521,-7394,-28325,-24120,31698,-26273,26834,8391,-849,5265,-28343,-16536,-23904,17640,-26396,-32076,-7449,-31821,-588,-8373,22821,26278,19767,17399,-7681,21486,30697,-32121},
  {-5020,-10312,-11156,-892,-29949,8277,-20009,-26525,32483,12721,14307,18874,-23164,25029,5455,9698,2956,17969,21897,22215,9822,19457,-29990,-9273,-10855,26252,-12343,28619,-32221,12242,-18641,30573,22746,20561,-7756,-23362,-2510,-8312,198,-6675,15264,1319,-29797,-7687,14182,-27106,3136,1182,7512,27826,-31170,31437,-9598,12030,-18154,26323,-32446,-22131,-2661,-24841,32380,-19554,-1926,-25328,-24641,-2085,30359,11344,2160,4741,-15131,-9959,-26215,18005,-17715,11655,-8046,16279,-7822,7553,-22586,30893,-10565,-10623,-31257,11239,18952,-12982,27499,-27393,22986,-10990,-5754,-16912,-32162,-16912,-18726,25312,15639,19282,22438,-8511,25940,4024,25856,-1593,14564,12585,-29894,26667,5559,461,27024,-13921,-3069,6948,29222,-30759,28114,-23397,15637,8855,-20059,-20760,2101,2441,-18822,-32048,12902,25153,-15804,-11665,-27057,-14354,4670,12992,-16537,18537,-30207,-9995,-31958,-25603,-7225,23064,-30142,1311,-10565,-15576,-29462,15782,-29965,26537,105,11259,3351,20192,-13215,-16166,13335,27937,-30551,-6369,-15723,11716,31454,-17171,-30403,31868,-22969,9333,-11229,-17432,-1119,30630,-31101,21390,-23801,-21771,18198,-15565,-15883,-27791,-25030,1241,15427,16589,2173,-20750,-5840,8598,28661,-28567,-9683,19471,-27398,3258,4551,-28061,29115,21624,-1649,16516,11643,8886,8822,10820,29635,28190,-5270,24331,3939,17804,5551,-19139,-26953,1603,-28968,-15595,-23684,8397,-30747,-16534,10888,11458,19047,5149,31832,1970,22632,-8213,-23650,-6068,23699,3426,-14394,-1533,-28009,-25125,-26645,15514,11523,684,-22730,-10776,12435,-9889,-2889,-21044,27744,10349,-16659,-22764,-10507,-24232,-1769,-4391,-8386,6572,-17008,32079,-4070,1604,-11576,9397,-16545,3279,2000,10377,14305,2223,20364,-32584,-10395,3174,22257,8465,-19716,26157,27363,2179,11613,10282,-27680,3113,-20379,13696,-24999,25885,6818,4816,20954,30806,20245,6391,-14267,48,32137,-10140,-22438,20662,-4721,31985,29760,-3796,30031,8024,-9265,-13963,29707,-28763,-11961,-1736,-28525,-29902,32727,-17447,-20233,-26275,27615,6462,24859,-31234,-4501,-31093,27084,-12820,-29000,-32071,-1981,-28609,-20878,5626,-29407,-29100,1197,-30255,403,30321,-19226,15902,-21914,28937,-875,-25193,-49,19615,30309,-18709,2687,-3643,22522,1656,11876,23136,-17491,10464,25952,-15946,22278,-20201,-23522,30469,1038,11033,16779,-11055,18795,24585,-12631,-10992,14234,21173,12322,15939,6345,18480,-18525,-4704,28868,-2466,-17853,-4983,-3313,27197,24520,4675,17216,-19366,4152,6509,-12648,30247,19604,5529,-31221,21347,-66,28102,23556,-23752,3888,-15222,-5924,25490,2855,22230,10033,24464,-29182,-4080,-17510,22242,31184,-1259,25628,4499,-9488,-8148,-12135,-12188,-4111,11513,-29661,-8783,-3111,3860,13104,14111,-24802,756,-321,-30548,6142,-5390,-32049,9686,18352,12630,19867,-32049,10631,-16178,-4542,24728,-24963,-29363,28283,19937,1863,-15748,22709,-2400,9029,31895,-18288,382,16332,21843,-15448,20597,-1679,-17140,-7816,-29365,3926,-28468,2019,19810,3879,13535,-22666,29458,-8905,-886,-18883,19867,17959,-5232,31050,14523,-453,10062,31218,-5442,-14541,-12698,15511,-6485,406,26857,-2379,30392,-28220,-11677,1711,-6050,4501,-12832,-13389,20966,-30576,-16554,7711,4979,27888,-14651,12684,-20926,-29675,-19386,-4265,27213,-13666,-10167,15605,23780,-24591,31349,-17270,-27666,-4231,9864,-10949,-24693,1707,-18754,-25138,-3355,12932,-8804,7902,8288,32183,6289,8090,-20266,-28097,7593,9776,-1717,20507,21863,5032,-13027,-5582,-7939,-21123,5240,17495,11939,-9071,16827,-29580,-11073,-22816,-6260,-9104,-8108,32414,25572,29101,17793,1602,-21055,11796,29996,-23158,11345,-17142,744,19720,-26442,-19237,-3899,-13196,-15321,2746,14770,-26923,-26576,6719,32263,-82,13495,29307,19490,-12809,-11625,-12287,-17242,-29314,7954,-27622,24231,15687,25649,13431,-29731,-2119,-18925,-22175,-16549,-18782,-20118,18856,937,-169,8957,-12220,20403,30693,-2457,-5538,14045,7031,-25944,-19209,-9830,-1392,8616,19966,14692,10853,-354,27741,-26671,-4370,28418,-27929,-20274,-4371,-15595,12024,31585,944,-12505,700,18735,18613,-23814,31749,-28873,-8765,27994,-22681,-13102,-10330,-6872,-17675,23941,78,28654,-7584,-29535,-15136,28216,4103,-22226,-15149,8390,-31296,-21753,6171,24958,10123,14010,-17077,21668,8830,-16740,30657,22680,-6261,32180,-3298,-12142,-142,21852,-29733,-21597,-19049,-24372,24577,6323,-3726,3328,28539,19016,4535,2791,-14103,-9707,-11355,-10662,15923,-18733,11440,24079,18117,10176,-11881,-23015,13781,-32679,-9728,18460,-584,13013,-21845,21464,-21662,-18920,22960,4954,-8322,22904,-21561,22597,27115,3810,-30739,-1308,-14076,-22933,-8696,2050,25175,-5698,-18156,9765,220,-1375,-18220,1119,-6372,24572,9453,-4736,-10432,-837,-1557,814,-17046,-16023,-17767,30115,-6991,-26481,-15150,29474,-22256,-20546,-30640,-22194,-3579,341,15748,12209,11371,-27809,30303},
} ;

static void test_encode_761x4591_impl(long long impl)
{
  unsigned char *s = test_encode_761x4591_s;
  unsigned char *x = test_encode_761x4591_x;
  unsigned char *s2 = test_encode_761x4591_s2;
  unsigned char *x2 = test_encode_761x4591_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_761x4591_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_761x4591(impl);
    printf("encode_761x4591 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_761x4591_implementation(impl),ntruprime_dispatch_encode_761x4591_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_761x4591;
    printf("encode_761x4591 selected implementation %s compiler %s\n",ntruprime_encode_761x4591_implementation(),ntruprime_encode_761x4591_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_761x4591_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_761x4591_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_761x4591_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_761x4591_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_761x4591_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_761x4591_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_761x4591(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"761x4591")) return;
  storage_encode_761x4591_s = callocplus(crypto_encode_STRBYTES);
  test_encode_761x4591_s = aligned(storage_encode_761x4591_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_761x4591_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_761x4591_x = aligned(storage_encode_761x4591_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_761x4591_s2 = callocplus(maxalloc);
  test_encode_761x4591_s2 = aligned(storage_encode_761x4591_s2,crypto_encode_STRBYTES);
  storage_encode_761x4591_x2 = callocplus(maxalloc);
  test_encode_761x4591_x2 = aligned(storage_encode_761x4591_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_761x4591 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_761x4591();++impl)
      forked(test_encode_761x4591_impl,impl);
    ++test_encode_761x4591_s;
    ++test_encode_761x4591_x;
    ++test_encode_761x4591_s2;
    ++test_encode_761x4591_x2;
  }
  free(storage_encode_761x4591_x2);
  free(storage_encode_761x4591_s2);
  free(storage_encode_761x4591_x);
  free(storage_encode_761x4591_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

