/* ----- core/scale3sntrup1013, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_scale3sntrup1013_checksums[] = {
  "3abb01f247f92e49c17e453baf12cbe9d31d3e736f1727b128b1d26ce1b05d8e",
  "62fa112e6584871480074801b4d477e6510956fab67d0e3ce6680fb208e1b1b9",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_scale3sntrup1013_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_scale3sntrup1013_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_scale3sntrup1013_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_scale3sntrup1013_CONSTBYTES

static void *storage_core_scale3sntrup1013_h;
static unsigned char *test_core_scale3sntrup1013_h;
static void *storage_core_scale3sntrup1013_n;
static unsigned char *test_core_scale3sntrup1013_n;
static void *storage_core_scale3sntrup1013_k;
static unsigned char *test_core_scale3sntrup1013_k;
static void *storage_core_scale3sntrup1013_c;
static unsigned char *test_core_scale3sntrup1013_c;
static void *storage_core_scale3sntrup1013_h2;
static unsigned char *test_core_scale3sntrup1013_h2;
static void *storage_core_scale3sntrup1013_n2;
static unsigned char *test_core_scale3sntrup1013_n2;
static void *storage_core_scale3sntrup1013_k2;
static unsigned char *test_core_scale3sntrup1013_k2;
static void *storage_core_scale3sntrup1013_c2;
static unsigned char *test_core_scale3sntrup1013_c2;

#define precomputed_core_scale3sntrup1013_NUM 4

static const unsigned char precomputed_core_scale3sntrup1013_h[precomputed_core_scale3sntrup1013_NUM][crypto_core_OUTPUTBYTES] = {
  {25,12,125,238,177,87,55,247,19,249,21,201,62,11,145,225,213,8,151,242,161,46,151,106,115,64,33,254,118,243,223,242,111,102,103,230,86,231,132,47,101,240,222,172,16,10,233,251,208,254,162,201,234,242,41,19,100,53,94,214,53,31,133,8,230,52,23,110,173,219,157,10,28,20,66,222,179,93,208,41,142,59,32,234,104,177,79,60,165,226,244,243,173,244,6,200,2,230,102,93,124,88,132,13,162,245,204,183,89,97,215,218,12,22,91,225,240,111,40,9,70,66,86,95,197,237,114,108,178,254,66,1,241,17,188,81,91,227,88,178,115,199,131,42,0,210,189,85,7,25,57,80,10,187,168,57,184,227,71,183,60,252,41,175,12,12,254,49,251,186,126,71,214,185,224,242,136,178,147,200,182,244,147,190,124,245,239,212,226,250,203,248,144,42,230,243,139,37,220,53,14,223,72,220,182,248,99,199,182,103,240,205,254,80,194,1,98,199,160,102,206,10,104,3,122,236,62,13,163,95,57,71,11,235,221,243,92,55,158,31,245,3,217,67,181,0,163,10,90,254,232,217,171,42,236,7,168,101,116,98,7,13,125,21,29,219,72,226,65,108,89,251,1,28,140,58,120,93,15,39,120,179,253,41,70,181,172,103,11,23,246,37,147,174,100,254,9,255,129,244,118,19,231,70,36,7,221,178,157,112,49,9,126,16,135,99,61,172,42,245,34,216,185,52,43,209,134,247,157,93,129,57,138,88,235,249,173,0,66,193,139,32,184,65,221,213,59,190,105,43,239,6,24,205,165,2,150,29,150,65,209,64,121,101,110,11,15,172,100,233,89,247,230,226,173,3,171,101,52,206,178,68,179,246,24,214,189,241,88,185,28,195,231,8,90,21,76,13,88,246,194,212,5,246,104,236,128,46,186,244,44,10,45,244,112,182,77,232,52,75,116,35,146,181,224,63,171,221,60,74,74,6,14,2,163,192,6,19,43,193,253,103,255,110,106,33,152,219,103,34,183,80,113,21,139,236,56,192,236,79,151,74,146,9,121,214,160,213,31,251,54,79,176,245,236,243,86,65,104,87,54,108,253,170,148,1,194,248,245,251,212,59,182,245,43,250,54,24,198,18,124,2,156,48,217,211,148,0,221,19,199,218,130,177,218,1,174,87,82,255,109,243,16,244,50,56,222,45,178,74,217,21,146,251,198,96,181,87,43,208,140,58,107,72,197,59,136,46,133,37,161,75,88,195,118,223,39,18,197,5,100,92,93,8,227,194,176,84,39,74,13,25,75,1,76,19,50,236,238,205,59,215,179,203,247,7,229,208,35,11,84,251,109,240,108,243,253,229,182,0,80,238,143,207,112,86,40,241,108,179,7,20,212,234,230,171,141,181,242,191,202,35,17,42,111,254,240,81,86,250,32,209,174,11,232,2,33,42,234,195,140,91,22,14,76,245,60,252,1,252,163,56,247,90,175,234,218,30,54,217,78,91,156,87,248,13,44,26,49,97,202,46,62,0,26,209,241,5,30,35,196,88,201,14,244,0,245,40,191,208,136,4,110,199,45,83,74,11,16,32,144,4,84,8,253,241,140,251,90,107,112,17,25,104,195,235,170,66,32,248,94,251,41,53,213,200,211,238,42,3,195,91,132,253,71,255,38,90,131,106,222,67,19,170,122,255,27,213,166,75,82,5,197,49,146,59,126,246,58,244,115,217,25,111,77,251,54,7,173,73,116,7,252,199,230,81,111,45,78,2,142,110,220,184,155,185,204,245,225,103,96,241,238,170,245,46,217,194,235,255,38,6,73,75,7,3,62,43,158,38,190,18,192,95,11,14,139,6,117,52,249,110,6,21,202,104,224,177,172,207,97,182,211,232,30,198,247,23,125,178,100,221,34,215,30,253,163,3,186,243,83,249,90,28,162,225,230,9,154,209,184,78,105,54,189,8,153,102,197,255,114,110,254,179,201,4,10,5,1,198,105,42,125,82,61,53,98,219,144,9,34,71,190,179,186,253,167,244,202,101,19,22,41,190,104,113,241,187,133,252,102,66,218,231,216,216,97,29,73,217,226,208,25,1,171,40,239,53,171,203,125,7,247,192,214,215,225,172,13,180,62,175,201,109,67,244,63,251,69,76,33,206,220,91,227,97,21,47,210,17,186,249,237,27,151,56,39,21,107,99,174,219,33,108,210,80,29,82,137,248,224,54,42,242,13,37,145,184,188,95,172,98,193,46,250,57,63,26,79,19,155,106,154,222,133,2,136,113,136,15,53,230,234,223,68,11,209,52,212,31,105,1,36,83,74,92,116,249,156,255,192,8,226,105,214,51,203,208,239,14,26,233,151,246,36,225,195,30,117,83,133,41,213,51,31,175,244,208,168,3,64,50,183,34,208,5,33,0,106,227,62,253,148,6,225,246,58,248,46,178,158,98,126,236,118,37,177,93,76,247,22,29,173,16,178,8,235,69,164,57,159,102,181,236,166,79,55,2,0,32,58,208,251,35,8,7,151,65,52,240,154,94,248,209,195,203,17,249,98,254,248,176,193,39,200,7,107,21,191,246,117,32,42,48,137,61,197,104,136,213,208,78,64,58,100,241,186,15,183,89,197,244,171,248,112,255,188,218,239,82,49,243,213,86,210,243,234,12,33,212,34,190,47,43,206,15,191,78,150,229,207,42,120,235,80,188,194,191,184,18,19,19,53,34,216,29,132,24,77,13,25,180,38,6,120,85,237,5,195,230,206,27,198,16,138,187,246,195,0,219,15,44,216,74,156,4,161,89,154,198,46,172,188,212,244,215,102,7,29,183,4,107,133,93,86,94,70,27,200,218,247,204,170,234,90,102,123,6,153,21,95,253,216,77,80,236,137,181,138,90,226,97,110,246,147,31,96,226,50,13,62,1,146,7,158,225,251,69,76,1,218,250,232,102,158,70,1,176,129,11,42,12,252,208,174,195,23,36,126,178,161,230,57,68,226,77,76,194,193,43,21,0,208,67,231,178,4,251,154,255,55,2,144,236,12,21,60,96,175,108,65,230,58,234,9,78,111,14,208,67,251,13,236,234,225,50,45,14,158,110,181,245,27,76,236,18,103,249,146,66,115,91,182,232,145,80,1,72,36,203,254,35,245,246,154,12,57,244,28,31,131,209,248,52,41,246,134,4,66,238,20,53,211,95,116,184,18,95,81,100,118,245,149,252,50,48,3,63,22,231,187,2,216,252,190,180,50,174,30,252,37,179,94,7,209,28,69,41,177,27,24,56,175,251,252,74,133,12,28,11,61,31,177,245,208,59,186,21,32,206,198,222,68,8,45,9,12,11,24,255,170,89,58,254,250,226,47,250,244,186,233,90,172,183,237,251,84,226,220,1,185,91,82,225,104,93,136,56,191,83,139,0,205,234,220,186,0,36,154,9,205,205,161,2,203,241,152,53,139,250,229,88,188,203,245,224,57,187,51,1,84,247,145,173,250,210,198,4,45,11,96,250,91,252,220,198,87,192,47,209,30,64,54,236,60,245,46,254,10,39,206,92,195,241,151,240,254,49,20,72,14,223,250,188,46,242,250,201,178,68,60,53,107,230,2,77,103,23,213,63,63,248,218,35,3,246,182,78,17,23,4,8,176,2,207,245,111,68,96,50,124,109,122,57,9,75,136,101,194,33,252,13,139,43,43,108,193,85,184,2,154,66,118,198,43,3,224,233,155,239,2,248,61,231,184,252,237,81,204,194,121,17,185,23,48,253,23,3,124,93,108,36,140,24,154,255,49,8,56,220,53,191,79,244,90,45,192,9,239,235,41,63,166,5,129,62,169,194,160,244,120,196,115,78,91,252,104,15,105,13,110,1,183,252,109,224,226,50,10,23,254,196,245,109,121,255,110,52,96,182,45,6,217,228,198,208,82,104,4,253,128,18,149,251,135,1,177,212,72,249,235,103,217,98,207,252,181,209,96,20,150,101,242,174,16,8,205,38,67,14,29,247,110,236,214,252,86,191,13,13,233,55,63,104,188,17,8,17,128,218,179,61,52,69,7,98,164,95,90,242,75,22,216,82,194,45,23,18,27,180,139,71,238,80,92,56,187,77,138,87,102,8,129,208,122,33,125,59,215,26,98,92,106,46,235,48,169,233,201,185,25,214,37,175,117,27,223,249,115,2,94,187,53,96,198,255,95,246,198,237,174,61,53,107,136,70,240,170,113,49,242,6,189,93,34,93,46,248,249,218,5,251,241,243,24,245,30,205,192,60,186,105,157,54,183,104,255,23,224,67,177,75,141,203,80,233,105,247,121,223,26,246,188,18,189,111,176,8,31,49,254,249,147,44,60,251,180,4,53,202,39,215,154,50,231,9,11,245,198,199,108,45,169,245,80,10,132,253,120,6,146,244,253,206,93,51,74,7,199,2,159,44,236,107,75,248,164,9,142,37,220,20,2,92,173,189,57,11,95,108,121,13,247,238,215,255,66,11,15,65,152,31,7,69,230,20,166,64,66,193,77,5,47,16,109,80,41,170,138,111,188,10,76,246,211,241,168,34,157,63,85,226,106,24,156,9},
  {201,235,175,50,30,3,74,16,10,4,30,255,68,41,46,78,210,11,230,246,92,6,5,9,105,186,248,7,245,247,211,213,114,8,124,1,234,3,146,92,77,22,23,1,227,7,93,186,252,23,121,185,185,214,236,244,154,8,192,254,229,51,59,252,178,61,241,4,201,235,193,253,146,245,248,8,139,26,177,83,217,22,69,174,113,62,182,79,249,255,180,254,124,105,74,236,121,185,92,55,171,110,167,2,56,242,46,4,132,252,25,88,186,255,125,171,130,106,98,173,113,13,67,239,166,195,124,70,131,189,54,35,126,69,76,207,29,80,149,237,140,0,159,8,0,211,65,8,248,71,0,81,150,92,235,246,141,253,5,2,48,94,51,9,142,195,246,211,103,253,212,8,182,245,57,198,238,23,167,33,214,12,17,3,124,113,182,88,137,250,140,236,234,9,197,27,238,191,246,23,199,44,37,246,108,203,64,12,114,49,204,37,54,13,161,11,221,74,98,108,244,6,117,56,9,81,41,214,86,254,16,248,110,242,225,31,98,4,190,176,231,252,22,110,117,78,8,194,103,250,98,64,194,109,54,253,80,4,64,46,99,72,89,1,112,255,212,91,72,50,59,192,235,242,238,87,108,6,149,244,124,111,198,43,168,217,71,111,138,35,252,96,239,202,89,210,235,202,107,190,32,95,130,239,245,97,166,245,252,30,156,59,160,100,180,55,249,16,46,8,97,184,44,4,231,54,177,26,58,61,82,252,211,28,127,249,16,9,218,253,118,95,71,21,96,77,208,7,89,246,172,231,201,67,72,37,180,180,33,236,242,199,133,9,139,11,136,44,42,193,21,0,113,70,140,44,98,110,76,255,224,177,83,41,96,49,103,27,159,8,147,6,150,50,79,11,207,222,243,46,238,5,202,243,0,225,142,76,55,185,69,217,36,12,14,93,31,251,244,5,218,33,108,66,220,13,12,248,180,43,5,203,62,30,20,240,12,78,37,100,19,242,106,62,42,175,94,229,122,54,16,187,224,95,8,227,174,26,123,0,165,15,211,113,187,1,146,39,91,78,247,96,219,6,107,217,90,245,80,95,234,171,70,60,110,188,80,43,197,65,247,92,135,252,70,49,187,192,232,206,84,230,68,192,206,254,177,180,65,226,146,196,206,60,29,248,98,12,72,26,190,26,237,253,171,247,197,65,232,8,241,95,66,181,39,6,110,245,236,98,243,98,165,79,110,188,112,37,156,0,228,95,79,221,217,1,255,0,14,249,250,5,31,67,155,217,236,36,219,25,81,10,229,245,79,85,166,10,250,194,198,223,86,179,226,181,119,32,229,176,233,251,46,60,93,87,46,194,23,253,22,253,199,88,232,253,145,4,82,31,206,253,192,190,218,223,246,250,95,19,194,183,44,2,117,41,191,246,23,7,4,243,156,1,41,104,236,195,9,244,38,215,239,32,202,255,56,34,204,218,2,9,64,253,66,12,100,12,225,252,203,108,18,107,26,212,228,242,42,186,31,38,71,40,68,26,173,200,66,73,54,92,1,3,14,9,197,52,105,24,13,112,97,67,179,76,11,206,200,95,196,186,123,223,201,248,1,247,237,172,167,30,57,9,130,182,193,1,41,5,74,88,213,45,81,76,208,218,235,244,34,85,115,51,153,246,23,207,217,104,168,45,185,30,125,30,238,26,128,224,128,25,151,245,112,113,208,226,130,100,105,247,137,253,179,15,81,91,212,176,40,242,30,253,28,22,251,12,144,17,112,62,100,82,105,8,23,48,77,26,238,31,142,215,71,172,238,243,194,253,238,60,31,36,149,192,235,243,133,81,88,53,207,31,174,10,43,13,138,245,122,2,147,32,236,175,158,244,189,84,104,100,73,93,29,29,142,248,219,234,52,4,243,203,50,3,146,11,144,9,80,252,51,247,195,85,144,177,207,181,62,33,187,34,255,11,39,246,212,228,49,83,54,106,146,69,53,251,158,255,159,69,106,37,24,34,40,68,194,31,39,58,104,231,99,190,234,247,166,85,172,81,168,89,160,251,42,112,115,252,198,215,11,11,188,80,192,252,148,205,194,255,52,249,231,252,146,8,172,254,164,244,67,215,50,6,1,29,243,209,15,213,183,50,70,203,235,232,120,231,206,6,151,88,94,8,42,38,107,189,126,67,189,211,232,91,131,191,246,86,72,231,72,172,1,10,63,237,121,200,150,218,49,97,161,111,218,87,197,208,171,71,29,187,12,236,172,176,229,2,47,199,142,233,166,27,237,1,194,189,36,80,163,9,115,4,52,217,1,50,212,188,5,75,44,39,37,4,86,26,164,81,230,83,25,92,11,249,25,246,146,33,137,244,239,58,230,226,115,245,46,246,185,17,219,207,102,43,143,183,246,105,12,207,39,226,73,74,210,87,143,10,249,4,61,13,225,3,212,48,249,201,134,12,222,79,156,9,148,68,1,6,62,16,230,10,50,245,110,75,9,11,148,82,104,13,10,213,245,91,199,82,147,18,96,10,217,231,177,14,171,245,170,110,133,175,147,249,188,173,181,66,155,111,92,5,113,193,116,183,78,85,81,84,43,98,106,213,211,2,119,1,162,43,129,235,160,228,180,255,122,6,41,44,2,173,109,171,73,185,103,66,35,3,23,83,206,85,169,250,174,13,26,13,37,196,78,185,39,22,68,1,93,36,90,248,132,11,94,76,29,48,242,216,142,205,109,241,11,213,102,41,74,251,205,203,121,105,30,246,83,74,16,44,150,12,243,54,156,228,150,247,80,98,139,173,78,47,4,24,250,247,20,230,69,244,253,71,162,2,16,41,254,228,112,250,90,64,122,67,197,224,61,22,61,231,19,8,181,84,78,60,189,60,203,251,246,111,55,35,185,199,155,201,42,245,112,243,244,47,182,221,22,198,202,46,110,252,130,58,181,242,46,34,110,72,166,188,143,28,145,8,51,215,37,44,93,51,93,12,130,3,60,53,95,179,170,40,3,201,48,64,188,234,77,248,248,8,37,25,44,90,25,182,100,185,62,244,48,10,74,11,160,224,112,249,68,171,196,70,62,0,48,50,179,209,84,58,106,210,241,233,239,229,27,236,233,181,181,98,100,2,216,246,56,241,154,6,30,23,182,20,69,55,53,248,227,33,176,235,43,181,55,226,148,197,134,240,84,103,178,238,81,195,142,190,207,186,153,235,27,186,50,223,47,78,101,56,206,5,137,24,240,63,84,77,231,177,136,253,9,248,1,254,79,41,102,196,100,251,213,12,29,208,14,195,238,35,74,7,37,19,128,246,22,174,54,3,213,67,194,82,92,39,174,11,74,12,120,51,163,107,220,43,78,207,100,236,141,3,152,235,154,218,77,4,83,38,143,105,242,188,239,112,138,83,5,80,33,97,168,248,8,247,166,172,142,2,74,193,0,196,91,29,112,92,238,48,142,44,180,7,62,81,246,8,37,7,241,243,86,252,135,33,186,27,16,6,122,93,14,196,170,225,71,103,141,4,193,67,5,244,223,247,96,250,17,6,179,189,202,13,171,85,194,6,111,8,212,33,139,208,192,21,253,1,134,17,69,231,35,70,43,241,120,91,208,60,206,3,245,75,231,231,66,227,33,113,234,173,191,212,245,49,157,11,135,249,112,73,141,71,14,10,228,85,16,232,245,101,96,38,141,12,55,10,37,101,178,220,208,91,230,92,227,214,240,252,221,2,209,195,247,244,116,113,175,11,0,79,45,172,68,40,107,95,99,17,95,36,228,79,242,112,139,242,157,253,3,32,131,170,31,173,191,4,160,74,126,253,99,180,126,248,220,68,227,246,218,3,142,254,95,240,172,1,66,178,120,212,182,177,145,245,48,247,206,109,64,30,152,221,17,6,70,7,31,10,122,248,130,108,33,219,64,47,73,247,44,12,78,179,213,198,58,58,95,32,150,20,59,101,201,243,87,52,221,53,252,66,88,8,159,92,30,85,109,250,62,27,89,3,162,103,22,73,71,31,136,244,132,48,27,17,195,42,203,209,132,13,140,244,1,112,152,9,91,199,83,113,207,72,114,43,49,71,21,195,159,20,110,255,97,221,41,177,36,11,130,57,141,64,152,9,191,83,167,197,215,26,13,6,123,251,243,48,167,43,1,171,222,207,94,191,91,220,159,73,171,78,180,193,107,99,152,249,142,254,101,201,155,172,44,229,3,251,4,3,169,10,66,3,95,49,64,251,196,108,209,186,106,74,244,192,226,199,143,91,226,207,231,211,61,10,126,228,130,199,42,29,82,217,1,242,27,251,123,21,69,95,159,255,121,13,254,184,239,65,122,228,120,43,48,81,242,74,202,213,45,236,13,187,219,22,248,9,252,38,123,91,161,234,76,247,138,39,254,2,72,17,145,80,75,253,244,174,96,245,121,173,116,39,240,113,181,212,220,1,134,74,214,95,192,193,230,208,222,64,45,246,146,1,156,194,176,246,180,201,94,43,227,0,77,0,132,22,30,47,27,3,85,242,53,255,116,92,94,7,212,0,254,8,34,7,151,25,59,93,192,246,240,83,57,205,58,255},
  {71,37,206,65,0,98,189,87,148,5,149,235,13,254,248,41,22,88,69,197,172,41,53,201,141,99,46,48,217,21,188,24,211,244,23,243,118,213,226,225,53,253,137,40,228,16,97,252,204,64,35,206,50,35,199,24,146,229,191,1,26,242,233,171,123,7,181,32,157,194,226,248,132,252,118,211,254,222,127,78,181,199,247,66,200,68,34,77,107,228,198,214,181,82,158,108,235,204,104,10,123,204,112,242,41,248,11,5,193,23,166,51,226,85,201,45,219,6,73,10,164,55,51,1,56,61,168,35,193,219,206,209,66,4,26,20,102,10,162,188,78,95,206,10,241,9,101,49,145,242,153,51,26,100,170,38,80,228,124,83,188,202,93,75,87,172,44,245,59,237,40,73,221,103,51,6,44,249,143,111,7,239,163,214,245,227,174,74,205,75,162,13,86,25,186,181,250,251,218,243,96,245,116,76,136,230,54,14,240,110,205,30,190,41,64,12,177,35,203,224,9,200,68,184,133,21,153,13,236,175,83,32,95,211,128,252,112,97,188,217,240,177,98,53,153,12,69,244,135,187,112,5,176,208,13,75,121,52,198,103,95,218,128,252,220,3,24,96,92,206,85,195,119,13,198,177,126,12,109,87,61,2,95,112,255,69,78,4,206,239,241,174,8,54,184,191,224,61,164,237,104,107,93,229,86,11,12,243,116,72,251,184,25,184,149,245,150,11,216,246,223,94,3,109,107,251,143,1,95,17,92,204,21,171,185,246,10,222,186,230,167,52,210,8,169,210,221,197,226,24,164,241,58,246,138,46,129,175,39,1,125,45,228,54,0,227,75,1,85,63,93,102,253,32,204,3,177,35,209,179,199,0,198,192,56,176,85,95,48,84,26,58,57,2,103,12,79,228,149,191,204,254,34,33,135,2,196,41,36,246,173,86,105,242,128,252,47,214,186,3,64,54,88,22,46,13,209,29,119,177,244,240,212,221,195,231,175,231,80,111,101,6,187,246,142,27,25,246,136,253,164,36,133,62,230,0,217,23,148,219,56,177,27,1,156,246,27,209,118,214,68,33,188,39,105,255,107,12,86,40,64,244,33,180,161,81,189,215,80,251,152,214,190,255,92,220,70,208,52,236,127,230,180,254,139,239,26,245,131,242,15,11,189,247,43,83,215,77,28,229,182,9,176,220,92,253,144,226,39,70,58,194,158,254,134,239,200,241,27,1,46,1,219,33,227,255,115,6,37,183,68,176,98,102,144,239,241,248,251,30,42,7,2,19,67,9,158,27,31,29,24,39,52,34,241,224,135,22,171,181,50,15,40,171,210,239,55,171,241,212,158,13,132,11,65,180,125,2,165,2,176,11,153,69,69,103,246,176,56,1,136,192,180,185,77,90,17,12,169,106,139,17,21,88,9,201,210,244,102,1,252,24,150,253,123,247,0,238,55,7,4,18,65,240,175,247,109,52,24,186,240,44,62,204,122,71,13,36,218,248,216,37,61,85,21,26,167,0,229,75,201,2,66,12,226,39,197,234,226,54,113,69,78,193,138,101,149,233,55,28,100,4,32,51,64,251,233,104,96,222,162,2,69,252,70,252,251,86,195,213,94,187,48,7,214,12,156,48,77,232,21,216,67,246,96,86,161,11,122,29,143,194,229,82,130,36,162,7,249,65,195,2,59,225,179,226,42,22,128,113,8,93,151,109,152,41,247,49,216,233,244,45,42,90,206,58,22,13,53,68,6,103,245,11,125,9,94,42,4,91,151,4,230,184,29,238,117,251,172,82,34,66,39,180,8,52,215,254,44,67,100,67,129,172,202,30,2,5,64,246,136,74,185,253,241,10,50,104,39,252,82,8,166,217,153,11,132,8,52,109,36,80,154,247,166,53,192,175,32,72,85,245,159,43,34,251,195,240,7,251,168,175,176,223,63,1,247,248,190,66,225,173,138,98,2,252,217,70,213,255,204,171,45,243,95,10,5,254,170,171,30,193,196,220,216,74,200,219,247,66,214,231,113,106,217,13,112,13,63,222,7,58,207,203,114,253,48,222,27,63,0,15,71,70,12,209,79,60,207,3,190,196,151,253,11,215,193,248,72,239,87,50,195,246,205,69,130,255,176,91,183,177,35,85,56,5,136,238,206,247,136,4,142,247,196,48,199,221,145,106,248,234,55,1,114,64,191,3,70,44,255,101,92,66,175,221,94,245,252,196,187,7,170,37,86,111,123,234,170,10,188,222,107,108,58,243,22,6,119,52,163,4,247,51,197,79,109,251,164,190,223,251,1,0,165,39,57,45,188,232,236,191,217,220,241,27,21,215,213,8,141,43,103,19,46,202,9,30,50,1,241,239,92,23,155,12,28,247,156,2,43,183,230,232,142,14,194,236,78,236,186,2,9,228,50,174,200,53,236,180,103,29,118,36,168,37,154,37,15,248,62,235,226,238,128,245,59,89,120,184,185,4,214,67,134,184,218,5,167,68,73,197,94,174,173,250,48,49,181,189,13,216,79,187,71,214,3,253,175,13,149,111,68,186,191,58,17,1,36,187,241,244,198,5,150,84,43,95,191,79,125,193,206,72,139,13,96,195,154,198,97,253,131,107,56,56,159,191,249,51,15,44,163,34,219,3,229,7,181,15,2,209,202,86,86,252,72,244,110,29,20,227,214,54,177,238,227,209,108,49,236,185,19,251,118,0,124,66,94,32,226,25,230,231,235,188,185,85,184,53,93,10,231,32,253,102,101,12,60,3,29,230,238,42,218,26,242,176,209,98,62,218,158,184,203,9,130,221,84,78,37,227,73,183,209,184,25,16,150,11,154,244,5,41,172,181,147,93,94,238,192,179,98,252,96,5,178,61,46,50,167,209,164,232,141,72,175,12,63,245,53,95,144,215,190,214,28,179,19,52,212,34,30,13,79,0,144,88,228,245,167,199,56,5,155,205,134,29,41,101,30,231,143,41,80,225,209,19,202,107,43,5,94,34,133,13,201,17,45,252,174,0,5,242,92,8,96,255,40,221,111,5,120,11,130,246,176,73,21,209,107,211,130,175,25,2,112,3,139,11,61,183,11,227,13,59,145,234,211,38,38,250,76,9,214,223,68,9,119,223,67,198,114,206,67,195,230,192,141,111,69,180,180,194,153,176,130,220,96,192,147,38,198,85,162,235,31,61,193,202,174,228,104,77,41,244,9,174,243,10,236,248,250,66,250,253,97,247,188,48,221,241,39,248,53,255,121,243,155,213,214,248,119,87,65,31,96,98,238,53,196,243,58,0,124,68,213,224,12,46,233,101,151,244,176,24,223,249,244,44,86,67,153,12,42,113,231,37,112,247,237,67,20,10,155,246,8,175,35,93,197,16,216,0,164,199,115,54,224,59,88,246,186,14,194,196,163,250,205,57,113,22,231,12,45,79,96,182,28,180,154,103,124,77,28,48,51,2,122,237,152,72,226,197,30,57,209,184,59,252,1,34,178,186,75,85,112,197,217,242,125,12,255,34,228,10,214,202,149,113,67,100,70,3,68,6,210,198,42,11,134,9,227,243,169,0,34,254,240,6,153,188,133,253,176,58,66,92,131,99,226,88,105,244,113,214,233,236,113,244,133,99,253,48,106,89,150,217,145,0,90,5,122,199,2,33,226,85,149,27,204,82,214,224,149,244,196,82,22,209,170,81,165,195,167,61,25,237,11,112,49,101,225,2,106,248,136,171,26,29,161,224,24,42,245,99,142,63,123,181,4,236,248,105,171,251,181,0,57,204,6,7,135,251,25,5,112,4,109,252,185,29,178,72,172,197,119,176,62,243,66,108,55,202,118,249,220,60,66,6,204,109,253,60,152,54,179,29,65,101,160,9,183,33,205,231,171,243,107,200,36,2,105,5,89,170,240,3,72,1,202,222,115,47,255,85,66,175,119,247,27,84,242,9,225,1,195,37,132,14,107,112,208,195,45,254,173,218,12,247,145,55,68,8,193,103,250,248,46,210,63,253,55,113,89,29,55,105,12,2,236,241,203,9,111,175,122,186,60,35,252,242,74,110,51,191,87,56,141,107,37,37,22,23,151,209,239,254,121,231,242,255,78,69,187,0,199,7,154,108,218,229,94,242,210,100,146,245,87,10,84,32,167,197,192,0,14,13,220,90,247,52,103,78,245,24,124,247,52,24,130,71,92,2,195,243,87,216,66,86,131,75,45,242,100,24,52,204,2,235,241,11,88,249,177,254,207,5,78,100,79,245,252,81,42,72,233,2,140,242,21,200,68,109,218,249,229,68,61,189,253,108,1,233,192,109,49,61,15,8,4,56,175,186,146,72,181,37,202,208,171,0,82,107,233,5,167,213,99,68,101,86,37,22,235,85,228,244,28,17,182,202,11,40,221,188,233,63,106,209,86,67,246,101,62,4,132,24,91,223,155,19,52,70,21,64,147,26,53,55,100,217,58,107,92,10,132,10,84,47,36,255,235,54,152,243,86,42,254,80,191,110,252,75,241,223,146,252,241,237,180,13,172,100,20,174,50,209,254,79,168,221,196,192,189,196,85,50,194,10,130,82,53,102,113,82},
  {212,251,69,25,59,86,159,244,3,179,53,63,221,25,138,214,89,3,147,9,207,227,118,250,94,4,94,52,154,1,10,9,124,9,249,46,52,99,127,225,79,249,253,236,52,244,119,11,76,250,127,36,172,254,85,9,122,224,27,199,50,239,153,243,16,246,14,171,229,15,76,89,207,12,173,192,148,240,35,4,185,249,142,206,232,42,218,16,22,225,6,202,202,198,46,192,241,41,3,172,145,29,143,68,253,17,10,19,31,27,144,41,226,173,67,246,127,249,170,85,244,7,129,86,114,197,87,38,93,89,162,203,180,197,201,205,150,182,252,15,203,11,158,246,202,15,52,61,249,55,135,194,131,246,35,61,207,106,29,72,220,66,138,91,191,110,60,25,31,202,175,242,164,50,2,0,144,73,93,33,92,6,226,10,231,95,228,55,24,89,106,191,140,182,220,13,135,78,212,8,95,103,234,52,152,173,20,217,83,198,219,227,37,229,91,79,159,10,41,2,234,17,58,181,106,247,6,96,238,97,210,5,53,69,175,7,201,74,142,222,26,189,2,193,215,208,110,23,101,75,151,87,17,30,211,12,159,201,118,254,155,93,123,8,198,255,165,91,127,243,131,7,185,247,130,225,141,240,170,219,197,190,192,249,111,218,157,81,40,38,168,47,21,56,116,175,122,245,162,252,207,202,236,24,226,22,87,249,119,9,220,220,70,208,104,65,151,87,187,10,182,47,9,254,121,37,217,41,86,225,206,246,89,254,93,239,179,254,176,252,131,17,142,93,62,251,150,97,91,11,43,69,180,219,117,210,59,203,97,242,77,48,196,43,198,11,79,209,110,0,52,242,241,24,104,252,100,194,121,244,157,49,153,70,223,33,215,65,242,252,61,226,104,56,154,24,254,12,137,216,214,226,55,0,161,101,153,51,151,8,200,6,180,42,0,30,99,26,30,14,243,63,244,184,244,246,209,67,66,86,148,237,138,242,47,200,161,227,50,73,106,239,250,69,70,223,226,14,255,218,157,205,94,91,55,31,176,3,220,43,62,222,90,252,239,191,110,36,52,211,73,203,211,47,100,170,227,57,179,195,155,192,132,5,124,201,105,44,55,13,44,244,191,244,110,190,14,238,11,10,141,81,104,78,199,174,186,243,111,0,234,43,135,215,244,184,100,112,205,59,227,217,168,252,225,36,91,85,181,40,21,78,228,179,154,252,130,7,75,4,103,239,30,233,179,40,219,203,1,10,196,66,248,233,189,66,56,113,195,230,12,245,242,194,240,80,28,188,248,77,127,34,178,198,75,32,212,233,114,232,187,61,152,255,31,171,173,183,254,91,141,104,242,1,214,84,82,55,100,245,191,228,19,35,86,106,7,96,107,50,224,8,237,53,98,45,53,250,198,7,94,10,90,85,118,171,117,183,79,80,81,11,171,11,130,12,71,65,132,109,117,54,205,236,71,57,70,174,67,251,222,244,202,11,27,180,248,220,255,242,78,17,152,205,230,33,154,84,235,91,56,6,242,0,254,74,252,42,195,91,232,170,87,182,146,44,36,46,104,254,19,247,250,2,69,10,239,243,103,113,71,234,6,104,80,72,145,27,173,205,5,177,52,2,175,246,195,33,158,13,29,229,26,3,216,241,192,187,57,251,152,202,18,49,81,246,126,226,73,247,74,212,122,255,33,113,143,97,156,62,69,1,253,45,226,45,157,28,21,13,213,8,233,255,13,252,131,35,89,9,131,196,210,107,158,184,227,172,109,106,190,1,44,224,25,102,80,22,197,70,147,109,104,58,148,215,72,40,98,249,222,197,225,6,17,242,133,245,38,9,214,246,188,243,243,252,227,239,54,207,60,234,13,42,52,71,164,203,173,105,250,80,27,238,84,237,183,221,31,15,139,106,38,243,195,246,187,44,234,12,197,236,28,242,201,221,212,177,176,26,251,209,50,20,10,216,132,2,82,246,53,66,218,222,179,36,143,235,180,229,195,2,100,5,196,13,44,252,0,6,161,3,48,8,143,7,153,27,10,252,123,180,44,186,112,211,17,211,57,243,86,219,56,7,93,3,155,62,190,243,41,253,211,250,139,180,180,245,235,10,229,12,84,243,239,28,212,192,220,6,18,232,0,14,116,28,58,44,250,252,56,243,119,9,220,69,181,251,65,12,178,241,104,61,103,212,240,181,83,83,130,1,244,211,153,90,195,6,30,55,202,238,128,50,122,246,15,71,81,29,91,188,131,72,198,68,2,254,31,45,165,242,122,171,155,6,80,233,163,15,95,6,231,6,1,247,202,252,174,50,90,213,130,222,144,2,28,31,159,36,198,104,101,175,75,246,131,189,12,9,239,12,232,15,199,7,155,200,251,255,207,67,166,249,149,7,245,13,28,85,224,89,170,8,191,0,95,22,195,240,172,179,206,39,145,229,38,235,206,56,105,10,97,247,102,105,234,242,190,33,144,8,179,19,224,51,163,227,214,254,65,57,107,107,59,5,26,247,207,105,111,237,106,93,161,252,210,253,17,171,4,28,53,2,106,0,73,6,197,171,63,49,2,244,158,60,11,214,136,0,92,21,6,177,215,49,237,106,92,227,165,23,44,3,180,29,221,220,120,72,237,56,243,7,46,246,108,189,186,10,126,250,204,47,165,28,48,5,219,105,213,11,43,244,36,7,222,32,232,180,96,80,33,95,41,216,12,190,95,27,99,182,245,190,243,104,245,11,212,177,172,8,29,253,134,96,255,90,213,238,251,201,161,194,247,78,220,44,29,242,101,35,54,226,255,7,100,106,153,86,76,56,114,19,84,175,68,247,255,7,3,248,70,44,126,4,98,205,120,191,105,10,18,196,124,251,203,183,237,102,8,11,247,25,40,218,164,193,37,180,239,184,156,0,178,250,25,11,197,246,120,65,184,223,237,11,187,177,107,0,146,206,219,247,85,106,37,245,121,189,184,254,160,4,16,39,67,5,216,226,202,194,76,248,109,184,145,83,73,245,214,58,96,210,40,255,38,73,8,5,101,248,205,245,175,7,79,16,134,45,134,255,108,187,92,34,152,48,182,99,63,181,28,4,2,4,0,189,64,55,8,197,189,250,154,82,126,68,35,246,148,23,26,253,195,61,70,67,29,86,201,63,21,228,222,205,158,5,120,91,120,230,31,1,167,244,50,218,46,186,6,218,253,46,139,4,129,37,146,255,245,84,3,28,224,4,81,255,111,78,198,244,66,185,44,182,188,243,208,220,98,201,204,107,7,108,48,113,235,62,106,219,233,69,50,176,84,109,162,218,98,230,73,216,15,78,153,187,143,83,233,183,96,0,90,2,138,73,179,62,1,213,52,253,9,29,57,13,109,11,22,3,176,24,199,26,96,72,218,46,179,197,45,226,13,96,50,5,248,245,192,2,223,184,128,252,189,71,34,9,196,18,86,226,216,252,253,70,129,207,224,208,238,234,158,183,57,252,28,241,163,193,4,59,180,245,145,194,43,192,163,254,119,207,140,231,239,244,72,229,181,252,41,3,154,255,61,47,192,93,206,198,15,218,67,216,140,245,121,220,201,1,118,255,105,250,66,245,130,227,167,4,173,11,72,45,127,59,88,230,181,203,102,107,177,2,45,5,95,76,13,218,192,67,62,191,230,230,246,8,82,106,27,100,15,212,183,239,76,27,39,8,245,195,58,84,157,172,44,179,17,237,94,109,38,97,141,3,194,250,113,177,92,48,229,255,144,0,105,25,79,102,206,184,10,113,50,43,96,1,212,24,51,239,155,2,7,220,150,246,214,69,18,189,163,174,121,82,94,244,128,49,129,198,98,12,199,203,34,21,58,225,43,96,151,106,97,10,5,33,174,3,44,45,145,211,2,247,248,253,237,48,57,253,173,2,140,100,95,38,105,46,14,254,212,243,84,45,203,179,228,89,36,231,130,213,207,6,60,5,87,218,113,212,141,255,250,220,77,71,244,110,206,11,125,227,116,2,124,200,247,242,222,81,91,233,27,0,14,68,120,4,62,206,128,218,34,8,4,255,222,109,0,8,176,226,144,194,167,4,87,199,52,56,81,173,93,89,18,199,118,223,84,95,252,1,159,113,43,201,119,22,205,243,155,19,129,252,226,110,90,75,208,13,198,177,116,104,211,189,8,252,44,226,151,241,126,253,1,4,255,181,141,2,4,247,118,225,171,251,176,42,209,8,241,202,204,52,51,101,213,254,58,7,126,215,195,22,114,175,188,233,16,103,57,4,185,219,6,10,205,203,62,242,158,198,37,209,92,34,210,205,152,210,238,91,222,245,124,22,101,180,153,185,34,247,21,252,11,46,199,102,153,190,23,16,205,174,143,219,101,214,95,251,237,239,168,233,117,252,163,0,193,11,239,112,85,176,140,182,27,83,152,91,85,112,46,51,229,239,2,214,233,91,171,12,177,244,30,1,112,112,182,5,112,77,71,248,62,242,195,253,231,2,53,211,120,245,202,252,157,246,249,48,194,196,155,223,119,228,150,189,11,214,94,5,241,171,202,7,251,29,189,62,211,245,118,98,52,56,194,39,208,3,9,1},
} ;

static const unsigned char precomputed_core_scale3sntrup1013_n[precomputed_core_scale3sntrup1013_NUM][crypto_core_INPUTBYTES] = {
  {182,98,124,155,62,209,189,167,177,253,4,143,109,98,216,65,74,12,221,80,142,195,224,44,212,30,8,246,207,71,245,80,40,214,202,152,111,238,47,25,116,241,71,48,176,88,166,178,243,8,51,143,78,166,102,186,207,197,199,232,106,190,218,182,165,197,96,131,140,234,220,164,183,186,19,150,148,40,243,193,221,199,93,239,117,220,200,114,52,66,255,175,146,5,255,227,83,67,37,211,215,38,47,99,51,243,65,137,118,212,154,63,7,102,198,65,83,217,184,173,197,116,117,126,148,240,41,216,233,8,19,247,254,185,151,36,198,151,197,220,206,227,132,23,253,145,66,123,176,17,22,36,171,223,59,199,229,151,106,222,17,160,96,134,1,80,173,196,166,223,45,33,239,137,160,251,213,220,46,228,149,5,46,54,212,81,162,61,243,244,153,253,51,194,159,242,220,21,247,197,87,150,21,64,146,253,30,57,149,214,77,59,173,121,153,180,115,142,227,128,157,183,123,10,123,69,106,4,228,211,22,33,86,154,156,242,119,198,141,190,167,86,246,31,228,246,228,12,27,246,245,233,60,194,161,78,59,43,127,127,176,13,130,16,92,234,21,66,110,45,112,74,174,18,135,199,43,211,8,193,37,221,2,194,191,221,231,43,92,102,85,107,46,134,201,160,6,9,43,252,213,15,80,118,9,249,156,135,226,46,190,97,45,100,48,213,188,218,11,243,179,62,150,197,182,145,133,6,226,125,46,199,49,124,249,253,146,9,19,55,220,190,235,201,156,232,102,139,38,109,162,163,5,59,55,86,53,19,53,31,158,201,214,213,119,250,2,48,201,153,118,6,159,151,140,162,60,43,185,144,233,202,148,91,5,62,60,71,197,137,177,55,74,164,33,187,199,13,200,252,147,61,87,167,117,69,131,195,59,72,103,183,15,252,205,136,108,153,191,119,127,106,131,136,163,30,54,235,23,34,113,11,90,171,222,54,5,101,182,225,2,44,88,46,209,105,133,234,208,20,64,36,126,16,214,154,101,225,167,206,224,204,134,88,208,232,221,61,184,7,21,121,141,72,164,166,117,116,123,38,21,216,252,132,217,161,147,73,164,74,159,114,146,252,182,244,21,188,69,186,215,180,55,196,240,231,220,170,162,186,234,148,211,49,155,76,61,209,198,255,210,175,179,90,105,113,77,195,233,204,246,101,131,74,69,212,234,123,182,230,135,199,124,33,154,114,219,24,218,21,142,34,197,55,207,235,16,186,154,96,207,210,34,12,158,55,147,37,16,34,178,17,25,171,199,15,99,69,247,229,102,62,142,58,250,163,244,230,100,98,25,245,204,70,36,81,252,237,146,85,109,155,130,230,211,208,181,241,33,221,176,186,153,239,159,218,44,51,163,54,241,191,94,23,40,94,83,207,111,159,93,60,55,165,248,0,14,194,75,141,135,210,181,184,196,81,20,84,174,178,228,198,0,125,226,68,161,19,15,63,29,125,55,209,168,4,103,103,190,41,241,24,109,9,91,60,248,77,13,21,239,38,70,14,255,94,170,193,146,145,213,162,119,142,18,37,110,174,179,190,48,172,31,12,2,90,132,254,33,45,211,185,182,214,62,69,145,31,96,253,202,83,102,112,68,228,238,240,14,1,68,125,47,179,106,246,101,39,132,215,77,117,174,132,126,170,6,147,229,119,195,77,154,196,137,114,42,82,190,166,206,233,182,131,108,74,15,249,146,204,121,78,81,57,165,36,40,195,29,10,221,216,241,222,134,52,65,243,78,129,29,71,247,132,170,195,240,140,252,179,95,163,198,119,170,247,109,194,141,107,237,100,67,41,92,99,214,248,42,112,86,46,5,187,241,214,157,220,225,59,200,136,238,238,7,142,0,188,124,135,201,149,179,147,7,75,222,247,65,5,116,92,33,104,51,151,159,164,219,145,235,120,38,198,66,12,54,214,154,94,41,46,167,50,70,96,171,77,168,56,38,194,130,207,194,197,115,234,48,3,185,203,231,135,62,255,138,157,241,213,180,16,96,139,123,132,248,223,212,74,37,202,155,238,69,148,206,189,192,233,243,230,176,161,60,108,168,112,54,229,124,78,250,54,239,147,72,48,172,50,103,134,70,131,190,242,21,169,26,120,8,230,247,39,164,212,10,25,73,15,65,7,82,189,224,198,16,187,124,42,55,149,14,216,73,36,98,207,134,177,163,27,11,242,178,21,216,222,151,126,231,212,238,24,1,114,24,18,200,15,140,215,219,64,212,76,219,217,219,99,100,67,75,65,108,174,158,197,159,190,35,171,15,37,113,125,127,92,49,161,67,12,249,129,245,111,150,145,168,99,91,68,218,72,9,151,68,190,42,37,218,193,74,197,178,219,249,230,59,181,195,196,64,106,243,181,11,0,203,151,109,8,217,248,78,6,190,82,183,220,141,127,39,240,213,21,62,211,193,243,181,189,146,185,227,78,252,117,143,28,56,214,228,154,229,35,186,76,3,20,187,230,172,106,91,182,224,201,185,70,225,40,165,60,62,229,88,244,115,75,165,49,238,107,149,78,124,16,152,91,42,20,17,196,134,200,154,129,213,61,243,120,195,28,201,241,65,185,64,39,148,157,57,168,211,179,145,63,168,207,190,175,74,38,73,5,81,184,8,232,179,224,104,194,157,14,152,35,47,67,72,194,37,69,109,53,147,54,235,100,180,15,106,191,75,19,47,188,108,80,176,50,101,11,43,123,79,87,62,238,157,18,69,100,43,53,79,141,253,148,8,24,75,34,49,248,142,124,219,56,183,218,145,61,249,147,34,173,92,222,175,215,218,125,117,211,197,103,149,63,250,58,139,239,33,214,44,182,54,187,117,84,75,35,109,69,128,136,49,210,249,41,125,91,52,105,29,66,105,184,106,0,131,78,135,236,172,32,199,9,155,159,251,128,141,203,168,134,43,89,17,184,81,60,55,141,96,21,39,50,136,67,22,32,249,205,193,140,238,23,10,180,243,31,74,50,175,7,225,179,186,76,45,240,7,187,23,212,232,130,104,67,187,68,6,206,40,14,243,31,166,80,161,239,78,26,18,14,141,131,231,81,12,120,167,15,205,253,137,31,212,39,143,153,222,206,174,118,9,229,173,106,164,243,219,250,19,252,183,19,126,60,171,197,99,167,133,181,19,70,95,112,244,211,121,137,9,41,30,128,207,157,135,169,105,25,4,201,175,67,233,0,69,160,231,50,99,219,7,160,180,135,202,87,158,189,26,23,62,189,11,28,232,7,87,34,218,98,177,79,194,19,62,91,243,199,65,187,93,59,63,150,111,97,15,3,7,13,11,9,145,124,193,8,251,236,101,83,249,52,166,39,225,51,82,93,25,66,247,9,150,210,195,65,123,40,219,198,152,122,214,246,236,68,241,52,3,192,219,249,236,229,136,247,150,156,139,112,214,244,250,38,145,58,164,65,16,53,20,95,25,73,216,133,251,60,69,96,15,89,32,254,201,254,241,56,26,140,98,60,13,116,15,240,23,91,183,160,177,107,157,125,62,71,218,70,173,196,95,33,87,150,251,138,183,156,251,57,233,202,23,27,118,67,89,120,208,187,74,201,21,168,161,106,4,6,149,35,94,102,175,182,147,95,69,167,40,32,35,26,215,45,129,28,6,205,219,213,153,20,87,99,220,23,188,130,238,37,232,0,225,116,207,56,182,247,157,68,134,70,86,253,188,67,232,254,82,207,65,226,214,185,150,102,13,75,96,10,215,125,39,192,135,17,225,179,184,78,101,149,100,54,194,242,33,195,67,183,162,154,102,30,223,77,46,30,224,140,224,166,37,56,212,120,204,178,123,14,38,99,125,180,64,8,204,150,249,196,177,187,167,141,170,216,214,179,125,197,29,222,12,78,240,66,63,60,201,214,169,245,131,15,132,74,45,171,56,232,24,83,252,43,246,212,72,8,228,145,35,16,53,43,163,219,173,78,242,192,196,184,92,158,119,69,239,74,111,54,172,165,166,198,24,44,151,100,91,100,125,63,148,200,191,117,176,212,143,126,27,242,28,102,75,122,153,24,96,15,6,136,220,203,253,206,119,113,236,205,49,209,37,12,40,60,129,20,130,114,160,103,121,125,209,24,252,110,224,153,64,223,176,232,180,219,42,189,248,177,209,0,199,223,106,41,69,9,114,243,63,155,61,115,106,130,219,32,77,218,126,196,169,11,66,211,185,125,189,6,80,234,87,254,248,71,8,167,7,59,67,200,65,215,226,112,64,44,88,17,163,202,62,205,44,229,109,68,32,73,208,235,97,91,151,15,66,217,141,249,184,25,173,92,52,24,17,245,60,172,100,143,10,233,225,196,74,79,86,72,63,57,39,195,224,157,112,3,44,255,43,182,131,157,252,144,34,197,110,2,240,180,56,24,167,130,28,92,140,88,221,21,247,186,89,125,140,224,22,13,120,45,214,13,250,240,157,170,22,89,8,31,139,190,176,117,165,101,229,30,19,55,114,96,104,185,210,206,96,47,49,217,148,3,196,252,238,241,59,106,226,115,196,236,209,102,55,183},
  {64,69,232,196,7,77,113,185,174,86,7,161,111,108,189,120,73,13,159,243,113,163,90,12,32,138,171,182,167,82,238,61,41,12,212,85,75,77,137,125,114,187,90,76,161,2,28,138,87,17,208,137,144,147,167,5,225,182,67,94,250,111,102,245,233,29,254,10,64,69,232,245,131,72,165,249,220,188,62,37,246,16,20,134,126,115,149,206,83,85,63,94,215,129,107,69,208,137,119,198,60,46,141,171,107,175,183,162,44,84,182,38,62,85,124,218,217,44,115,48,123,4,190,155,223,55,215,32,126,224,21,21,45,203,193,59,98,121,132,240,132,85,56,12,253,60,110,97,171,118,3,207,53,40,252,176,50,179,84,247,19,126,14,79,215,55,79,61,202,245,156,173,149,176,16,142,253,187,144,20,239,250,91,86,215,217,149,209,131,83,129,69,78,3,154,18,247,139,85,17,240,194,186,176,33,229,189,250,41,111,71,107,15,251,139,174,162,119,121,45,249,248,42,28,6,207,96,147,111,75,176,82,125,175,78,105,115,77,231,134,80,8,181,216,42,206,85,55,208,92,121,201,153,216,18,255,112,1,195,24,36,204,115,0,211,179,159,210,27,26,102,225,249,80,253,123,36,2,138,5,215,131,69,109,53,63,112,46,49,21,87,212,162,143,112,231,246,228,118,139,99,126,211,155,170,212,223,157,87,190,55,29,227,42,63,113,86,100,186,2,200,222,100,1,80,198,62,18,193,29,198,254,244,18,213,253,179,97,161,8,213,211,112,16,35,35,240,87,112,243,225,67,70,117,27,107,57,136,8,240,163,142,215,173,214,79,219,194,11,55,10,180,126,203,135,109,121,131,196,255,157,220,116,108,35,111,208,103,53,88,46,78,53,26,197,3,66,150,84,110,250,1,235,71,253,150,221,34,186,137,20,63,9,80,93,40,181,83,252,1,161,20,39,202,241,165,1,244,63,109,84,58,109,19,89,241,7,206,186,42,174,156,209,200,11,49,199,237,129,27,173,223,163,126,85,66,61,18,38,76,58,185,244,217,236,9,137,22,204,120,0,127,76,182,118,148,27,243,115,126,75,133,197,114,119,53,115,194,154,116,0,211,42,160,197,25,230,54,245,144,25,238,105,225,151,75,56,136,104,151,131,141,157,29,95,253,118,89,27,18,237,188,76,75,54,73,154,116,248,2,254,211,19,51,13,2,122,252,167,127,84,42,58,121,119,53,211,21,49,76,79,41,194,149,243,85,82,76,90,168,254,1,184,31,134,148,167,21,76,103,24,250,250,5,200,37,229,12,251,140,63,65,111,50,243,221,128,105,244,134,166,178,189,114,34,209,183,140,93,84,181,93,240,38,248,169,216,162,201,19,154,84,61,54,155,150,85,178,120,186,147,222,97,247,42,23,152,91,96,182,169,71,52,171,102,129,161,226,3,252,95,62,168,105,235,75,107,191,65,234,89,12,192,169,25,184,201,250,72,160,156,45,9,45,91,61,76,166,11,138,184,192,112,193,111,103,140,57,25,119,21,40,171,171,93,12,154,197,38,188,178,46,206,31,148,205,86,59,155,126,233,52,38,65,67,168,174,91,76,48,144,19,22,183,211,136,232,161,102,96,113,209,74,195,30,120,237,148,249,166,185,37,212,111,54,6,90,230,246,214,59,195,150,19,130,19,253,188,125,65,131,188,218,157,211,217,237,236,217,42,38,177,134,8,148,14,30,125,153,49,187,4,13,179,183,16,166,165,51,15,211,200,207,36,35,88,96,25,114,103,253,19,215,147,106,133,247,71,147,160,253,114,184,106,132,225,249,251,218,121,203,197,72,105,55,250,182,165,49,91,129,95,52,20,161,134,138,81,66,208,123,213,198,125,98,104,221,6,70,154,191,10,78,229,102,86,131,250,45,79,112,169,14,73,68,123,45,135,66,51,109,20,236,20,88,13,13,82,153,237,190,207,21,130,137,32,106,178,135,246,56,203,209,21,11,106,187,202,153,190,16,114,117,238,30,54,78,253,229,37,231,121,59,39,224,83,17,132,212,178,63,233,92,98,151,121,67,8,217,229,147,246,185,73,80,8,137,97,231,8,140,81,190,147,102,87,174,189,78,231,2,147,64,26,191,143,246,238,37,153,154,87,224,38,202,2,17,22,118,224,45,117,60,61,251,39,126,54,85,38,21,153,21,48,171,88,18,155,208,142,47,234,190,41,142,46,161,38,148,145,60,33,92,138,1,240,225,134,250,180,98,142,215,153,229,103,82,95,147,224,15,36,225,173,212,10,185,233,174,196,153,53,90,34,103,22,180,162,117,103,143,36,165,122,182,210,86,244,182,176,137,20,134,5,168,199,159,151,209,81,189,176,150,100,70,145,37,109,130,222,85,215,1,145,10,66,198,204,73,209,133,3,86,96,194,13,72,77,159,25,80,143,133,13,77,121,55,183,223,202,171,172,109,185,159,79,99,72,125,34,6,13,223,36,117,80,171,61,170,210,240,36,52,186,35,98,240,67,62,14,54,243,145,131,212,219,49,83,145,48,234,116,140,46,119,96,120,140,121,222,29,123,30,208,188,212,203,61,238,76,128,180,57,109,40,69,221,66,57,161,129,11,102,109,83,48,204,47,192,137,208,116,100,10,96,122,157,208,224,244,61,99,97,184,180,226,23,223,16,102,105,76,34,192,30,168,47,13,205,34,98,25,163,233,215,229,204,241,86,232,37,23,110,254,236,143,214,129,10,82,116,119,179,194,47,80,84,198,49,152,47,73,115,127,214,133,29,25,175,102,251,243,89,67,26,176,2,204,57,10,179,193,167,237,208,168,33,116,129,202,148,65,194,16,188,67,177,2,234,122,29,200,66,200,153,254,85,217,192,191,144,142,134,228,11,243,208,251,255,195,143,64,175,56,241,24,125,93,217,28,234,4,189,20,125,33,223,138,136,189,216,78,14,233,186,194,34,197,31,4,211,247,23,27,114,50,145,193,254,142,19,116,145,239,111,253,165,249,186,17,103,39,176,136,201,137,109,5,16,174,110,174,221,150,211,177,105,218,239,32,103,161,19,26,142,60,31,114,203,60,248,153,162,152,6,240,160,136,234,212,201,76,75,6,101,156,222,172,13,17,149,101,26,113,100,73,164,20,141,154,182,221,186,236,217,141,127,241,31,129,227,240,24,141,215,224,66,138,48,69,6,138,99,150,104,35,122,113,151,248,134,17,83,201,31,35,74,135,213,245,6,92,168,160,200,193,31,56,204,83,68,80,92,145,87,226,253,191,107,78,186,15,128,167,175,48,18,1,74,117,153,207,119,22,61,13,113,13,43,197,228,215,247,23,23,145,201,154,44,77,133,154,219,148,111,1,116,107,136,44,163,53,168,217,49,37,90,121,14,127,53,244,91,6,223,218,221,180,107,140,253,55,204,189,211,210,253,110,221,194,63,97,109,36,85,12,180,163,251,251,114,169,48,191,65,189,176,172,129,40,87,141,139,236,112,214,47,172,238,31,90,5,248,91,29,74,91,87,142,224,238,89,60,123,150,87,40,12,159,20,214,230,67,187,255,85,133,100,20,153,100,203,182,241,43,125,243,114,151,162,170,34,74,153,19,237,14,47,75,219,146,61,170,196,226,183,42,159,211,33,50,33,90,3,79,123,173,238,170,128,35,22,44,80,189,88,186,213,227,234,243,39,165,125,158,147,77,160,159,171,152,226,250,242,127,132,232,183,3,121,12,48,111,193,124,126,36,15,120,21,79,121,169,217,214,156,226,93,4,20,126,47,178,133,149,1,227,204,45,179,30,136,39,244,247,202,158,243,155,162,218,84,114,241,225,161,19,50,37,232,143,220,222,5,13,73,157,216,195,104,133,64,88,163,194,87,181,88,126,253,217,130,8,149,195,195,198,91,100,89,23,221,68,142,193,28,120,105,53,16,108,128,67,81,32,112,162,112,87,202,200,2,56,40,13,123,207,168,109,18,112,162,57,129,181,33,112,190,219,90,47,196,12,15,68,194,150,60,47,99,132,81,174,46,136,88,198,227,116,132,72,204,41,109,190,203,4,141,56,16,119,246,200,149,96,220,12,89,217,113,50,116,136,88,152,122,138,56,160,103,178,96,41,169,84,196,144,194,168,47,71,145,199,139,198,234,56,119,60,206,57,55,124,42,136,168,218,84,116,228,134,133,97,152,1,169,175,95,227,88,25,181,120,196,192,83,239,130,152,223,209,204,249,54,243,227,136,210,243,59,74,61,194,12,39,152,211,227,17,19,195,233,174,4,6,245,44,187,26,41,56,9,214,13,167,137,168,116,123,237,43,109,19,207,169,119,235,61,12,240,172,223,76,102,165,164,87,22,44,125,136,239,199,91,49,193,170,171,27,15,222,206,28,179,249,48,35,91,208,133,127,22,83,47,228,146,241,161,133,119,245,211,61,55,159,145,77,116,15,82,134,0,49,226,141,243,57,143,205,23,158,161,108,161,47,102,13,25,12,181,202,4,103,170,127,125,205,11,153,161,170,173,179,163,224,17,108,40,67,6,83,37,16,59,190,255},
  {112,192,157,116,3,42,66,209,217,77,132,154,175,84,171,108,181,38,20,227,231,193,100,228,50,213,189,110,246,101,151,17,238,242,93,166,207,61,243,65,106,8,134,193,79,100,203,254,71,116,94,59,105,106,240,102,131,152,146,76,91,71,160,218,41,173,234,190,220,140,246,82,47,8,207,231,167,235,216,120,228,227,0,117,155,117,185,205,118,237,63,62,234,36,141,45,246,58,123,183,38,144,205,156,96,73,89,172,238,187,229,111,249,37,70,195,73,2,195,88,143,198,17,171,107,200,59,21,232,63,151,60,22,172,97,101,34,174,51,224,29,41,151,79,254,97,122,196,216,156,54,197,97,213,145,107,109,237,215,207,145,143,34,205,26,48,97,72,102,240,187,33,162,214,14,78,100,168,136,46,170,155,222,232,164,66,61,34,242,119,51,251,117,188,59,51,254,83,155,242,32,167,127,205,213,152,21,14,83,46,242,104,237,193,192,174,62,21,150,65,0,228,105,137,218,101,51,175,161,134,116,105,114,146,131,93,211,41,145,148,77,135,121,112,54,184,20,72,42,53,211,181,141,145,178,119,214,26,69,129,114,63,131,93,247,95,11,212,113,59,196,55,128,184,63,135,42,4,210,123,188,76,120,217,88,203,23,248,151,70,248,48,91,27,229,139,163,200,137,240,123,130,28,67,114,174,4,81,127,33,166,137,176,222,132,72,53,13,72,82,248,40,4,131,121,254,133,0,120,100,113,229,4,133,147,167,171,64,59,238,144,197,70,88,224,60,156,56,249,102,137,156,190,252,49,110,40,49,13,171,130,24,79,198,253,236,25,171,202,115,34,214,2,191,65,77,62,21,152,50,237,170,63,140,101,49,202,211,19,208,97,199,16,162,205,174,194,66,132,54,68,170,185,105,48,10,239,193,15,6,146,123,32,242,125,245,98,147,59,77,195,112,203,16,189,13,158,104,122,220,249,70,153,64,62,153,226,67,115,46,122,11,233,252,221,103,182,176,216,169,143,21,218,200,165,9,246,187,217,63,101,220,9,171,55,6,6,231,207,232,111,20,151,22,35,85,118,165,117,193,195,90,8,136,142,36,60,233,115,178,133,147,231,75,113,149,191,230,185,154,210,152,60,170,214,155,97,176,132,175,8,13,66,177,188,207,160,120,177,237,149,12,141,149,113,160,45,66,16,118,187,140,135,75,127,70,149,156,6,247,189,9,76,191,164,94,212,96,180,51,105,49,121,43,45,241,251,82,172,19,17,97,89,186,193,173,141,18,184,189,11,193,191,20,248,150,48,102,54,51,105,14,181,47,67,241,186,47,248,146,135,80,44,89,104,221,130,95,55,86,144,174,54,203,26,129,79,220,104,0,213,54,57,223,114,39,91,89,230,44,220,185,10,124,0,143,73,176,34,171,87,188,53,179,44,177,253,69,189,87,175,100,104,241,226,243,210,26,5,138,83,24,103,229,129,118,178,106,155,73,75,107,194,37,10,18,144,9,250,119,64,162,25,184,249,107,148,239,249,112,126,32,23,55,49,43,132,68,192,18,204,86,99,26,195,7,166,129,29,150,54,86,26,8,191,74,172,123,62,147,199,223,16,173,245,98,55,196,108,153,4,148,196,176,35,38,139,174,129,104,130,55,250,36,217,106,51,249,86,31,68,10,102,236,142,151,17,102,131,132,91,40,224,45,139,108,0,26,69,239,255,109,17,210,157,199,181,13,106,117,5,129,164,250,127,88,205,108,175,39,218,162,159,137,92,155,39,169,231,36,185,116,10,136,91,197,157,255,103,202,207,31,40,48,241,104,86,172,192,252,219,204,147,84,251,88,105,129,10,160,201,182,223,233,51,89,47,12,191,45,15,36,225,91,229,197,61,49,99,33,202,5,56,109,182,83,62,156,170,159,53,49,141,150,18,247,0,7,237,116,72,219,49,42,86,169,246,32,68,161,65,133,12,157,117,3,87,255,139,218,7,55,233,234,75,34,149,234,0,117,239,67,126,215,243,89,208,89,18,150,176,28,66,229,41,179,13,150,12,201,3,185,112,203,1,231,200,114,69,1,231,226,224,93,86,62,232,158,21,241,32,26,65,82,242,117,211,75,147,210,58,135,100,208,104,172,213,240,151,158,219,10,221,91,239,110,234,149,222,44,165,239,192,9,41,116,146,162,197,194,88,43,119,31,226,149,199,157,81,56,233,87,145,192,117,46,38,154,145,183,145,235,124,45,190,251,181,96,128,197,222,162,0,112,154,206,204,159,137,139,242,159,171,170,58,193,22,195,145,153,161,54,240,234,254,103,4,233,74,12,50,109,208,15,183,228,6,190,99,76,248,155,119,102,140,13,177,243,52,86,182,51,159,153,221,184,147,69,23,240,65,10,0,152,99,219,155,112,161,221,208,189,213,106,59,107,225,21,5,168,103,154,243,240,131,176,108,124,37,52,144,77,245,31,127,137,158,172,144,117,192,141,199,48,146,7,19,111,228,53,172,62,194,223,106,147,4,179,232,13,138,46,105,223,152,199,88,76,9,53,254,90,63,163,53,208,188,211,152,206,124,140,157,33,217,89,29,141,219,56,200,245,132,130,107,113,50,225,86,197,8,24,228,20,76,181,250,11,234,99,83,60,241,208,114,169,24,252,125,104,89,66,245,112,56,70,158,60,39,111,161,52,180,7,207,246,215,116,205,190,249,17,159,238,246,138,150,208,235,197,34,98,80,20,2,129,116,165,23,181,92,67,253,108,161,103,163,49,158,127,103,63,135,137,150,164,211,149,31,206,180,151,192,51,152,137,182,14,53,13,222,166,90,108,225,221,52,211,199,240,61,221,118,169,35,11,233,29,189,196,138,60,137,153,50,204,229,174,21,167,106,126,45,233,231,232,177,135,180,26,159,191,13,99,194,246,51,124,73,243,138,142,104,172,134,144,133,104,102,128,7,153,136,108,109,236,158,186,241,215,182,77,205,20,218,13,70,15,12,160,58,0,90,175,119,97,32,85,181,149,37,87,43,13,214,252,147,204,4,231,118,146,211,219,176,76,205,247,220,183,188,51,86,66,178,199,216,68,244,192,95,159,193,249,239,235,108,88,122,150,190,56,35,230,190,55,159,225,50,217,20,136,57,226,48,220,211,234,29,140,52,22,69,123,51,69,184,29,232,228,55,152,123,120,99,81,0,134,81,174,167,177,1,117,1,94,206,91,151,25,156,156,13,168,100,246,208,71,134,232,245,6,128,38,110,190,35,42,253,197,233,71,187,246,215,202,68,236,7,110,166,128,221,166,147,17,242,73,255,194,117,202,48,80,17,47,80,107,208,167,82,117,92,3,134,243,85,134,100,40,154,185,69,76,137,142,212,112,163,114,197,72,65,14,147,141,228,92,242,113,126,187,77,4,18,121,29,222,177,50,225,43,215,205,183,110,14,162,123,240,139,33,243,141,13,199,152,137,102,245,174,20,227,52,28,123,205,141,243,80,127,89,88,106,79,98,239,228,138,132,196,42,197,95,111,11,67,142,17,13,133,12,164,90,230,94,182,84,77,78,48,224,218,93,147,199,25,40,132,42,249,38,38,176,120,147,160,69,120,157,218,127,2,111,209,209,47,63,222,94,27,163,123,142,89,20,249,37,138,18,71,122,239,150,132,157,239,36,175,145,145,36,52,141,144,200,176,69,92,217,190,213,78,10,206,82,213,47,97,104,136,65,11,194,170,42,221,115,38,51,169,154,171,44,60,93,231,170,16,144,255,248,45,169,179,1,205,162,207,254,150,104,233,118,225,141,122,49,109,90,25,216,186,228,213,177,247,114,22,2,71,131,2,115,139,27,148,104,110,128,224,173,64,191,236,67,54,157,118,57,9,162,35,87,112,47,83,181,21,247,235,64,212,195,88,123,19,49,125,82,12,208,166,88,78,95,68,107,47,14,124,217,237,55,15,170,140,63,4,253,222,27,111,97,238,43,1,7,183,60,21,255,192,217,118,104,192,129,4,86,161,156,153,88,34,49,123,223,23,21,81,242,113,131,14,225,32,28,50,45,186,21,181,187,218,145,168,179,208,67,166,170,29,203,230,246,240,11,225,130,155,152,199,156,73,128,137,176,32,98,31,20,138,56,64,0,90,4,247,124,0,27,208,120,170,17,209,243,191,102,217,203,119,95,65,81,26,148,25,38,132,34,18,90,207,102,185,58,83,154,248,79,197,73,59,170,72,11,29,128,197,81,87,207,17,204,160,247,132,251,4,228,111,216,155,244,250,202,188,53,2,131,168,153,67,131,190,29,2,164,175,198,226,52,137,33,234,21,235,230,60,180,201,215,160,248,138,232,36,32,122,123,186,16,252,37,79,176,183,185,143,143,92,193,156,53,166,30,203,145,117,202,85,43,106,1,47,188,198,235,140,186,191,32,10,116,52,18,106,198,201,233,193,215,119,183,47,98,31,25,12,85,252,112,139,90,117,23,173,121,152,131,87,205,248,235,131,245,248,69,57,251,231,42,89,219,99,60,173,206,53,235,233,54,60,56,202,196,147,79,217,36,106,43,126,207},
  {153,74,26,103,108,123,53,252,254,220,106,30,162,188,43,62,112,162,46,79,66,237,207,244,202,86,205,26,222,85,177,97,209,249,86,110,191,127,210,65,197,253,252,154,188,166,128,98,199,92,216,106,231,8,199,173,123,65,6,57,99,70,54,5,176,252,87,218,250,99,199,209,72,184,140,225,217,70,94,77,150,92,215,144,251,108,161,185,175,65,255,57,235,56,183,54,254,193,254,47,222,189,136,117,2,186,177,15,184,103,51,23,243,133,193,252,213,253,145,208,249,163,46,38,35,227,32,22,34,39,51,229,57,227,64,59,47,222,87,185,150,250,135,243,241,99,191,29,86,113,42,226,132,91,100,200,72,130,98,33,247,116,49,125,152,131,23,103,178,228,229,80,143,111,86,85,51,119,34,191,113,163,246,88,80,41,79,113,11,39,203,139,129,51,241,165,48,206,153,249,120,214,81,112,133,48,89,148,110,227,70,237,180,237,204,35,56,98,99,171,81,15,187,221,206,167,5,212,253,41,67,163,106,32,229,87,70,34,215,64,91,224,83,140,154,145,125,102,122,34,224,123,94,19,238,250,50,143,213,8,140,40,38,164,63,161,58,125,213,251,129,2,144,158,211,65,44,156,139,234,148,139,64,83,34,234,226,121,187,192,59,25,10,28,121,134,126,252,54,84,66,58,167,17,249,16,32,7,128,12,241,234,191,230,123,116,224,123,233,88,149,110,3,170,214,21,246,193,111,236,157,91,112,75,28,241,148,179,144,169,132,100,221,125,106,254,53,127,201,3,188,117,57,149,36,146,102,58,200,156,114,25,239,23,66,89,194,145,125,9,191,4,254,102,123,93,201,140,208,242,226,25,54,118,248,105,160,116,163,245,188,236,123,113,225,102,170,89,128,233,239,236,192,94,142,128,54,197,221,2,149,163,63,194,3,190,36,18,13,14,84,201,249,222,252,252,158,202,25,38,217,69,49,90,98,57,136,66,105,204,203,155,1,118,191,235,249,184,82,234,220,229,205,39,192,19,144,86,247,23,103,235,33,8,162,54,125,21,185,231,192,143,244,195,201,132,164,28,142,226,134,225,41,163,209,57,38,24,189,89,103,5,149,81,119,139,87,155,86,79,50,207,123,35,234,48,59,157,34,76,81,109,42,233,249,222,207,46,242,199,158,148,59,8,78,192,204,37,234,22,10,206,73,221,225,178,217,11,22,248,202,155,7,239,148,193,70,229,171,88,239,116,165,68,66,202,107,132,62,238,4,167,163,55,83,36,177,138,171,120,216,20,227,56,28,20,153,68,35,68,236,29,133,246,178,47,140,222,173,210,50,44,163,76,245,122,201,27,207,5,146,237,180,191,117,215,176,126,124,111,160,173,82,27,121,24,103,83,63,249,202,88,33,123,207,47,36,137,200,206,24,165,60,13,217,98,112,116,47,131,42,198,236,154,112,28,191,48,190,159,77,176,235,79,6,136,165,149,88,90,29,15,133,144,165,20,225,122,252,39,101,163,163,161,173,119,87,194,68,125,245,132,26,222,137,109,15,110,120,255,174,243,1,181,23,174,165,166,208,217,106,239,5,44,115,33,222,103,140,144,84,220,191,180,226,72,68,191,138,4,92,152,94,86,69,71,61,53,22,93,133,143,9,111,27,82,39,66,198,91,107,61,129,94,14,47,136,212,55,30,23,171,2,110,249,109,226,18,10,99,68,164,163,170,172,74,132,106,118,12,126,141,73,45,135,137,158,133,210,44,237,9,97,65,182,128,115,187,154,203,52,131,123,199,217,147,27,108,118,168,71,227,72,78,88,71,215,81,98,88,242,252,148,166,78,160,158,70,15,145,17,154,178,108,191,203,137,58,146,44,1,207,6,70,25,155,58,235,184,99,220,44,95,242,65,82,236,194,75,80,148,69,183,4,64,235,153,220,147,103,166,60,105,101,171,62,44,86,195,72,106,31,155,235,148,21,130,154,57,67,62,162,207,181,236,89,100,169,253,77,136,162,19,12,133,2,54,189,177,178,38,136,97,223,205,231,88,146,16,157,111,234,104,2,34,181,140,115,234,251,96,160,241,168,214,50,57,243,249,88,244,250,28,81,168,189,153,225,241,248,3,68,0,90,127,189,193,194,254,254,107,90,122,164,247,117,228,159,107,89,227,241,123,200,202,146,77,51,116,122,211,161,249,231,54,210,68,182,13,113,235,240,131,111,123,243,8,33,30,19,198,138,132,33,69,32,86,255,184,109,58,90,123,218,134,163,109,68,228,99,117,87,74,78,171,167,238,254,61,26,27,147,211,64,51,10,183,19,56,192,69,44,116,134,28,6,126,224,1,79,162,165,251,99,234,163,134,57,172,94,72,117,229,177,138,182,170,184,183,37,163,124,145,97,152,9,120,187,62,156,225,135,157,22,216,237,95,154,157,113,32,250,200,243,37,215,81,90,237,105,45,164,148,186,163,26,222,151,245,8,110,28,124,130,108,96,94,82,72,215,34,155,209,125,139,169,70,255,88,218,175,18,100,247,206,170,192,248,148,218,24,111,83,157,141,29,86,147,219,94,119,16,255,134,160,196,82,130,113,66,58,17,100,86,63,19,156,149,43,204,82,28,81,173,186,252,33,139,62,174,45,178,71,25,58,104,16,87,76,215,74,13,182,242,12,173,77,20,245,50,35,36,14,41,96,233,1,54,120,18,30,222,164,139,84,44,167,174,153,220,228,2,95,84,133,41,88,210,68,70,166,228,136,55,0,121,247,194,92,71,122,106,15,66,82,249,207,44,54,38,199,198,41,101,25,49,108,82,82,249,4,92,197,194,42,172,115,144,37,225,38,98,3,56,215,7,150,222,82,214,85,250,0,18,181,148,137,140,180,50,162,137,55,180,233,92,182,183,154,91,43,31,229,235,79,89,230,49,118,161,131,59,70,73,202,44,186,5,208,53,232,84,224,86,179,107,193,1,69,66,235,140,199,6,204,222,222,207,198,5,245,28,29,146,181,75,101,204,85,248,116,73,242,5,232,11,200,14,133,24,133,94,33,53,119,191,139,25,149,42,18,51,180,86,89,181,253,138,195,27,85,56,66,178,225,36,45,32,97,167,223,187,91,160,68,115,197,31,98,123,70,201,4,152,71,59,138,172,43,125,37,238,178,161,141,81,99,63,183,52,255,233,2,25,214,162,46,107,134,170,170,37,4,104,160,1,30,9,40,206,69,176,19,223,97,51,145,242,237,234,115,228,71,45,176,130,19,47,252,200,203,63,166,32,99,49,31,131,51,234,115,67,192,62,8,206,48,53,136,122,160,222,32,0,27,162,49,119,148,115,168,61,185,245,6,19,19,175,207,3,178,171,147,17,240,188,35,204,161,195,142,56,12,66,178,126,102,172,171,176,61,162,242,222,125,245,66,33,182,173,239,100,111,151,69,160,2,33,40,145,157,145,247,68,135,222,19,84,177,241,222,225,175,199,57,243,216,140,182,54,228,8,122,230,129,238,168,5,21,67,234,178,99,86,222,255,194,195,67,211,151,227,2,234,190,62,132,252,208,234,67,171,210,255,38,178,19,243,211,151,141,1,140,250,27,195,216,199,197,152,228,143,37,45,59,86,18,11,120,205,172,148,67,117,103,54,159,67,82,88,201,44,12,128,2,232,58,241,199,103,13,88,164,226,193,122,220,218,97,50,88,240,205,45,101,212,44,77,147,159,120,220,119,25,247,255,51,180,38,103,200,128,151,137,177,217,105,194,29,247,159,17,14,241,140,95,170,234,53,6,245,117,3,139,222,48,214,36,199,242,131,196,40,142,115,165,234,143,185,101,187,65,188,126,224,44,203,88,90,20,55,77,103,24,216,231,86,82,171,8,82,196,19,255,143,171,135,213,120,107,38,110,90,255,153,242,31,195,150,50,79,39,9,153,211,61,66,78,17,163,26,234,120,61,50,9,251,234,114,118,255,216,151,250,124,66,124,171,209,142,250,156,77,207,198,153,9,0,93,117,43,96,103,59,125,63,182,2,175,179,77,131,0,88,141,151,45,226,141,1,26,57,191,198,24,219,34,39,3,57,207,235,31,41,84,171,56,47,182,57,128,187,239,251,140,186,43,84,249,216,33,205,240,89,63,135,127,129,238,53,85,245,97,151,218,241,39,75,171,86,82,51,47,86,175,91,207,65,54,245,147,23,158,97,248,228,71,112,20,43,74,94,187,163,39,233,68,102,35,49,145,68,179,43,19,172,144,234,5,98,236,143,103,71,135,227,180,145,119,191,67,59,133,231,253,39,71,243,215,16,116,221,48,223,182,167,10,8,92,195,240,128,48,54,96,185,236,48,130,234,116,147,120,178,76,241,53,239,39,84,225,170,232,79,168,217,196,134,129,51,12,37,139,210,202,46,189,111,244,155,83,147,166,210,60,184,59,252,7,247,211,46,149,96,211,205,109,253,109,175,68,179,80,10,100,146,37,243,235,74,226,176,86,196,147,141,134,150,122,237,47,139,86,147,205,181,248,47,241,11,172,104,66,30,241,81,213,212,191,198,153,22,243,95,0,247},
} ;

static const unsigned char precomputed_core_scale3sntrup1013_k[precomputed_core_scale3sntrup1013_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_scale3sntrup1013_c[precomputed_core_scale3sntrup1013_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_scale3sntrup1013_impl(long long impl)
{
  unsigned char *h = test_core_scale3sntrup1013_h;
  unsigned char *n = test_core_scale3sntrup1013_n;
  unsigned char *k = test_core_scale3sntrup1013_k;
  unsigned char *c = test_core_scale3sntrup1013_c;
  unsigned char *h2 = test_core_scale3sntrup1013_h2;
  unsigned char *n2 = test_core_scale3sntrup1013_n2;
  unsigned char *k2 = test_core_scale3sntrup1013_k2;
  unsigned char *c2 = test_core_scale3sntrup1013_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_scale3sntrup1013_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_scale3sntrup1013(impl);
    printf("core_scale3sntrup1013 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_scale3sntrup1013_implementation(impl),ntruprime_dispatch_core_scale3sntrup1013_compiler(impl));
  } else {
    crypto_core = ntruprime_core_scale3sntrup1013;
    printf("core_scale3sntrup1013 selected implementation %s compiler %s\n",ntruprime_core_scale3sntrup1013_implementation(),ntruprime_core_scale3sntrup1013_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(n2,n2,k,c);
      public(n2,hlen);
      public(k,klen);
      public(c,clen);
      if (memcmp(n2,h,hlen) != 0) fail("failure: crypto_core does not handle n=h overlap\n");
      memcpy(n2,n,nlen);
      secret(n,nlen);
      secret(k2,klen);
      secret(c,clen);
      crypto_core(k2,n,k2,c);
      public(k2,hlen);
      public(n,nlen);
      public(c,clen);
      if (memcmp(k2,h,hlen) != 0) fail("failure: crypto_core does not handle k=h overlap\n");
      memcpy(k2,k,klen);
      secret(n,nlen);
      secret(k,klen);
      secret(c2,clen);
      crypto_core(c2,n,k,c2);
      public(c2,hlen);
      public(n,nlen);
      public(k,klen);
      if (memcmp(c2,h,hlen) != 0) fail("failure: crypto_core does not handle c=h overlap\n");
      memcpy(c2,c,clen);
    }
    checksum_expected(core_scale3sntrup1013_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_scale3sntrup1013_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_scale3sntrup1013_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_scale3sntrup1013_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_scale3sntrup1013_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_scale3sntrup1013_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_scale3sntrup1013_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_scale3sntrup1013_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_scale3sntrup1013_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_scale3sntrup1013_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_scale3sntrup1013(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"scale3sntrup1013")) return;
  storage_core_scale3sntrup1013_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_scale3sntrup1013_h = aligned(storage_core_scale3sntrup1013_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_scale3sntrup1013_n = callocplus(crypto_core_INPUTBYTES);
  test_core_scale3sntrup1013_n = aligned(storage_core_scale3sntrup1013_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_scale3sntrup1013_k = callocplus(crypto_core_KEYBYTES);
  test_core_scale3sntrup1013_k = aligned(storage_core_scale3sntrup1013_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_scale3sntrup1013_c = callocplus(crypto_core_CONSTBYTES);
  test_core_scale3sntrup1013_c = aligned(storage_core_scale3sntrup1013_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_scale3sntrup1013_h2 = callocplus(maxalloc);
  test_core_scale3sntrup1013_h2 = aligned(storage_core_scale3sntrup1013_h2,crypto_core_OUTPUTBYTES);
  storage_core_scale3sntrup1013_n2 = callocplus(maxalloc);
  test_core_scale3sntrup1013_n2 = aligned(storage_core_scale3sntrup1013_n2,crypto_core_INPUTBYTES);
  storage_core_scale3sntrup1013_k2 = callocplus(maxalloc);
  test_core_scale3sntrup1013_k2 = aligned(storage_core_scale3sntrup1013_k2,crypto_core_KEYBYTES);
  storage_core_scale3sntrup1013_c2 = callocplus(maxalloc);
  test_core_scale3sntrup1013_c2 = aligned(storage_core_scale3sntrup1013_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_scale3sntrup1013 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_scale3sntrup1013();++impl)
      forked(test_core_scale3sntrup1013_impl,impl);
    ++test_core_scale3sntrup1013_h;
    ++test_core_scale3sntrup1013_n;
    ++test_core_scale3sntrup1013_k;
    ++test_core_scale3sntrup1013_c;
    ++test_core_scale3sntrup1013_h2;
    ++test_core_scale3sntrup1013_n2;
    ++test_core_scale3sntrup1013_k2;
    ++test_core_scale3sntrup1013_c2;
  }
  free(storage_core_scale3sntrup1013_c2);
  free(storage_core_scale3sntrup1013_k2);
  free(storage_core_scale3sntrup1013_n2);
  free(storage_core_scale3sntrup1013_h2);
  free(storage_core_scale3sntrup1013_c);
  free(storage_core_scale3sntrup1013_k);
  free(storage_core_scale3sntrup1013_n);
  free(storage_core_scale3sntrup1013_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

