/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.pdf;

import de.erichseifert.vectorgraphics2d.Document;
import de.erichseifert.vectorgraphics2d.Processor;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.filters.AbsoluteToRelativeTransformsFilter;
import de.erichseifert.vectorgraphics2d.intermediate.filters.FillPaintedShapeAsImageFilter;
import de.erichseifert.vectorgraphics2d.intermediate.filters.StateChangeGroupingFilter;
import de.erichseifert.vectorgraphics2d.pdf.PDFDocument;
import de.erichseifert.vectorgraphics2d.util.PageSize;

public class PDFProcessor
implements Processor {
    private final boolean compressed;

    public PDFProcessor(boolean bl) {
        this.compressed = bl;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public Document getDocument(CommandSequence commandSequence, PageSize pageSize) {
        AbsoluteToRelativeTransformsFilter absoluteToRelativeTransformsFilter = new AbsoluteToRelativeTransformsFilter(commandSequence);
        FillPaintedShapeAsImageFilter fillPaintedShapeAsImageFilter = new FillPaintedShapeAsImageFilter(absoluteToRelativeTransformsFilter);
        StateChangeGroupingFilter stateChangeGroupingFilter = new StateChangeGroupingFilter(fillPaintedShapeAsImageFilter);
        PDFDocument pDFDocument = new PDFDocument(stateChangeGroupingFilter, pageSize, this.isCompressed());
        return pDFDocument;
    }
}

