------------------------------------------------------------------------------
--                             G N A T C O L L                              --
--                                                                          --
--                     Copyright (C) 2009-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.IO;
with GNAT.OS_Lib;
with GNATCOLL.GMP.Integers.IO;

use GNAT.IO;
use GNATCOLL.GMP.Integers;
use GNATCOLL.GMP.Integers.IO;
use GNATCOLL.GMP;  --  for numeric types

procedure Test_Mod is

   R, A, B : Big_Integer;

   procedure Fail
     (Call     : String;
      Expected : Long;
      Actual   : Big_Integer);

   procedure Fail
     (Call     : String;
      Expected : Long;
      Actual   : Big_Integer)
   is
   begin
      Put ("test_mod failed: " & Call
           & " should be " & Expected'Img & " but was ");
      Put (Actual);
      New_Line;
      GNAT.OS_Lib.OS_Exit (-1);
   end Fail;

begin
   Set (B, "5", 10);

   Set (A, "10", 10);
   Get_Mod (R, A, B);
   if R /= 0 then
      Fail ("Get_Mod (10, 5)", 0, R);
   end if;

   Set (A, "11", 10);
   Get_Mod (R, A, B);
   if R /= 1 then
      Fail ("Get_Mod (11, 5)", 1, R);
   end if;

   Set (A, "12", 10);
   Get_Mod (R, A, B);
   if R /= 2 then
      Fail ("Get_Mod (12, 5)", 2, R);
   end if;

   Set (A, "13", 10);
   Get_Mod (R, A, B);
   if R /= 3 then
      Fail ("Get_Mod (13, 5)", 3, R);
   end if;

   Set (A, "14", 10);
   Get_Mod (R, A, B);
   if R /= 4 then
      Fail ("Get_Mod (14, 5)", 4, R);
   end if;

----

   Set (B, "-5", 10);

   Set (A, "10", 10);
   Get_Mod (R, A, B);
   if R /= 0 then
      Fail ("Get_Mod (10, -5)", 0, R);
   end if;

   Set (A, "11", 10);
   Get_Mod (R, A, B);
   if R /= -4 then
      Fail ("Get_Mod (11, -5)", -4, R);
   end if;

   Set (A, "12", 10);
   Get_Mod (R, A, B);
   if R /= -3 then
      Fail ("Get_Mod (12, -5)", -3, R);
   end if;

   Set (A, "13", 10);
   Get_Mod (R, A, B);
   if R /= -2 then
      Fail ("Get_Mod (13, -5)", -2, R);
   end if;

   Set (A, "14", 10);
   Get_Mod (R, A, B);
   if R /= -1 then
      Fail ("Get_Mod (14, -5)", -1, R);
   end if;

----

   Set (B, "5", 10);

   Set (A, "10", 10);
   Set (R, A mod B);
   if R /= 0 then
      Fail ("10 mod 5", 0, R);
   end if;

   Set (A, "11", 10);
   Set (R, A mod B);
   if R /= 1 then
      Fail ("11 mod 5", 1, R);
   end if;

   Set (A, "12", 10);
   Set (R, A mod B);
   if R /= 2 then
      Fail ("12 mod 5", 2, R);
   end if;

   Set (A, "13", 10);
   Set (R, A mod B);
   if R /= 3 then
      Fail ("13 mod 5", 3, R);
   end if;

   Set (A, "14", 10);
   Set (R, A mod B);
   if R /= 4 then
      Fail ("14 mod 5", 4, R);
   end if;

----

   Set (B, "5", 10);

   Set (A, "-10", 10);
   Set (R, A mod B);
   if R /= 0 then
      Fail ("-10 mod 5", 0, R);
   end if;

   Set (A, "-11", 10);
   Set (R, A mod B);
   if R /= 4 then
      Fail ("-11 mod 5", 4, R);
   end if;

   Set (A, "-12", 10);
   Set (R, A mod B);
   if R /= 3 then
      Fail ("-12 mod 5", 3, R);
   end if;

   Set (A, "-13", 10);
   Set (R, A mod B);
   if R /= 2 then
      Fail ("-13 mod 5", 2, R);
   end if;

   Set (A, "-14", 10);
   Set (R, A mod B);
   if R /= 1 then
      Fail ("-14 mod 5", 1, R);
   end if;

----

   Set (B, "-5", 10);

   Set (A, "10", 10);
   Set (R, A mod B);
   if R /= 0 then
      Fail ("10 mod -5", 0, R);
   end if;

   Set (A, "11", 10);
   Set (R, A mod B);
   if R /= -4 then
      Fail ("11 mod -5", -4, R);
   end if;

   Set (A, "12", 10);
   Set (R, A mod B);
   if R /= -3 then
      Fail ("12 mod -5", -3, R);
   end if;

   Set (A, "13", 10);
   Set (R, A mod B);
   if R /= -2 then
      Fail ("13 mod -5", -2, R);
   end if;

   Set (A, "14", 10);
   Set (R, A mod B);
   if R /= -1 then
      Fail ("14 mod -5", -1, R);
   end if;

----

   Set (B, "-5", 10);

   Set (A, "-10", 10);
   Set (R, A mod B);
   if R /= 0 then
      Fail ("-10 mod -5", 0, R);
   end if;

   Set (A, "-11", 10);
   Set (R, A mod B);
   if R /= -1 then
      Fail ("-11 mod -5", -1, R);
   end if;

   Set (A, "-12", 10);
   Set (R, A mod B);
   if R /= -2 then
      Fail ("-12 mod -5", -2, R);
   end if;

   Set (A, "-13", 10);
   Set (R, A mod B);
   if R /= -3 then
      Fail ("-13 mod -5", -3, R);
   end if;

   Set (A, "-14", 10);
   Set (R, A mod B);
   if R /= -4 then
      Fail ("-14 mod -5", -4, R);
   end if;

----

   Put_Line ("test_mod passed");
end Test_Mod;
