---MH---------------------------------------------------------------------------
-- Das Urheberrecht dieses Dokumentes verbleibt jederzeit der Siemens Schweiz AG.
-- Ohne deren schriftliche Einwilligung darf es nicht vervielfaeltigt oder dritten
-- Personen, auch nicht in abgeaenderter Form, ganz oder teilweise mitgeteilt,
-- zugaenglich oder nutzbar gemacht werden. Es ist Fabrikations- und
-- Geschaeftsgeheimnis im Sinne von OR 192 und StGB 273.
-- 
-- Filename    : test_hex_dump.adb
-- Version     : \main\2
-- 
-- Location    : \ILTIS\Cell\ilss\src\
-- Creation    : 20-Okt-05 08:53  GAU
-- Description : Hexdump von File erstellen.
-- 
-- \main branch:
--    2  09-Feb-09 06:41  chakuhm0  CMS-History durch ClearCase-History ersetzt
--    1  20-Okt-05 08:53  GAU       FR#3540: implementiert.
---END--------------------------------------------------------------------------

with Ada.Exceptions;
with Ada.Text_Io;
with ILSS_Command_Line;
with ILSS_Hex_Dump;
with ILSS_Io;

--         ******************************
--         *
-- BODY    *    Test_Hex_Dump
--         *
--         ******************************
procedure Test_Hex_Dump is
--!
--! Purpose
--!   Hex-dump von Files erstellen
--!

   C_Cmd_Line : constant STRING := ILSS_Command_Line.Get_Command_Line;
   Cmd_Iter   : ILSS_Command_Line.T_ITERATOR;

   type T_BYTE is mod 256; for T_BYTE'size use 8;
   package Byte_Io is new ILSS_Io.Direct_Io(T_BYTE);

   procedure Hex_Dump is new ILSS_Hex_Dump(Put_Line => Ada.Text_Io.Put_Line);

   procedure Dump_File(Filename : in STRING) is
      File : Byte_Io.FILE_TYPE;
      procedure Dump(Data : in Byte_Io.ITEM_ARRAY) is
      begin
         Hex_Dump(Start_Address => Data(Data'first)'address,
                  Length        => Data'length);
      end;
      procedure Dump_All is new Byte_Io.Direct_Read_Access(Dump);
   begin
      Byte_Io.Open(File => File,
                   Name => Filename,
                   Mode => Byte_Io.In_File);
      Dump_All(File);
      Byte_Io.Close(File);
   end Dump_File;

begin
   ILSS_Command_Line.Create_Iterator(Command_Line => C_Cmd_Line,
                                     Iterator     => Cmd_Iter);
   if ILSS_Command_Line.End_Of_Parameter(Cmd_Iter) then
      Ada.Text_Io.Put_Line("Usage: hex_dump <filename> { <filename> }");
      return;
   end if;

   while not ILSS_Command_Line.End_Of_Parameter(Cmd_Iter) loop
      Dump_File(ILSS_Command_Line.Get_Parameter
                   (Command_Line => C_Cmd_Line,
                    Iterator     => Cmd_Iter));
      ILSS_Command_Line.Next_Parameter(Command_Line => C_Cmd_Line,
                                       Iterator     => Cmd_Iter);
   end loop;
exception
when e: others =>
   Ada.Text_Io.Put_Line
      (Ada.Text_Io.Standard_Error,
       Ada.Exceptions.Exception_Information(e));
end Test_Hex_Dump;
