/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FONT_H
#define FONT_H
#define ENABLELOADFONT 0

#include <stdarg.h>
#include <vector>
#include <string>

#include "Texture.h"
#include "NumberBitmap.h"

namespace libgltf
{

class Font
{
public:
    bool loadFont();

    void printString(std::string sText, int x, int y, int iPXSize = -1);

    void printFormattedString(int x, int y, int iPXSize, const char* sText, ...);

    void deleteFont();

    void setShaderProgram(unsigned int shaderId);

    Font();
private:
    void createChar(int iIndex, unsigned char* pBitmap, int iW, int iH);
    void loadTextureFromBitmap();
    void setGLBufferData();
    Texture mCharTextures[256];
    int mAdvX[256], mAdvY[256];
    int mBearingX[256];
    int mLoadedPixelSize, mNewLine;
    bool bLoaded;
    unsigned int mVAO;
    std::vector<unsigned char> mDataBuffer;
    unsigned int mBuffer;
    unsigned int mShaderId;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
