// LIBGHEMICALDEFINE.H : just some macros #defined here...

// Copyright (C) 1998 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef LIBGHEMICALDEFINE_H
#define LIBGHEMICALDEFINE_H

/*################################################################################################*/

#define WEBSITE "http://www.bioinformatics.org/ghemical"

/*################################################################################################*/

/// NOT_DEFINED is defined as -1; therefore negative values often mean "##not defined".

#define NOT_DEFINED -1

/// The value zero is reserved for unregistered glnames (GUI stuff).

#define GLNAME_UNREGISTERED 0

/*################################################################################################*/

// the platform specific stuff is here...

#ifndef WIN32

#define DIR_SEPARATOR '/'	// directory separator
#define EXT_SEPARATOR '.'	// extension separator

//#define NEWLINE "\n"	// a string that does the newline-operation.

#define AMINO_BUILDER_FILE "builder/amino.txt"
#define NUCLEIC_BUILDER_FILE "builder/nucleic.txt"

#else	// WIN32

#define DIR_SEPARATOR '\\'	// directory separator
#define EXT_SEPARATOR '.'	// extension separator

//#define NEWLINE "\r\n"	// a string that does the newline-operation.

#define AMINO_BUILDER_FILE "builder\\amino.txt"
#define NUCLEIC_BUILDER_FILE "builder\\nucleic.txt"

#endif	// WIN32

/*################################################################################################*/

#endif	// LIBGHEMICALDEFINE_H

// eof
