/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__FOOBAROBJECTADAPTER_HPP)                                 
#include <FooBarObjectAdapter.hpp>
#endif

#if   !defined(__BAR_HPP)
#include <Bar.hpp>
#endif

using namespace corelinux;

//
// Default constructor breeches the contract
// of state
//

FooBarObjectAdapter::FooBarObjectAdapter( void )
   :
   Adapter( ),
   Foo( ),
   theBar( NULLPTR )
{
   NEVER_GET_HERE;
}

//
// Constructor with coordinates
// We adhere to the Foo constraints by checking
// the arguments with the boundries.
//

FooBarObjectAdapter::FooBarObjectAdapter( BarPtr aBar ) throw(Exception)
   :
   Adapter( ),
   Foo( ),
   theBar( aBar )
{
   REQUIRE( aBar != NULLPTR );

   if( (theBar->getHorizontal() < Foo::getMinimumHorizontalPosition() ||
        theBar->getHorizontal() > Foo::getMaximumHorizontalPosition() ) ||
       (theBar->getVertical() < Foo::getMinimumVerticalPosition() ||
        theBar->getVertical() > Foo::getMaximumVerticalPosition() ) )
   {
      throw Exception("Invalid Foo Boundry",LOCATION);
   }
   else
   {
      ;  // do nothing
   }
}

//
// Copy constructor
//

FooBarObjectAdapter::FooBarObjectAdapter( FooBarObjectAdapterCref aRef )
   :
   Adapter( aRef ),
   Foo( aRef ),
   theBar( aRef.getBar() )
{
   ;  // do nothing
}

//
// Destructor
//

FooBarObjectAdapter::~FooBarObjectAdapter( void )
{
   theBar = NULLPTR;  
}

//
// Assignment operator
//

FooBarObjectAdapterRef FooBarObjectAdapter::operator=
   ( 
      FooBarObjectAdapterCref aRef 
   )
{
   if( *this == aRef )
   {
      ; //  do nothing
   }
   else
   {
      (*theBar) = *(aRef.getBar());
   }
   return (*this);
}

//
// Equality test
//

bool FooBarObjectAdapter::operator==( FooBarObjectAdapterCref aRef )
{
   return (*theBar == *(aRef.getBar()));
}

//
// Return the Y coordinate
//

IntCref FooBarObjectAdapter::getVerticalPosition(void) const
{
   return theBar->getVertical();
}

//
// Return the X coordinate
//

IntCref FooBarObjectAdapter::getHorizontalPosition(void) const
{
   return theBar->getHorizontal();
}

//
// Set the Y coordinate after validating with Foo
//
   
void FooBarObjectAdapter::setVerticalPosition(Int aY) throw(Exception)
{
   if(aY >= Foo::getMinimumVerticalPosition() &&
    aY <= Foo::getMaximumVerticalPosition() )
   {
      theBar->setVertical(aY);
   }
   else
   {
      throw Exception("Invalid Vertical Coordinate",LOCATION);
   }
}

//
// Set the X coordinate after validating with Foo
//
   
void FooBarObjectAdapter::setHorizontalPosition(Int aX) throw(Exception)
{
   if(aX >= Foo::getMinimumVerticalPosition() &&
    aX <= Foo::getMaximumVerticalPosition() )
   {
      theBar->setHorizontal(aX);
   }
   else
   {
      throw Exception("Invalid Horizontal Coordinate",LOCATION);
   }
}

//
// Retrieves theBar Pointer
//

BarPtr   FooBarObjectAdapter::getBar( void ) const
{
   return theBar;
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/01/19 14:48:44 $
   $Locker:  $
*/

