#!/bin/sh

set -e

VERSION=$1
MAJOR=$(echo $VERSION | sed 's,\(.*\)\.[0-9]$,\1.x,')
USJ=$(pwd)/debian/tmp/usr/share/java
USMR=$(pwd)/debian/tmp/usr/share/maven-repo

rm -rf $USMR
mkdir -p $USJ $USMR

find build -name 'lucene-*.jar' |
    while read file; do
        basename=$(basename $file)
        artifact=$(basename $file -$VERSION.jar)

        echo "$0: installing file"
        install -m644 $file $USJ
        for version in $VERSION $MAJOR; do
            echo "$0: generating POM for $artifact/$version"
            mkdir -p $USMR/org/apache/lucene/$artifact/$version
            echo "\
<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\"
    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">
  <modelVersion>4.0.0</modelVersion>
  <groupId>org.apache.lucene</groupId>
  <artifactId>$artifact</artifactId>
  <version>$version</version>
  <description>dummy POM</description>
  <packaging>jar</packaging>
</project>\
" \
                 > $USMR/org/apache/lucene/$artifact/$version/$artifact-$version.pom
            ln -rs $USJ/$basename \
               $USMR/org/apache/lucene/$artifact/$version/$artifact-$version.jar
        done
    done
