#!/usr/bin/perl

# A simple script to translate the images of Linux Letters and Numbers
# <http://lln.sourceforge.net/> to a local language, in order to let
# the young users learn their language.

# The syntax of the table is quite simple: 
#       english-name local-name 
# for instance, for French: 
#       Wolf  Loup

# Copyright Stephane Bortzmeyer <bortzmeyer@sources.org>. Licence is
# the licence of LLN itself.

# Known bugs:
# 1) after translation, some letters may be missing,
# 2) Multiple names (Tiger.1 and Tiger.2) are not elegantly supported

# Feel free to modify these
if (! $ENV{'LANG'}) {
    die "You need to set the LANG environment variable";
}
# Where are the actual image files
$dir = "/usr/share/games/lletters/images";
# Where to put the symbolic links
$local_dir = "/usr/share/games/lletters/" . $ENV{'LANG'} . "/images";
if (! -d $local_dir) {
    mkdir $local_dir, 0755 or die "Cannot create $local_dir: $!";
}
$table = (shift (@ARGV) or ($local_dir . "/table-" . $ENV{'LANG'}));

# Do not edit below this point
$orig_table = $table;
if (! -e $table) {
    if ($table !~ /^$local_dir/) {
	$table = $local_dir . "/" . $table;
    }
    else {
	die "No such table $table";
    }
}
if (! -e $table) {
	die "No such table found (tried $orig_table and $table)";
}

opendir (DIR, $dir) or die "Cannot open $dir: $!";
while ($file = readdir (DIR)) {
    $files{$file} = 1;
}
closedir (DIR);
open (TABLE, "< $table") or die "Cannot open $table: $!";
while (<TABLE>) {
    chomp;
    $line = $_;
    # Skip comments
    $line =~ s/#.*$//;
    if ($line =~ /^ *$/) {
	next; # Skip empty lines	
    }
    ($english, $local) = split ('[ \t]', $line);
    $table{$english} = $local;
}
close (TABLE);

foreach $file (keys (%files)) {
    $basename = $file;
    $basename =~ s/\.([a-zA-Z]+)$//;
    $type = $1;
    if ($table{$basename}) {
	symlink (($dir . '/' . $file), 
		 ($local_dir . '/' . $table{$basename} . ".$type")) or 
	    die "Cannot symlink $table{$basename}.$type to $file: $!";
	print $table{$basename} . ".$type", " -> ", $file, "\n";
    }
}

