
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQOperatingSystemVersion.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QOperatingSystemVersion>
#include <QVersionNumber>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QOperatingSystemVersion

//  Constructor QOperatingSystemVersion::QOperatingSystemVersion(QOperatingSystemVersion::OSType osType, int vmajor, int vminor, int vmicro)


static void _init_ctor_QOperatingSystemVersion_5514 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("osType");
  decl->add_arg<const qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vmajor");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("vminor", true, "-1");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("vmicro", true, "-1");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QOperatingSystemVersion> ();
}

static void _call_ctor_QOperatingSystemVersion_5514 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QOperatingSystemVersion *> (new QOperatingSystemVersion (qt_gsi::QtToCppAdaptor<QOperatingSystemVersion::OSType>(arg1).cref(), arg2, arg3, arg4));
}


// int QOperatingSystemVersion::majorVersion()


static void _init_f_majorVersion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_majorVersion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QOperatingSystemVersion *)cls)->majorVersion ());
}


// int QOperatingSystemVersion::microVersion()


static void _init_f_microVersion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_microVersion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QOperatingSystemVersion *)cls)->microVersion ());
}


// int QOperatingSystemVersion::minorVersion()


static void _init_f_minorVersion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minorVersion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QOperatingSystemVersion *)cls)->minorVersion ());
}


// QString QOperatingSystemVersion::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QOperatingSystemVersion *)cls)->name ());
}


// int QOperatingSystemVersion::segmentCount()


static void _init_f_segmentCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_segmentCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QOperatingSystemVersion *)cls)->segmentCount ());
}


// QOperatingSystemVersion::OSType QOperatingSystemVersion::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type > ((qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type)qt_gsi::CppToQtAdaptor<QOperatingSystemVersion::OSType>(((QOperatingSystemVersion *)cls)->type ()));
}


// QVersionNumber QOperatingSystemVersion::version()


static void _init_f_version_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVersionNumber > ();
}

static void _call_f_version_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVersionNumber > ((QVersionNumber)((QOperatingSystemVersion *)cls)->version ());
}


// static QOperatingSystemVersion QOperatingSystemVersion::current()


static void _init_f_current_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QOperatingSystemVersion > ();
}

static void _call_f_current_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QOperatingSystemVersion > ((QOperatingSystemVersion)QOperatingSystemVersion::current ());
}


// static QOperatingSystemVersion::OSType QOperatingSystemVersion::currentType()


static void _init_f_currentType_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type > ();
}

static void _call_f_currentType_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type > ((qt_gsi::Converter<QOperatingSystemVersion::OSType>::target_type)qt_gsi::CppToQtAdaptor<QOperatingSystemVersion::OSType>(QOperatingSystemVersion::currentType ()));
}



namespace gsi
{

static gsi::Methods methods_QOperatingSystemVersion () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QOperatingSystemVersion::QOperatingSystemVersion(QOperatingSystemVersion::OSType osType, int vmajor, int vminor, int vmicro)\nThis method creates an object of class QOperatingSystemVersion.", &_init_ctor_QOperatingSystemVersion_5514, &_call_ctor_QOperatingSystemVersion_5514);
  methods += new qt_gsi::GenericMethod ("majorVersion", "@brief Method int QOperatingSystemVersion::majorVersion()\n", true, &_init_f_majorVersion_c0, &_call_f_majorVersion_c0);
  methods += new qt_gsi::GenericMethod ("microVersion", "@brief Method int QOperatingSystemVersion::microVersion()\n", true, &_init_f_microVersion_c0, &_call_f_microVersion_c0);
  methods += new qt_gsi::GenericMethod ("minorVersion", "@brief Method int QOperatingSystemVersion::minorVersion()\n", true, &_init_f_minorVersion_c0, &_call_f_minorVersion_c0);
  methods += new qt_gsi::GenericMethod ("name", "@brief Method QString QOperatingSystemVersion::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
  methods += new qt_gsi::GenericMethod ("segmentCount", "@brief Method int QOperatingSystemVersion::segmentCount()\n", true, &_init_f_segmentCount_c0, &_call_f_segmentCount_c0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method QOperatingSystemVersion::OSType QOperatingSystemVersion::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod ("version", "@brief Method QVersionNumber QOperatingSystemVersion::version()\n", true, &_init_f_version_c0, &_call_f_version_c0);
  methods += new qt_gsi::GenericStaticMethod ("current", "@brief Static method QOperatingSystemVersion QOperatingSystemVersion::current()\nThis method is static and can be called without an instance.", &_init_f_current_0, &_call_f_current_0);
  methods += new qt_gsi::GenericStaticMethod ("currentType", "@brief Static method QOperatingSystemVersion::OSType QOperatingSystemVersion::currentType()\nThis method is static and can be called without an instance.", &_init_f_currentType_0, &_call_f_currentType_0);
  return methods;
}

gsi::Class<QOperatingSystemVersion> decl_QOperatingSystemVersion ("QtCore", "QOperatingSystemVersion",
  methods_QOperatingSystemVersion (),
  "@qt\n@brief Binding of QOperatingSystemVersion");


GSI_QTCORE_PUBLIC gsi::Class<QOperatingSystemVersion> &qtdecl_QOperatingSystemVersion () { return decl_QOperatingSystemVersion; }

}


//  Implementation of the enum wrapper class for QOperatingSystemVersion::OSType
namespace qt_gsi
{

static gsi::Enum<QOperatingSystemVersion::OSType> decl_QOperatingSystemVersion_OSType_Enum ("QtCore", "QOperatingSystemVersion_OSType",
    gsi::enum_const ("Unknown", QOperatingSystemVersion::Unknown, "@brief Enum constant QOperatingSystemVersion::Unknown") +
    gsi::enum_const ("Windows", QOperatingSystemVersion::Windows, "@brief Enum constant QOperatingSystemVersion::Windows") +
    gsi::enum_const ("MacOS", QOperatingSystemVersion::MacOS, "@brief Enum constant QOperatingSystemVersion::MacOS") +
    gsi::enum_const ("IOS", QOperatingSystemVersion::IOS, "@brief Enum constant QOperatingSystemVersion::IOS") +
    gsi::enum_const ("TvOS", QOperatingSystemVersion::TvOS, "@brief Enum constant QOperatingSystemVersion::TvOS") +
    gsi::enum_const ("WatchOS", QOperatingSystemVersion::WatchOS, "@brief Enum constant QOperatingSystemVersion::WatchOS") +
    gsi::enum_const ("Android", QOperatingSystemVersion::Android, "@brief Enum constant QOperatingSystemVersion::Android"),
  "@qt\n@brief This class represents the QOperatingSystemVersion::OSType enum");

static gsi::QFlagsClass<QOperatingSystemVersion::OSType > decl_QOperatingSystemVersion_OSType_Enums ("QtCore", "QOperatingSystemVersion_QFlags_OSType",
  "@qt\n@brief This class represents the QFlags<QOperatingSystemVersion::OSType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QOperatingSystemVersion> inject_QOperatingSystemVersion_OSType_Enum_in_parent (decl_QOperatingSystemVersion_OSType_Enum.defs ());
static gsi::ClassExt<QOperatingSystemVersion> decl_QOperatingSystemVersion_OSType_Enum_as_child (decl_QOperatingSystemVersion_OSType_Enum, "OSType");
static gsi::ClassExt<QOperatingSystemVersion> decl_QOperatingSystemVersion_OSType_Enums_as_child (decl_QOperatingSystemVersion_OSType_Enums, "QFlags_OSType");

}

