/* Copyright (c) 2006 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package sample.gbase.cmdline;

import com.google.gdata.client.Service;

/**
 * Deletes an item.
 */
public class DeleteCommand extends Command {

  private String itemId;

  public void execute() throws Exception {

    Service service = createService();
    Service.GDataRequest request =
        service.createDeleteRequest(fixEditUrl(itemId));

    // Send the request (HTTP DELETE)
    request.execute();

    System.out.println("Item deleted successfully.");
  }

  /** Sets the Id of the item, which is also its URL. */
  public void setItemId(String itemId) {
    this.itemId = itemId;
  }
}
