/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.HTMLElements;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.TagType;

public abstract class Tag
extends Segment {
    String name = null;
    private Object userData = null;
    Element element = Element.NOT_CACHED;
    private Tag previousTag = NOT_CACHED;
    private Tag nextTag = NOT_CACHED;
    static final Tag NOT_CACHED = new StartTag();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source, int n, int n2, String string) {
        super(source, n, n2);
        this.name = HTMLElements.getConstantElementName(string.toLowerCase());
    }

    Tag() {
    }

    public abstract Element getElement();

    public final String getName() {
        return this.name;
    }

    public Segment getNameSegment() {
        int n = this.begin + this.getTagType().startDelimiterPrefix.length();
        return new Segment(this.source, n, n + this.name.length());
    }

    public abstract TagType getTagType();

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Tag getNextTag() {
        if (this.nextTag == NOT_CACHED) {
            Tag tag = Tag.getNextTag(this.source, this.begin + 1);
            if (this.source.wasFullSequentialParseCalled()) {
                return tag;
            }
            this.nextTag = tag;
        }
        return this.nextTag;
    }

    public Tag getPreviousTag() {
        if (this.previousTag == NOT_CACHED) {
            this.previousTag = Tag.getPreviousTag(this.source, this.begin - 1);
        }
        return this.previousTag;
    }

    public abstract boolean isUnregistered();

    public abstract String tidy();

    public static final boolean isXMLName(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0 || !Tag.isXMLNameStartChar(charSequence.charAt(0))) {
            return false;
        }
        for (int i = 1; i < charSequence.length(); ++i) {
            if (Tag.isXMLNameChar(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLNameStartChar(char c) {
        return Character.isLetter(c) || c == '_' || c == ':';
    }

    public static final boolean isXMLNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':';
    }

    StartTag getNextStartTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getNextTag()) != null) continue;
            return null;
        } while (!(tag instanceof StartTag));
        return (StartTag)tag;
    }

    StartTag getPreviousStartTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getPreviousTag()) != null) continue;
            return null;
        } while (!(tag instanceof StartTag));
        return (StartTag)tag;
    }

    Tag getNextTag(TagType tagType) {
        if (tagType == null) {
            return this.getNextTag();
        }
        if (tagType == StartTagType.UNREGISTERED || tagType == EndTagType.UNREGISTERED) {
            return Tag.getNextTag(this.source, this.begin + 1, tagType);
        }
        Tag tag = this;
        do {
            if (tag.nextTag == NOT_CACHED) {
                return Tag.getNextTag(this.source, tag.begin + 1, tagType);
            }
            tag = tag.nextTag;
            if (tag != null) continue;
            return null;
        } while (tag.getTagType() != tagType);
        return tag;
    }

    Tag getPreviousTag(TagType tagType) {
        if (tagType == null) {
            return this.getPreviousTag();
        }
        if (tagType == StartTagType.UNREGISTERED || tagType == EndTagType.UNREGISTERED) {
            return Tag.getPreviousTag(this.source, this.begin - 1, tagType);
        }
        Tag tag = this;
        do {
            if (tag.previousTag == NOT_CACHED) {
                return Tag.getPreviousTag(this.source, tag.begin - 1, tagType);
            }
            tag = tag.previousTag;
            if (tag != null) continue;
            return null;
        } while (tag.getTagType() != tagType);
        return tag;
    }

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag getPreviousTag(Source source, int n) {
        return source.useAllTypesCache ? source.cache.getPreviousTag(n) : Tag.getPreviousTagUncached(source, n, -1);
    }

    static final Tag getNextTag(Source source, int n) {
        return source.useAllTypesCache ? source.cache.getNextTag(n) : Tag.getNextTagUncached(source, n, -1);
    }

    static final Tag getPreviousTagUncached(Source source, int n, int n2) {
        try {
            ParseText parseText = source.getParseText();
            int n3 = n;
            do {
                if ((n3 = parseText.lastIndexOf('<', n3, n2)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, n3, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (--n3 >= 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new AssertionError((Object)"Unexpected internal exception");
        }
        return null;
    }

    static final Tag getNextTagUncached(Source source, int n, int n2) {
        try {
            ParseText parseText = source.getParseText();
            int n3 = n;
            do {
                if ((n3 = parseText.indexOf('<', n3, n2)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, n3, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (++n3 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag getPreviousTag(Source source, int n, TagType tagType) {
        if (source.useSpecialTypesCache) {
            return source.cache.getPreviousTag(n, tagType);
        }
        return Tag.getPreviousTagUncached(source, n, tagType, -1);
    }

    static final Tag getNextTag(Source source, int n, TagType tagType) {
        if (source.useSpecialTypesCache) {
            return source.cache.getNextTag(n, tagType);
        }
        return Tag.getNextTagUncached(source, n, tagType, -1);
    }

    static final Tag getPreviousTagUncached(Source source, int n, TagType tagType, int n2) {
        if (tagType == null) {
            return Tag.getPreviousTagUncached(source, n, n2);
        }
        String string = tagType.getStartDelimiter();
        ParseText parseText = source.getParseText();
        int n3 = n;
        do {
            if ((n3 = parseText.lastIndexOf(string, n3, n2)) == -1) {
                return null;
            }
            Tag tag = Tag.getTagAt(source, n3, false);
            if (tag == null || tag.getTagType() != tagType) continue;
            return tag;
        } while (--n3 >= 0);
        return null;
    }

    static final Tag getNextTagUncached(Source source, int n, TagType tagType, int n2) {
        if (tagType == null) {
            return Tag.getNextTagUncached(source, n, n2);
        }
        String string = tagType.getStartDelimiter();
        try {
            ParseText parseText = source.getParseText();
            int n3 = n;
            do {
                if ((n3 = parseText.indexOf(string, n3, n2)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source, n3, false);
                if (tag == null || tag.getTagType() != tagType) continue;
                return tag;
            } while (++n3 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source, int n, boolean bl) {
        return source.useAllTypesCache ? source.cache.getTagAt(n, bl) : Tag.getTagAtUncached(source, n, bl);
    }

    static final Tag getTagAtUncached(Source source, int n, boolean bl) {
        return TagType.getTagAt(source, n, bl, false);
    }

    static final Tag[] parseAll(Source source, boolean bl) {
        int n;
        Object object;
        Tag[] tagArray;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        source.fullSequentialParseData = new int[1];
        if (source.end != 0) {
            tagArray = source.getParseText();
            object = Tag.parseAllgetNextTag(source, (ParseText)tagArray, 0, bl);
            while (object != null) {
                arrayList.add((Tag)object);
                if (!object.isUnregistered()) {
                    ++n2;
                    if (object instanceof StartTag) {
                        ++n3;
                    }
                }
                int n4 = n = bl && !object.isUnregistered() ? object.end : object.begin + 1;
                if (n == source.end) break;
                object = Tag.parseAllgetNextTag(source, (ParseText)tagArray, n, bl);
            }
        }
        tagArray = new Tag[n2];
        object = new StartTag[n3];
        source.cache.loadAllTags((List<Tag>)arrayList, tagArray, (StartTag[])object);
        source.allTagsArray = tagArray;
        source.allTags = Arrays.asList(tagArray);
        source.allStartTags = Arrays.asList(object);
        n = tagArray.length - 1;
        for (int i = 0; i < tagArray.length; ++i) {
            Tag tag = tagArray[i];
            tag.previousTag = i > 0 ? tagArray[i - 1] : null;
            tag.nextTag = i < n ? tagArray[i + 1] : null;
        }
        return tagArray;
    }

    private static final Tag parseAllgetNextTag(Source source, ParseText parseText, int n, boolean bl) {
        try {
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf('<', n2)) == -1) {
                    return null;
                }
                Tag tag = TagType.getTagAt(source, n2, false, bl);
                if (tag == null) continue;
                if (!bl) {
                    TagType tagType = tag.getTagType();
                    if (tag.end > source.fullSequentialParseData[0] && tagType != StartTagType.DOCTYPE_DECLARATION && tagType != StartTagType.UNREGISTERED && tagType != EndTagType.UNREGISTERED) {
                        source.fullSequentialParseData[0] = tagType == StartTagType.NORMAL && tag.name == "script" ? Integer.MAX_VALUE : tag.end;
                    }
                }
                return tag;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    void orphan() {
        this.nextTag = NOT_CACHED;
    }

    boolean isOrphaned() {
        return this.source.wasFullSequentialParseCalled() && this.nextTag == NOT_CACHED;
    }
}

