#!/usr/bin/env perl

# $Header: /cvs/src/jbofihe/add_trace_to_tabc.pl,v 1.3 2001/01/11 21:49:52 richard Exp $

# Script to take the x.tab.c output from Bison, and insert extra function calls
# into it to support the following :

# - detection of possible elidable terminators
# - backtracing on syntax errors

# Hopefully, this changes things that are not *too* specific to particular
# versions of bison.  It was originally developed against output from bison
# version 1.27.

#
# Copyright (C) Richard P. Curnow  1998-2001
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
# 
#

print <<EOF;
extern elide_trace_reduce(int, int);
extern elide_trace_shift(int,int);
extern report_trace_shift(int);
extern report_trace_reduce(int, int);
extern report_trace_error(short *yyss, short *yyssp);
EOF

while (<>) {

    # Force type of yytranslate, otherwise we won't have a fixed type to
    # declare it as in the elide code.
    
    s/static const char yytranslate/static const short yytranslate/o;

    if (m{/\* Shift the lookahead}o) {
        print;
        print "elide_trace_shift(yystate,yychar);\n";
        print "report_trace_shift(yychar);\n";
    } elsif (m{^\s*yyreduce\:}o) {
        print;
        print "elide_trace_reduce(yystate, yyn);\n";
        print "report_trace_reduce(yystate, yyn);\n";
        
    } elsif (m{^\s*yyerrlab\:}o) {
        print;
        print "report_trace_error(yyss, yyssp);";

    } else {
        print;
    }
}

        
