#! /bin/bash
# Contributed by 'leahcimb', August 2011.
# Updated by Nathaniel Cunningham, May 2014.
# Updated by Otfried Cheong, November 2015.

# To be run after "make app" and "make distribution" from "src/ipe"!

APPDIR=../../build/Ipe.app
APPFRAMEWORKS=$APPDIR/Contents/Frameworks
APPMACOS=$APPDIR/Contents/MacOS
APPPLUGINS=$APPDIR/Contents/PlugIns
APPRESOURCES=$APPDIR/Contents/Resources
mkdir -p $APPPLUGINS

# qt.conf
echo '[Paths]
Plugins = PlugIns
' > $APPRESOURCES/qt.conf
ln -s ../../../Resources/qt.conf $APPMACOS/qt.conf

## Copy Qt frameworks into .app bundle and set relative links
cp -R /Library/Frameworks/QtCore.framework $APPFRAMEWORKS/
cp -R /Library/Frameworks/QtGui.framework $APPFRAMEWORKS/

install_name_tool -id @executable_path/../Frameworks/QtCore.framework/Versions/4/QtCore $APPFRAMEWORKS/QtCore.framework/Versions/4/QtCore
install_name_tool -id @executable_path/../Frameworks/QtGui.framework/Versions/4/QtGui $APPFRAMEWORKS/QtGui.framework/Versions/4/QtGui

FIX_QTCORE='install_name_tool -change QtCore.framework/Versions/4/QtCore @executable_path/../Frameworks/QtCore.framework/Versions/4/QtCore'
FIX_QTGUI='install_name_tool -change QtGui.framework/Versions/4/QtGui @executable_path/../Frameworks/QtGui.framework/Versions/4/QtGui'

$FIX_QTCORE $APPFRAMEWORKS/QtGui.framework/Versions/4/QtGui

cp -R /Developer/Applications/Qt/plugins/accessible $APPPLUGINS/
cp -R /Developer/Applications/Qt/plugins/codecs $APPPLUGINS/
cp -R /Developer/Applications/Qt/plugins/graphicssystems $APPPLUGINS/
cp -R /Developer/Applications/Qt/plugins/imageformats $APPPLUGINS/
rm -rf $APPPLUGINS/accessible/libqtaccessiblecompatwidgets.dylib
rm -rf $APPPLUGINS/graphicssystems/libqglgraphicssystem.dylib
rm -rf $APPPLUGINS/imageformats/libqsvg.dylib

## Fix dynamic library links
find $APPMACOS -d -type f -exec $FIX_QTCORE {} \; &> /dev/null
find $APPMACOS -d -type f -exec $FIX_QTGUI {} \; &> /dev/null
find $APPFRAMEWORKS -d -type f -exec $FIX_QTCORE {} \; &> /dev/null
find $APPFRAMEWORKS -d -type f -exec $FIX_QTGUI {} \; &> /dev/null
find $APPPLUGINS -d -type f -exec $FIX_QTCORE {} \; &> /dev/null
find $APPPLUGINS -d -type f -exec $FIX_QTGUI {} \; &> /dev/null

