# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
FEDORA_RELEASES += 41
FEDORA_41_SUBVER = 1.4

.PHONY: all
all:: fedora-cloud-41.$(GARDEN_ARCH).qcow2 fedora-cloud-41.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-41-$(FEDORA_41_SUBVER).$(GARDEN_ARCH).qcow2

$(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-41-$(FEDORA_41_SUBVER).x86_64.qcow2 $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-41-$(FEDORA_41_SUBVER).aarch64.qcow2: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-41-$(FEDORA_41_SUBVER).%.qcow2: | $(GARDEN_DL_DIR)/fedora
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://download.fedoraproject.org/pub/fedora/linux/releases/41/Cloud/$*/images/Fedora-Cloud-Base-Generic-41-$(FEDORA_41_SUBVER).$*.qcow2)

$(GARDEN_DL_DIR)/fedora/fedora-cloud-base-41.%.qcow2: $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic-41-$(FEDORA_41_SUBVER).%.qcow2 | $(GARDEN_DL_DIR)/fedora
	ln -sf $(notdir $<) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/fedora/fedora-cloud-base-41.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/fedora/Fedora-Cloud-Base-Generic.*-41-$(FEDORA_41_SUBVER).qcow2
