{- This module was generated from data in the Kate syntax
   highlighting file kotlin.xml, version 2, by Sergey Mashkov (sergey.mashkov@jetbrains.com) -}

module Text.Highlighting.Kate.Syntax.Kotlin
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Kotlin"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.kt;*.kts"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Kotlin","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Kotlin","Normal") -> return ()
      ("Kotlin","Imports") -> (popContext) >> pEndLine
      ("Kotlin","VariableDeclaration") -> return ()
      ("Kotlin","TypeDeclaration") -> return ()
      ("Kotlin","SuperTypes") -> return ()
      ("Kotlin","FunctionDeclaration") -> return ()
      ("Kotlin","TypeParameters") -> return ()
      ("Kotlin","Parameters") -> return ()
      ("Kotlin","TypeName") -> return ()
      ("Kotlin","FunctionType") -> return ()
      ("Kotlin","Expression") -> return ()
      ("Kotlin","ExpressionInner") -> return ()
      ("Kotlin","Char") -> (popContext) >> pEndLine
      ("Kotlin","String") -> (popContext) >> pEndLine
      ("Kotlin","MultiLineDoubleString") -> return ()
      ("Kotlin","CommentSingleLine") -> (popContext) >> pEndLine
      ("Kotlin","CommentMultiline") -> return ()
      ("Kotlin","symbols") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "package import sealed data class enum interface companion object private public protected internal open final get set fun var val constructor inline reified crossinline tailrec in out is as by where vararg get set return throw typealias typeof override infix operator"
list_controlFlowKeyword = Set.fromList $ words $ "if else when for while do try catch finally continue break yield"
list_predeclared = Set.fromList $ words $ "this super null true false"
list_types = Set.fromList $ words $ "Unit Nothing String Char Int Long Byte Short Float Double Boolean"

regex_'5cb'28package'7cimport'29'5cb = compileRegex True "\\b(package|import)\\b"
regex_'5cbfun'5cb = compileRegex True "\\bfun\\b"
regex_'5cb'28object'7cclass'7cinterface'29'5cb = compileRegex True "\\b(object|class|interface)\\b"
regex_'5cb'28val'7cvar'29'5cb = compileRegex True "\\b(val|var)\\b"
regex_'40'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a = compileRegex True "@[_\\w][_\\w\\d]*"
regex_TODO'5cs'2a'5c'28'5b'5e'29'5d'2a'5c'29 = compileRegex True "TODO\\s*\\([^)]*\\)"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'5c'2e'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'29'2a'28'5c'2e'5c'2a'29'3f = compileRegex True "\\b[_\\w][_\\w\\d]*(\\.[_\\w][_\\w\\d]*)*(\\.\\*)?"
regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a = compileRegex True "[_\\w][_\\w\\d]*"
regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'5b'3f'5d'3f = compileRegex True "[_\\w][_\\w\\d]*[?]?"
regex_'3c'5cw'2b = compileRegex True "<\\w+"
regex_'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d = compileRegex True "\\\\u[0-9a-fA-F]{4}"

parseRules ("Kotlin","Normal") =
  (((pRegExpr regex_'5cb'28package'7cimport'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Kotlin","Imports"))
   <|>
   ((pRegExpr regex_'5cbfun'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Kotlin","FunctionDeclaration"))
   <|>
   ((pRegExpr regex_'5cb'28object'7cclass'7cinterface'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Kotlin","TypeDeclaration"))
   <|>
   ((pRegExpr regex_'5cb'28val'7cvar'29'5cb >>= withAttribute KeywordTok) >>~ pushContext ("Kotlin","VariableDeclaration"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_predeclared >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_controlFlowKeyword >>= withAttribute ControlFlowTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute KeywordTok))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Kotlin","MultiLineDoubleString"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Kotlin","String"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Kotlin","Char"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentSingleLine"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentMultiline"))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) ((pString False "L" >>= withAttribute DecValTok)))
   <|>
   ((pRegExpr regex_'40'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a >>= withAttribute AttributeTok))
   <|>
   ((pRegExpr regex_TODO'5cs'2a'5c'28'5b'5e'29'5d'2a'5c'29 >>= withAttribute AlertTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '#' '!' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentSingleLine"))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","Imports") =
  (((pDetectChar False ';' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pString False "as" >>= withAttribute KeywordTok) >>~ pushContext ("Kotlin","TypeName"))
   <|>
   ((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'5c'2e'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'29'2a'28'5c'2e'5c'2a'29'3f >>= withAttribute ImportTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","Imports")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","VariableDeclaration") =
  (((pDetectIdentifier >>= withAttribute VariableTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","VariableDeclaration")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","TypeDeclaration") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '<' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeParameters"))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","Parameters"))
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","SuperTypes"))
   <|>
   ((lookAhead (pDetectChar False '{') >> (popContext) >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","TypeDeclaration")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","SuperTypes") =
  (((lookAhead (pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords) >> (popContext >> popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((lookAhead (pDetectChar False '{') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","Parameters"))
   <|>
   ((pDetectChar False '<' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeParameters"))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","SuperTypes")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","FunctionDeclaration") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '.' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","Parameters"))
   <|>
   ((pDetectChar False '<' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeParameters"))
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeName"))
   <|>
   ((lookAhead (pAnyChar "{=") >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a >>= withAttribute FunctionTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","FunctionDeclaration")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","TypeParameters") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeName"))
   <|>
   ((pDetectChar False '*' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '>' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '<' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeParameters"))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'5b'3f'5d'3f >>= withAttribute DataTypeTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","TypeParameters")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","Parameters") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","TypeName"))
   <|>
   ((pDetectChar False '=' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","Expression"))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a >>= withAttribute VariableTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","Parameters")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","TypeName") =
  (((pDetectChar False '*' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","FunctionType"))
   <|>
   ((pString False "->" >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'5b'3f'5d'3f >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","TypeName")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","FunctionType") =
  (((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'5b'3f'5d'3f >>= withAttribute DataTypeTok))
   <|>
   ((pString False "->" >>= withAttribute NormalTok))
   <|>
   ((pString False "," >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","FunctionType")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","Expression") =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","ExpressionInner"))
   <|>
   ((lookAhead (pDetectChar False ')') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","ExpressionInner"))
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pRegExpr regex_'3c'5cw'2b) >> pushContext ("Kotlin","TypeParameters") >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Kotlin","Char"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Kotlin","MultiLineDoubleString"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Kotlin","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentSingleLine"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentMultiline"))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","Expression")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","ExpressionInner") =
  (((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","ExpressionInner"))
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Kotlin","ExpressionInner"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((lookAhead (pRegExpr regex_'3c'5cw'2b) >> pushContext ("Kotlin","TypeParameters") >> currentContext >>= parseRules))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Kotlin","Char"))
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext ("Kotlin","MultiLineDoubleString"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Kotlin","String"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentSingleLine"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Kotlin","CommentMultiline"))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","ExpressionInner")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Kotlin","Char") =
  (((pRegExpr regex_'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d >>= withAttribute SpecialCharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","Char")) >> pDefault >>= withAttribute CharTok))

parseRules ("Kotlin","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute SpecialCharTok))
   <|>
   ((pRegExpr regex_'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d >>= withAttribute SpecialCharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Kotlin","MultiLineDoubleString") =
  (((pString False "\"\"\"" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","MultiLineDoubleString")) >> pDefault >>= withAttribute StringTok))

parseRules ("Kotlin","CommentSingleLine") =
  (((pString False "TODO" >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","CommentSingleLine")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Kotlin","CommentMultiline") =
  (((pString False "TODO" >>= withAttribute AlertTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","CommentMultiline")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Kotlin","symbols") =
  (((pAnyChar ":!%&+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Kotlin","symbols")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("Kotlin","Normal") <|> fail ("Unknown context" ++ show x)
