!****h* ROBODoc/H5GLOBAL
!
! NAME
!  MODULE H5GLOBAL
!
! FILE
!  src/fortran/H5f90global.F90
!
! PURPOSE
!  This module is used to pass C stubs for H5 Fortran APIs. The C stubs are
!  packed into arrays in H5_f.c and these arrays are then passed to Fortran.
!  This module then uses EQUIVALENCE to assign elements of the arrays to
!  Fortran equivalent C stubs.
!
! NOTES
!  The size of the C arrays in H5_f.c has to match the values of the variables
!  declared as PARAMETER, hence if the size of an array in H5_f.c is changed
!  then the PARAMETER of that corresponding array in Fortran must also be changed.
!
! USES
!  H5FORTRAN_TYPES 	 - This module is generated at run time. See
!
! COPYRIGHT
! * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
!   Copyright by The HDF Group.                                               *
!   Copyright by the Board of Trustees of the University of Illinois.         *
!   All rights reserved.                                                      *
!                                                                             *
!   This file is part of HDF5.  The full HDF5 copyright notice, including     *
!   terms governing use, modification, and redistribution, is contained in    *
!   the files COPYING and Copyright.html.  COPYING can be found at the root   *
!   of the source code distribution tree; Copyright.html can be found at the  *
!   root level of an installed copy of the electronic HDF5 document set and   *
!   is linked from the top-level documents page.  It can also be found at     *
!   http://hdfgroup.org/HDF5/doc/Copyright.html.  If you do not have          *
!   access to either file, you may request a copy from help@hdfgroup.org.     *
! * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
!
! AUTHOR
!  Elena Pourmal
!
!*****

MODULE H5GLOBAL
  USE H5FORTRAN_TYPES

  IMPLICIT NONE

  ! Enumerate data type that is interoperable with C.
  ENUM, BIND(C)
    ENUMERATOR :: enum_dtype
  END ENUM
  INTEGER, PARAMETER :: ENUM_T = KIND(enum_dtype)
  

  ! Definitions for reference datatypes.
  ! If you change the value of these parameters, do not forget to change corresponding
  ! values in the H5f90.h file.
  INTEGER, PARAMETER :: REF_REG_BUF_LEN = 3

  ! Parameters used in the function 'h5kind_to_type' located in H5_ff.F90.
  ! The flag is used to tell the function whether the kind input variable
  ! is for a REAL or INTEGER data type.

  INTEGER, PARAMETER :: H5_REAL_KIND = 1
  INTEGER, PARAMETER :: H5_INTEGER_KIND = 0

  TYPE :: hobj_ref_t_f
     INTEGER(HADDR_T) ref
  END TYPE hobj_ref_t_f

  TYPE :: hdset_reg_ref_t_f
     INTEGER, DIMENSION(1:REF_REG_BUF_LEN) :: ref
  END TYPE hdset_reg_ref_t_f

  INTEGER, PARAMETER :: PREDEF_TYPES_LEN = 19 ! Do not forget to change this
                                              ! value when new predefined
                                              ! datatypes are added

  ! Do not forget to change the following line when new predefined
  ! floating data types are added
  INTEGER, PARAMETER :: FLOATING_TYPES_LEN = 4

  ! Do not forget to change the following line when new predefined
  ! integer data types are added
  INTEGER, PARAMETER :: INTEGER_TYPES_LEN = 27

  INTEGER(HID_T) :: H5T_NATIVE_INTEGER_1, &
       H5T_NATIVE_INTEGER_2, &
       H5T_NATIVE_INTEGER_4, &
       H5T_NATIVE_INTEGER_8, &
       H5T_NATIVE_REAL_C_FLOAT, &
       H5T_NATIVE_REAL_C_DOUBLE, &
       H5T_NATIVE_REAL_C_LONG_DOUBLE, &
       H5T_NATIVE_INTEGER, &
       H5T_NATIVE_REAL, &
       H5T_NATIVE_DOUBLE, &
       H5T_NATIVE_CHARACTER , &
       H5T_STD_REF_OBJ,      &
       H5T_STD_REF_DSETREG, &
       H5T_IEEE_F32BE,  &
       H5T_IEEE_F32LE,  &
       H5T_IEEE_F64BE,  &
       H5T_IEEE_F64LE,  &
       H5T_STD_I8BE,    &
       H5T_STD_I8LE,    &
       H5T_STD_I16BE,   &
       H5T_STD_I16LE,   &
       H5T_STD_I32BE,   &
       H5T_STD_I32LE,   &
       H5T_STD_I64BE,   &
       H5T_STD_I64LE,   &
       H5T_STD_U8BE,    &
       H5T_STD_U8LE,    &
       H5T_STD_U16BE,   &
       H5T_STD_U16LE,   &
       H5T_STD_U32BE
       
  INTEGER(HID_T) :: H5T_NATIVE_INTEGER_16 ! NEED IFDEF -MSB-
  INTEGER(HID_T) :: H5T_NATIVE_FLOAT_128 ! NEED IFDEF -MSB-

! NOTE: Splitting the line since the Fortran 95 standard limits the number of 
!       continuation lines to 39; the F03/F08 standard limits the number 
!       to 255 lines.

  INTEGER(HID_T) :: H5T_STD_U32LE,   &
       H5T_STD_U64BE,   &
       H5T_STD_U64LE,   &
       H5T_STRING,      &
       H5T_STD_B8BE,    &
       H5T_STD_B8LE,    &
       H5T_STD_B16BE,   &
       H5T_STD_B16LE,   &
       H5T_STD_B32BE,   &
       H5T_STD_B32LE,   &
       H5T_STD_B64BE,   &
       H5T_STD_B64LE,   &
       H5T_NATIVE_B8,   &
       H5T_NATIVE_B16,  &
       H5T_NATIVE_B32,  &
       H5T_NATIVE_B64,  &
       H5T_FORTRAN_S1,  &
       H5T_C_S1


  INTEGER(HID_T), DIMENSION(PREDEF_TYPES_LEN) :: predef_types
  EQUIVALENCE (predef_types(1), H5T_NATIVE_INTEGER)
  EQUIVALENCE (predef_types(2), H5T_NATIVE_REAL)
  EQUIVALENCE (predef_types(3), H5T_NATIVE_DOUBLE)
  EQUIVALENCE (predef_types(4), H5T_NATIVE_CHARACTER)
  EQUIVALENCE (predef_types(5), H5T_STD_REF_OBJ)
  EQUIVALENCE (predef_types(6), H5T_STD_REF_DSETREG)
  EQUIVALENCE (predef_types(7), H5T_NATIVE_INTEGER_1)
  EQUIVALENCE (predef_types(8), H5T_NATIVE_INTEGER_2)
  EQUIVALENCE (predef_types(9), H5T_NATIVE_INTEGER_4)
  EQUIVALENCE (predef_types(10), H5T_NATIVE_INTEGER_8)
  EQUIVALENCE (predef_types(11), H5T_NATIVE_REAL_C_FLOAT)
  EQUIVALENCE (predef_types(12), H5T_NATIVE_REAL_C_DOUBLE)
  EQUIVALENCE (predef_types(13), H5T_NATIVE_REAL_C_LONG_DOUBLE)
  EQUIVALENCE (predef_types(14), H5T_NATIVE_B8 )
  EQUIVALENCE (predef_types(15), H5T_NATIVE_B16)
  EQUIVALENCE (predef_types(16), H5T_NATIVE_B32)
  EQUIVALENCE (predef_types(17), H5T_NATIVE_B64)  
  EQUIVALENCE (predef_types(18), H5T_NATIVE_INTEGER_16)   ! ADDED NEW TYPE -MSB- 
  EQUIVALENCE (predef_types(19), H5T_NATIVE_FLOAT_128)   ! ADDED NEW TYPE -MSB-

  INTEGER(HID_T), DIMENSION(FLOATING_TYPES_LEN) :: floating_types
  EQUIVALENCE (floating_types(1), H5T_IEEE_F32BE )
  EQUIVALENCE (floating_types(2), H5T_IEEE_F32LE)
  EQUIVALENCE (floating_types(3), H5T_IEEE_F64BE)
  EQUIVALENCE (floating_types(4), H5T_IEEE_F64LE)

  INTEGER(HID_T), DIMENSION(INTEGER_TYPES_LEN) :: integer_types
  EQUIVALENCE (integer_types(1), H5T_STD_I8BE )
  EQUIVALENCE (integer_types(2), H5T_STD_I8LE)
  EQUIVALENCE (integer_types(3), H5T_STD_I16BE)
  EQUIVALENCE (integer_types(4), H5T_STD_I16LE)
  EQUIVALENCE (integer_types(5), H5T_STD_I32BE)
  EQUIVALENCE (integer_types(6), H5T_STD_I32LE)
  EQUIVALENCE (integer_types(7), H5T_STD_I64BE)
  EQUIVALENCE (integer_types(8), H5T_STD_I64LE)
  EQUIVALENCE (integer_types(9), H5T_STD_U8BE)
  EQUIVALENCE (integer_types(10), H5T_STD_U8LE)
  EQUIVALENCE (integer_types(11), H5T_STD_U16BE)
  EQUIVALENCE (integer_types(12), H5T_STD_U16LE)
  EQUIVALENCE (integer_types(13), H5T_STD_U32BE)
  EQUIVALENCE (integer_types(14), H5T_STD_U32LE)
  EQUIVALENCE (integer_types(15), H5T_STD_U64BE)
  EQUIVALENCE (integer_types(16), H5T_STD_U64LE)
  EQUIVALENCE (integer_types(17), H5T_STRING)
  EQUIVALENCE (integer_types(18), H5T_STD_B8BE)
  EQUIVALENCE (integer_types(19), H5T_STD_B8LE)
  EQUIVALENCE (integer_types(20), H5T_STD_B16BE)
  EQUIVALENCE (integer_types(21), H5T_STD_B16LE)
  EQUIVALENCE (integer_types(22), H5T_STD_B32BE)
  EQUIVALENCE (integer_types(23), H5T_STD_B32LE)
  EQUIVALENCE (integer_types(24), H5T_STD_B64BE)
  EQUIVALENCE (integer_types(25), H5T_STD_B64LE)
  EQUIVALENCE (integer_types(26), H5T_FORTRAN_S1)
  EQUIVALENCE (integer_types(27), H5T_C_S1)


  !      COMMON /PREDEFINED_TYPES/ H5T_NATIVE_INTEGER, &
  !                                H5T_NATIVE_REAL, &
  !                                H5T_NATIVE_DOUBLE, &
  !                                H5T_NATIVE_CHARACTER, &
  !                                H5T_STD_REF_OBJ, &
  !                                H5T_STD_REF_DSETREG
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /PREDEFINED_TYPES/
  !DEC$endif
  COMMON /PREDEFINED_TYPES/  predef_types

  !      COMMON /FLOATING_TYPES/ H5T_IEEE_F32BE,  &
  !                              H5T_IEEE_F32LE,  &
  !                              H5T_IEEE_F64BE,  &
  !                              H5T_IEEE_F64LE
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /FLOATING_TYPES/
  !DEC$endif
  COMMON /FLOATING_TYPES/ floating_types
  !
  !      COMMON /INTEGER_TYPES/ H5T_STD_I8BE,  &
  !                             H5T_STD_I8LE,    &
  !                             H5T_STD_I16BE,   &
  !                             H5T_STD_I16LE,   &
  !                             H5T_STD_I32BE,   &
  !                             H5T_STD_I32LE,   &
  !                             H5T_STD_I64BE,   &
  !                             H5T_STD_I64LE,   &
  !                             H5T_STD_U8BE,    &
  !                             H5T_STD_U8LE,    &
  !                             H5T_STD_U16BE,   &
  !                             H5T_STD_U16LE,   &
  !                             H5T_STD_U32BE,   &
  !                             H5T_STD_U32LE,   &
  !                             H5T_STD_U64BE,   &
  !                             H5T_STD_U64LE
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /INTEGER_TYPES/
  !DEC$endif
  COMMON /INTEGER_TYPES/ integer_types
  !
  ! Fortran flags
  !
  !
  ! H5F flags (DO NOT FORGET TO UPDATE WHEN NEW FLAGS ARE ADDED !)
  !
  ! H5F flags declaration
  !
  INTEGER, PARAMETER :: H5F_FLAGS_LEN = 19
  INTEGER :: H5F_flags(H5F_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5F_FLAGS/
  !DEC$endif
  COMMON /H5F_FLAGS/ H5F_flags

  INTEGER :: H5F_ACC_RDWR_F
  INTEGER :: H5F_ACC_RDONLY_F
  INTEGER :: H5F_ACC_TRUNC_F
  INTEGER :: H5F_ACC_EXCL_F
  INTEGER :: H5F_ACC_DEBUG_F
  INTEGER :: H5F_SCOPE_LOCAL_F
  INTEGER :: H5F_SCOPE_GLOBAL_F
  INTEGER :: H5F_CLOSE_DEFAULT_F
  INTEGER :: H5F_CLOSE_WEAK_F
  INTEGER :: H5F_CLOSE_SEMI_F
  INTEGER :: H5F_CLOSE_STRONG_F
  INTEGER :: H5F_OBJ_FILE_F
  INTEGER :: H5F_OBJ_DATASET_F
  INTEGER :: H5F_OBJ_GROUP_F
  INTEGER :: H5F_OBJ_DATATYPE_F
  INTEGER :: H5F_OBJ_ALL_F
  INTEGER :: H5F_LIBVER_EARLIEST_F
  INTEGER :: H5F_LIBVER_LATEST_F
  INTEGER :: H5F_UNLIMITED_F

  EQUIVALENCE(H5F_flags(1), H5F_ACC_RDWR_F)
  EQUIVALENCE(H5F_flags(2), H5F_ACC_RDONLY_F)
  EQUIVALENCE(H5F_flags(3), H5F_ACC_TRUNC_F)
  EQUIVALENCE(H5F_flags(4), H5F_ACC_EXCL_F)
  EQUIVALENCE(H5F_flags(5), H5F_ACC_DEBUG_F)
  EQUIVALENCE(H5F_flags(6), H5F_SCOPE_LOCAL_F)
  EQUIVALENCE(H5F_flags(7), H5F_SCOPE_GLOBAL_F)
  EQUIVALENCE(H5F_flags(8), H5F_CLOSE_DEFAULT_F)
  EQUIVALENCE(H5F_flags(9), H5F_CLOSE_WEAK_F)
  EQUIVALENCE(H5F_flags(10), H5F_CLOSE_SEMI_F)
  EQUIVALENCE(H5F_flags(11), H5F_CLOSE_STRONG_F)
  EQUIVALENCE(H5F_flags(12), H5F_OBJ_FILE_F)
  EQUIVALENCE(H5F_flags(13), H5F_OBJ_DATASET_F)
  EQUIVALENCE(H5F_flags(14), H5F_OBJ_GROUP_F)
  EQUIVALENCE(H5F_flags(15), H5F_OBJ_DATATYPE_F)
  EQUIVALENCE(H5F_flags(16), H5F_OBJ_ALL_F)
  EQUIVALENCE(H5F_flags(17), H5F_LIBVER_EARLIEST_F)
  EQUIVALENCE(H5F_flags(18), H5F_LIBVER_LATEST_F)
  EQUIVALENCE(H5F_flags(19), H5F_UNLIMITED_F)
  !
  ! H5generic flags declaration
  !
  INTEGER, PARAMETER :: H5generic_FLAGS_LEN = 9
  INTEGER :: H5generic_flags(H5generic_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5generic_FLAGS/
  !DEC$endif
  COMMON /H5generic_FLAGS/ H5generic_flags

  INTEGER :: H5_INDEX_UNKNOWN_F
  INTEGER :: H5_INDEX_NAME_F
  INTEGER :: H5_INDEX_CRT_ORDER_F
  INTEGER :: H5_INDEX_N_F
  INTEGER :: H5_ITER_UNKNOWN_F
  INTEGER :: H5_ITER_INC_F
  INTEGER :: H5_ITER_DEC_F
  INTEGER :: H5_ITER_NATIVE_F
  INTEGER :: H5_ITER_N_F

  EQUIVALENCE(H5generic_flags(1), H5_INDEX_UNKNOWN_F)
  EQUIVALENCE(H5generic_flags(2), H5_INDEX_NAME_F)
  EQUIVALENCE(H5generic_flags(3), H5_INDEX_CRT_ORDER_F)
  EQUIVALENCE(H5generic_flags(4), H5_INDEX_N_F)
  EQUIVALENCE(H5generic_flags(5), H5_ITER_UNKNOWN_F)
  EQUIVALENCE(H5generic_flags(6), H5_ITER_INC_F)
  EQUIVALENCE(H5generic_flags(7), H5_ITER_DEC_F)
  EQUIVALENCE(H5generic_flags(8), H5_ITER_NATIVE_F)
  EQUIVALENCE(H5generic_flags(9), H5_ITER_N_F)

  INTEGER, PARAMETER :: H5generic_haddr_FLAGS_LEN = 1
  INTEGER(HADDR_T) :: H5generic_haddr_flags(H5generic_haddr_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5generic_haddr_FLAGS/
  !DEC$endif
  COMMON /H5generic_haddr_FLAGS/ H5generic_haddr_flags

  INTEGER(HADDR_T) :: HADDR_UNDEF_F

  EQUIVALENCE(H5generic_haddr_flags(1), HADDR_UNDEF_F)

  !
  ! H5G flags declaration
  !
  INTEGER, PARAMETER :: H5G_FLAGS_LEN = 12
  INTEGER :: H5G_flags(H5G_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5G_FLAGS/
  !DEC$endif
  COMMON /H5G_FLAGS/ H5G_flags

  INTEGER :: H5G_UNKNOWN_F
  INTEGER :: H5G_GROUP_F
  INTEGER :: H5G_DATASET_F
  INTEGER :: H5G_TYPE_F
  INTEGER :: H5G_LINK_F
  INTEGER :: H5G_UDLINK_F
  INTEGER :: H5G_SAME_LOC_F
  INTEGER :: H5G_LINK_ERROR_F
  INTEGER :: H5G_LINK_HARD_F
  INTEGER :: H5G_LINK_SOFT_F
  INTEGER :: H5G_STORAGE_TYPE_UNKNOWN_F
  INTEGER :: H5G_STORAGE_TYPE_SYMBOL_TABLE_F
  INTEGER :: H5G_STORAGE_TYPE_COMPACT_F
  INTEGER :: H5G_STORAGE_TYPE_DENSE_F

  EQUIVALENCE(H5G_flags(1), H5G_UNKNOWN_F) ! Unknown object type
  EQUIVALENCE(H5G_flags(2), H5G_GROUP_F)   ! Object is a group
  EQUIVALENCE(H5G_flags(3), H5G_DATASET_F) ! Object is a dataset
  EQUIVALENCE(H5G_flags(4), H5G_TYPE_F)    ! Object is a named data type
  EQUIVALENCE(H5G_flags(5), H5G_SAME_LOC_F)
  EQUIVALENCE(H5G_flags(6), H5G_LINK_ERROR_F)
  EQUIVALENCE(H5G_flags(7), H5G_LINK_HARD_F)
  EQUIVALENCE(H5G_flags(8), H5G_LINK_SOFT_F)

  EQUIVALENCE(H5G_flags(9), H5G_STORAGE_TYPE_UNKNOWN_F )
  EQUIVALENCE(H5G_flags(10), H5G_STORAGE_TYPE_SYMBOL_TABLE_F)
  EQUIVALENCE(H5G_flags(11), H5G_STORAGE_TYPE_COMPACT_F)
  EQUIVALENCE(H5G_flags(12), H5G_STORAGE_TYPE_DENSE_F)

  !
  ! H5D flags declaration
  !
  INTEGER, PARAMETER :: H5D_FLAGS_LEN = 29
  INTEGER :: H5D_flags(H5D_FLAGS_LEN)
  INTEGER, PARAMETER :: H5D_SIZE_FLAGS_LEN = 2
  INTEGER(SIZE_T) :: H5D_size_flags(H5D_SIZE_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5D_FLAGS/
  !DEC$ATTRIBUTES DLLEXPORT :: /H5D_SIZE_FLAGS/
  !DEC$endif
  COMMON /H5D_FLAGS/ H5D_flags
  COMMON /H5D_SIZE_FLAGS/ H5D_size_flags

  INTEGER :: H5D_COMPACT_F
  INTEGER :: H5D_CONTIGUOUS_F
  INTEGER :: H5D_CHUNKED_F

  INTEGER :: H5D_ALLOC_TIME_ERROR_F
  INTEGER :: H5D_ALLOC_TIME_DEFAULT_F
  INTEGER :: H5D_ALLOC_TIME_EARLY_F
  INTEGER :: H5D_ALLOC_TIME_LATE_F
  INTEGER :: H5D_ALLOC_TIME_INCR_F

  INTEGER :: H5D_SPACE_STS_ERROR_F
  INTEGER :: H5D_SPACE_STS_NOT_ALLOCATED_F
  INTEGER :: H5D_SPACE_STS_PART_ALLOCATED_F
  INTEGER :: H5D_SPACE_STS_ALLOCATED_F

  INTEGER :: H5D_FILL_TIME_ERROR_F
  INTEGER :: H5D_FILL_TIME_ALLOC_F
  INTEGER :: H5D_FILL_TIME_NEVER_F

  INTEGER :: H5D_FILL_VALUE_ERROR_F
  INTEGER :: H5D_FILL_VALUE_UNDEFINED_F
  INTEGER :: H5D_FILL_VALUE_DEFAULT_F
  INTEGER :: H5D_FILL_VALUE_USER_DEFINED_F

! shortened "_DEFAULT" to "_DFLT" to satisfy the limit of 31
! characters for variable names in Fortran.
! shortened "_CONTIGUOUS" to "_CONTIG" to satisfy the limit of 31
! characters for variable names in Fortran.

  INTEGER(SIZE_T) :: H5D_CHUNK_CACHE_NSLOTS_DFLT_F
  INTEGER(SIZE_T) :: H5D_CHUNK_CACHE_NBYTES_DFLT_F
  INTEGER :: H5D_CHUNK_CACHE_W0_DFLT_F
  INTEGER :: H5D_MPIO_NO_COLLECTIVE_F
  INTEGER :: H5D_MPIO_CHUNK_INDEPENDENT_F
  INTEGER :: H5D_MPIO_CHUNK_COLLECTIVE_F
  INTEGER :: H5D_MPIO_CHUNK_MIXED_F
  INTEGER :: H5D_MPIO_CONTIG_COLLECTIVE_F
  INTEGER :: H5D_VDS_ERROR_F
  INTEGER :: H5D_VDS_FIRST_MISSING_F
  INTEGER :: H5D_VDS_LAST_AVAILABLE_F
  INTEGER :: H5D_VIRTUAL_F

  EQUIVALENCE(H5D_flags(1), H5D_COMPACT_F)
  EQUIVALENCE(H5D_flags(2), H5D_CONTIGUOUS_F)
  EQUIVALENCE(H5D_flags(3), H5D_CHUNKED_F)

  EQUIVALENCE(H5D_flags(4), H5D_ALLOC_TIME_ERROR_F)
  EQUIVALENCE(H5D_flags(5), H5D_ALLOC_TIME_DEFAULT_F)
  EQUIVALENCE(H5D_flags(6), H5D_ALLOC_TIME_EARLY_F)
  EQUIVALENCE(H5D_flags(7), H5D_ALLOC_TIME_LATE_F)
  EQUIVALENCE(H5D_flags(8), H5D_ALLOC_TIME_INCR_F)

  EQUIVALENCE(H5D_flags(9), H5D_SPACE_STS_ERROR_F)
  EQUIVALENCE(H5D_flags(10), H5D_SPACE_STS_NOT_ALLOCATED_F)
  EQUIVALENCE(H5D_flags(11), H5D_SPACE_STS_PART_ALLOCATED_F)
  EQUIVALENCE(H5D_flags(12), H5D_SPACE_STS_ALLOCATED_F)

  EQUIVALENCE(H5D_flags(13), H5D_FILL_TIME_ERROR_F)
  EQUIVALENCE(H5D_flags(14), H5D_FILL_TIME_ALLOC_F)
  EQUIVALENCE(H5D_flags(15), H5D_FILL_TIME_NEVER_F)

  EQUIVALENCE(H5D_flags(16), H5D_FILL_VALUE_ERROR_F)
  EQUIVALENCE(H5D_flags(17), H5D_FILL_VALUE_UNDEFINED_F)
  EQUIVALENCE(H5D_flags(18), H5D_FILL_VALUE_DEFAULT_F)
  EQUIVALENCE(H5D_flags(19), H5D_FILL_VALUE_USER_DEFINED_F)

  EQUIVALENCE(H5D_flags(20), H5D_CHUNK_CACHE_W0_DFLT_F)
  EQUIVALENCE(H5D_flags(21), H5D_MPIO_NO_COLLECTIVE_F)
  EQUIVALENCE(H5D_flags(22), H5D_MPIO_CHUNK_INDEPENDENT_F)
  EQUIVALENCE(H5D_flags(23), H5D_MPIO_CHUNK_COLLECTIVE_F)
  EQUIVALENCE(H5D_flags(24), H5D_MPIO_CHUNK_MIXED_F)
  EQUIVALENCE(H5D_flags(25), H5D_MPIO_CONTIG_COLLECTIVE_F)
  EQUIVALENCE(H5D_flags(26), H5D_VDS_ERROR_F)
  EQUIVALENCE(H5D_flags(27), H5D_VDS_FIRST_MISSING_F)
  EQUIVALENCE(H5D_flags(28), H5D_VDS_LAST_AVAILABLE_F)
  EQUIVALENCE(H5D_flags(29), H5D_VIRTUAL_F)

  EQUIVALENCE(H5D_size_flags(1), H5D_CHUNK_CACHE_NSLOTS_DFLT_F)
  EQUIVALENCE(H5D_size_flags(2), H5D_CHUNK_CACHE_NBYTES_DFLT_F)

  !
  ! H5E flags declaration
  !
  INTEGER, PARAMETER :: H5E_FLAGS_LEN = 4
  INTEGER :: H5E_flags(H5E_FLAGS_LEN)
  INTEGER, PARAMETER :: H5E_HID_FLAGS_LEN = 1
  INTEGER(HID_T) :: H5E_hid_flags(H5E_HID_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5E_FLAGS/
  !DEC$ATTRIBUTES DLLEXPORT :: /H5E_HID_FLAGS/
  !DEC$endif
  COMMON /H5E_FLAGS/ H5E_flags
  COMMON /H5E_HID_FLAGS/ H5E_hid_flags

  INTEGER(HID_T) :: H5E_DEFAULT_F
  INTEGER :: H5E_MAJOR_F
  INTEGER :: H5E_MINOR_F
  INTEGER :: H5E_WALK_UPWARD_F
  INTEGER :: H5E_WALK_DOWNWARD_F

  EQUIVALENCE(H5E_hid_flags(1), H5E_DEFAULT_F)
  EQUIVALENCE(H5E_flags(1)    , H5E_MAJOR_F)
  EQUIVALENCE(H5E_flags(2)    , H5E_MINOR_F)
  EQUIVALENCE(H5E_flags(3)    , H5E_WALK_UPWARD_F)
  EQUIVALENCE(H5E_flags(4)    , H5E_WALK_DOWNWARD_F)

  !
  ! H5FD flags declaration
  !
  INTEGER, PARAMETER :: H5FD_FLAGS_LEN = 11
  INTEGER :: H5FD_flags(H5FD_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5FD_FLAGS/
  !DEC$endif
  COMMON /H5FD_FLAGS/ H5FD_flags

  INTEGER :: H5FD_MPIO_INDEPENDENT_F
  INTEGER :: H5FD_MPIO_COLLECTIVE_F
  INTEGER :: H5FD_MEM_NOLIST_F
  INTEGER :: H5FD_MEM_DEFAULT_F
  INTEGER :: H5FD_MEM_SUPER_F
  INTEGER :: H5FD_MEM_BTREE_F
  INTEGER :: H5FD_MEM_DRAW_F
  INTEGER :: H5FD_MEM_GHEAP_F
  INTEGER :: H5FD_MEM_LHEAP_F
  INTEGER :: H5FD_MEM_OHDR_F
  INTEGER :: H5FD_MEM_NTYPES_F

  EQUIVALENCE(H5FD_flags(1), H5FD_MPIO_INDEPENDENT_F)
  EQUIVALENCE(H5FD_flags(2), H5FD_MPIO_COLLECTIVE_F)
  EQUIVALENCE(H5FD_flags(3), H5FD_MEM_NOLIST_F)
  EQUIVALENCE(H5FD_flags(4), H5FD_MEM_DEFAULT_F)
  EQUIVALENCE(H5FD_flags(5), H5FD_MEM_SUPER_F)
  EQUIVALENCE(H5FD_flags(6), H5FD_MEM_BTREE_F)
  EQUIVALENCE(H5FD_flags(7), H5FD_MEM_DRAW_F)
  EQUIVALENCE(H5FD_flags(8), H5FD_MEM_GHEAP_F)
  EQUIVALENCE(H5FD_flags(9), H5FD_MEM_LHEAP_F)
  EQUIVALENCE(H5FD_flags(10), H5FD_MEM_OHDR_F)
  EQUIVALENCE(H5FD_flags(11), H5FD_MEM_NTYPES_F)
  !
  ! H5FD file drivers flags declaration
  !
  INTEGER, PARAMETER :: H5FD_HID_FLAGS_LEN = 7
  INTEGER(HID_T) :: H5FD_hid_flags(H5FD_HID_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5FD_HID_FLAGS/
  !DEC$endif
  COMMON /H5FD_HID_FLAGS/ H5FD_hid_flags

  INTEGER(HID_T) :: H5FD_CORE_F
  INTEGER(HID_T) :: H5FD_FAMILY_F
  INTEGER(HID_T) :: H5FD_LOG_F
  INTEGER(HID_T) :: H5FD_MPIO_F
  INTEGER(HID_T) :: H5FD_MULTI_F
  INTEGER(HID_T) :: H5FD_SEC2_F
  INTEGER(HID_T) :: H5FD_STDIO_F

  EQUIVALENCE(H5FD_hid_flags(1), H5FD_CORE_F)
  EQUIVALENCE(H5FD_hid_flags(2), H5FD_FAMILY_F)
  EQUIVALENCE(H5FD_hid_flags(3), H5FD_LOG_F)
  EQUIVALENCE(H5FD_hid_flags(4), H5FD_MPIO_F)
  EQUIVALENCE(H5FD_hid_flags(5), H5FD_MULTI_F)
  EQUIVALENCE(H5FD_hid_flags(6), H5FD_SEC2_F)
  EQUIVALENCE(H5FD_hid_flags(7), H5FD_STDIO_F)

  !
  ! H5I flags declaration
  !
  INTEGER, PARAMETER :: H5I_FLAGS_LEN = 7
  INTEGER :: H5I_flags(H5I_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5I_FLAGS/
  !DEC$endif
  COMMON /H5I_FLAGS/ H5I_flags

  INTEGER ::  H5I_FILE_F
  INTEGER ::  H5I_GROUP_F
  INTEGER ::  H5I_DATATYPE_F
  INTEGER ::  H5I_DATASPACE_F
  INTEGER ::  H5I_DATASET_F
  INTEGER ::  H5I_ATTR_F
  INTEGER ::  H5I_BADID_F

  EQUIVALENCE(H5I_flags(1), H5I_FILE_F)
  EQUIVALENCE(H5I_flags(2), H5I_GROUP_F)
  EQUIVALENCE(H5I_flags(3), H5I_DATATYPE_F)
  EQUIVALENCE(H5I_flags(4), H5I_DATASPACE_F)
  EQUIVALENCE(H5I_flags(5), H5I_DATASET_F)
  EQUIVALENCE(H5I_flags(6), H5I_ATTR_F)
  EQUIVALENCE(H5I_flags(7), H5I_BADID_F)
  !
  ! H5L flags declaration
  !
  INTEGER, PARAMETER :: H5L_FLAGS_LEN = 6
  INTEGER :: H5L_flags(H5L_FLAGS_LEN)

  INTEGER :: H5L_TYPE_ERROR_F
  INTEGER :: H5L_TYPE_HARD_F
  INTEGER :: H5L_TYPE_SOFT_F
  INTEGER :: H5L_TYPE_EXTERNAL_F
  INTEGER :: H5L_SAME_LOC_F
  INTEGER :: H5L_LINK_CLASS_T_VERS_F

  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5L_FLAGS/
  !DEC$endif
  COMMON /H5L_FLAGS/ H5L_flags

  EQUIVALENCE(H5L_flags(1), H5L_TYPE_ERROR_F)
  EQUIVALENCE(H5L_flags(2), H5L_TYPE_HARD_F)
  EQUIVALENCE(H5L_flags(3), H5L_TYPE_SOFT_F)
  EQUIVALENCE(H5L_flags(4), H5L_TYPE_EXTERNAL_F)
  EQUIVALENCE(H5L_flags(5), H5L_SAME_LOC_F)
  EQUIVALENCE(H5L_flags(6), H5L_LINK_CLASS_T_VERS_F)
  !
  ! H5O flags declaration
  !
  INTEGER, PARAMETER :: H5O_FLAGS_LEN = 27
  INTEGER :: H5o_flags(H5O_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5O_FLAGS/
  !DEC$endif
  COMMON /H5O_FLAGS/ H5O_flags

  INTEGER :: H5O_COPY_SHALLOW_HIERARCHY_F ! *** THESE VARIABLES DO
  INTEGER :: H5O_COPY_EXPAND_SOFT_LINK_F  ! NOT MATCH THE C VARIABLE
  INTEGER :: H5O_COPY_EXPAND_EXT_LINK_F   ! IN ORDER
  INTEGER :: H5O_COPY_EXPAND_REFERENCE_F  ! TO STAY UNDER THE
  INTEGER :: H5O_COPY_WITHOUT_ATTR_FLAG_F
  INTEGER :: H5O_COPY_PRESERVE_NULL_FLAG_F
  INTEGER :: H5O_COPY_ALL_F
  INTEGER :: H5O_SHMESG_NONE_FLAG_F
  INTEGER :: H5O_SHMESG_SDSPACE_FLAG_F
  INTEGER :: H5O_SHMESG_DTYPE_FLAG_F
  INTEGER :: H5O_SHMESG_FILL_FLAG_F
  INTEGER :: H5O_SHMESG_PLINE_FLAG_F
  INTEGER :: H5O_SHMESG_ATTR_FLAG_F
  INTEGER :: H5O_SHMESG_ALL_FLAG_F
  INTEGER :: H5O_HDR_CHUNK0_SIZE_F
  INTEGER :: H5O_HDR_ATTR_CRT_ORDER_TRACK_F ! 32 CHARACTER
  INTEGER :: H5O_HDR_ATTR_CRT_ORDER_INDEX_F ! VARIABLE
  INTEGER :: H5O_HDR_ATTR_STORE_PHASE_CHA_F ! LENGTH ***
  INTEGER :: H5O_HDR_STORE_TIMES_F
  INTEGER :: H5O_HDR_ALL_FLAGS_F
  INTEGER :: H5O_SHMESG_MAX_NINDEXES_F
  INTEGER :: H5O_SHMESG_MAX_LIST_SIZE_F
  INTEGER :: H5O_TYPE_UNKNOWN_F
  INTEGER :: H5O_TYPE_GROUP_F
  INTEGER :: H5O_TYPE_DATASET_F
  INTEGER :: H5O_TYPE_NAMED_DATATYPE_F
  INTEGER :: H5O_TYPE_NTYPES_F

  EQUIVALENCE(h5o_flags(1) , H5O_COPY_SHALLOW_HIERARCHY_F)
  EQUIVALENCE(h5o_flags(2) , H5O_COPY_EXPAND_SOFT_LINK_F)
  EQUIVALENCE(h5o_flags(3) , H5O_COPY_EXPAND_EXT_LINK_F)
  EQUIVALENCE(h5o_flags(4) , H5O_COPY_EXPAND_REFERENCE_F)
  EQUIVALENCE(h5o_flags(5) , H5O_COPY_WITHOUT_ATTR_FLAG_F)
  EQUIVALENCE(h5o_flags(6) , H5O_COPY_PRESERVE_NULL_FLAG_F)
  EQUIVALENCE(h5o_flags(7) , H5O_COPY_ALL_F)
  EQUIVALENCE(h5o_flags(8) , H5O_SHMESG_NONE_FLAG_F)
  EQUIVALENCE(h5o_flags(9) , H5O_SHMESG_SDSPACE_FLAG_F)
  EQUIVALENCE(h5o_flags(10) , H5O_SHMESG_DTYPE_FLAG_F)
  EQUIVALENCE(h5o_flags(11) , H5O_SHMESG_FILL_FLAG_F)
  EQUIVALENCE(h5o_flags(12) , H5O_SHMESG_PLINE_FLAG_F)
  EQUIVALENCE(h5o_flags(13) , H5O_SHMESG_ATTR_FLAG_F)
  EQUIVALENCE(h5o_flags(14) , H5O_SHMESG_ALL_FLAG_F)
  EQUIVALENCE(h5o_flags(15) , H5O_HDR_CHUNK0_SIZE_F)
  EQUIVALENCE(h5o_flags(16) , H5O_HDR_ATTR_CRT_ORDER_TRACK_F)
  EQUIVALENCE(h5o_flags(17) , H5O_HDR_ATTR_CRT_ORDER_INDEX_F)
  EQUIVALENCE(h5o_flags(18) , H5O_HDR_ATTR_STORE_PHASE_CHA_F)
  EQUIVALENCE(h5o_flags(19) , H5O_HDR_STORE_TIMES_F)
  EQUIVALENCE(h5o_flags(20) , H5O_HDR_ALL_FLAGS_F)
  EQUIVALENCE(h5o_flags(21) , H5O_SHMESG_MAX_NINDEXES_F)
  EQUIVALENCE(h5o_flags(22) , H5O_SHMESG_MAX_LIST_SIZE_F)
  EQUIVALENCE(h5o_flags(23) , H5O_TYPE_UNKNOWN_F)
  EQUIVALENCE(h5o_flags(24) , H5O_TYPE_GROUP_F)
  EQUIVALENCE(h5o_flags(25) , H5O_TYPE_DATASET_F)
  EQUIVALENCE(h5o_flags(26) , H5O_TYPE_NAMED_DATATYPE_F)
  EQUIVALENCE(h5o_flags(27) , H5O_TYPE_NTYPES_F)

  !
  ! H5P flags declaration
  !
  INTEGER, PARAMETER :: H5P_FLAGS_LEN = 18
  INTEGER(HID_T) H5P_flags(H5P_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5P_FLAGS/
  !DEC$endif
  COMMON /H5P_FLAGS/ H5P_flags

  INTEGER(HID_T) :: H5P_FILE_CREATE_F
  INTEGER(HID_T) :: H5P_FILE_ACCESS_F
  INTEGER(HID_T) :: H5P_DATASET_CREATE_F
  INTEGER(HID_T) :: H5P_DATASET_XFER_F
  INTEGER(HID_T) :: H5P_FILE_MOUNT_F
  INTEGER(HID_T) :: H5P_DEFAULT_F
  INTEGER(HID_T) :: H5P_ROOT_F
  INTEGER(HID_T) :: H5P_OBJECT_CREATE_F
  INTEGER(HID_T) :: H5P_DATASET_ACCESS_F
  INTEGER(HID_T) :: H5P_GROUP_CREATE_F
  INTEGER(HID_T) :: H5P_GROUP_ACCESS_F
  INTEGER(HID_T) :: H5P_DATATYPE_CREATE_F
  INTEGER(HID_T) :: H5P_DATATYPE_ACCESS_F
  INTEGER(HID_T) :: H5P_STRING_CREATE_F
  INTEGER(HID_T) :: H5P_ATTRIBUTE_CREATE_F
  INTEGER(HID_T) :: H5P_OBJECT_COPY_F
  INTEGER(HID_T) :: H5P_LINK_CREATE_F
  INTEGER(HID_T) :: H5P_LINK_ACCESS_F

  EQUIVALENCE(H5P_flags(1), H5P_FILE_CREATE_F)
  EQUIVALENCE(H5P_flags(2), H5P_FILE_ACCESS_F)
  EQUIVALENCE(H5P_flags(3), H5P_DATASET_CREATE_F)
  EQUIVALENCE(H5P_flags(4), H5P_DATASET_XFER_F)
  EQUIVALENCE(H5P_flags(5), H5P_FILE_MOUNT_F)
  EQUIVALENCE(H5P_flags(6), H5P_DEFAULT_F)
  EQUIVALENCE(H5P_flags(7), H5P_ROOT_F)
  EQUIVALENCE(H5P_flags(8), H5P_OBJECT_CREATE_F)
  EQUIVALENCE(H5P_flags(9), H5P_DATASET_ACCESS_F)
  EQUIVALENCE(H5P_flags(10), H5P_GROUP_CREATE_F)
  EQUIVALENCE(H5P_flags(11), H5P_GROUP_ACCESS_F)
  EQUIVALENCE(H5P_flags(12), H5P_DATATYPE_CREATE_F)
  EQUIVALENCE(H5P_flags(13), H5P_DATATYPE_ACCESS_F)
  EQUIVALENCE(H5P_flags(14), H5P_STRING_CREATE_F)
  EQUIVALENCE(H5P_flags(15), H5P_ATTRIBUTE_CREATE_F)
  EQUIVALENCE(H5P_flags(16), H5P_OBJECT_COPY_F)
  EQUIVALENCE(H5P_flags(17), H5P_LINK_CREATE_F)
  EQUIVALENCE(H5P_flags(18), H5P_LINK_ACCESS_F)

  !
  ! H5P integers flags declaration
  !
  INTEGER, PARAMETER :: H5P_FLAGS_INT_LEN = 2
  INTEGER :: H5P_flags_int(H5P_FLAGS_INT_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5P_FLAGS_INT/
  !DEC$endif
  COMMON /H5P_FLAGS_INT/ H5P_flags_int
  INTEGER :: H5P_CRT_ORDER_INDEXED_F
  INTEGER :: H5P_CRT_ORDER_TRACKED_F
  EQUIVALENCE(H5P_flags_int(1), H5P_CRT_ORDER_INDEXED_F)
  EQUIVALENCE(H5P_flags_int(2), H5P_CRT_ORDER_TRACKED_F)
  !
  ! H5R flags declaration
  !
  INTEGER, PARAMETER :: H5R_FLAGS_LEN = 2
  INTEGER :: H5R_flags(H5R_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5R_FLAGS/
  !DEC$endif
  COMMON /H5R_FLAGS/ H5R_flags

  INTEGER :: H5R_OBJECT_F
  INTEGER :: H5R_DATASET_REGION_F

  EQUIVALENCE(H5R_flags(1), H5R_OBJECT_F)
  EQUIVALENCE(H5R_flags(2), H5R_DATASET_REGION_F)

  !
  ! H5S flags declaration
  !
  INTEGER, PARAMETER :: H5S_FLAGS_LEN = 19
  INTEGER :: H5S_flags(H5S_FLAGS_LEN)
  INTEGER, PARAMETER :: H5S_HSIZE_FLAGS_LEN = 1
  INTEGER(HSIZE_T) H5S_hsize_flags(H5S_HSIZE_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5S_FLAGS/
  !DEC$ATTRIBUTES DLLEXPORT :: /H5S_HSIZE_FLAGS/
  !DEC$endif
  COMMON /H5S_FLAGS/ H5S_flags
  COMMON /H5S_HSIZE_FLAGS/ H5S_hsize_flags

  INTEGER(HSIZE_T) :: H5S_UNLIMITED_F

  INTEGER :: H5S_SCALAR_F
  INTEGER :: H5S_SIMPLE_F
  INTEGER :: H5S_NULL_F

  INTEGER :: H5S_ALL_F

  INTEGER :: H5S_SELECT_NOOP_F
  INTEGER :: H5S_SELECT_SET_F
  INTEGER :: H5S_SELECT_OR_F
  INTEGER :: H5S_SELECT_AND_F
  INTEGER :: H5S_SELECT_XOR_F
  INTEGER :: H5S_SELECT_NOTB_F
  INTEGER :: H5S_SELECT_NOTA_F
  INTEGER :: H5S_SELECT_APPEND_F
  INTEGER :: H5S_SELECT_PREPEND_F
  INTEGER :: H5S_SELECT_INVALID_F

  INTEGER :: H5S_SEL_ERROR_F
  INTEGER :: H5S_SEL_NONE_F
  INTEGER :: H5S_SEL_POINTS_F
  INTEGER :: H5S_SEL_HYPERSLABS_F
  INTEGER :: H5S_SEL_ALL_F

  EQUIVALENCE(H5S_hsize_flags(1), H5S_UNLIMITED_F)
  EQUIVALENCE(H5S_flags(1), H5S_SCALAR_F)
  EQUIVALENCE(H5S_flags(2), H5S_SIMPLE_F)
  EQUIVALENCE(H5S_flags(3), H5S_NULL_F)
  EQUIVALENCE(H5S_flags(4), H5S_SELECT_SET_F)
  EQUIVALENCE(H5S_flags(5), H5S_SELECT_OR_F)
  EQUIVALENCE(H5S_flags(6), H5S_ALL_F)

  EQUIVALENCE(H5S_flags(7), H5S_SELECT_NOOP_F)
  EQUIVALENCE(H5S_flags(8), H5S_SELECT_AND_F)
  EQUIVALENCE(H5S_flags(9), H5S_SELECT_XOR_F)
  EQUIVALENCE(H5S_flags(10), H5S_SELECT_NOTB_F)
  EQUIVALENCE(H5S_flags(11), H5S_SELECT_NOTA_F)
  EQUIVALENCE(H5S_flags(12), H5S_SELECT_APPEND_F)
  EQUIVALENCE(H5S_flags(13), H5S_SELECT_PREPEND_F)
  EQUIVALENCE(H5S_flags(14), H5S_SELECT_INVALID_F)


  EQUIVALENCE(H5S_flags(15), H5S_SEL_ERROR_F)
  EQUIVALENCE(H5S_flags(16), H5S_SEL_NONE_F)
  EQUIVALENCE(H5S_flags(17), H5S_SEL_POINTS_F)
  EQUIVALENCE(H5S_flags(18), H5S_SEL_HYPERSLABS_F)
  EQUIVALENCE(H5S_flags(19), H5S_SEL_ALL_F)

  !
  ! H5T flags declaration
  !
  INTEGER, PARAMETER :: H5T_FLAGS_LEN = 35
  INTEGER :: H5T_flags(H5T_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5T_FLAGS/
  !DEC$endif
  COMMON /H5T_FLAGS/ H5T_flags

  INTEGER :: H5T_NO_CLASS_F
  INTEGER :: H5T_INTEGER_F
  INTEGER :: H5T_FLOAT_F
  INTEGER :: H5T_TIME_F
  INTEGER :: H5T_STRING_F
  INTEGER :: H5T_BITFIELD_F
  INTEGER :: H5T_OPAQUE_F
  INTEGER :: H5T_COMPOUND_F
  INTEGER :: H5T_REFERENCE_F
  INTEGER :: H5T_ENUM_F
  INTEGER :: H5T_VLEN_F
  INTEGER :: H5T_ARRAY_F
  INTEGER :: H5T_ORDER_LE_F
  INTEGER :: H5T_ORDER_BE_F
  INTEGER :: H5T_ORDER_VAX_F
  INTEGER :: H5T_ORDER_NONE_F
  INTEGER :: H5T_ORDER_MIXED_F
  INTEGER :: H5T_PAD_ZERO_F
  INTEGER :: H5T_PAD_ONE_F
  INTEGER :: H5T_PAD_BACKGROUND_F
  INTEGER :: H5T_PAD_ERROR_F
  INTEGER :: H5T_SGN_NONE_F
  INTEGER :: H5T_SGN_2_F
  INTEGER :: H5T_SGN_ERROR_F
  INTEGER :: H5T_NORM_IMPLIED_F
  INTEGER :: H5T_NORM_MSBSET_F
  INTEGER :: H5T_NORM_NONE_F
  INTEGER :: H5T_CSET_ASCII_F
  INTEGER :: H5T_CSET_UTF8_F
  INTEGER :: H5T_STR_NULLTERM_F
  INTEGER :: H5T_STR_NULLPAD_F
  INTEGER :: H5T_STR_SPACEPAD_F
  INTEGER :: H5T_STR_ERROR_F
  INTEGER :: H5T_DIR_ASCEND_F
  INTEGER :: H5T_DIR_DESCEND_F

  EQUIVALENCE(H5T_flags(1), H5T_NO_CLASS_F)
  EQUIVALENCE(H5T_flags(2), H5T_INTEGER_F)
  EQUIVALENCE(H5T_flags(3), H5T_FLOAT_F)
  EQUIVALENCE(H5T_flags(4), H5T_TIME_F)
  EQUIVALENCE(H5T_flags(5), H5T_STRING_F)
  EQUIVALENCE(H5T_flags(6), H5T_BITFIELD_F)
  EQUIVALENCE(H5T_flags(7), H5T_OPAQUE_F)
  EQUIVALENCE(H5T_flags(8), H5T_COMPOUND_F)
  EQUIVALENCE(H5T_flags(9), H5T_REFERENCE_F)
  EQUIVALENCE(H5T_flags(10), H5T_ENUM_F)
  EQUIVALENCE(H5T_flags(11), H5T_ORDER_LE_F)
  EQUIVALENCE(H5T_flags(12), H5T_ORDER_BE_F)
  EQUIVALENCE(H5T_flags(13), H5T_ORDER_MIXED_F)
  EQUIVALENCE(H5T_flags(14), H5T_ORDER_VAX_F)
  EQUIVALENCE(H5T_flags(15), H5T_ORDER_NONE_F)
  EQUIVALENCE(H5T_flags(16), H5T_PAD_ZERO_F)
  EQUIVALENCE(H5T_flags(17), H5T_PAD_ONE_F)
  EQUIVALENCE(H5T_flags(18), H5T_PAD_BACKGROUND_F)
  EQUIVALENCE(H5T_flags(19), H5T_PAD_ERROR_F)
  EQUIVALENCE(H5T_flags(20), H5T_SGN_NONE_F)
  EQUIVALENCE(H5T_flags(21), H5T_SGN_2_F)
  EQUIVALENCE(H5T_flags(22), H5T_SGN_ERROR_F)
  EQUIVALENCE(H5T_flags(23), H5T_NORM_IMPLIED_F)
  EQUIVALENCE(H5T_flags(24), H5T_NORM_MSBSET_F)
  EQUIVALENCE(H5T_flags(25), H5T_NORM_NONE_F)
  EQUIVALENCE(H5T_flags(26), H5T_CSET_ASCII_F)
  EQUIVALENCE(H5T_flags(27), H5T_CSET_UTF8_F)
  EQUIVALENCE(H5T_flags(28), H5T_STR_NULLTERM_F)
  EQUIVALENCE(H5T_flags(29), H5T_STR_NULLPAD_F)
  EQUIVALENCE(H5T_flags(30), H5T_STR_SPACEPAD_F)
  EQUIVALENCE(H5T_flags(31), H5T_STR_ERROR_F)
  EQUIVALENCE(H5T_flags(32), H5T_VLEN_F)
  EQUIVALENCE(H5T_flags(33), H5T_ARRAY_F)
  EQUIVALENCE(H5T_flags(34), H5T_DIR_ASCEND_F)
  EQUIVALENCE(H5T_flags(35), H5T_DIR_DESCEND_F)
  !
  ! H5Z flags declaration
  !
  INTEGER, PARAMETER :: H5Z_FLAGS_LEN = 20
  INTEGER :: H5Z_flags(H5Z_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5Z_FLAGS/
  !DEC$endif
  COMMON /H5Z_FLAGS/ H5Z_flags

  INTEGER :: H5Z_FILTER_ERROR_F
  INTEGER :: H5Z_FILTER_NONE_F
  INTEGER :: H5Z_FILTER_ALL_F
  INTEGER :: H5Z_FILTER_DEFLATE_F
  INTEGER :: H5Z_FILTER_SHUFFLE_F
  INTEGER :: H5Z_FILTER_FLETCHER32_F
  INTEGER :: H5Z_FILTER_SZIP_F
  INTEGER :: H5Z_ERROR_EDC_F
  INTEGER :: H5Z_DISABLE_EDC_F
  INTEGER :: H5Z_ENABLE_EDC_F
  INTEGER :: H5Z_NO_EDC_F
  INTEGER :: H5Z_FLAG_OPTIONAL_F
  INTEGER :: H5Z_FILTER_ENCODE_ENABLED_F
  INTEGER :: H5Z_FILTER_DECODE_ENABLED_F
  INTEGER :: H5Z_FILTER_NBIT_F
  INTEGER :: H5Z_FILTER_SCALEOFFSET_F
  INTEGER :: H5Z_SO_FLOAT_DSCALE_F
  INTEGER :: H5Z_SO_FLOAT_ESCALE_F
  INTEGER :: H5Z_SO_INT_F
  INTEGER :: H5Z_SO_INT_MINBITS_DEFAULT_F

  EQUIVALENCE(H5Z_flags(1), H5Z_FILTER_ERROR_F)
  EQUIVALENCE(H5Z_flags(2), H5Z_FILTER_NONE_F)
  EQUIVALENCE(H5Z_flags(3), H5Z_FILTER_DEFLATE_F)
  EQUIVALENCE(H5Z_flags(4), H5Z_FILTER_SHUFFLE_F)
  EQUIVALENCE(H5Z_flags(5), H5Z_FILTER_FLETCHER32_F)
  EQUIVALENCE(H5Z_flags(6), H5Z_ERROR_EDC_F)
  EQUIVALENCE(H5Z_flags(7), H5Z_DISABLE_EDC_F)
  EQUIVALENCE(H5Z_flags(8), H5Z_ENABLE_EDC_F)
  EQUIVALENCE(H5Z_flags(9), H5Z_NO_EDC_F)
  EQUIVALENCE(H5Z_flags(10), H5Z_FILTER_SZIP_F)
  EQUIVALENCE(H5Z_flags(11), H5Z_FLAG_OPTIONAL_F)
  EQUIVALENCE(H5Z_flags(12), H5Z_FILTER_ENCODE_ENABLED_F)
  EQUIVALENCE(H5Z_flags(13), H5Z_FILTER_DECODE_ENABLED_F)
  EQUIVALENCE(H5Z_flags(14), H5Z_FILTER_ALL_F)
  EQUIVALENCE(H5Z_flags(15), H5Z_FILTER_NBIT_F)
  EQUIVALENCE(H5Z_flags(16), H5Z_FILTER_SCALEOFFSET_F)
  EQUIVALENCE(H5Z_flags(17), H5Z_SO_FLOAT_DSCALE_F)
  EQUIVALENCE(H5Z_flags(18), H5Z_SO_FLOAT_ESCALE_F)
  EQUIVALENCE(H5Z_flags(19), H5Z_SO_INT_F)
  EQUIVALENCE(H5Z_flags(20), H5Z_SO_INT_MINBITS_DEFAULT_F)

  !
  ! H5 Library flags declaration
  !
  INTEGER, PARAMETER :: H5LIB_FLAGS_LEN =  2
  INTEGER :: H5LIB_flags(H5LIB_FLAGS_LEN)
  !DEC$if defined(BUILD_HDF5_DLL)
  !DEC$ATTRIBUTES DLLEXPORT :: /H5LIB_FLAGS/
  !DEC$endif
  COMMON /H5LIB_FLAGS/ H5LIB_flags
  INTEGER :: H5_SZIP_EC_OM_F
  INTEGER :: H5_SZIP_NN_OM_F
  !
  EQUIVALENCE(H5LIB_flags(1), H5_SZIP_EC_OM_F)
  EQUIVALENCE(H5LIB_flags(2), H5_SZIP_NN_OM_F)


  ! General H5 flags declarations
  !
!!$      INTEGER, PARAMETER :: H5_FLAGS_LEN = 2
!!$      INTEGER H5_flags(H5_FLAGS_LEN)
!!$!DEC$if defined(BUILD_HDF5_DLL)
!!$!DEC$ATTRIBUTES DLLEXPORT :: /H5_FLAGS/
!!$!DEC$endif
!!$      COMMON /H5_FLAGS/ H5_flags
!!$
!!$      INTEGER :: _F
!!$      INTEGER :: H5F_SCOPE_LOCAL_F
!!$
!!$      EQUIVALENCE(H5F_flags(1), H5F_SCOPE_GLOBAL_F)
!!$      EQUIVALENCE(H5F_flags(2), H5F_SCOPE_LOCAL_F)

CONTAINS

  ! Copy a c string to a Fortran string

  SUBROUTINE H5_Fortran_string_c2f(c_string, f_string)

    USE, INTRINSIC :: ISO_C_BINDING
    IMPLICIT NONE
    CHARACTER(KIND=C_CHAR, LEN=*), INTENT(IN) :: c_string
    CHARACTER(LEN=*), INTENT(OUT) :: f_string
    INTEGER(SIZE_T) :: c_len, f_len

    ! Find the length of the C string by locating the null terminator
    c_len = MAX(INDEX(c_string,C_NULL_CHAR, KIND=SIZE_T)-1_SIZE_T,1_SIZE_T)
    ! Find the length of the Fortran string
    f_len = LEN(f_string)

    ! CASE (1): C string is equal to or larger than Fortran character buffer,
    !           so fill the entire Fortran buffer. 
    IF(c_len.GE.f_len)THEN !
       f_string(1:f_len) = c_string(1:f_len)

    ! CASE (2): C string is smaller than Fortran character buffer, 
    !           so copy C string and blank pad remaining characters.
    ELSE
       f_string(1:c_len) = c_string(1:c_len)
       f_string(c_len+1:f_len) =' '
    ENDIF
  END SUBROUTINE H5_Fortran_string_c2f

  SUBROUTINE H5_Fortran_string_f2c(f_string, c_string)

    USE, INTRINSIC :: ISO_C_BINDING
    IMPLICIT NONE
    CHARACTER(LEN=*), INTENT(IN) :: f_string
    CHARACTER(KIND=C_CHAR, LEN=*), INTENT(OUT) :: c_string

    c_string = TRIM(f_string)//C_NULL_CHAR

  END SUBROUTINE H5_Fortran_string_f2c


! Copy Fortran string to C charater array, assuming the C array is one-char
! longer for the terminating null char.
! fstring : the Fortran input string
! cstring : the C output string (with memory already allocated)
!!$subroutine MPIR_Fortran_string_f2c(fstring, cstring)
!!$    implicit none
!!$    character(len=*), intent(in) :: fstring
!!$    character(kind=c_char), intent(out) :: cstring(:)
!!$    integer :: i, j
!!$    logical :: met_non_blank
!!$
!!$    ! Trim the leading and trailing blank characters
!!$    j = 1
!!$    met_non_blank = .false.
!!$    do i = 1, len_trim(fstring)
!!$        if (met_non_blank) then
!!$            cstring(j) = fstring(i:i)
!!$            j = j + 1
!!$        else if (fstring(i:i) /= ' ') then
!!$            met_non_blank = .true.
!!$            cstring(j) = fstring(i:i)
!!$            j = j + 1
!!$        end if
!!$    end do
!!$
!!$    cstring(j) = C_NULL_CHAR
!!$end subroutine MPIR_Fortran_string_f2c
!!$
!!$! Copy C charater array to Fortran string
!!$subroutine MPIR_Fortran_string_c2f(cstring, fstring)
!!$    implicit none
!!$    character(kind=c_char), intent(in) :: cstring(:)
!!$    character(len=*), intent(out) :: fstring
!!$    integer :: i, j, length
!!$
!!$    i = 1
!!$    do while (cstring(i) /= C_NULL_CHAR)
!!$        fstring(i:i) = cstring(i)
!!$        i = i + 1
!!$    end do
!!$
!!$    ! Zero out the trailing characters
!!$    length = len(fstring)
!!$    do j = i, length
!!$        fstring(j:j) = ' '
!!$    end do
!!$end subroutine MPIR_Fortran_string_c2f
  
END MODULE H5GLOBAL

