/*
 * Copyright 2012 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import QtGraphicalEffects 1.0
import Ubuntu.Components 0.1
import Ubuntu.Components.ListItems 0.1 as ListItem
import Ubuntu.Components.Popups 0.1
import Friends 0.2

Item {
    id: statusUpdateTile

    height: {
        var baseHeight = statusUpdateContent.height + statusUpdateAttachement.height

        if(metaInfo.hasContent)
            return baseHeight + units.gu(2)
        else
            return baseHeight + units.gu(1)
    }

    anchors {
        left: parent.left
        right: parent.right
    }

    MetaInfo {
        id: metaInfo
    }

    //Forward properties
    property bool liked : model.liked
    property bool fromMe: model.fromMe
    property string message: model.message
    property string service: model.service
    property string linkUrl: model.linkUrl
    property string linkName: model.linkName
    property string linkDescription: model.linkDescription
    property string avatar: model.avatar
    property string location: model.location
    property string sender: model.sender
    property string linkPicture: model.linkPicture
    property int latitude: model.latitude
    property int longitude: model.longitude
    property string messageId: model.messageId
    property string stream: model.stream
    property string senderNick: model.senderNick
    property string url: model.url
    property string accountId: model.accountId

    function showConversation() {
        main.addConversation(statusUpdateTile)
    }

    property string timeString: friendsUtils.createTimeString(timestamp)

    property int likeCount: {
        if(likes == 0) {
            if(liked)
                return 1
            else
                return 0
        }

        return likes
    }

    property string likesString: likeCount > 1 ? i18n.tr("people liked this") : i18n.tr("person liked this")
    property string icon: "images/"+service+".png"

    function recalculateTimeString() {
        statusUpdateTile.timeString = friendsUtils.createTimeString(timestamp);
    }

    FriendsUtils {
        id: friendsUtils
    }

    FriendsDispatcher {
        id: friends

        onRetweetComplete: {
            retweetSpinner.visible = false;
            if (success) {
                console.log ("Retweet completed successfully");
            } else {
                console.log ("Retweet failed: " + errorMessage);
            }
        }
    }


    // Keep below content so links are still clickable
    MouseArea {
        anchors.fill: statusUpdateTile
        onClicked: {
            showConversation()
        }
    }

    AvatarImage {
        id: avatarImage

        anchors {
            left: parent.left
            leftMargin: units.gu(1)
        }
    }

    Image {
        id: privateIcon
        anchors {
            right: avatarImage.right
            bottom: avatarImage.bottom
            bottomMargin: units.dp(3)
            rightMargin: units.dp(3)
        }
        source: "images/private.png"
        asynchronous: true
        visible: stream === "private"
    }

    Image {
        id: replyIcon
        anchors {
            right: avatarImage.right
            bottom: avatarImage.bottom
            bottomMargin: units.dp(3)
            rightMargin: units.dp(3)
        }
        source: "images/replies.png"
        asynchronous: true
        visible: stream === "mentions"
    }

    Image {
        id: serviceIcon
        anchors {
            left: parent.left
            top: avatarImage.bottom
            topMargin: units.gu(1)
            leftMargin: units.gu(1)
            bottomMargin: units.gu(1)
        }
        source: icon
        width: units.gu(2)
        height: units.gu(2)
        asynchronous: true
        smooth: true
    }

    StatusUpdateContent {
        id: statusUpdateContent

        anchors {
            left: avatarImage.right
            right: parent.right
            top: parent.top
            margins: units.gu(1)
        }
    }

    StatusUpdateAttachment {
        id: statusUpdateAttachement

        crop: true

        anchors {
            top: statusUpdateContent.bottom

            left: statusUpdateTile.width > units.gu(90) ? statusUpdateContent.left : statusUpdateTile.left
            leftMargin: units.gu(1)
        }

        width: statusUpdateTile.width > units.gu(80) ? units.gu(78) : (statusUpdateTile.width - units.gu(2))
    }
}
