/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowType;
import visad.Tuple;
import visad.TypeException;
import visad.VisADException;

public class TupleType
extends MathType {
    private MathType[] tupleComponents;
    private boolean Flat;
    private final RealType[] realComponents;
    private int[] lows;
    private int[] his;

    public TupleType(MathType[] types) throws VisADException {
        boolean allReal = true;
        this.Flat = true;
        int n = types.length;
        int nFlat = 0;
        this.tupleComponents = new MathType[n];
        if (n < 1) {
            throw new TypeException("TupleType: # components must be > 0");
        }
        for (int i = 0; i < n; ++i) {
            if (types[i] == null) {
                throw new TypeException("TupleType: components must be non-null");
            }
            this.tupleComponents[i] = types[i];
            if (!(types[i] instanceof RealType)) {
                allReal = false;
            }
            if (types[i] instanceof RealType) {
                ++nFlat;
                continue;
            }
            if (types[i] instanceof RealTupleType) {
                nFlat += ((RealTupleType)types[i]).getDimension();
                continue;
            }
            this.Flat = false;
        }
        if (allReal && !(this instanceof RealTupleType)) {
            throw new TypeException("TupleType: all components are RealType, must use RealTupleType");
        }
        this.realComponents = new RealType[nFlat];
        this.lows = new int[n];
        this.his = new int[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            this.lows[i] = j;
            if (types[i] instanceof RealType) {
                this.realComponents[j] = (RealType)types[i];
            } else if (types[i] instanceof RealTupleType) {
                int m = ((RealTupleType)types[i]).getDimension();
                for (int k = 0; k < m; ++k) {
                    this.realComponents[j] = (RealType)((RealTupleType)types[i]).getComponent(k);
                    ++j;
                }
            }
            this.his[i] = ++j;
        }
    }

    TupleType(RealType[] types, boolean b) {
        super(b);
        boolean allReal = true;
        this.Flat = true;
        int n = types.length;
        int nFlat = 0;
        this.tupleComponents = new MathType[n];
        for (int i = 0; i < n; ++i) {
            this.tupleComponents[i] = types[i];
            ++nFlat;
        }
        this.realComponents = new RealType[nFlat];
        this.lows = new int[n];
        this.his = new int[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            this.lows[i] = j;
            if (types[i] instanceof RealType) {
                this.realComponents[j] = types[i];
            }
            this.his[i] = ++j;
        }
    }

    public int getDimension() {
        return this.tupleComponents.length;
    }

    public MathType[] getComponents() {
        return this.tupleComponents;
    }

    public RealType[] getRealComponents() {
        return this.realComponents;
    }

    public int getNumberOfRealComponents() {
        return this.realComponents.length;
    }

    public MathType __getitem__(int index) throws VisADException {
        return this.getComponent(index);
    }

    public int __len__() {
        return this.tupleComponents.length;
    }

    public MathType getComponent(int i) throws VisADException {
        if (0 <= i && i < this.tupleComponents.length) {
            return this.tupleComponents[i];
        }
        throw new TypeException("TupleType: component index out of range");
    }

    public int getIndex(String name) {
        return this.getIndex(RealType.getRealTypeByName(name));
    }

    public int getIndex(MathType type) {
        for (int i = 0; i < this.tupleComponents.length; ++i) {
            if (!this.tupleComponents[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object type) {
        if (!(type instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.tupleComponents[i].equals(((TupleType)type).getComponent(i))) continue;
                return false;
            }
        }
        catch (VisADException e) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return ((Object)Arrays.asList(this.tupleComponents)).hashCode();
    }

    public boolean equalsExceptName(MathType type) {
        if (!(type instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            for (int i = 0; i < n; ++i) {
                flag = flag && this.tupleComponents[i].equalsExceptName(((TupleType)type).getComponent(i));
            }
            return flag;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public boolean equalsExceptNameButUnits(MathType type) {
        if (!(type instanceof TupleType)) {
            return false;
        }
        try {
            int n = this.tupleComponents.length;
            if (n != ((TupleType)type).getDimension()) {
                return false;
            }
            boolean flag = true;
            for (int i = 0; i < n; ++i) {
                flag = flag && this.tupleComponents[i].equalsExceptNameButUnits(((TupleType)type).getComponent(i));
            }
            return flag;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public MathType cloneDerivative(RealType d_partial) throws VisADException {
        int n_comps = this.tupleComponents.length;
        MathType[] new_types = new MathType[n_comps];
        boolean allReal = true;
        for (int ii = 0; ii < n_comps; ++ii) {
            new_types[ii] = this.getComponent(ii).cloneDerivative(d_partial);
            if (new_types[ii] instanceof RealType) continue;
            allReal = false;
        }
        if (allReal) {
            RealType[] r_types = new RealType[n_comps];
            for (int ii = 0; ii < n_comps; ++ii) {
                r_types[ii] = (RealType)new_types[ii];
            }
            return new RealTupleType(r_types);
        }
        return new TupleType(new_types);
    }

    public MathType binary(MathType type, int op, Vector names) throws VisADException {
        if (type == null) {
            throw new TypeException("TupleType.binary: type may not be null");
        }
        if (type instanceof RealTupleType) {
            throw new TypeException("TupleType.binary: types don't match");
        }
        if (type instanceof TupleType) {
            int n_comps = this.tupleComponents.length;
            MathType[] new_types = new MathType[n_comps];
            for (int ii = 0; ii < n_comps; ++ii) {
                MathType type_component = ((TupleType)type).getComponent(ii);
                new_types[ii] = this.getComponent(ii).binary(type_component, op, names);
            }
            return new TupleType(new_types);
        }
        if (type instanceof RealType) {
            int n_comps = this.tupleComponents.length;
            MathType[] new_types = new MathType[n_comps];
            for (int ii = 0; ii < n_comps; ++ii) {
                new_types[ii] = this.getComponent(ii).binary(type, op, names);
            }
            return new TupleType(new_types);
        }
        if (type instanceof FunctionType && ((FunctionType)type).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)type).getDomain(), ((FunctionType)type).getRange().binary(this, DataImpl.invertOp(op), names));
        }
        throw new TypeException("TupleType.binary: types don't match");
    }

    public MathType unary(int op, Vector names) throws VisADException {
        int n_comps = this.tupleComponents.length;
        MathType[] new_types = new MathType[n_comps];
        for (int ii = 0; ii < n_comps; ++ii) {
            new_types[ii] = this.getComponent(ii).unary(op, names);
        }
        return new TupleType(new_types);
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public String prettyString(int indent) {
        int n = this.tupleComponents.length;
        String[] cs = new String[n];
        int[] lens = new int[n];
        int maxlen = 0;
        int sumlen = 0;
        for (int i = 0; i < n; ++i) {
            cs[i] = this.tupleComponents[i].prettyString(indent + 1);
            lens[i] = cs[i].length();
            if (lens[i] > maxlen) {
                maxlen = lens[i];
            }
            sumlen += lens[i];
        }
        if (sumlen + indent <= 72) {
            String s = "(" + cs[0];
            for (int i = 1; i < n; ++i) {
                s = s + ", " + cs[i];
            }
            return s + ")";
        }
        String blanks = "";
        for (int j = 0; j < indent + 1; ++j) {
            blanks = blanks + " ";
        }
        String s = "(" + cs[0];
        if (1 < n) {
            s = s + ",";
        }
        for (int i = 1; i < n; ++i) {
            s = s + "\n" + blanks + cs[i];
            if (i + 1 >= n) continue;
            s = s + ",";
        }
        return s + ")";
    }

    public Data missingData() {
        return new Tuple(this);
    }

    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowTupleType(this, link, parent);
    }
}

