/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.VisADException;

public class LogCoordinateSystem
extends CoordinateSystem {
    private double base = 10.0;

    public LogCoordinateSystem(RealTupleType reference) throws VisADException {
        this(reference, 10.0);
    }

    public LogCoordinateSystem(RealTupleType reference, double base) throws VisADException {
        super(reference, reference.getDefaultUnits());
        if (base <= 0.0) {
            throw new VisADException("LogCoordinateSystem: log base (" + base + ") must be positive");
        }
        this.base = base;
    }

    public double[][] toReference(double[][] values) throws VisADException {
        if (values == null || values[0].length < 1) {
            return values;
        }
        if (values.length != this.getDimension()) {
            throw new CoordinateSystemException("LogCoordinateSystem.toReference: values wrong dimension");
        }
        int len = values[0].length;
        double[][] logValues = new double[this.getDimension()][len];
        for (int i = 0; i < this.getDimension(); ++i) {
            for (int j = 0; j < len; ++j) {
                logValues[i][j] = Math.log(values[i][j]) / Math.log(this.base);
            }
        }
        return logValues;
    }

    public double[][] fromReference(double[][] logValues) throws VisADException {
        if (logValues == null || logValues[0].length < 1) {
            return logValues;
        }
        if (logValues.length != this.getDimension()) {
            throw new CoordinateSystemException("LogCoordinateSystem.fromReference: logValues wrong dimension");
        }
        int len = logValues[0].length;
        double[][] values = new double[this.getDimension()][len];
        for (int i = 0; i < this.getDimension(); ++i) {
            for (int j = 0; j < len; ++j) {
                values[i][j] = Math.pow(this.base, logValues[i][j]);
            }
        }
        return values;
    }

    public double getBase() {
        return this.base;
    }

    public boolean equals(Object cs) {
        if (!(cs instanceof LogCoordinateSystem)) {
            return false;
        }
        LogCoordinateSystem that = (LogCoordinateSystem)cs;
        return this == that || that.getReference().equals(this.getReference()) && Double.doubleToLongBits(that.base) == Double.doubleToLongBits(this.base);
    }
}

