/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.StatusListener;

public class ImageReader
implements IFormatReader {
    private static ClassList defaultClasses;
    private IFormatReader[] readers;
    private String[] suffixes;
    private String currentId;
    private int current;

    private static ClassList getDefaultReaderClasses() {
        if (defaultClasses == null) {
            try {
                defaultClasses = new ClassList("readers.txt", IFormatReader.class);
            }
            catch (IOException exc) {
                defaultClasses = new ClassList(IFormatReader.class);
                LogTools.trace(exc);
            }
        }
        return defaultClasses;
    }

    public ImageReader() {
        this(ImageReader.getDefaultReaderClasses());
    }

    public ImageReader(ClassList classList) {
        Vector<IFormatReader> v = new Vector<IFormatReader>();
        Class[] c = classList.getClasses();
        for (int i = 0; i < c.length; ++i) {
            IFormatReader reader = null;
            try {
                reader = (IFormatReader)c[i].newInstance();
            }
            catch (IllegalAccessException exc) {
            }
            catch (InstantiationException exc) {
                // empty catch block
            }
            if (reader == null) {
                LogTools.println("Error: " + c[i].getName() + " cannot be instantiated.");
                continue;
            }
            v.add(reader);
        }
        this.readers = new IFormatReader[v.size()];
        v.copyInto(this.readers);
    }

    public String getFormat(String id) throws FormatException, IOException {
        return this.getReader(id).getFormat();
    }

    public IFormatReader getReader(String id) throws FormatException, IOException {
        if (!id.equals(this.currentId)) {
            boolean success = false;
            for (int i = 0; i < this.readers.length; ++i) {
                if (!this.readers[i].isThisType(id)) continue;
                this.current = i;
                this.currentId = id;
                success = true;
                break;
            }
            if (!success) {
                throw new FormatException("Unknown file format: " + id);
            }
        }
        return this.readers[this.current];
    }

    public IFormatReader getReader() {
        return this.readers[this.current];
    }

    public IFormatReader getReader(Class c) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].getClass().equals(c)) continue;
            return this.readers[i];
        }
        return null;
    }

    public IFormatReader[] getReaders() {
        IFormatReader[] r = new IFormatReader[this.readers.length];
        System.arraycopy(this.readers, 0, r, 0, this.readers.length);
        return r;
    }

    public boolean isThisType(byte[] block) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(block)) continue;
            return true;
        }
        return false;
    }

    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getImageCount();
    }

    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isRGB();
    }

    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeX();
    }

    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeY();
    }

    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeC();
    }

    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeZ();
    }

    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSizeT();
    }

    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getPixelType();
    }

    public int getEffectiveSizeC() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getEffectiveSizeC();
    }

    public int getRGBChannelCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getRGBChannelCount();
    }

    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isIndexed();
    }

    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isFalseColor();
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().get16BitLookupTable();
    }

    public int[] getChannelDimLengths() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getChannelDimLengths();
    }

    public String[] getChannelDimTypes() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getChannelDimTypes();
    }

    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getThumbSizeX();
    }

    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getThumbSizeY();
    }

    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isLittleEndian();
    }

    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getDimensionOrder();
    }

    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isOrderCertain();
    }

    public boolean isInterleaved() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isInterleaved();
    }

    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isInterleaved(subC);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openImage(no);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openBytes(no);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openBytes(no, buf);
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openThumbImage(no);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().openThumbBytes(no);
    }

    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getSeriesCount();
    }

    public void setSeries(int no) {
        FormatTools.assertId(this.currentId, true, 2);
        this.getReader().setSeries(no);
    }

    public int getSeries() {
        return this.getReader().getSeries();
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getUsedFiles();
    }

    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getIndex(z, c, t);
    }

    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getZCTCoords(index);
    }

    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadataValue(field);
    }

    public Hashtable getMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadata();
    }

    public CoreMetadata getCoreMetadata() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getCoreMetadata();
    }

    public void close(boolean fileOnly) throws IOException {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].close(fileOnly);
        }
    }

    public void setGroupFiles(boolean group) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setGroupFiles(group);
        }
    }

    public boolean isGroupFiles() {
        return this.getReader().isGroupFiles();
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return this.getReader(id).fileGroupOption(id);
    }

    public boolean isMetadataComplete() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().isMetadataComplete();
    }

    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setNormalized(normalize);
        }
    }

    public boolean isNormalized() {
        return this.readers[0].isNormalized();
    }

    public void setMetadataCollected(boolean collect) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataCollected(collect);
        }
    }

    public boolean isMetadataCollected() {
        return this.readers[0].isMetadataCollected();
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setOriginalMetadataPopulated(populate);
        }
    }

    public boolean isOriginalMetadataPopulated() {
        return this.readers[0].isOriginalMetadataPopulated();
    }

    public String getCurrentFile() {
        return this.getReader().getCurrentFile();
    }

    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataFiltered(filter);
        }
    }

    public boolean isMetadataFiltered() {
        return this.readers[0].isMetadataFiltered();
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 2);
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].setMetadataStore(store);
        }
    }

    public MetadataStore getMetadataStore() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadataStore();
    }

    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 2);
        return this.getReader().getMetadataStoreRoot();
    }

    public boolean isThisType(String name) {
        return this.isThisType(name, false);
    }

    public boolean isThisType(String name, boolean open) {
        for (int i = 0; i < this.readers.length; ++i) {
            if (!this.readers[i].isThisType(name, open)) continue;
            return true;
        }
        return false;
    }

    public String getFormat() {
        return this.getReader().getFormat();
    }

    public String[] getSuffixes() {
        if (this.suffixes == null) {
            HashSet<String> suffixSet = new HashSet<String>();
            for (int i = 0; i < this.readers.length; ++i) {
                String[] suf = this.readers[i].getSuffixes();
                for (int j = 0; j < suf.length; ++j) {
                    suffixSet.add(suf[j]);
                }
            }
            this.suffixes = new String[suffixSet.size()];
            suffixSet.toArray(this.suffixes);
            Arrays.sort(this.suffixes);
        }
        return this.suffixes;
    }

    public void setId(String id) throws FormatException, IOException {
        this.getReader(id).setId(id);
    }

    public void setId(String id, boolean force) throws FormatException, IOException {
        this.getReader(id).setId(id, force);
    }

    public void close() throws IOException {
        this.currentId = null;
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].close();
        }
    }

    public void addStatusListener(StatusListener l) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].addStatusListener(l);
        }
    }

    public void removeStatusListener(StatusListener l) {
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i].removeStatusListener(l);
        }
    }

    public StatusListener[] getStatusListeners() {
        return this.readers[0].getStatusListeners();
    }

    public int getImageCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getImageCount();
    }

    public boolean isRGB(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().isRGB();
    }

    public int getSizeX(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSizeX();
    }

    public int getSizeY(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSizeY();
    }

    public int getSizeZ(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSizeZ();
    }

    public int getSizeC(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSizeC();
    }

    public int getSizeT(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSizeT();
    }

    public int getPixelType(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getPixelType();
    }

    public int getEffectiveSizeC(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getEffectiveSizeC();
    }

    public int getRGBChannelCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getRGBChannelCount();
    }

    public int[] getChannelDimLengths(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getChannelDimLengths();
    }

    public String[] getChannelDimTypes(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getChannelDimTypes();
    }

    public int getThumbSizeX(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getThumbSizeX();
    }

    public int getThumbSizeY(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getThumbSizeY();
    }

    public boolean isLittleEndian(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().isLittleEndian();
    }

    public String getDimensionOrder(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getDimensionOrder();
    }

    public boolean isOrderCertain(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().isOrderCertain();
    }

    public boolean isInterleaved(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().isInterleaved();
    }

    public boolean isInterleaved(String id, int subC) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().isInterleaved(subC);
    }

    public BufferedImage openImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().openImage(no);
    }

    public byte[] openBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().openBytes(no);
    }

    public byte[] openBytes(String id, int no, byte[] buf) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().openBytes(no, buf);
    }

    public BufferedImage openThumbImage(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().openThumbImage(no);
    }

    public byte[] openThumbBytes(String id, int no) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().openThumbBytes(no);
    }

    public int getSeriesCount(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSeriesCount();
    }

    public void setSeries(String id, int no) throws FormatException, IOException {
        this.setId(id);
        this.getReader().setSeries(no);
    }

    public int getSeries(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getSeries();
    }

    public String[] getUsedFiles(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getUsedFiles();
    }

    public int getIndex(String id, int z, int c, int t) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getIndex(z, c, t);
    }

    public int[] getZCTCoords(String id, int index) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getZCTCoords(index);
    }

    public Object getMetadataValue(String id, String field) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getMetadataValue(field);
    }

    public Hashtable getMetadata(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getMetadata();
    }

    public CoreMetadata getCoreMetadata(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getCoreMetadata();
    }

    public MetadataStore getMetadataStore(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getMetadataStore();
    }

    public Object getMetadataStoreRoot(String id) throws FormatException, IOException {
        this.setId(id);
        return this.getReader().getMetadataStoreRoot();
    }
}

