/*
 * $Id: network_cable.c,v 1.7 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue.h"
#include "random100.h"
#include "sig_integer.h"

#include "network_cable.h"

#define COMP_(x) network_cable_ ## x

struct cpssp {
	unsigned int packet_loss;

	struct sig_eth *port_end0;
	struct sig_eth *port_end1;
};

static void
COMP_(packet_loss_set)(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->packet_loss = val;
}

static void
COMP_(connect)(void *_cpssp, const char *port, void *_sig)
{
	static const struct sig_integer_funcs packet_loss_funcs = {
		.set = COMP_(packet_loss_set),
	};
	struct cpssp *cpssp = (struct cpssp *) _cpssp;
	struct sig_integer *sig = (struct sig_integer *) _sig;

	if (strcmp(port, "packet_loss") == 0) {
		sig_integer_connect_in(sig, cpssp, &packet_loss_funcs);
	} else {
		assert(0); /* FIXME */
	}
}

static void
COMP_(disconnect)(void *_cpssp, const char *port)
{
	// struct cpssp *cpssp = (struct cpssp *) _cpssp;

	/* FIXME */
	if (strcmp(port, "packet_loss") == 0) {
		// sig_integer_disconnect_in(sig, cpssp);
	} else {
		assert(0); /* FIXME */
	}
}

static void
COMP_(recv0)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (random100() < cpssp->packet_loss) {
		/* Packet lost due to fault injection. */
		return;
	}

	sig_eth_send(cpssp->port_end1, cpssp, buf, buflen);
}

static void
COMP_(recv1)(void *_cpssp, const void *buf, unsigned int buflen)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (random100() < cpssp->packet_loss) {
		/* Packet lost due to fault injection. */
		return;
	}

	sig_eth_send(cpssp->port_end0, cpssp, buf, buflen);
}

void *
COMP_(create)(
	const char *name,
	struct sig_manage *manage,
	struct sig_eth *port_end0,
	struct sig_eth *port_end1
)
{
	static const struct sig_manage_funcs manage_funcs = {
		.connect = COMP_(connect),
		.disconnect = COMP_(disconnect),
	};
	static const struct sig_eth_funcs end0_funcs = {
		.recv = COMP_(recv0),
	};
	static const struct sig_eth_funcs end1_funcs = {
		.recv = COMP_(recv1),
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->packet_loss = 0;

	/* Call */
	sig_manage_connect(manage, cpssp, &manage_funcs);

	cpssp->port_end0 = port_end0;
	sig_eth_connect(port_end0, cpssp, &end0_funcs);

	cpssp->port_end1 = port_end1;
	sig_eth_connect(port_end1, cpssp, &end1_funcs);

	/* Out */
	/* In */
	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
