/*
 * $Id: media_gen_image.c,v 1.7 2012-02-22 09:27:20 siflkres Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DEBUG	0

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"
#include "glue-png.h"

#include "media_gen_image.h"

#define COMP_(x) media_gen_image_ ## x

struct cpssp {
	struct sig_opt_rgb *port_connect;

	unsigned int width;
	unsigned int height;
	struct {
		uint8_t r, g, b;
	} pixel[1080][1920];
};

static void
COMP_(send)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int x;
	unsigned int y;

#if DEBUG
	fprintf(stderr, "%s: Sending...\n", __FUNCTION__);
#endif

	sig_opt_rgb_size_set(cpssp->port_connect, cpssp,
			cpssp->width, cpssp->height);
	for (y = 0; y < cpssp->height; y++) {
		for (x = 0; x < cpssp->width; x++) {
			sig_opt_rgb_pixel_set(cpssp->port_connect, cpssp, x, y,
					cpssp->pixel[y][x].r,
					cpssp->pixel[y][x].g,
					cpssp->pixel[y][x].b);
		}
	}
	sig_opt_rgb_sync(cpssp->port_connect, cpssp);

	time_call_after(TIME_HZ / 10, COMP_(send), cpssp);
}

void *
COMP_(create)(
	const char *name,
	const char *image,
	struct sig_manage *manage,
	struct sig_opt_rgb *port_connect
)
{
	struct cpssp *cpssp;
	uint32_t *img;
	uint32_t *ptr;
	unsigned int x;
	unsigned int y;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	if (! image) image = "unknown";

	if (! png_read(&img, &cpssp->width, &cpssp->height, image)) {
		fprintf(stderr, "ERROR: %s: Can't find %s.\n",
				__FUNCTION__, image);

		cpssp->width = 10;
		cpssp->height = 10;
		for (y = 0; y < cpssp->height; y++) {
			for (x = 0; x < cpssp->width; x++) {
				cpssp->pixel[y][x].r = 0;
				cpssp->pixel[y][x].g = 0;
				cpssp->pixel[y][x].b = 0;
			}
		}

	} else {
		fprintf(stderr, "Read %u x %u image...\n",
				cpssp->width, cpssp->height);

		ptr = img;
		for (y = 0; y < cpssp->height; y++) {
			for (x = 0; x < cpssp->width; x++) {
				cpssp->pixel[y][x].r = GET_RED(*ptr);
				cpssp->pixel[y][x].g = GET_GREEN(*ptr);
				cpssp->pixel[y][x].b = GET_BLUE(*ptr);
				ptr++;
			}
		}

		(void) free(img);
	}

	/* Call */

	/* Out */
	cpssp->port_connect = port_connect;

	/* In */

	time_call_after(TIME_HZ / 10, COMP_(send), cpssp);

	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
