/* $Id: glue-gui-gtk-keyboard.c,v 1.8 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "glue-gui-gtk-keyboard.h"
#include "glue-gui-gtk-led.h"

typedef struct {
	GtkVBoxClass parent_class;

	void (*type) (GuiGtkKeyboard *keyboard);
} GuiGtkKeyboardClass;

enum {
	KEYBOARD_TYPE,
	GUI_GTK_KEYBOARD_LAST_SIGNAL
};

static guint gui_gtk_keyboard_signals[GUI_GTK_KEYBOARD_LAST_SIGNAL] = { 0 };

static GuiGtkKeyboard *keyboard_current = NULL;

static void
gui_gtk_keyboard_class_init(GuiGtkKeyboardClass *class)
{
	gui_gtk_keyboard_signals[KEYBOARD_TYPE] =
		g_signal_new("keyboard-type",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkKeyboardClass, type),
			NULL, NULL,
			g_cclosure_marshal_VOID__INT, G_TYPE_NONE,
			1, G_TYPE_INT);
}

static void
gui_gtk_keyboard_type_do(GuiGtkKeyboard *keyboard, unsigned int nr, int pressed)
{
	int val;

	val = (nr << 16) | pressed;

	g_signal_emit(G_OBJECT(keyboard),
			gui_gtk_keyboard_signals[KEYBOARD_TYPE], 0, val);
}

static void
gui_gtk_keyboard_deselect(GuiGtkKeyboard *keyboard)
{
	if (! keyboard->active) {
		keyboard->active = 1;

		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(keyboard->select), 0);

		keyboard->active = 0;
	}
}

static void
gui_gtk_keyboard_select_toggled(GtkWidget *w, gpointer _keyboard)
{
	GuiGtkKeyboard *keyboard = (GuiGtkKeyboard *) _keyboard;

	if (! keyboard->active) {
		keyboard->active = 1;

		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))) {
			if (keyboard_current) {
				gui_gtk_keyboard_deselect(keyboard_current);
			}
			keyboard_current = keyboard;
		} else {
			keyboard_current = NULL;
		}

		keyboard->active = 0;
	}
}

static void
gui_gtk_keyboard_special_clicked(GtkWidget *w, gpointer _keyboard)
{
	GuiGtkKeyboard *keyboard = (GuiGtkKeyboard *) _keyboard;

	gtk_menu_popup(GTK_MENU(keyboard->special_menu),
			NULL, NULL, NULL, NULL, 0, GDK_CURRENT_TIME);
}

static void
gui_gtk_keyboard_special_send(gpointer _keyboard, unsigned int key)
{
	GuiGtkKeyboard *keyboard = (GuiGtkKeyboard *) _keyboard;

	assert(key < 128);

	gui_gtk_keyboard_type_do(keyboard, 0x1d, 1); /* Cntrl (Left) */
	gui_gtk_keyboard_type_do(keyboard, 0x38, 1); /* Alt (Left) */
	gui_gtk_keyboard_type_do(keyboard, key, 1);
	gui_gtk_keyboard_type_do(keyboard, key, 0);
	gui_gtk_keyboard_type_do(keyboard, 0x38, 0); /* Alt (Left) */
	gui_gtk_keyboard_type_do(keyboard, 0x1d, 0); /* Cntrl (Left) */
}

#define SEND(keyname, keyval) \
static void \
gui_gtk_keyboard_special_send_ ## keyname(GtkWidget *w, gpointer keyboard) \
{ \
	gui_gtk_keyboard_special_send(keyboard, keyval); \
}

SEND(f1, 0x3b) /* F1 */
SEND(f2, 0x3c) /* F2 */
SEND(f3, 0x3d) /* F3 */
SEND(f4, 0x3e) /* F4 */
SEND(f5, 0x3f) /* F5 */
SEND(f6, 0x40) /* F6 */
SEND(f7, 0x41) /* F7 */
SEND(f8, 0x42) /* F8 */
SEND(f9, 0x43) /* F9 */
SEND(f10, 0x44) /* F10 */
SEND(f11, 0x57) /* F11 */
SEND(f12, 0x58) /* F12 */
SEND(del, 0x6f) /* Delete */
SEND(esc, 0x01) /* Escape */
SEND(bspace, 0x0e) /* Backspace */

#undef SEND

#if defined(DARWIN)
static void
gui_gtk_keyboard_special_send_del_plain(GtkWidget *w, gpointer _keyboard)
{
	GuiGtkKeyboard *keyboard = (GuiGtkKeyboard *) _keyboard;

	gui_gtk_keyboard_type_do(keyboard, 0x6f, 1); /* Delete */
	gui_gtk_keyboard_type_do(keyboard, 0x6f, 0); /* Delete */
}
#endif

static void
gui_gtk_keyboard_init(GuiGtkKeyboard *keyboard)
{
	GtkWidget *keycode_f1;
	GtkWidget *keycode_f2;
	GtkWidget *keycode_f3;
	GtkWidget *keycode_f4;
	GtkWidget *keycode_f5;
	GtkWidget *keycode_f6;
	GtkWidget *keycode_f7;
	GtkWidget *keycode_f8;
	GtkWidget *keycode_f9;
	GtkWidget *keycode_f10;
	GtkWidget *keycode_f11;
	GtkWidget *keycode_f12;
	GtkWidget *keycode_del;
	GtkWidget *keycode_esc;
	GtkWidget *keycode_bspace;
#if defined(DARWIN)
	GtkWidget *keycode_del_plain;
#endif
	GtkWidget *hbox;
	
	hbox = gtk_hbox_new(FALSE, 1);

	keyboard->num_led = gui_gtk_led_new("NUM");
	gtk_widget_show(keyboard->num_led);
	gtk_box_pack_start(GTK_BOX(hbox), keyboard->num_led,
			FALSE, FALSE, 1);

	keyboard->caps_led = gui_gtk_led_new("CAPS");
	gtk_widget_show(keyboard->caps_led);
	gtk_box_pack_start(GTK_BOX(hbox), keyboard->caps_led,
			FALSE, FALSE, 1);

	keyboard->scroll_led = gui_gtk_led_new("SCRL");
	gtk_widget_show(keyboard->scroll_led);
	gtk_box_pack_start(GTK_BOX(hbox), keyboard->scroll_led,
			FALSE, FALSE, 1);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(keyboard), hbox, FALSE, FALSE, 1);

	hbox = gtk_hbox_new(FALSE, 1);

	keyboard->select = gtk_check_button_new_with_label("Selected");
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(keyboard->select), GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(keyboard->select), "toggled",
			G_CALLBACK(gui_gtk_keyboard_select_toggled), keyboard);

	gtk_widget_show(keyboard->select);
	gtk_box_pack_start(GTK_BOX(hbox), keyboard->select,
			FALSE, FALSE, 1);

	/* Last call will de-select all other keyboards. */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(keyboard->select), 1);

	/* Send Keycode Popup Button */
	keyboard->special = gtk_button_new_with_label("Send Keycode");
	GTK_WIDGET_UNSET_FLAGS(keyboard->special, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(keyboard->special), "clicked",
			G_CALLBACK(gui_gtk_keyboard_special_clicked),
			keyboard);

	gtk_widget_show(keyboard->special);
	gtk_box_pack_start(GTK_BOX(hbox), keyboard->special,
			FALSE, FALSE, 1);

	/* Send Keycode Popup Menu */
	keyboard->special_menu = gtk_menu_new();

	/* CTRL-ALT-F1 */
	keycode_f1 = gtk_menu_item_new_with_label("CTRL + ALT + F1");
	g_signal_connect((gpointer) keycode_f1, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f1), keyboard);
	gtk_widget_show(keycode_f1);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f1);

	/* CTRL-ALT-F2 */
	keycode_f2 = gtk_menu_item_new_with_label("CTRL + ALT + F2");
	g_signal_connect((gpointer) keycode_f2, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f2), keyboard);
	gtk_widget_show(keycode_f2);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f2);

	/* CTRL-ALT-F3 */
	keycode_f3 = gtk_menu_item_new_with_label("CTRL + ALT + F3");
	g_signal_connect((gpointer) keycode_f3, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f3), keyboard);
	gtk_widget_show(keycode_f3);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f3);

	/* CTRL-ALT-F4 */
	keycode_f4 = gtk_menu_item_new_with_label("CTRL + ALT + F4");
	g_signal_connect((gpointer) keycode_f4, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f4), keyboard);
	gtk_widget_show(keycode_f4);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f4);

	/* CTRL-ALT-F5 */
	keycode_f5 = gtk_menu_item_new_with_label("CTRL + ALT + F5");
	g_signal_connect((gpointer) keycode_f5, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f5), keyboard);
	gtk_widget_show(keycode_f5);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f5);

	/* CTRL-ALT-F6 */
	keycode_f6 = gtk_menu_item_new_with_label("CTRL + ALT + F6");
	g_signal_connect((gpointer) keycode_f6, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f6), keyboard);
	gtk_widget_show(keycode_f6);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f6);

	/* CTRL-ALT-F7 */
	keycode_f7 = gtk_menu_item_new_with_label("CTRL + ALT + F7");
	g_signal_connect((gpointer) keycode_f7, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f7), keyboard);
	gtk_widget_show(keycode_f7);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f7);

	/* CTRL-ALT-F8 */
	keycode_f8 = gtk_menu_item_new_with_label("CTRL + ALT + F8");
	g_signal_connect((gpointer) keycode_f8, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f8), keyboard);
	gtk_widget_show(keycode_f8);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f8);

	/* CTRL-ALT-F9 */
	keycode_f9 = gtk_menu_item_new_with_label("CTRL + ALT + F9");
	g_signal_connect((gpointer) keycode_f9, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f9), keyboard);
	gtk_widget_show(keycode_f9);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f9);

	/* CTRL-ALT-F10 */
	keycode_f10 = gtk_menu_item_new_with_label("CTRL + ALT + F10");
	g_signal_connect((gpointer) keycode_f10, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f10), keyboard);
	gtk_widget_show(keycode_f10);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f10);

	/* CTRL-ALT-F11 */
	keycode_f11 = gtk_menu_item_new_with_label("CTRL + ALT + F11");
	g_signal_connect((gpointer) keycode_f11, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f11), keyboard);
	gtk_widget_show(keycode_f11);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f11);

	/* CTRL-ALT-F12 */
	keycode_f12 = gtk_menu_item_new_with_label("CTRL + ALT + F12");
	g_signal_connect((gpointer) keycode_f12, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_f12), keyboard);
	gtk_widget_show(keycode_f12);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_f12);

	/* CTRL-ALT-DEL */
	keycode_del = gtk_menu_item_new_with_label("CTRL + ALT + DEL");
	g_signal_connect((gpointer) keycode_del, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_del), keyboard);
	gtk_widget_show(keycode_del);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_del);

	/* CTRL-ALT-ESC */
	keycode_esc = gtk_menu_item_new_with_label("CTRL + ALT + ESC");
	g_signal_connect((gpointer) keycode_esc, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_esc), keyboard);
	gtk_widget_show(keycode_esc);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_esc);

	/* CTRL-ALT-BACKSPACE */
	keycode_bspace = gtk_menu_item_new_with_label("CTRL + ALT + BACKSPACE");
	g_signal_connect((gpointer) keycode_bspace, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_bspace), keyboard);
	gtk_widget_show(keycode_bspace);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_bspace);

#if defined(DARWIN)
	/* DELETE */
	keycode_del_plain = gtk_menu_item_new_with_label("DEL");
	g_signal_connect((gpointer) keycode_del_plain, "activate",
			G_CALLBACK(gui_gtk_keyboard_special_send_del_plain), keyboard);
	gtk_widget_show(keycode_del_plain);
	gtk_container_add(GTK_CONTAINER(keyboard->special_menu), keycode_del_plain)
;
#endif

	gtk_widget_show(hbox);
	gtk_box_pack_end(GTK_BOX(keyboard), hbox, FALSE, FALSE, 1);
}

GType
gui_gtk_keyboard_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkKeyboardClass),
			NULL,   /* base_init */
			NULL,   /* base_finalize */
			(GClassInitFunc) gui_gtk_keyboard_class_init,
			NULL,   /* class_finalize */
			NULL,   /* class_data */
			sizeof(GuiGtkKeyboard),
			0,      /* n_preallocs */
			(GInstanceInitFunc) gui_gtk_keyboard_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_VBOX,
				"Keyboard", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKKEYBOARD_TYPE       gui_gtk_keyboard_get_type()

GtkWidget *
gui_gtk_keyboard_new(void)
{
	GuiGtkKeyboard *keyboard;

	keyboard = GUI_GTK_KEYBOARD(g_object_new(GUIGTKKEYBOARD_TYPE, NULL));

	return GTK_WIDGET(keyboard);
}

void
gui_gtk_keyboard_type(unsigned int nr, int pressed)
{
	if (keyboard_current) {
		gui_gtk_keyboard_type_do(keyboard_current, nr, pressed);
	}
}

void
gui_gtk_keyboard_num_led_set(GuiGtkKeyboard *keyboard, unsigned int on)
{
	assert(keyboard->num_led);

	gui_gtk_led_set(GUI_GTK_LED(keyboard->num_led), on);
}

void
gui_gtk_keyboard_caps_led_set(GuiGtkKeyboard *keyboard, unsigned int on)
{
	assert(keyboard->caps_led);

	gui_gtk_led_set(GUI_GTK_LED(keyboard->caps_led), on);
}

void
gui_gtk_keyboard_scroll_led_set(GuiGtkKeyboard *keyboard, unsigned int on)
{
	assert(keyboard->scroll_led);

	gui_gtk_led_set(GUI_GTK_LED(keyboard->scroll_led), on);
}
