/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner.util;

import gnu.bioinformatics.jaligner.util.AlphanumericCompartor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Matrices
extends HashMap {
    private static Matrices instance;
    private static final char COMMENT_STARTER = '#';
    private static final int SIZE = 127;
    private static final String MATRICES_HOME = "gnu/bioinformatics/jaligner/matrices/";
    static /* synthetic */ Class class$0;

    private Matrices() {
    }

    public static Matrices getInstance() {
        if (instance == null) {
            instance = new Matrices();
        }
        return instance;
    }

    private void load(String matrix) throws FileNotFoundException, IOException {
        String line;
        InputStream is = null;
        is = new StringTokenizer(matrix, System.getProperty("file.separator")).countTokens() == 1 ? this.getClass().getClassLoader().getResourceAsStream(MATRICES_HOME + matrix) : new FileInputStream(matrix);
        char[] acids = new char[127];
        int i = 0;
        while (i < 127) {
            acids[i] = '\u0000';
            ++i;
        }
        float[][] scores = new float[127][127];
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null && line.trim().charAt(0) == '#') {
        }
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        int j = 0;
        while (tokenizer.hasMoreTokens()) {
            acids[j] = tokenizer.nextToken().charAt(0);
            ++j;
        }
        while ((line = reader.readLine()) != null) {
            tokenizer = new StringTokenizer(line.trim());
            char acid = tokenizer.nextToken().charAt(0);
            int i2 = 0;
            while (i2 < 127) {
                if (acids[i2] != '\u0000') {
                    scores[acid][acids[i2]] = Float.parseFloat(tokenizer.nextToken());
                }
                ++i2;
            }
        }
        this.put(matrix, scores);
    }

    public float[][] get(String matrix) throws FileNotFoundException, IOException {
        if (!this.containsKey(matrix)) {
            this.load(matrix);
        }
        return (float[][])this.get((Object)matrix);
    }

    public static float score(String matrix, char c1, char c2) throws FileNotFoundException, IOException {
        Matrices matrices = Matrices.getInstance();
        float[][] similarity = matrices.get(matrix);
        return similarity[c1][c2];
    }

    public static String[] list() throws IOException {
        URL url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gnu.bioinformatics.jaligner.util.Matrices");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((url = clazz.getClassLoader().getResource(MATRICES_HOME)).getFile().toString().indexOf("!") != -1) {
            JarURLConnection jarConn = (JarURLConnection)url.openConnection();
            JarFile jarfile = jarConn.getJarFile();
            Enumeration<JarEntry> list = jarfile.entries();
            ArrayList<String> array = new ArrayList<String>();
            int n = MATRICES_HOME.length();
            while (list.hasMoreElements()) {
                String name;
                JarEntry entry = list.nextElement();
                if (entry.isDirectory() || !(name = entry.getName()).startsWith(MATRICES_HOME)) continue;
                array.add(name.substring(n));
            }
            String[] entries = new String[array.size()];
            int i = 0;
            while (i < entries.length) {
                entries[i] = (String)array.get(i);
                ++i;
            }
            Arrays.sort(entries, new AlphanumericCompartor());
            return entries;
        }
        File file = new File(url.getFile());
        String[] files = file.list();
        Arrays.sort(files, new AlphanumericCompartor());
        return files;
    }
}

