// A Bison parser, made by GNU Bison 3.7.5.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


/**
 ** \file Parser.hh
 ** Define the Tokenizer::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

#ifndef YY_YY_PARSER_HH_INCLUDED
# define YY_YY_PARSER_HH_INCLUDED
// "%code requires" blocks.
#line 30 "Parser.yy"

namespace macro { class Driver; }
#line 43 "Parser.yy"

#include "Directives.hh"
using namespace macro;

#line 57 "Parser.hh"

# include <cassert>
# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>

#if defined __cplusplus
# define YY_CPLUSPLUS __cplusplus
#else
# define YY_CPLUSPLUS 199711L
#endif

// Support move semantics when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_MOVE           std::move
# define YY_MOVE_OR_COPY   move
# define YY_MOVE_REF(Type) Type&&
# define YY_RVREF(Type)    Type&&
# define YY_COPY(Type)     Type
#else
# define YY_MOVE
# define YY_MOVE_OR_COPY   copy
# define YY_MOVE_REF(Type) Type&
# define YY_RVREF(Type)    const Type&
# define YY_COPY(Type)     const Type&
#endif

// Support noexcept when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_NOEXCEPT noexcept
# define YY_NOTHROW
#else
# define YY_NOEXCEPT
# define YY_NOTHROW throw ()
#endif

// Support constexpr when possible.
#if 201703 <= YY_CPLUSPLUS
# define YY_CONSTEXPR constexpr
#else
# define YY_CONSTEXPR
#endif
# include "location.hh"
#include <typeinfo>
#ifndef YY_ASSERT
# include <cassert>
# define YY_ASSERT assert
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

#line 25 "Parser.yy"
namespace Tokenizer {
#line 192 "Parser.hh"




  /// A Bison parser.
  class parser
  {
  public:
#ifndef YYSTYPE
  /// A buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current parser state.
  class semantic_type
  {
  public:
    /// Type of *this.
    typedef semantic_type self_type;

    /// Empty construction.
    semantic_type () YY_NOEXCEPT
      : yybuffer_ ()
      , yytypeid_ (YY_NULLPTR)
    {}

    /// Construct and fill.
    template <typename T>
    semantic_type (YY_RVREF (T) t)
      : yytypeid_ (&typeid (T))
    {
      YY_ASSERT (sizeof (T) <= size);
      new (yyas_<T> ()) T (YY_MOVE (t));
    }

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    semantic_type (const self_type&) = delete;
    /// Non copyable.
    self_type& operator= (const self_type&) = delete;
#endif

    /// Destruction, allowed only if empty.
    ~semantic_type () YY_NOEXCEPT
    {
      YY_ASSERT (!yytypeid_);
    }

# if 201103L <= YY_CPLUSPLUS
    /// Instantiate a \a T in here from \a t.
    template <typename T, typename... U>
    T&
    emplace (U&&... u)
    {
      YY_ASSERT (!yytypeid_);
      YY_ASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (std::forward <U>(u)...);
    }
# else
    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    emplace ()
    {
      YY_ASSERT (!yytypeid_);
      YY_ASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T ();
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    emplace (const T& t)
    {
      YY_ASSERT (!yytypeid_);
      YY_ASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (t);
    }
# endif

    /// Instantiate an empty \a T in here.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build ()
    {
      return emplace<T> ();
    }

    /// Instantiate a \a T in here from \a t.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build (const T& t)
    {
      return emplace<T> (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as () YY_NOEXCEPT
    {
      YY_ASSERT (yytypeid_);
      YY_ASSERT (*yytypeid_ == typeid (T));
      YY_ASSERT (sizeof (T) <= size);
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const YY_NOEXCEPT
    {
      YY_ASSERT (yytypeid_);
      YY_ASSERT (*yytypeid_ == typeid (T));
      YY_ASSERT (sizeof (T) <= size);
      return *yyas_<T> ();
    }

    /// Swap the content with \a that, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsibility.
    /// Swapping between built and (possibly) non-built is done with
    /// self_type::move ().
    template <typename T>
    void
    swap (self_type& that) YY_NOEXCEPT
    {
      YY_ASSERT (yytypeid_);
      YY_ASSERT (*yytypeid_ == *that.yytypeid_);
      std::swap (as<T> (), that.as<T> ());
    }

    /// Move the content of \a that to this.
    ///
    /// Destroys \a that.
    template <typename T>
    void
    move (self_type& that)
    {
# if 201103L <= YY_CPLUSPLUS
      emplace<T> (std::move (that.as<T> ()));
# else
      emplace<T> ();
      swap<T> (that);
# endif
      that.destroy<T> ();
    }

# if 201103L <= YY_CPLUSPLUS
    /// Move the content of \a that to this.
    template <typename T>
    void
    move (self_type&& that)
    {
      emplace<T> (std::move (that.as<T> ()));
      that.destroy<T> ();
    }
#endif

    /// Copy the content of \a that to this.
    template <typename T>
    void
    copy (const self_type& that)
    {
      emplace<T> (that.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
      yytypeid_ = YY_NULLPTR;
    }

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    semantic_type (const self_type&);
    /// Non copyable.
    self_type& operator= (const self_type&);
#endif

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ () YY_NOEXCEPT
    {
      void *yyp = yybuffer_.yyraw;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const YY_NOEXCEPT
    {
      const void *yyp = yybuffer_.yyraw;
      return static_cast<const T*> (yyp);
     }

    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // statement
      // directive
      // directive_one_line
      // directive_multiline
      // for
      // if
      // ifdef
      // ifndef
      // text
      // eval
      char dummy1[sizeof (DirectivePtr)];

      // for_when
      // primary_expr
      // oper_expr
      // colon_expr
      // expr
      char dummy2[sizeof (ExpressionPtr)];

      // function
      char dummy3[sizeof (FunctionPtr)];

      // symbol
      char dummy4[sizeof (VariablePtr)];

      // elseif
      // else
      char dummy5[sizeof (pair<ExpressionPtr, vector<DirectivePtr>>)];

      // NAME
      // TEXT
      // QUOTED_STRING
      // NUMBER
      char dummy6[sizeof (string)];

      // function_args
      // comma_expr
      // tuple_comma_expr
      char dummy7[sizeof (vector<ExpressionPtr>)];

      // if_list
      // if_list1
      char dummy8[sizeof (vector<pair<ExpressionPtr, vector<DirectivePtr>>>)];

      // name_list
      char dummy9[sizeof (vector<string>)];
    };

    /// The size of the largest semantic type.
    enum { size = sizeof (union_type) };

    /// A buffer to store semantic values.
    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me;
      /// A buffer large enough to store any of the semantic values.
      char yyraw[size];
    } yybuffer_;

    /// Whether the content is built: if defined, the name of the stored type.
    const std::type_info *yytypeid_;
  };

#else
    typedef YYSTYPE semantic_type;
#endif
    /// Symbol locations.
    typedef location location_type;

    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const location_type& l, const std::string& m)
        : std::runtime_error (m)
        , location (l)
      {}

      syntax_error (const syntax_error& s)
        : std::runtime_error (s.what ())
        , location (s.location)
      {}

      ~syntax_error () YY_NOEXCEPT YY_NOTHROW;

      location_type location;
    };

    /// Token kinds.
    struct token
    {
      enum token_kind_type
      {
        YYEMPTY = -2,
    YYEOF = 0,                     // "end of file"
    YYerror = 256,                 // error
    YYUNDEF = 257,                 // "invalid token"
    FOR = 258,                     // FOR
    ENDFOR = 259,                  // ENDFOR
    IF = 260,                      // IF
    IFDEF = 261,                   // IFDEF
    IFNDEF = 262,                  // IFNDEF
    ELSEIF = 263,                  // ELSEIF
    ELSE = 264,                    // ELSE
    ENDIF = 265,                   // ENDIF
    TRUE = 266,                    // TRUE
    FALSE = 267,                   // FALSE
    INCLUDE = 268,                 // INCLUDE
    INCLUDEPATH = 269,             // INCLUDEPATH
    DEFINE = 270,                  // DEFINE
    EQUAL = 271,                   // EQUAL
    D_ECHO = 272,                  // D_ECHO
    ERROR = 273,                   // ERROR
    COMMA = 274,                   // COMMA
    LPAREN = 275,                  // LPAREN
    RPAREN = 276,                  // RPAREN
    LBRACKET = 277,                // LBRACKET
    RBRACKET = 278,                // RBRACKET
    WHEN = 279,                    // WHEN
    BEGIN_EVAL = 280,              // BEGIN_EVAL
    END_EVAL = 281,                // END_EVAL
    ECHOMACROVARS = 282,           // ECHOMACROVARS
    SAVE = 283,                    // SAVE
    LINE = 284,                    // LINE
    EXP = 285,                     // EXP
    LOG = 286,                     // LOG
    LN = 287,                      // LN
    LOG10 = 288,                   // LOG10
    SIN = 289,                     // SIN
    COS = 290,                     // COS
    TAN = 291,                     // TAN
    ASIN = 292,                    // ASIN
    ACOS = 293,                    // ACOS
    ATAN = 294,                    // ATAN
    SQRT = 295,                    // SQRT
    CBRT = 296,                    // CBRT
    SIGN = 297,                    // SIGN
    MAX = 298,                     // MAX
    MIN = 299,                     // MIN
    FLOOR = 300,                   // FLOOR
    CEIL = 301,                    // CEIL
    TRUNC = 302,                   // TRUNC
    SUM = 303,                     // SUM
    MOD = 304,                     // MOD
    ERF = 305,                     // ERF
    ERFC = 306,                    // ERFC
    GAMMA = 307,                   // GAMMA
    LGAMMA = 308,                  // LGAMMA
    ROUND = 309,                   // ROUND
    NORMPDF = 310,                 // NORMPDF
    NORMCDF = 311,                 // NORMCDF
    LENGTH = 312,                  // LENGTH
    ISEMPTY = 313,                 // ISEMPTY
    ISBOOLEAN = 314,               // ISBOOLEAN
    ISREAL = 315,                  // ISREAL
    ISSTRING = 316,                // ISSTRING
    ISTUPLE = 317,                 // ISTUPLE
    ISARRAY = 318,                 // ISARRAY
    BOOL = 319,                    // BOOL
    REAL = 320,                    // REAL
    STRING = 321,                  // STRING
    TUPLE = 322,                   // TUPLE
    ARRAY = 323,                   // ARRAY
    DEFINED = 324,                 // DEFINED
    OR = 325,                      // OR
    AND = 326,                     // AND
    EQUAL_EQUAL = 327,             // EQUAL_EQUAL
    NOT_EQUAL = 328,               // NOT_EQUAL
    LESS = 329,                    // LESS
    GREATER = 330,                 // GREATER
    LESS_EQUAL = 331,              // LESS_EQUAL
    GREATER_EQUAL = 332,           // GREATER_EQUAL
    IN = 333,                      // IN
    COLON = 334,                   // COLON
    UNION = 335,                   // UNION
    INTERSECTION = 336,            // INTERSECTION
    PLUS = 337,                    // PLUS
    MINUS = 338,                   // MINUS
    TIMES = 339,                   // TIMES
    DIVIDE = 340,                  // DIVIDE
    UNARY = 341,                   // UNARY
    NOT = 342,                     // NOT
    CAST = 343,                    // CAST
    POWER = 344,                   // POWER
    EOL = 345,                     // EOL
    NAME = 346,                    // NAME
    TEXT = 347,                    // TEXT
    QUOTED_STRING = 348,           // QUOTED_STRING
    NUMBER = 349                   // NUMBER
      };
      /// Backward compatibility alias (Bison 3.6).
      typedef token_kind_type yytokentype;
    };

    /// Token kind, as returned by yylex.
    typedef token::yytokentype token_kind_type;

    /// Backward compatibility alias (Bison 3.6).
    typedef token_kind_type token_type;

    /// Symbol kinds.
    struct symbol_kind
    {
      enum symbol_kind_type
      {
        YYNTOKENS = 95, ///< Number of tokens.
        S_YYEMPTY = -2,
        S_YYEOF = 0,                             // "end of file"
        S_YYerror = 1,                           // error
        S_YYUNDEF = 2,                           // "invalid token"
        S_FOR = 3,                               // FOR
        S_ENDFOR = 4,                            // ENDFOR
        S_IF = 5,                                // IF
        S_IFDEF = 6,                             // IFDEF
        S_IFNDEF = 7,                            // IFNDEF
        S_ELSEIF = 8,                            // ELSEIF
        S_ELSE = 9,                              // ELSE
        S_ENDIF = 10,                            // ENDIF
        S_TRUE = 11,                             // TRUE
        S_FALSE = 12,                            // FALSE
        S_INCLUDE = 13,                          // INCLUDE
        S_INCLUDEPATH = 14,                      // INCLUDEPATH
        S_DEFINE = 15,                           // DEFINE
        S_EQUAL = 16,                            // EQUAL
        S_D_ECHO = 17,                           // D_ECHO
        S_ERROR = 18,                            // ERROR
        S_COMMA = 19,                            // COMMA
        S_LPAREN = 20,                           // LPAREN
        S_RPAREN = 21,                           // RPAREN
        S_LBRACKET = 22,                         // LBRACKET
        S_RBRACKET = 23,                         // RBRACKET
        S_WHEN = 24,                             // WHEN
        S_BEGIN_EVAL = 25,                       // BEGIN_EVAL
        S_END_EVAL = 26,                         // END_EVAL
        S_ECHOMACROVARS = 27,                    // ECHOMACROVARS
        S_SAVE = 28,                             // SAVE
        S_LINE = 29,                             // LINE
        S_EXP = 30,                              // EXP
        S_LOG = 31,                              // LOG
        S_LN = 32,                               // LN
        S_LOG10 = 33,                            // LOG10
        S_SIN = 34,                              // SIN
        S_COS = 35,                              // COS
        S_TAN = 36,                              // TAN
        S_ASIN = 37,                             // ASIN
        S_ACOS = 38,                             // ACOS
        S_ATAN = 39,                             // ATAN
        S_SQRT = 40,                             // SQRT
        S_CBRT = 41,                             // CBRT
        S_SIGN = 42,                             // SIGN
        S_MAX = 43,                              // MAX
        S_MIN = 44,                              // MIN
        S_FLOOR = 45,                            // FLOOR
        S_CEIL = 46,                             // CEIL
        S_TRUNC = 47,                            // TRUNC
        S_SUM = 48,                              // SUM
        S_MOD = 49,                              // MOD
        S_ERF = 50,                              // ERF
        S_ERFC = 51,                             // ERFC
        S_GAMMA = 52,                            // GAMMA
        S_LGAMMA = 53,                           // LGAMMA
        S_ROUND = 54,                            // ROUND
        S_NORMPDF = 55,                          // NORMPDF
        S_NORMCDF = 56,                          // NORMCDF
        S_LENGTH = 57,                           // LENGTH
        S_ISEMPTY = 58,                          // ISEMPTY
        S_ISBOOLEAN = 59,                        // ISBOOLEAN
        S_ISREAL = 60,                           // ISREAL
        S_ISSTRING = 61,                         // ISSTRING
        S_ISTUPLE = 62,                          // ISTUPLE
        S_ISARRAY = 63,                          // ISARRAY
        S_BOOL = 64,                             // BOOL
        S_REAL = 65,                             // REAL
        S_STRING = 66,                           // STRING
        S_TUPLE = 67,                            // TUPLE
        S_ARRAY = 68,                            // ARRAY
        S_DEFINED = 69,                          // DEFINED
        S_OR = 70,                               // OR
        S_AND = 71,                              // AND
        S_EQUAL_EQUAL = 72,                      // EQUAL_EQUAL
        S_NOT_EQUAL = 73,                        // NOT_EQUAL
        S_LESS = 74,                             // LESS
        S_GREATER = 75,                          // GREATER
        S_LESS_EQUAL = 76,                       // LESS_EQUAL
        S_GREATER_EQUAL = 77,                    // GREATER_EQUAL
        S_IN = 78,                               // IN
        S_COLON = 79,                            // COLON
        S_UNION = 80,                            // UNION
        S_INTERSECTION = 81,                     // INTERSECTION
        S_PLUS = 82,                             // PLUS
        S_MINUS = 83,                            // MINUS
        S_TIMES = 84,                            // TIMES
        S_DIVIDE = 85,                           // DIVIDE
        S_UNARY = 86,                            // UNARY
        S_NOT = 87,                              // NOT
        S_CAST = 88,                             // CAST
        S_POWER = 89,                            // POWER
        S_EOL = 90,                              // EOL
        S_NAME = 91,                             // NAME
        S_TEXT = 92,                             // TEXT
        S_QUOTED_STRING = 93,                    // QUOTED_STRING
        S_NUMBER = 94,                           // NUMBER
        S_YYACCEPT = 95,                         // $accept
        S_statements = 96,                       // statements
        S_statement = 97,                        // statement
        S_directive = 98,                        // directive
        S_directive_one_line = 99,               // directive_one_line
        S_name_list = 100,                       // name_list
        S_directive_multiline = 101,             // directive_multiline
        S_for_when = 102,                        // for_when
        S_for = 103,                             // for
        S_104_1 = 104,                           // $@1
        S_if = 105,                              // if
        S_106_2 = 106,                           // $@2
        S_ifdef = 107,                           // ifdef
        S_108_3 = 108,                           // $@3
        S_ifndef = 109,                          // ifndef
        S_110_4 = 110,                           // $@4
        S_if_list = 111,                         // if_list
        S_if_list1 = 112,                        // if_list1
        S_elseif_begin = 113,                    // elseif_begin
        S_elseif = 114,                          // elseif
        S_else_begin = 115,                      // else_begin
        S_else = 116,                            // else
        S_text = 117,                            // text
        S_eval = 118,                            // eval
        S_symbol = 119,                          // symbol
        S_function = 120,                        // function
        S_function_args = 121,                   // function_args
        S_comma_expr = 122,                      // comma_expr
        S_tuple_comma_expr = 123,                // tuple_comma_expr
        S_primary_expr = 124,                    // primary_expr
        S_oper_expr = 125,                       // oper_expr
        S_colon_expr = 126,                      // colon_expr
        S_expr = 127                             // expr
      };
    };

    /// (Internal) symbol kind.
    typedef symbol_kind::symbol_kind_type symbol_kind_type;

    /// The number of tokens.
    static const symbol_kind_type YYNTOKENS = symbol_kind::YYNTOKENS;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol kind
    /// via kind ().
    ///
    /// Provide access to semantic value and location.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol ()
        : value ()
        , location ()
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      basic_symbol (basic_symbol&& that)
        : Base (std::move (that))
        , value ()
        , location (std::move (that.location))
      {
        switch (this->kind ())
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.move< DirectivePtr > (std::move (that.value));
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.move< ExpressionPtr > (std::move (that.value));
        break;

      case symbol_kind::S_function: // function
        value.move< FunctionPtr > (std::move (that.value));
        break;

      case symbol_kind::S_symbol: // symbol
        value.move< VariablePtr > (std::move (that.value));
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.move< pair<ExpressionPtr, vector<DirectivePtr>> > (std::move (that.value));
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.move< string > (std::move (that.value));
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.move< vector<ExpressionPtr> > (std::move (that.value));
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.move< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > (std::move (that.value));
        break;

      case symbol_kind::S_name_list: // name_list
        value.move< vector<string> > (std::move (that.value));
        break;

      default:
        break;
    }

      }
#endif

      /// Copy constructor.
      basic_symbol (const basic_symbol& that);

      /// Constructors for typed symbols.
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, location_type&& l)
        : Base (t)
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const location_type& l)
        : Base (t)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, DirectivePtr&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const DirectivePtr& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, ExpressionPtr&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const ExpressionPtr& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, FunctionPtr&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const FunctionPtr& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, VariablePtr&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const VariablePtr& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, pair<ExpressionPtr, vector<DirectivePtr>>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const pair<ExpressionPtr, vector<DirectivePtr>>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, string&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const string& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<ExpressionPtr>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<ExpressionPtr>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<pair<ExpressionPtr, vector<DirectivePtr>>>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<pair<ExpressionPtr, vector<DirectivePtr>>>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

      /// Destroy the symbol.
      ~basic_symbol ()
      {
        clear ();
      }

      /// Destroy contents, and record that is empty.
      void clear () YY_NOEXCEPT
      {
        // User destructor.
        symbol_kind_type yykind = this->kind ();
        basic_symbol<Base>& yysym = *this;
        (void) yysym;
        switch (yykind)
        {
       default:
          break;
        }

        // Value type destructor.
switch (yykind)
    {
      case symbol_kind::S_statement: // statement
      case symbol_kind::S_directive: // directive
      case symbol_kind::S_directive_one_line: // directive_one_line
      case symbol_kind::S_directive_multiline: // directive_multiline
      case symbol_kind::S_for: // for
      case symbol_kind::S_if: // if
      case symbol_kind::S_ifdef: // ifdef
      case symbol_kind::S_ifndef: // ifndef
      case symbol_kind::S_text: // text
      case symbol_kind::S_eval: // eval
        value.template destroy< DirectivePtr > ();
        break;

      case symbol_kind::S_for_when: // for_when
      case symbol_kind::S_primary_expr: // primary_expr
      case symbol_kind::S_oper_expr: // oper_expr
      case symbol_kind::S_colon_expr: // colon_expr
      case symbol_kind::S_expr: // expr
        value.template destroy< ExpressionPtr > ();
        break;

      case symbol_kind::S_function: // function
        value.template destroy< FunctionPtr > ();
        break;

      case symbol_kind::S_symbol: // symbol
        value.template destroy< VariablePtr > ();
        break;

      case symbol_kind::S_elseif: // elseif
      case symbol_kind::S_else: // else
        value.template destroy< pair<ExpressionPtr, vector<DirectivePtr>> > ();
        break;

      case symbol_kind::S_NAME: // NAME
      case symbol_kind::S_TEXT: // TEXT
      case symbol_kind::S_QUOTED_STRING: // QUOTED_STRING
      case symbol_kind::S_NUMBER: // NUMBER
        value.template destroy< string > ();
        break;

      case symbol_kind::S_function_args: // function_args
      case symbol_kind::S_comma_expr: // comma_expr
      case symbol_kind::S_tuple_comma_expr: // tuple_comma_expr
        value.template destroy< vector<ExpressionPtr> > ();
        break;

      case symbol_kind::S_if_list: // if_list
      case symbol_kind::S_if_list1: // if_list1
        value.template destroy< vector<pair<ExpressionPtr, vector<DirectivePtr>>> > ();
        break;

      case symbol_kind::S_name_list: // name_list
        value.template destroy< vector<string> > ();
        break;

      default:
        break;
    }

        Base::clear ();
      }

      /// The user-facing name of this symbol.
      std::string name () const YY_NOEXCEPT
      {
        return parser::symbol_name (this->kind ());
      }

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// Whether empty.
      bool empty () const YY_NOEXCEPT;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      semantic_type value;

      /// The location.
      location_type location;

    private:
#if YY_CPLUSPLUS < 201103L
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& that);
#endif
    };

    /// Type access provider for token (enum) based symbols.
    struct by_kind
    {
      /// Default constructor.
      by_kind ();

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      by_kind (by_kind&& that);
#endif

      /// Copy constructor.
      by_kind (const by_kind& that);

      /// The symbol kind as needed by the constructor.
      typedef token_kind_type kind_type;

      /// Constructor from (external) token numbers.
      by_kind (kind_type t);

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_kind& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// The symbol kind.
      /// \a S_YYEMPTY when empty.
      symbol_kind_type kind_;
    };

    /// Backward compatibility for a private implementation detail (Bison 3.6).
    typedef by_kind by_type;

    /// "External" symbols: returned by the scanner.
    struct symbol_type : basic_symbol<by_kind>
    {
      /// Superclass.
      typedef basic_symbol<by_kind> super_type;

      /// Empty symbol.
      symbol_type () {}

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, location_type l)
        : super_type(token_type (tok), std::move (l))
#else
      symbol_type (int tok, const location_type& l)
        : super_type(token_type (tok), l)
#endif
      {
        YY_ASSERT (tok == token::YYEOF
                   || (token::YYerror <= tok && tok <= token::EOL));
      }
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, string v, location_type l)
        : super_type(token_type (tok), std::move (v), std::move (l))
#else
      symbol_type (int tok, const string& v, const location_type& l)
        : super_type(token_type (tok), v, l)
#endif
      {
        YY_ASSERT ((token::NAME <= tok && tok <= token::NUMBER));
      }
    };

    /// Build a parser object.
    parser (macro::Driver &driver_yyarg);
    virtual ~parser ();

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    parser (const parser&) = delete;
    /// Non copyable.
    parser& operator= (const parser&) = delete;
#endif

    /// Parse.  An alias for parse ().
    /// \returns  0 iff parsing succeeded.
    int operator() ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if YYDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param loc    where the syntax error is found.
    /// \param msg    a description of the syntax error.
    virtual void error (const location_type& loc, const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

    /// The user-facing name of the symbol whose (internal) number is
    /// YYSYMBOL.  No bounds checking.
    static std::string symbol_name (symbol_kind_type yysymbol);

    // Implementation of make_symbol for each symbol type.
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYEOF (location_type l)
      {
        return symbol_type (token::YYEOF, std::move (l));
      }
#else
      static
      symbol_type
      make_YYEOF (const location_type& l)
      {
        return symbol_type (token::YYEOF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYerror (location_type l)
      {
        return symbol_type (token::YYerror, std::move (l));
      }
#else
      static
      symbol_type
      make_YYerror (const location_type& l)
      {
        return symbol_type (token::YYerror, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYUNDEF (location_type l)
      {
        return symbol_type (token::YYUNDEF, std::move (l));
      }
#else
      static
      symbol_type
      make_YYUNDEF (const location_type& l)
      {
        return symbol_type (token::YYUNDEF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FOR (location_type l)
      {
        return symbol_type (token::FOR, std::move (l));
      }
#else
      static
      symbol_type
      make_FOR (const location_type& l)
      {
        return symbol_type (token::FOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDFOR (location_type l)
      {
        return symbol_type (token::ENDFOR, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDFOR (const location_type& l)
      {
        return symbol_type (token::ENDFOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IF (location_type l)
      {
        return symbol_type (token::IF, std::move (l));
      }
#else
      static
      symbol_type
      make_IF (const location_type& l)
      {
        return symbol_type (token::IF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IFDEF (location_type l)
      {
        return symbol_type (token::IFDEF, std::move (l));
      }
#else
      static
      symbol_type
      make_IFDEF (const location_type& l)
      {
        return symbol_type (token::IFDEF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IFNDEF (location_type l)
      {
        return symbol_type (token::IFNDEF, std::move (l));
      }
#else
      static
      symbol_type
      make_IFNDEF (const location_type& l)
      {
        return symbol_type (token::IFNDEF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ELSEIF (location_type l)
      {
        return symbol_type (token::ELSEIF, std::move (l));
      }
#else
      static
      symbol_type
      make_ELSEIF (const location_type& l)
      {
        return symbol_type (token::ELSEIF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ELSE (location_type l)
      {
        return symbol_type (token::ELSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ELSE (const location_type& l)
      {
        return symbol_type (token::ELSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDIF (location_type l)
      {
        return symbol_type (token::ENDIF, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDIF (const location_type& l)
      {
        return symbol_type (token::ENDIF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRUE (location_type l)
      {
        return symbol_type (token::TRUE, std::move (l));
      }
#else
      static
      symbol_type
      make_TRUE (const location_type& l)
      {
        return symbol_type (token::TRUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FALSE (location_type l)
      {
        return symbol_type (token::FALSE, std::move (l));
      }
#else
      static
      symbol_type
      make_FALSE (const location_type& l)
      {
        return symbol_type (token::FALSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INCLUDE (location_type l)
      {
        return symbol_type (token::INCLUDE, std::move (l));
      }
#else
      static
      symbol_type
      make_INCLUDE (const location_type& l)
      {
        return symbol_type (token::INCLUDE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INCLUDEPATH (location_type l)
      {
        return symbol_type (token::INCLUDEPATH, std::move (l));
      }
#else
      static
      symbol_type
      make_INCLUDEPATH (const location_type& l)
      {
        return symbol_type (token::INCLUDEPATH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFINE (location_type l)
      {
        return symbol_type (token::DEFINE, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFINE (const location_type& l)
      {
        return symbol_type (token::DEFINE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUAL (location_type l)
      {
        return symbol_type (token::EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUAL (const location_type& l)
      {
        return symbol_type (token::EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_D_ECHO (location_type l)
      {
        return symbol_type (token::D_ECHO, std::move (l));
      }
#else
      static
      symbol_type
      make_D_ECHO (const location_type& l)
      {
        return symbol_type (token::D_ECHO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERROR (location_type l)
      {
        return symbol_type (token::ERROR, std::move (l));
      }
#else
      static
      symbol_type
      make_ERROR (const location_type& l)
      {
        return symbol_type (token::ERROR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMMA (location_type l)
      {
        return symbol_type (token::COMMA, std::move (l));
      }
#else
      static
      symbol_type
      make_COMMA (const location_type& l)
      {
        return symbol_type (token::COMMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LPAREN (location_type l)
      {
        return symbol_type (token::LPAREN, std::move (l));
      }
#else
      static
      symbol_type
      make_LPAREN (const location_type& l)
      {
        return symbol_type (token::LPAREN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RPAREN (location_type l)
      {
        return symbol_type (token::RPAREN, std::move (l));
      }
#else
      static
      symbol_type
      make_RPAREN (const location_type& l)
      {
        return symbol_type (token::RPAREN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LBRACKET (location_type l)
      {
        return symbol_type (token::LBRACKET, std::move (l));
      }
#else
      static
      symbol_type
      make_LBRACKET (const location_type& l)
      {
        return symbol_type (token::LBRACKET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RBRACKET (location_type l)
      {
        return symbol_type (token::RBRACKET, std::move (l));
      }
#else
      static
      symbol_type
      make_RBRACKET (const location_type& l)
      {
        return symbol_type (token::RBRACKET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WHEN (location_type l)
      {
        return symbol_type (token::WHEN, std::move (l));
      }
#else
      static
      symbol_type
      make_WHEN (const location_type& l)
      {
        return symbol_type (token::WHEN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BEGIN_EVAL (location_type l)
      {
        return symbol_type (token::BEGIN_EVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_BEGIN_EVAL (const location_type& l)
      {
        return symbol_type (token::BEGIN_EVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_END_EVAL (location_type l)
      {
        return symbol_type (token::END_EVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_END_EVAL (const location_type& l)
      {
        return symbol_type (token::END_EVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ECHOMACROVARS (location_type l)
      {
        return symbol_type (token::ECHOMACROVARS, std::move (l));
      }
#else
      static
      symbol_type
      make_ECHOMACROVARS (const location_type& l)
      {
        return symbol_type (token::ECHOMACROVARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE (location_type l)
      {
        return symbol_type (token::SAVE, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE (const location_type& l)
      {
        return symbol_type (token::SAVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINE (location_type l)
      {
        return symbol_type (token::LINE, std::move (l));
      }
#else
      static
      symbol_type
      make_LINE (const location_type& l)
      {
        return symbol_type (token::LINE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXP (location_type l)
      {
        return symbol_type (token::EXP, std::move (l));
      }
#else
      static
      symbol_type
      make_EXP (const location_type& l)
      {
        return symbol_type (token::EXP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG (location_type l)
      {
        return symbol_type (token::LOG, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG (const location_type& l)
      {
        return symbol_type (token::LOG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LN (location_type l)
      {
        return symbol_type (token::LN, std::move (l));
      }
#else
      static
      symbol_type
      make_LN (const location_type& l)
      {
        return symbol_type (token::LN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG10 (location_type l)
      {
        return symbol_type (token::LOG10, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG10 (const location_type& l)
      {
        return symbol_type (token::LOG10, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIN (location_type l)
      {
        return symbol_type (token::SIN, std::move (l));
      }
#else
      static
      symbol_type
      make_SIN (const location_type& l)
      {
        return symbol_type (token::SIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COS (location_type l)
      {
        return symbol_type (token::COS, std::move (l));
      }
#else
      static
      symbol_type
      make_COS (const location_type& l)
      {
        return symbol_type (token::COS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TAN (location_type l)
      {
        return symbol_type (token::TAN, std::move (l));
      }
#else
      static
      symbol_type
      make_TAN (const location_type& l)
      {
        return symbol_type (token::TAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASIN (location_type l)
      {
        return symbol_type (token::ASIN, std::move (l));
      }
#else
      static
      symbol_type
      make_ASIN (const location_type& l)
      {
        return symbol_type (token::ASIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ACOS (location_type l)
      {
        return symbol_type (token::ACOS, std::move (l));
      }
#else
      static
      symbol_type
      make_ACOS (const location_type& l)
      {
        return symbol_type (token::ACOS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ATAN (location_type l)
      {
        return symbol_type (token::ATAN, std::move (l));
      }
#else
      static
      symbol_type
      make_ATAN (const location_type& l)
      {
        return symbol_type (token::ATAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQRT (location_type l)
      {
        return symbol_type (token::SQRT, std::move (l));
      }
#else
      static
      symbol_type
      make_SQRT (const location_type& l)
      {
        return symbol_type (token::SQRT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBRT (location_type l)
      {
        return symbol_type (token::CBRT, std::move (l));
      }
#else
      static
      symbol_type
      make_CBRT (const location_type& l)
      {
        return symbol_type (token::CBRT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIGN (location_type l)
      {
        return symbol_type (token::SIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_SIGN (const location_type& l)
      {
        return symbol_type (token::SIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX (location_type l)
      {
        return symbol_type (token::MAX, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX (const location_type& l)
      {
        return symbol_type (token::MAX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MIN (location_type l)
      {
        return symbol_type (token::MIN, std::move (l));
      }
#else
      static
      symbol_type
      make_MIN (const location_type& l)
      {
        return symbol_type (token::MIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLOOR (location_type l)
      {
        return symbol_type (token::FLOOR, std::move (l));
      }
#else
      static
      symbol_type
      make_FLOOR (const location_type& l)
      {
        return symbol_type (token::FLOOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CEIL (location_type l)
      {
        return symbol_type (token::CEIL, std::move (l));
      }
#else
      static
      symbol_type
      make_CEIL (const location_type& l)
      {
        return symbol_type (token::CEIL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRUNC (location_type l)
      {
        return symbol_type (token::TRUNC, std::move (l));
      }
#else
      static
      symbol_type
      make_TRUNC (const location_type& l)
      {
        return symbol_type (token::TRUNC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUM (location_type l)
      {
        return symbol_type (token::SUM, std::move (l));
      }
#else
      static
      symbol_type
      make_SUM (const location_type& l)
      {
        return symbol_type (token::SUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOD (location_type l)
      {
        return symbol_type (token::MOD, std::move (l));
      }
#else
      static
      symbol_type
      make_MOD (const location_type& l)
      {
        return symbol_type (token::MOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERF (location_type l)
      {
        return symbol_type (token::ERF, std::move (l));
      }
#else
      static
      symbol_type
      make_ERF (const location_type& l)
      {
        return symbol_type (token::ERF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERFC (location_type l)
      {
        return symbol_type (token::ERFC, std::move (l));
      }
#else
      static
      symbol_type
      make_ERFC (const location_type& l)
      {
        return symbol_type (token::ERFC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GAMMA (location_type l)
      {
        return symbol_type (token::GAMMA, std::move (l));
      }
#else
      static
      symbol_type
      make_GAMMA (const location_type& l)
      {
        return symbol_type (token::GAMMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LGAMMA (location_type l)
      {
        return symbol_type (token::LGAMMA, std::move (l));
      }
#else
      static
      symbol_type
      make_LGAMMA (const location_type& l)
      {
        return symbol_type (token::LGAMMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ROUND (location_type l)
      {
        return symbol_type (token::ROUND, std::move (l));
      }
#else
      static
      symbol_type
      make_ROUND (const location_type& l)
      {
        return symbol_type (token::ROUND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMPDF (location_type l)
      {
        return symbol_type (token::NORMPDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMPDF (const location_type& l)
      {
        return symbol_type (token::NORMPDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMCDF (location_type l)
      {
        return symbol_type (token::NORMCDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMCDF (const location_type& l)
      {
        return symbol_type (token::NORMCDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LENGTH (location_type l)
      {
        return symbol_type (token::LENGTH, std::move (l));
      }
#else
      static
      symbol_type
      make_LENGTH (const location_type& l)
      {
        return symbol_type (token::LENGTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISEMPTY (location_type l)
      {
        return symbol_type (token::ISEMPTY, std::move (l));
      }
#else
      static
      symbol_type
      make_ISEMPTY (const location_type& l)
      {
        return symbol_type (token::ISEMPTY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISBOOLEAN (location_type l)
      {
        return symbol_type (token::ISBOOLEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_ISBOOLEAN (const location_type& l)
      {
        return symbol_type (token::ISBOOLEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISREAL (location_type l)
      {
        return symbol_type (token::ISREAL, std::move (l));
      }
#else
      static
      symbol_type
      make_ISREAL (const location_type& l)
      {
        return symbol_type (token::ISREAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISSTRING (location_type l)
      {
        return symbol_type (token::ISSTRING, std::move (l));
      }
#else
      static
      symbol_type
      make_ISSTRING (const location_type& l)
      {
        return symbol_type (token::ISSTRING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISTUPLE (location_type l)
      {
        return symbol_type (token::ISTUPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_ISTUPLE (const location_type& l)
      {
        return symbol_type (token::ISTUPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISARRAY (location_type l)
      {
        return symbol_type (token::ISARRAY, std::move (l));
      }
#else
      static
      symbol_type
      make_ISARRAY (const location_type& l)
      {
        return symbol_type (token::ISARRAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOOL (location_type l)
      {
        return symbol_type (token::BOOL, std::move (l));
      }
#else
      static
      symbol_type
      make_BOOL (const location_type& l)
      {
        return symbol_type (token::BOOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL (location_type l)
      {
        return symbol_type (token::REAL, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL (const location_type& l)
      {
        return symbol_type (token::REAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRING (location_type l)
      {
        return symbol_type (token::STRING, std::move (l));
      }
#else
      static
      symbol_type
      make_STRING (const location_type& l)
      {
        return symbol_type (token::STRING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TUPLE (location_type l)
      {
        return symbol_type (token::TUPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_TUPLE (const location_type& l)
      {
        return symbol_type (token::TUPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ARRAY (location_type l)
      {
        return symbol_type (token::ARRAY, std::move (l));
      }
#else
      static
      symbol_type
      make_ARRAY (const location_type& l)
      {
        return symbol_type (token::ARRAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFINED (location_type l)
      {
        return symbol_type (token::DEFINED, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFINED (const location_type& l)
      {
        return symbol_type (token::DEFINED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OR (location_type l)
      {
        return symbol_type (token::OR, std::move (l));
      }
#else
      static
      symbol_type
      make_OR (const location_type& l)
      {
        return symbol_type (token::OR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AND (location_type l)
      {
        return symbol_type (token::AND, std::move (l));
      }
#else
      static
      symbol_type
      make_AND (const location_type& l)
      {
        return symbol_type (token::AND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUAL_EQUAL (location_type l)
      {
        return symbol_type (token::EQUAL_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUAL_EQUAL (const location_type& l)
      {
        return symbol_type (token::EQUAL_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOT_EQUAL (location_type l)
      {
        return symbol_type (token::NOT_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_NOT_EQUAL (const location_type& l)
      {
        return symbol_type (token::NOT_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LESS (location_type l)
      {
        return symbol_type (token::LESS, std::move (l));
      }
#else
      static
      symbol_type
      make_LESS (const location_type& l)
      {
        return symbol_type (token::LESS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GREATER (location_type l)
      {
        return symbol_type (token::GREATER, std::move (l));
      }
#else
      static
      symbol_type
      make_GREATER (const location_type& l)
      {
        return symbol_type (token::GREATER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LESS_EQUAL (location_type l)
      {
        return symbol_type (token::LESS_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_LESS_EQUAL (const location_type& l)
      {
        return symbol_type (token::LESS_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GREATER_EQUAL (location_type l)
      {
        return symbol_type (token::GREATER_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GREATER_EQUAL (const location_type& l)
      {
        return symbol_type (token::GREATER_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IN (location_type l)
      {
        return symbol_type (token::IN, std::move (l));
      }
#else
      static
      symbol_type
      make_IN (const location_type& l)
      {
        return symbol_type (token::IN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COLON (location_type l)
      {
        return symbol_type (token::COLON, std::move (l));
      }
#else
      static
      symbol_type
      make_COLON (const location_type& l)
      {
        return symbol_type (token::COLON, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNION (location_type l)
      {
        return symbol_type (token::UNION, std::move (l));
      }
#else
      static
      symbol_type
      make_UNION (const location_type& l)
      {
        return symbol_type (token::UNION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERSECTION (location_type l)
      {
        return symbol_type (token::INTERSECTION, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERSECTION (const location_type& l)
      {
        return symbol_type (token::INTERSECTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUS (location_type l)
      {
        return symbol_type (token::PLUS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUS (const location_type& l)
      {
        return symbol_type (token::PLUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUS (location_type l)
      {
        return symbol_type (token::MINUS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUS (const location_type& l)
      {
        return symbol_type (token::MINUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMES (location_type l)
      {
        return symbol_type (token::TIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMES (const location_type& l)
      {
        return symbol_type (token::TIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIVIDE (location_type l)
      {
        return symbol_type (token::DIVIDE, std::move (l));
      }
#else
      static
      symbol_type
      make_DIVIDE (const location_type& l)
      {
        return symbol_type (token::DIVIDE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNARY (location_type l)
      {
        return symbol_type (token::UNARY, std::move (l));
      }
#else
      static
      symbol_type
      make_UNARY (const location_type& l)
      {
        return symbol_type (token::UNARY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOT (location_type l)
      {
        return symbol_type (token::NOT, std::move (l));
      }
#else
      static
      symbol_type
      make_NOT (const location_type& l)
      {
        return symbol_type (token::NOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CAST (location_type l)
      {
        return symbol_type (token::CAST, std::move (l));
      }
#else
      static
      symbol_type
      make_CAST (const location_type& l)
      {
        return symbol_type (token::CAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POWER (location_type l)
      {
        return symbol_type (token::POWER, std::move (l));
      }
#else
      static
      symbol_type
      make_POWER (const location_type& l)
      {
        return symbol_type (token::POWER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EOL (location_type l)
      {
        return symbol_type (token::EOL, std::move (l));
      }
#else
      static
      symbol_type
      make_EOL (const location_type& l)
      {
        return symbol_type (token::EOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAME (string v, location_type l)
      {
        return symbol_type (token::NAME, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NAME (const string& v, const location_type& l)
      {
        return symbol_type (token::NAME, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TEXT (string v, location_type l)
      {
        return symbol_type (token::TEXT, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_TEXT (const string& v, const location_type& l)
      {
        return symbol_type (token::TEXT, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QUOTED_STRING (string v, location_type l)
      {
        return symbol_type (token::QUOTED_STRING, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_QUOTED_STRING (const string& v, const location_type& l)
      {
        return symbol_type (token::QUOTED_STRING, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER (string v, location_type l)
      {
        return symbol_type (token::NUMBER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER (const string& v, const location_type& l)
      {
        return symbol_type (token::NUMBER, v, l);
      }
#endif


    class context
    {
    public:
      context (const parser& yyparser, const symbol_type& yyla);
      const symbol_type& lookahead () const YY_NOEXCEPT { return yyla_; }
      symbol_kind_type token () const YY_NOEXCEPT { return yyla_.kind (); }
      const location_type& location () const YY_NOEXCEPT { return yyla_.location; }

      /// Put in YYARG at most YYARGN of the expected tokens, and return the
      /// number of tokens stored in YYARG.  If YYARG is null, return the
      /// number of expected tokens (guaranteed to be less than YYNTOKENS).
      int expected_tokens (symbol_kind_type yyarg[], int yyargn) const;

    private:
      const parser& yyparser_;
      const symbol_type& yyla_;
    };

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    parser (const parser&);
    /// Non copyable.
    parser& operator= (const parser&);
#endif


    /// Stored state numbers (used for stacks).
    typedef short state_type;

    /// The arguments of the error message.
    int yy_syntax_error_arguments_ (const context& yyctx,
                                    symbol_kind_type yyarg[], int yyargn) const;

    /// Generate an error message.
    /// \param yyctx     the context in which the error occurred.
    virtual std::string yysyntax_error_ (const context& yyctx) const;
    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    static state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue);

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue);

    static const short yypact_ninf_;
    static const signed char yytable_ninf_;

    /// Convert a scanner token kind \a t to a symbol kind.
    /// In theory \a t should be a token_kind_type, but character literals
    /// are valid, yet not members of the token_type enum.
    static symbol_kind_type yytranslate_ (int t);

    /// Convert the symbol name \a n to a form suitable for a diagnostic.
    static std::string yytnamerr_ (const char *yystr);

    /// For a symbol, its name in clear.
    static const char* const yytname_[];


    // Tables.
    // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
    // STATE-NUM.
    static const short yypact_[];

    // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
    // Performed when YYTABLE does not specify something else to do.  Zero
    // means the default is an error.
    static const unsigned char yydefact_[];

    // YYPGOTO[NTERM-NUM].
    static const short yypgoto_[];

    // YYDEFGOTO[NTERM-NUM].
    static const short yydefgoto_[];

    // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
    // positive, shift that token.  If negative, reduce the rule whose
    // number is the opposite.  If YYTABLE_NINF, syntax error.
    static const short yytable_[];

    static const short yycheck_[];

    // YYSTOS[STATE-NUM] -- The (internal number of the) accessing
    // symbol of state STATE-NUM.
    static const signed char yystos_[];

    // YYR1[YYN] -- Symbol number of symbol that rule YYN derives.
    static const signed char yyr1_[];

    // YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.
    static const signed char yyr2_[];


#if YYDEBUG
    // YYRLINE[YYN] -- Source line where rule number YYN was defined.
    static const short yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r) const;
    /// Print the state stack on the debug stream.
    virtual void yy_stack_print_ () const;

    /// Debugging level.
    int yydebug_;
    /// Debug stream.
    std::ostream* yycdebug_;

    /// \brief Display a symbol kind, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state () YY_NOEXCEPT;

      /// The symbol kind as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s) YY_NOEXCEPT;

      /// Copy constructor.
      by_state (const by_state& that) YY_NOEXCEPT;

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_state& that);

      /// The symbol kind (corresponding to \a state).
      /// \a symbol_kind::S_YYEMPTY when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// The state number used to denote an empty symbol.
      /// We use the initial state, as it does not have a value.
      enum { empty_state = 0 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Move or copy construction.
      stack_symbol_type (YY_RVREF (stack_symbol_type) that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) sym);
#if YY_CPLUSPLUS < 201103L
      /// Assignment, needed by push_back by some old implementations.
      /// Moves the contents of that.
      stack_symbol_type& operator= (stack_symbol_type& that);

      /// Assignment, needed by push_back by other implementations.
      /// Needed by some other old implementations.
      stack_symbol_type& operator= (const stack_symbol_type& that);
#endif
    };

    /// A stack with random access from its top.
    template <typename T, typename S = std::vector<T> >
    class stack
    {
    public:
      // Hide our reversed order.
      typedef typename S::iterator iterator;
      typedef typename S::const_iterator const_iterator;
      typedef typename S::size_type size_type;
      typedef typename std::ptrdiff_t index_type;

      stack (size_type n = 200)
        : seq_ (n)
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Non copyable.
      stack (const stack&) = delete;
      /// Non copyable.
      stack& operator= (const stack&) = delete;
#endif

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (index_type i) const
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (index_type i)
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Steal the contents of \a t.
      ///
      /// Close to move-semantics.
      void
      push (YY_MOVE_REF (T) t)
      {
        seq_.push_back (T ());
        operator[] (0).move (t);
      }

      /// Pop elements from the stack.
      void
      pop (std::ptrdiff_t n = 1) YY_NOEXCEPT
      {
        for (; 0 < n; --n)
          seq_.pop_back ();
      }

      /// Pop all elements from the stack.
      void
      clear () YY_NOEXCEPT
      {
        seq_.clear ();
      }

      /// Number of elements on the stack.
      index_type
      size () const YY_NOEXCEPT
      {
        return index_type (seq_.size ());
      }

      /// Iterator on top of the stack (going downwards).
      const_iterator
      begin () const YY_NOEXCEPT
      {
        return seq_.begin ();
      }

      /// Bottom of the stack.
      const_iterator
      end () const YY_NOEXCEPT
      {
        return seq_.end ();
      }

      /// Present a slice of the top of a stack.
      class slice
      {
      public:
        slice (const stack& stack, index_type range)
          : stack_ (stack)
          , range_ (range)
        {}

        const T&
        operator[] (index_type i) const
        {
          return stack_[range_ - i];
        }

      private:
        const stack& stack_;
        index_type range_;
      };

    private:
#if YY_CPLUSPLUS < 201103L
      /// Non copyable.
      stack (const stack&);
      /// Non copyable.
      stack& operator= (const stack&);
#endif
      /// The wrapped container.
      S seq_;
    };


    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;

    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param sym  the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a sym.value is stolen.
    void yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym);

    /// Pop \a n symbols from the stack.
    void yypop_ (int n = 1);

    /// Constants.
    enum
    {
      yylast_ = 1128,     ///< Last index in yytable_.
      yynnts_ = 33,  ///< Number of nonterminal symbols.
      yyfinal_ = 91 ///< Termination state number.
    };


    // User arguments.
    macro::Driver &driver;

  };


#line 25 "Parser.yy"
} // Tokenizer
#line 2984 "Parser.hh"




#endif // !YY_YY_PARSER_HH_INCLUDED
