# Authors:
#     Endi S. Dewata <edewata@redhat.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Copyright (C) 2015 Red Hat, Inc.
# All rights reserved.
#

from __future__ import absolute_import
import os

import pki.server.upgrade


class RemoveDependencyOnJackson2(pki.server.upgrade.PKIServerUpgradeScriptlet):

    def __init__(self):
        super(RemoveDependencyOnJackson2, self).__init__()
        self.message = 'Remove dependency on Jackson 2'

    def upgrade_instance(self, instance):

        # Tomcat common library
        common_lib = os.path.join(instance.base_dir, 'common', 'lib')

        # remove old links
        link = os.path.join(common_lib, 'jackson-annotations.jar')
        self.remove_link(link)

        link = os.path.join(common_lib, 'jackson-core.jar')
        self.remove_link(link)

        link = os.path.join(common_lib, 'jackson-databind.jar')
        self.remove_link(link)

        link = os.path.join(common_lib, 'jackson-jaxrs-base.jar')
        self.remove_link(link)

        link = os.path.join(common_lib, 'jackson-jaxrs-json-provider.jar')
        self.remove_link(link)

        link = os.path.join(common_lib, 'jackson-module-jaxb-annotations.jar')
        self.remove_link(link)

    def remove_link(self, link):

        self.backup(link)
        os.remove(link)
