// ------------------------------------------------------------------------
//
// SPDX-License-Identifier: LGPL-2.1-or-later
// Copyright (C) 2000 - 2020 by the deal.II authors
//
// This file is part of the deal.II library.
//
// Part of the source code is dual licensed under Apache-2.0 WITH
// LLVM-exception OR LGPL-2.1-or-later. Detailed license information
// governing the source code and code contributions can be found in
// LICENSE.md and CONTRIBUTING.md at the top level directory of deal.II.
//
// ------------------------------------------------------------------------


#include <deal.II/lac/block_vector.templates.h>

DEAL_II_NAMESPACE_OPEN

#include "block_vector.inst"

#ifndef DOXYGEN
// these functions can't be generated by the preprocessor since
// the template arguments need to be different
template BlockVector<double>::BlockVector(const BlockVector<float> &);
template BlockVector<float>::BlockVector(const BlockVector<double> &);

#  ifdef DEAL_II_WITH_COMPLEX_VALUES
template BlockVector<std::complex<double>>::BlockVector(
  const BlockVector<std::complex<float>> &);
template BlockVector<std::complex<float>>::BlockVector(
  const BlockVector<std::complex<double>> &);
#  endif
#endif

DEAL_II_NAMESPACE_CLOSE
