//
// C++ Implementation: searchlistmodel
//
// Description: 
//
//
// Author: Mikael Gransell <mikael.gransell@bredband.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "searchtablemodel.h"
#include "log.h"
#include "util.h"

#include <QtCore>

#include <stdexcept>


int SearchEntry::sortElement = SearchEntry::SORT_FILENAME;

/*
#include <iostream>

SearchTableModel::~SearchTableModel()
{
	std::cerr << "~SearchTableModel()\n";
}
*/

void SearchTableModel::onSearchResult( int /* session */, const SearchEntry& entry ) {
	int n = filteredResults.size();
	sortedInsert( entry );
	// Tell the views that data we have added a row
	if(n!=filteredResults.size()) emit layoutChanged();
}

void SearchTableModel::onSearchResult( int /* session */, const QList<SearchEntry>& entries )
{
	int n = filteredResults.size();
	for(int i=0; i < entries.size(); i++ ) //searchResults.append( entries.at(i) );
		sortedInsert( entries.at(i) );
	if(n!=filteredResults.size()) emit layoutChanged();
}

QVariant SearchTableModel::data( const QModelIndex& index, int role ) const {
    if( !index.isValid() )
        return QVariant();

    if( index.row() < 0 || index.row() >= filteredResults.size() )
        return QVariant();

    QVariant ret;
	int i = index.row();
	
	if( role == Qt::DisplayRole || role == Qt::ToolTipRole ) {
		switch( index.column() ) {
        case FILENAME_COLUMN:
            ret = filteredResults.at(i).getFileName();
            break;

        case USER_COLUMN:
            ret = filteredResults.at(i).getNick();
            break;

        case SIZE_COLUMN:
            ret = Util::bytesToStr(filteredResults.at(i).getFileSize());
            break;

        case PATH_COLUMN:
            ret = filteredResults.at(i).getPath();
            break;

        case HUBNAME_COLUMN:
            ret =  filteredResults.at(i).getHubName();
            break;

        //case TYPE_COLUMN:
         //   ret = filteredResults.at(i).getType();
         //   break;

        case SLOTS_COLUMN:
			ret = QString::number( filteredResults.at(i).getFreeSlots() ) + "/" +
					QString::number( filteredResults.at(i).getUserSlots() );
            break;

		case TTH_COLUMN:
			ret = filteredResults.at(i).getTTH();
			break;
        }
    }
	else if( role == Qt::DecorationRole ) {
		
		// only display icon for the first column
		if ( index.column() == 0 ) {
			
			// Get an icon from the icon provider
			ret = m_pIconProvider->icon( filteredResults.at(i).getType() == SearchEntry::DIRECTORY ? QFileIconProvider::Folder : QFileIconProvider::File );
		}
	}
	
    return ret;
}


QVariant SearchTableModel::headerData ( int section, Qt::Orientation orientation, int role ) const
{
	if (role != Qt::DisplayRole)
		return QVariant();

	if(orientation==Qt::Horizontal) {
		switch( section ) {
			case FILENAME_COLUMN:
				return tr("File Name");

			case USER_COLUMN:
				return tr("User");

			case SIZE_COLUMN:
				return tr("Size");

			case PATH_COLUMN:
				return tr("Path");

			case SLOTS_COLUMN:
				return tr("Slots");

			case HUBNAME_COLUMN:
				return tr("Hub");
				
			//case TYPE_COLUMN:
			//	return tr("Type");
				
			case TTH_COLUMN:
				return tr("TTH");
		}
	}
	return QVariant();
}

const SearchEntry& SearchTableModel::getEntry( int index ) const
{
	// Make sure the index is OK
	if( index < 0 || index >= filteredResults.size() ) {
		logger->error("SearchTableModel::getEntry() index out of valid range");
		throw std::out_of_range("Index out of range when fetching SearchEntry from model");
	}
	
	return filteredResults.at(index);
}

void SearchTableModel::sort( int column, Qt::SortOrder order )
{
	sortOrder = order;
	switch( column ) {
		case FILENAME_COLUMN: SearchEntry::sortElement = SearchEntry::SORT_FILENAME;break;
		case USER_COLUMN: SearchEntry::sortElement = SearchEntry::SORT_USER ;break;
		case SIZE_COLUMN:SearchEntry::sortElement = SearchEntry::SORT_SIZE;break;
		case PATH_COLUMN:SearchEntry::sortElement = SearchEntry::SORT_PATH;break;
		case SLOTS_COLUMN:SearchEntry::sortElement = SearchEntry::SORT_SLOTS;break;
		case HUBNAME_COLUMN:SearchEntry::sortElement = SearchEntry::SORT_HUBNAME;break;
		//case TYPE_COLUMN:SearchEntry::sortElement = SearchEntry::SORT_TYPE;break;
		case TTH_COLUMN:SearchEntry::sortElement = SearchEntry::SORT_TTH;break;
	}
	if(order==Qt::DescendingOrder)
		qSort(filteredResults.begin(),filteredResults.end(),qGreater<SearchEntry>());
	else 
		qSort(filteredResults.begin(),filteredResults.end());


	emit layoutChanged();
}

void SearchTableModel::clear() 
{
	searchResults.clear();
	filteredResults.clear();
	emit layoutChanged();
}

void SearchTableModel::sortedInsert(const SearchEntry &e )
{
	// This one doesnt need sorting since we only use it for building the filtered set.
	searchResults.append(e);
	
	if(!filterEnabled || e.getFreeSlots() > 0) {
		QList<SearchEntry>::iterator i = (sortOrder==Qt::AscendingOrder) ? 
				qUpperBound(filteredResults.begin(), filteredResults.end(), e) :
				qLowerBound(filteredResults.begin(), filteredResults.end(), e);
		filteredResults.insert(i, e);
	}
}

void SearchTableModel::enableFilter( bool yes )
{
	if( yes == filterEnabled ) return;
	filterEnabled = yes;
	filteredResults.clear();
	if(!filterEnabled) filteredResults = searchResults;
	else 
		for(int i=0; i < searchResults.size(); i++)
			if( searchResults.at(i).getFreeSlots() > 0 )
				filteredResults += searchResults.at(i);
	if(sortOrder==Qt::DescendingOrder)
		qSort(filteredResults.begin(),filteredResults.end(),qGreater<SearchEntry>());
	else 
		qSort(filteredResults.begin(),filteredResults.end());
	emit layoutChanged();
}
