pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Strings;
with Interfaces.C.Extensions;
with System;
with dbus_types_h;

package dbus_errors_h is

   --  unsupported macro: DBUS_ERROR_INIT { NULL, NULL, TRUE, 0, 0, 0, 0, NULL }
   type DBusError is record
      name : Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-errors.h:49:15
      message : Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-errors.h:50:15
      dummy1 : Extensions.Unsigned_1;  -- ../dbus/dbus-errors.h:52:16
      dummy2 : Extensions.Unsigned_1;  -- ../dbus/dbus-errors.h:53:16
      dummy3 : Extensions.Unsigned_1;  -- ../dbus/dbus-errors.h:54:16
      dummy4 : Extensions.Unsigned_1;  -- ../dbus/dbus-errors.h:55:16
      dummy5 : Extensions.Unsigned_1;  -- ../dbus/dbus-errors.h:56:16
      padding1 : System.Address;  -- ../dbus/dbus-errors.h:58:9
   end record;
   pragma Convention (C_Pass_By_Copy, DBusError);
   pragma Pack (DBusError);  -- ../dbus/dbus-errors.h:42:16

   procedure dbus_error_init (arg1 : access DBusError);  -- ../dbus/dbus-errors.h:63:13
   pragma Import (C, dbus_error_init, "dbus_error_init");

   procedure dbus_error_free (arg1 : access DBusError);  -- ../dbus/dbus-errors.h:64:13
   pragma Import (C, dbus_error_free, "dbus_error_free");

   procedure dbus_set_error
     (arg1 : access DBusError;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : Interfaces.C.Strings.chars_ptr  -- , ...
      );  -- ../dbus/dbus-errors.h:65:13
   pragma Import (C, dbus_set_error, "dbus_set_error");

   procedure dbus_set_error_const
     (arg1 : access DBusError;
      arg2 : Interfaces.C.Strings.chars_ptr;
      arg3 : Interfaces.C.Strings.chars_ptr);  -- ../dbus/dbus-errors.h:69:13
   pragma Import (C, dbus_set_error_const, "dbus_set_error_const");

   procedure dbus_move_error (arg1 : access DBusError; arg2 : access DBusError);  -- ../dbus/dbus-errors.h:72:13
   pragma Import (C, dbus_move_error, "dbus_move_error");

   function dbus_error_has_name (arg1 : access constant DBusError; arg2 : Interfaces.C.Strings.chars_ptr) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-errors.h:74:13
   pragma Import (C, dbus_error_has_name, "dbus_error_has_name");

   function dbus_error_is_set (arg1 : access constant DBusError) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-errors.h:76:13
   pragma Import (C, dbus_error_is_set, "dbus_error_is_set");

end dbus_errors_h;
