We're proud to announce the new feature release of darktable, 3.8.1!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-3.8.1](https://github.com/darktable-org/darktable/releases/tag/release-3.8.1).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz file. The checksums are:

```
$ sha256sum darktable-3.8.1.tar.xz
??? darktable-3.8.1.tar.xz
$ sha256sum darktable-3.8.1.dmg
??? darktable-3.8.1.dmg
$ sha256sum darktable-3.8.1.exe
??? darktable-3.8.1.exe
```

When updating from the currently stable 3.6.x series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will no longer be usable with 3.6.x.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 3.8.0:
- More than 160 commits to darktable+rawspeed
- 75 pull requests handled
- 55 issues closed

## The Big Ones

- Two new languages are now available for the documentation: Spanish
  and Dutch. This brings the total number of translations to six.
  Thanks to all the translators for their hard work.

## Other New Features And Changes

- Speed up the retouch's heal tool by using better parallelism.

- Add new variable $(DARKTABLE_VERSION).

## Bug Fixes

- Fix control and feather points for path and brush shapes when editing
  using zoom > 200%. The editing is now smooth and no longer jumps as the
  mouse is moved.

- On the lighttable view, fix Shift-click when selecting a range - at least one
  image must first be selected.

- Fix expansion of some variables on Windows.

- Fix SVG rendering by computing proper dimension in the watermark module with
  libsvg 2.52.

- Fix printing when the export module is set to scale mode. This was caused by
  a bug in the interaction between export/print.

- Fix print module image layout display when using inch unit.

- Fix yellow border for selected grouped images.

- Fix some tag export issues.

- Fix crash on Windows when importing from a folder containing special
  characters.

- Fix mouse-over thumbnail display when leaving the lighttable from the
  bottom - ensure that the thumbnail stops being highlighted.

- Remove the double-click hint in the crop module for committing parameters.
  This functionality was removed in darktable 3.8.0.

- Better layout for the star and rejected icons.

- Fix some refresh issues on the guide overlays menu - ensure that the popup
  shows the current settings after they have been changed via a keyboard shortcut.

- Fix guide lines in the rotate and perspective module - ensure the
  guides are displayed only within the cropped area.

- Fix Piwigo export for new version of Piwigo which now uses a lounge
  for new images. We now flush it to ensure the images are assigned to
  their corresponding album.

- Fix handling of circle/ellipse sources in the retouch module. Shapes can now be
  moved immediately after placing them via drag+drop.

- Fix a bug in rotate and perspective that was preventing removal of
  the last manually drawn line.

- Fix multiple issues in tagging module. Some UI interactions have
  been reworked to be closer to what a user would expect.

  Also, some new keys have been added:
  <kbd>shift-enter</kbd> attach selected tag, reset entry and give it the focus
  <kbd>shift-left</kbd> collapse the entire tree

- Fix multiple drag+drop issues on the lighttable that were causing crashes.

- Fix a possible crash with very large up-scaling at export.

- Rework the history items on thumbnail tooltips.

- Rework the GUI for the copy / paste of history items. The on/off
  status icon has been removed from the labels and replaced with a specific
  "on/off" column.

- Fix some demosaicer issues specific to AMD OpenCL drivers.

- Fix possible crash in styles module for style names containing a
  slash.

- Add option to enter the new module instance name automatically when
  duplicating a preset.

- Fix Filmic RGB graph update when used in the quick access panel.

- Restore shortcut for creating a virgin duplicate in the lighttable view.

- Allow presets in the tagging module to append the tags instead of replacing them.

- Fix tooltip on mid-tones vs extreme luminance saturation sliders in Filmic RGB.

- Fix crop adjustment in rotate and perspective module when preview
  down-sampling is active. Movements were amplified making the
  adjustment harder and the clicked location was not constant when
  dragging the crop area.

- Fix writing XMP metadata in AVIF format.

- Fix importing from SMB shares mounted using gvfs.

- Fix possible color shifting when activating lens correction on a
  monochrome image.

- Fix $(RATING_ICONS) variable substitution - now displays an "X" when rating
  is 0 instead of an empty string.

- Add some missing variable substitutions in the displayed list.

- Fix reset button in metadata editor. The metadata entries were properly
  removed from the selected pictures but the module display was not
  refreshed.

- Fix enabling processing modules from a shortcut. The module is no
  longer given focus when activated, matching the "click" behaviour.

- Fix automatic tab selection when opening the preferences in non English
  languages.

- Improve the unknown DNG illuminant handling.

- Fix high quality export when the export size is specified "by scale".

- Fix some shortcuts being ignored when applied to a widget in an inactive
  or unfocused popover dialog.

## Lua


## Notes

- We now display a large red message for cameras with missing
  samples. The cameras that were removed in 3.8.0 have been added back
  to darktable for a short period of time.

  If you see such a message this means that your camera is missing samples. If
  you do nothing, support will be removed for good in the next major darktable
  release.

  Read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) for more information.

  The samples must be uploaded here https://raw.pixls.us/.

## Changed Dependencies

## RawSpeed changes


## Camera support, compared to 3.8.0

### Base Support


### White Balance Presets


### Noise Profiles

- Canon EOS D60
- Samsung NX1000

### Custom Color Matrices

### Suspended Support

No samples on raw.pixls.us

- Canon EOS M2
- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm FinePix HS50EXR
- Fujifilm FinePix S6000fd
- Fujifilm FinePix S9600fd
- Fujifilm IS-1
- GoPro FUSION
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Leica D-LUX 6
- Minolta DiMAGE 5
- Nikon 1 J4
- Nikon 1 S1
- Nikon Coolpix P7700
- Nikon D1H
- Nikon D2H
- Nikon D3S
- Olympus E-10
- Olympus SP320
- Olympus SP570UZ
- Panasonic DMC-FX150
- Panasonic DMC-G2
- Pentax K200D
- Pentax K2000
- Pentax Q10
- Phase One IQ250
- Samsung GX10
- Samsung GX20
- Samsung NX5
- Samsung NX10
- Samsung NX11
- Samsung NX20
- Samsung NX2000
- Samsung EK-GN120
- Samsung SM-G920F
- Samsung SM-G935F
- Sinar Hy6/ Sinarback eXact
- Sony DSLR-A380
- Sony DSLR-A560
- ST Micro STV680

## Translations

- Brazilian Portuguese
- Chinese - China
- Dutch
- Esperanto
- European Spanish
- Finnish
- French
- German
- Hebrew
- Hungarian
- Italian
- Japanese
- Polish
- Slovenian
- Ukrainian
