/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/

#include "qczmq.h"

///
//  Copy-construct to return the proper wrapped c types
QZproc::QZproc (zproc_t *self, QObject *qObjParent) : QObject (qObjParent)
{
    this->self = self;
}


///
//  Create a new zproc.
//  NOTE: On Windows and with libzmq3 and libzmq2 this function
//  returns NULL. Code needs to be ported there.
QZproc::QZproc (QObject *qObjParent) : QObject (qObjParent)
{
    this->self = zproc_new ();
}

///
//  Destroy zproc, wait until process ends.
QZproc::~QZproc ()
{
    zproc_destroy (&self);
}

///
//  Setup the command line arguments, the first item must be an (absolute) filename
//  to run.
void QZproc::setArgs (QZlistx *args)
{
    zproc_set_args (self, args->self);

}

///
//  Setup the environment variables for the process.
void QZproc::setEnv (QZhashx *args)
{
    zproc_set_env (self, args->self);

}

///
//  Connects process stdin with a readable ('>', connect) zeromq socket. If
//  socket argument is NULL, zproc creates own managed pair of inproc
//  sockets.  The writable one is then accessbile via zproc_stdin method.
void QZproc::setStdin (void *socket)
{
    zproc_set_stdin (self, socket);

}

///
//  Connects process stdout with a writable ('@', bind) zeromq socket. If
//  socket argument is NULL, zproc creates own managed pair of inproc
//  sockets.  The readable one is then accessbile via zproc_stdout method.
void QZproc::setStdout (void *socket)
{
    zproc_set_stdout (self, socket);

}

///
//  Connects process stderr with a writable ('@', bind) zeromq socket. If
//  socket argument is NULL, zproc creates own managed pair of inproc
//  sockets.  The readable one is then accessbile via zproc_stderr method.
void QZproc::setStderr (void *socket)
{
    zproc_set_stderr (self, socket);

}

///
//  Return subprocess stdin writable socket. NULL for
//  not initialized or external sockets.
void * QZproc::stdin ()
{
    void * rv = zproc_stdin (self);
    return rv;
}

///
//  Return subprocess stdout readable socket. NULL for
//  not initialized or external sockets.
void * QZproc::stdout ()
{
    void * rv = zproc_stdout (self);
    return rv;
}

///
//  Return subprocess stderr readable socket. NULL for
//  not initialized or external sockets.
void * QZproc::stderr ()
{
    void * rv = zproc_stderr (self);
    return rv;
}

///
//  Starts the process.
int QZproc::run ()
{
    int rv = zproc_run (self);
    return rv;
}

///
//  process exit code
int QZproc::returncode ()
{
    int rv = zproc_returncode (self);
    return rv;
}

///
//  PID of the process
int QZproc::pid ()
{
    int rv = zproc_pid (self);
    return rv;
}

///
//  return true if process is running, false if not yet started or finished
bool QZproc::running ()
{
    bool rv = zproc_running (self);
    return rv;
}

///
//  wait or poll process status, return return code
int QZproc::wait (bool hang)
{
    int rv = zproc_wait (self, hang);
    return rv;
}

///
//  return internal actor, usefull for the polling if process died
void * QZproc::actor ()
{
    void * rv = zproc_actor (self);
    return rv;
}

///
//  send a signal to the subprocess
void QZproc::kill (int signal)
{
    zproc_kill (self, signal);

}

///
//  set verbose mode
void QZproc::setVerbose (bool verbose)
{
    zproc_set_verbose (self, verbose);

}

///
//  Returns CZMQ version as a single 6-digit integer encoding the major
//  version (x 10000), the minor version (x 100) and the patch.
int QZproc::czmqVersion ()
{
    int rv = zproc_czmq_version ();
    return rv;
}

///
//  Returns true if the process received a SIGINT or SIGTERM signal.
//  It is good practice to use this method to exit any infinite loop
//  processing messages.
bool QZproc::interrupted ()
{
    bool rv = zproc_interrupted ();
    return rv;
}

///
//  Returns true if the underlying libzmq supports CURVE security.
bool QZproc::hasCurve ()
{
    bool rv = zproc_has_curve ();
    return rv;
}

///
//  Return current host name, for use in public tcp:// endpoints.
//  If the host name is not resolvable, returns NULL.
QString QZproc::hostname ()
{
    char *retStr_ = zproc_hostname ();
    QString rv = QString (retStr_);
    zstr_free (&retStr_);
    return rv;
}

///
//  Move the current process into the background. The precise effect
//  depends on the operating system. On POSIX boxes, moves to a specified
//  working directory (if specified), closes all file handles, reopens
//  stdin, stdout, and stderr to the null device, and sets the process to
//  ignore SIGHUP. On Windows, does nothing. Returns 0 if OK, -1 if there
//  was an error.
void QZproc::daemonize (const QString &workdir)
{
    zproc_daemonize (workdir.toUtf8().data());

}

///
//  Drop the process ID into the lockfile, with exclusive lock, and
//  switch the process to the specified group and/or user. Any of the
//  arguments may be null, indicating a no-op. Returns 0 on success,
//  -1 on failure. Note if you combine this with zsys_daemonize, run
//  after, not before that method, or the lockfile will hold the wrong
//  process ID.
void QZproc::runAs (const QString &lockfile, const QString &group, const QString &user)
{
    zproc_run_as (lockfile.toUtf8().data(), group.toUtf8().data(), user.toUtf8().data());

}

///
//  Configure the number of I/O threads that ZeroMQ will use. A good
//  rule of thumb is one thread per gigabit of traffic in or out. The
//  default is 1, sufficient for most applications. If the environment
//  variable ZSYS_IO_THREADS is defined, that provides the default.
//  Note that this method is valid only before any socket is created.
void QZproc::setIoThreads (size_t ioThreads)
{
    zproc_set_io_threads (ioThreads);

}

///
//  Configure the number of sockets that ZeroMQ will allow. The default
//  is 1024. The actual limit depends on the system, and you can query it
//  by using zsys_socket_limit (). A value of zero means "maximum".
//  Note that this method is valid only before any socket is created.
void QZproc::setMaxSockets (size_t maxSockets)
{
    zproc_set_max_sockets (maxSockets);

}

///
//  Set network interface name to use for broadcasts, particularly zbeacon.
//  This lets the interface be configured for test environments where required.
//  For example, on Mac OS X, zbeacon cannot bind to 255.255.255.255 which is
//  the default when there is no specified interface. If the environment
//  variable ZSYS_INTERFACE is set, use that as the default interface name.
//  Setting the interface to "*" means "use all available interfaces".
void QZproc::setBiface (const QString &value)
{
    zproc_set_biface (value.toUtf8().data());

}

///
//  Return network interface to use for broadcasts, or "" if none was set.
const QString QZproc::biface ()
{
    const QString rv = QString (zproc_biface ());
    return rv;
}

///
//  Set log identity, which is a string that prefixes all log messages sent
//  by this process. The log identity defaults to the environment variable
//  ZSYS_LOGIDENT, if that is set.
void QZproc::setLogIdent (const QString &value)
{
    zproc_set_log_ident (value.toUtf8().data());

}

///
//  Sends log output to a PUB socket bound to the specified endpoint. To
//  collect such log output, create a SUB socket, subscribe to the traffic
//  you care about, and connect to the endpoint. Log traffic is sent as a
//  single string frame, in the same format as when sent to stdout. The
//  log system supports a single sender; multiple calls to this method will
//  bind the same sender to multiple endpoints. To disable the sender, call
//  this method with a null argument.
void QZproc::setLogSender (const QString &endpoint)
{
    zproc_set_log_sender (endpoint.toUtf8().data());

}

///
//  Enable or disable logging to the system facility (syslog on POSIX boxes,
//  event log on Windows). By default this is disabled.
void QZproc::setLogSystem (bool logsystem)
{
    zproc_set_log_system (logsystem);

}

///
//  Log error condition - highest priority
void QZproc::logError (const QString &param)
{
    zproc_log_error ("%s", param.toUtf8().data());

}

///
//  Log warning condition - high priority
void QZproc::logWarning (const QString &param)
{
    zproc_log_warning ("%s", param.toUtf8().data());

}

///
//  Log normal, but significant, condition - normal priority
void QZproc::logNotice (const QString &param)
{
    zproc_log_notice ("%s", param.toUtf8().data());

}

///
//  Log informational message - low priority
void QZproc::logInfo (const QString &param)
{
    zproc_log_info ("%s", param.toUtf8().data());

}

///
//  Log debug-level message - lowest priority
void QZproc::logDebug (const QString &param)
{
    zproc_log_debug ("%s", param.toUtf8().data());

}

///
//  Self test of this class.
void QZproc::test (bool verbose)
{
    zproc_test (verbose);

}
/*
################################################################################
#  THIS FILE IS 100% GENERATED BY ZPROJECT; DO NOT EDIT EXCEPT EXPERIMENTALLY  #
#  Read the zproject/README.md for information about making permanent changes. #
################################################################################
*/
