/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class ObjectValue
extends AtomicValue {
    private Object value;

    public ObjectValue() {
    }

    public ObjectValue(Object object) {
        this.value = object;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 285: 
            case 643: {
                return this;
            }
            case 514: {
                return BooleanValue.get(this.value == null ? false : this.value.toString().length() > 0);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        return new StringValue(this.getStringValue()).convertPrimitive(builtInAtomicType, bl, xPathContext);
    }

    public String getStringValue() {
        return this.value == null ? "" : this.value.toString();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return this.value != null;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return new ExternalObjectType(this.value.getClass(), typeHierarchy.getConfiguration());
    }

    public Object getObject() {
        return this.value;
    }

    public boolean equals(Object object) {
        return this.value.equals(((ObjectValue)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (this.value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.value.getClass())) {
            return this.value;
        }
        if (clazz == Value.class || clazz == ObjectValue.class) {
            return this;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            BooleanValue booleanValue = (BooleanValue)this.convert(514, xPathContext);
            return booleanValue.getBooleanValue();
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            DoubleValue doubleValue = (DoubleValue)this.convert(517, xPathContext);
            return new Double(doubleValue.getDoubleValue());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            DoubleValue doubleValue = (DoubleValue)this.convert(516, xPathContext);
            return new Float(doubleValue.getDoubleValue());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Long(integerValue.longValue());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Integer((int)integerValue.longValue());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Short((short)integerValue.longValue());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            IntegerValue integerValue = (IntegerValue)this.convert(532, xPathContext);
            return new Byte((byte)integerValue.longValue());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            String string = this.getStringValue();
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new DynamicError("Cannot convert string to Java char unless length is 1");
        }
        throw new DynamicError("Conversion of external object to " + clazz.getName() + " is not supported");
    }
}

