/*
 *  Copyright 2011 Wolfgang Koller - http://www.gofg.at/
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include "notification.h"
#include "../cordova.h"

#include <QApplication>
#include <QFeedbackHapticsEffect>

#include <QMediaPlayer>
#include <QMessageBox>

Notification::Notification(Cordova *cordova) : CPlugin(cordova) {
}

void Notification::beep(int scId, int ecId, int p_times) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)
    Q_UNUSED(p_times)
    QMediaPlayer* player = new QMediaPlayer;
    player->setVolume(100);
    player->setMedia(QUrl::fromLocalFile("/usr/share/sounds/ui-tones/snd_default_beep.wav"));
    player->play();
}

void Notification::vibrate(int scId, int ecId, int p_milliseconds) {
    Q_UNUSED(scId)
    Q_UNUSED(ecId)

    QFeedbackHapticsEffect *vibrate = new QFeedbackHapticsEffect;
    vibrate->setIntensity(1.0);
    vibrate->setDuration(p_milliseconds);
    connect(vibrate, SIGNAL(stateChanged()), this, SLOT(deleteEffectAtStateStopped()));
    vibrate->start();
}

void Notification::deleteEffectAtStateStopped() {
    QFeedbackEffect *effect = qobject_cast<QFeedbackEffect *>(sender());
    if (!effect)
        return;
    if (effect->state() == QFeedbackEffect::Stopped)
        effect->deleteLater();
}

void Notification::confirm(int scId, int ecId, const QString &message, const QString &title, const QStringList &buttonLabels) {
    Q_UNUSED(ecId)
    QString s1, s2, s3;
    if (buttonLabels.size() > 0)
        s1 = buttonLabels[0];
    if (buttonLabels.size() > 1)
        s2 = buttonLabels[1];
    if (buttonLabels.size() > 2)
        s3 = buttonLabels[2];
    m_cordova->confirmBox(scId, message, title, s1, s2, s3);
}

void Notification::prompt(int scId, int ecId, const QString &message, const QString &title, const QStringList &buttonLabels, const QString &defaultText) {
    Q_UNUSED(ecId)
    QString s1, s2, s3;
    if (buttonLabels.size() > 0)
        s1 = buttonLabels[0];
    if (buttonLabels.size() > 1)
        s2 = buttonLabels[1];
    if (buttonLabels.size() > 2)
        s3 = buttonLabels[2];
    m_cordova->promptBox(scId, message, title, s1, s2, s3, defaultText);
}
