/**
 *    Copyright 2011 Peter Murray-Rust et. al.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;

import nu.xom.Element;
import nu.xom.Node;

import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.base.CMLUtil;
import org.xmlcml.cml.interfacex.HasDictRef;

/**
 * user-modifiable class supporting list. * autogenerated from schema use as a
 * shell which can be edited
 *
 */
public class CMLList extends org.xmlcml.cml.element.AbstractList implements HasDictRef {

	/** namespaced element name.*/
	public final static String NS = C_E+TAG;

    /**
     * constructor.
     */
    public CMLList() {
    }

    /**
     * constructor.
     *
     * @param old
     */
    public CMLList(CMLList old) {
        super((AbstractList) old);

    }

    /**
     * copy node .
     *
     * @return Node
     */
    public Element copy() {
        return new CMLList(this);

    }

    /**
     * create new instance in context of parent, overridable by subclasses.
     *
     * @param parent
     *            parent of element to be constructed (ignored by default)
     * @return CMLList
     */
    public CMLElement makeElementInContext(Element parent) {
        return new CMLList();
    }

    /** adds the array as a column to the tableRows.
     *
     * @param tableRows
     */
    public void addColumnElementsTo(CMLElements<CMLTableRow> tableRows) {
        List<Node> nodes = CMLUtil.getQueryNodes(this, CMLConstants.S_STAR);
        if (nodes.size() != tableRows.size()) {
            throw new RuntimeException("inconsistent column size: "+
                    nodes.size()+" expected "+tableRows.size());
        }
        int j = 0;
        Class<?> classx = null;
        for (Node node : nodes) {
            if (classx == null) {
                classx = node.getClass();
            } else if (classx != node.getClass()) {
                throw new RuntimeException("incompatible classes "+
                        node.getClass() +" expected "+classx);
            }
            tableRows.get(j++).appendChild(new CMLTableCell((Element)node));
        }
    }

    /** get size of array.
     * @return size
     */
    public int getArraySize() {
        List<Node> nodeList = CMLUtil.getQueryNodes(this, CMLConstants.S_STAR);
        return nodeList.size();
    }

    /** get array elements.
     * recalcuates each time so best cached for frequent use
     * @return elements as String
     */
    public List<String> getStringValues() {
        List<Node> nodeList = CMLUtil.getQueryNodes(this, CMLConstants.S_STAR);
        List<String> stringList = new ArrayList<String>();
        for (Node node : nodeList) {
            stringList.add(node.getValue());
        }
        return stringList;
    }
}
