# CiviCRM 5.20.0

Released December 4, 2019

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| **Fix security vulnerabilities?**                               | **yes** |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="security"></a>Security advisories

- **[CIVI-SA-2019-24](https://civicrm.org/advisory/civi-sa-2019-24-csrf-in-apiv4-ajax-end-point): Cross-site request forgery in APIv4 AJAX endpoint**

## <a name="features"></a>Features

### Core CiviCRM

- **Replace complex logic in email templates with simple logic on billing name
  and credit card
  ([dev/core#1344](https://lab.civicrm.org/dev/core/issues/1344):
  [15653](https://github.com/civicrm/civicrm-core/pull/15653),
  [15688](https://github.com/civicrm/civicrm-core/pull/15688),
  [15646](https://github.com/civicrm/civicrm-core/pull/15646),
  [15651](https://github.com/civicrm/civicrm-core/pull/15651),
  [15682](https://github.com/civicrm/civicrm-core/pull/15682) and
  [15680](https://github.com/civicrm/civicrm-core/pull/15680))**

  The Billing Name and Address and Credit Card Information sections are now
  included when the billing name and credit card type fields are available,
  respectively.  This replaces template-based logic regarding the payment
  method, amount, waitlist status, and more with the logic used when collecting
  and processing this information.

- **Contact Display Name vs Email Greeting in Workflow templates
  ([dev/core#781](https://lab.civicrm.org/dev/core/issues/781):
  [15491](https://github.com/civicrm/civicrm-core/pull/15491))**

  This ensures all standard workflow message templates use the contact's email
  greeting. Before this change some standard workflow message templates used a
  hard-coded "Dear" followed by the display name.

- **Workflow templates - Update 'Thank You' & other text corrections
  ([dev/core#1316](https://lab.civicrm.org/dev/core/issues/1316):
  [15749](https://github.com/civicrm/civicrm-core/pull/15749),
  [15745](https://github.com/civicrm/civicrm-core/pull/15745),
  [15503](https://github.com/civicrm/civicrm-core/pull/15503) and
  [15751](https://github.com/civicrm/civicrm-core/pull/15751))**

  Improves grammar and readability of the standard workflow templates.

- **Workflow templates - Include displayname in subject
  ([dev/core#1320](https://lab.civicrm.org/dev/core/issues/1320):
  [15513](https://github.com/civicrm/civicrm-core/pull/15513))**

  This adds a contact's display name to the subject of some workflow templates
  to make them more personal, less likely to be grouped together by email
  clients, and more likely to be opened.

- **Replace Open Flash Charts with charts that work
  ([15448](https://github.com/civicrm/civicrm-core/pull/15448),
  [268](https://github.com/civicrm/civicrm-packages/pull/268),
  [267](https://github.com/civicrm/civicrm-packages/pull/267) and
  [15493](https://github.com/civicrm/civicrm-core/pull/15493))**

  These changes move CiviCRM charts to use dc.js (which is based upon
  Crossfilter and D3.js) instead of the outdated Open Flash Chart library.

- **Add freeform relative date for 'This Fiscal Year'
  ([14894](https://github.com/civicrm/civicrm-core/pull/14894))**

  Adds support for freeform relative dates (this_n.year & this_n.fiscal_year).
  To utilize this new functionality administrators must add an option value to
  the `relative_date_filters` option group.

- **Remove the sentence: "Please print this page for your records." from the
  various CiviCRM tpls
  ([dev/core#371](https://lab.civicrm.org/dev/core/issues/371):
  [15467](https://github.com/civicrm/civicrm-core/pull/15467))**

  Removes the text "Print for your records" to discourage people from wasting
  paper.

- **Remove Print Icon
  ([15322](https://github.com/civicrm/civicrm-core/pull/15322))**

  This removes the print icon from the upper left hand corner of all pages.  The
  icon generally linked to a version of the page stripped of styling, but
  printing the page through the browser's normal print command nearly always
  looks better.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  (Work towards [dev/core#560](https://lab.civicrm.org/dev/core/issues/560):
  [15608](https://github.com/civicrm/civicrm-core/pull/15608) and
  [15623](https://github.com/civicrm/civicrm-core/pull/15623))**

  Works towards throwing exceptions (instead of fatal errors) in
  several places including if aborting because if a type of a param error.

- **Make relationship description searchable
  ([dev/core#1257](https://lab.civicrm.org/dev/core/issues/1257):
  [15358](https://github.com/civicrm/civicrm-core/pull/15358))**

  Exposes the relationship description field to the advanced search form.

- **Add in method to allow extensions to opt out of using temporary table when
  building ACL Contact Cache
  ([15701](https://github.com/civicrm/civicrm-core/pull/15701))**

  Adds in getter and setter functions and a static class variable to
  determine if a temporary table should be used when building the ACL contact
  Cache

- **Re-arrange change log advanced search panel so both modified fields are next
  to each other ([15712](https://github.com/civicrm/civicrm-core/pull/15712))**

  This switches the modified date and changed date to appear in the reverse
  order in order to improve the appearance.

- **Schema changes for PaymentProcessor and PaymentProcessorType to support
  apiv4 entities ([15733](https://github.com/civicrm/civicrm-core/pull/15733))**

  Begins work to add `PaymentProcesor` and `PaymentProcessorType` entities to
  APIv4.

- **Remove CIVICRM_SUPPORT_MULTIPLE_LOCKS and make it always enabled if
  available ([15604](https://github.com/civicrm/civicrm-core/pull/15604))**

  Makes `CIVICRM_SUPPORT_MULTIPLE_LOCKS` turned on by default so that by default
  sites can use multiple locks on modern versions of MySQL/MariaDB.

- **Add help text to payment processor subject field
  ([15590](https://github.com/civicrm/civicrm-core/pull/15590))**

  Improves consistency by adding a help icon to the subject field on the
  "Settings - Payment Processor" form (CiviCRM Admin bar -> Adminster -> System
  Settings -> Payment Processors add or edit a payment processor).

- **Generic Settings Pages: Make getSettingPageFilter() public so we can use it
  in hooks ([15576](https://github.com/civicrm/civicrm-core/pull/15576))**

  Makes the `_filter` property available in hooks so extension developers can
  use it.

- **Update api3 explorer url path for consistency
  ([15597](https://github.com/civicrm/civicrm-core/pull/15597))**

  Changes the path to access the Api3 explorer to `civicrm/api3` so that it
  is consistent with `civicrm/api4`, `civicrm/api` now redirects to
  `civicrm/api3`.

- **Improvements to copying events and contribution pages
  ([15144](https://github.com/civicrm/civicrm-core/pull/15144))**

  Ensures when an admin copies an event or contribution page the current user ID
  and time are stored in the `created_date` and `created_id` fields.
  Additionally, ensures when copying a contribution page the user is
  redirected to the 'edit' screen for the newly copied page.

- **Allow custom ts functions in extensions; defer custom ts calls until booted
  ([15411](https://github.com/civicrm/civicrm-core/pull/15411))**

  Makes it possible for developers to write custom translate functions in
  extensions.

- **Update Sending Emails section of configuration checklist
  ([dev/core#1278](https://lab.civicrm.org/dev/core/issues/1278):
  [15359](https://github.com/civicrm/civicrm-core/pull/15359))**

  Improves the readability of the "Sending Emails" section of the configuration
  checklist.

- **Support street address sorting for contact detail report
  ([15581](https://github.com/civicrm/civicrm-core/pull/15581))**

  Improves the "Contact Detail" report template by making it possible to sort by
  "Street Address".

### CiviCase

- **Unable to use url search arguments in 'Advanced Search' using force=1 (Work
  Towards [dev/core#692](https://lab.civicrm.org/dev/core/issues/692):
  [15370](https://github.com/civicrm/civicrm-core/pull/15370))**

  Improves the "Find Cases" form's ability to accept url arguments.

- **Convert case activity links to 'actionLinks'
  ([14349](https://github.com/civicrm/civicrm-core/pull/14349))**

  Converts Case activity links to use actionLinks so they can be accessed by
  extension developers using the hook `hook_civicrm_links`.

- **Format details for case custom data activity in a human readable format
  ([13365](https://github.com/civicrm/civicrm-core/pull/13365))**

  Improves readability of the activity details saved to case "Change Custom
  Data" activities.

### CiviContribute

- **Payment processor names: separate internal and external usage
  ([dev/financial#2](https://lab.civicrm.org/dev/financial/issues/2):
  [15418](https://github.com/civicrm/civicrm-core/pull/15418),
  [15497](https://github.com/civicrm/civicrm-core/pull/15497),
  [15617](https://github.com/civicrm/civicrm-core/pull/15617) and
  [15632](https://github.com/civicrm/civicrm-core/pull/15632))**

  Adds a new field "Payment Processor Title" to the "Edit Payment Processor"
  form if configured the title will appear on front end forms. This allows
  administrators to configure internal and external names for payment
  processors. For example, internally a payment processor may be called "Action
  Fund - Stripe" while externally It may use the label "Credit Card". Ensures
  that the front end title of the payment processor is used in receipts when
  available.

- **Payments - Where do we store IDs from payment processor?
  ([dev/financial#57](https://lab.civicrm.org/dev/financial/issues/57):
  [15468](https://github.com/civicrm/civicrm-core/pull/15468))**

  Adds an `order_reference` field to `civicrm_financial_trxn` table. The
  `order_reference` field is intended to hold the payment processor provided
  external reference to an order / invoice (when applicable/possible).

- **New methodology for storing template contributions (Work towards
  [dev/financial#72](https://lab.civicrm.org/dev/financial/issues/72):
  [15472](https://github.com/civicrm/civicrm-core/pull/15472),
  [15470](https://github.com/civicrm/civicrm-core/pull/15470),
  [15550](https://github.com/civicrm/civicrm-core/pull/15550),
  [15431](https://github.com/civicrm/civicrm-core/pull/15431),
  [15456](https://github.com/civicrm/civicrm-core/pull/15456),
  [15433](https://github.com/civicrm/civicrm-core/pull/15433) and
  [15419](https://github.com/civicrm/civicrm-core/pull/15419))**

  Moves towards a new methodology for storing template contributions by: using a
  standard function to create contribution status dropdowns for batch
  contribution entry and the batch pending contribution status update task, adds
  a new contribution status "Template", adds an `is_template` field to
  contributions. Adds some logic surrounding pulling Contributions templates
  using the new `is_template` field.

- **PaymentProcessor.pay should handle 'invoice_id' & map it to a getter so
  processors can retrieve it
  ([dev/financial#77](https://lab.civicrm.org/dev/financial/issues/77):
  [15639](https://github.com/civicrm/civicrm-core/pull/15639))**

  Makes `contribution_id` required when calling the `PaymentProcessor.pay` API.

- **Order.create should not require total amount
  ([dev/financial#73](https://lab.civicrm.org/dev/financial/issues/73):
  [15501](https://github.com/civicrm/civicrm-core/pull/15501))**

  Updates the Order.create API to require `total_amount` OR `line_items` instead
  of solely requiring `total_amount`.

- **Order api updates to fix participant handling & deprecate creating
  'completed ([15514](https://github.com/civicrm/civicrm-core/pull/15514))**

  Improves the Order api by making it so status is no longer required for
  creating participants and creating completed orders is deprecated.

- **Develop getter & setter structure for Payment classes (Work towards
  [dev/financial#82](https://lab.civicrm.org/dev/financial/issues/82):
  [15707](https://github.com/civicrm/civicrm-core/pull/15707) and
  [15509](https://github.com/civicrm/civicrm-core/pull/15509))**

  Begins work to refactor how CRM_Core_Payment works so that `doPayment` accepts
  a consistent defined set of variables.

- **Contribution Summary report only shows first 50 entries
  ([dev/core#1252](https://lab.civicrm.org/dev/core/issues/1252):
  [15528](https://github.com/civicrm/civicrm-core/pull/15528))**

  Adds support for paging on the Contribution Summary Report.

- **Provide precautionary handling for theoretical error scenario.
  ([15748](https://github.com/civicrm/civicrm-core/pull/15748))**

  Provides protection against fatal errors when adding payments if
  `financial_items` have not been created.

- **Support chaining Payment.create from Order api
  ([15548](https://github.com/civicrm/civicrm-core/pull/15548))**

  Adds support to chain a `Payment.create` call from an `Order.create` api call.

- **Translate two string in AdditionalPayment form
  ([15577](https://github.com/civicrm/civicrm-core/pull/15577))**

  Translates two strings on the Additional Payment form.

### WordPress Integration

- **Switch WP over to new installer
  ([dev/wordpress#37](https://lab.civicrm.org/dev/wordpress/issues/37):
  [165](https://github.com/civicrm/civicrm-wordpress/pull/165))**

  Improves the CiviCRM installation process for WordPress sites by redirecting
  users to an install screen when the CiviCRM plugin is activated.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Add support for bulkcreates (Work towards
  [dev/core#1093](https://lab.civicrm.org/dev/core/issues/1093):
  [15599](https://github.com/civicrm/civicrm-core/pull/15599))**

  Fixes a fatal error when updating a custom field with logging enabled.

- **Attachment API for event custom field gives: Failed to run Permissions
  checks ([dev/core#1205](https://lab.civicrm.org/dev/core/issues/1205):
  [15580](https://github.com/civicrm/civicrm-core/pull/15580))**

  Fixes a bug where using the Attachment API for a custom file field would fail
  with a permission denied error.

- **Email Processor drops the other attachments if there's more than 3
  ([dev/core#1270](https://lab.civicrm.org/dev/core/issues/1270):
  [15438](https://github.com/civicrm/civicrm-core/pull/15438))**

  Fixes a bug where the email processor would drop attachments if there were
  more attachments in the incoming email than the limit set at system settings -
  misc.

- **Fix CSS for public select2 elements regardless of parent theme box-size
  ([15442](https://github.com/civicrm/civicrm-core/pull/15442))**

  Fixes the height of select2 boxes (so that they do not appears squished) on
  front facing forms across CMS's and browsers.

- **CiviCRM Dashboard does not respect multiple domains
  ([dev/core#1200](https://lab.civicrm.org/dev/core/issues/1200):
  [15283](https://github.com/civicrm/civicrm-core/pull/15283))**

  Ongoing fixes for the CiviCRM Dashboard when using multiple Domains.

- **Warning: array_key_exists(): The first argument should be either a string or
  an integer in CRM_Contact_Form_Search::getModeValue()
  ([dev/core#1347](https://lab.civicrm.org/dev/core/issues/1347):
  [15650](https://github.com/civicrm/civicrm-core/pull/15650))**

  Fixes a php warning on the advanced search form when opening some accordions.

- **Report improvements
  ([CRM-21677](https://issues.civicrm.org/jira/browse/CRM-21677):
  [15567](https://github.com/civicrm/civicrm-core/pull/15567))**

  Removes redundant gender evaluation code from the Case Demographic Report
  template.

- **Re-installation of Extension With Custom Fields and Logging Enabled Causes
  Error ([dev/core#1383](https://lab.civicrm.org/dev/core/issues/1383):
  [15816](https://github.com/civicrm/civicrm-core/pull/15816))**

- **Php 7.3 fix - don't mis-use continue
  ([15737](https://github.com/civicrm/civicrm-core/pull/15737))**

  Fixes some php warnings regarding using continue where break would be
  preferable for sites running PHP 7.3.

- **Allow regen.sh to work with either upper/lower case for CMS name to match
  elsewhere ([15647](https://github.com/civicrm/civicrm-core/pull/15647))**

  Ensures regen.sh works with both Proper and lower case CMS names.

- **Make sure labels match the actual date input format
  ([15520](https://github.com/civicrm/civicrm-core/pull/15520))**

  Ensures the labels of the date input format dropdown (under
  `/civicrm/admin/setting/date`) match the actual value of the formats.

- **Can't search for activity subjects starting with 1 - and many more caching
  issues ([dev/core#1411](https://lab.civicrm.org/dev/core/issues/1411):
  [15918](https://github.com/civicrm/civicrm-core/pull/15918))**

  The query to fill the SQL cache would fail in a variety of cases, either
  returning no results or running a fresh, uncached set of results.

- **Fix fatal error when sorting by status in activity search
  ([15923](https://github.com/civicrm/civicrm-core/pull/15923))**

- **E Notice 'info' Extension.php:248 -> When installing via cv
  ([dev/core#1371](https://lab.civicrm.org/dev/core/issues/1371):
  [15762](https://github.com/civicrm/civicrm-core/pull/15762))**

- **Reports show "&nbsp;" in filters with child-groups
  ([dev/core#826](https://lab.civicrm.org/dev/core/issues/826):
  [15293](https://github.com/civicrm/civicrm-core/pull/15293))**

- **Upgrade failure with 5.19 involving interaction between APIv4 and extensions
  ([dev/core#1376](https://lab.civicrm.org/dev/core/issues/1376):
  [15765](https://github.com/civicrm/civicrm-core/pull/15765))**

- **Fixing a fatal error when installing extensions with Option Values defined
  in XML ([15643](https://github.com/civicrm/civicrm-core/pull/15643))**

- **Civi\Core\Container - Fix warning about Symfony 3=>4 and boot services
  ([15704](https://github.com/civicrm/civicrm-core/pull/15704))**

- **Customfields attached to addresses break the profile page
  ([dev/core#1324](https://lab.civicrm.org/dev/core/issues/1324):
  [15541](https://github.com/civicrm/civicrm-core/pull/15541))**

- **Fix bug in SQL queue that can cause tasks to be run twice in a
  multiprocess environment
  ([15421](https://github.com/civicrm/civicrm-core/pull/15421))**

- **Fixes an issue where the two arrays weren't always being merged correctly
  ([15482](https://github.com/civicrm/civicrm-core/pull/15482))**

- **Fix error when adding activities from Search Builder
  ([15522](https://github.com/civicrm/civicrm-core/pull/15522))**

- **Do no invoke Hooks via UF unless container has been built or it is a hook
  designed to run without container being built
  ([15339](https://github.com/civicrm/civicrm-core/pull/15339))**

- **Ensure front-end hooks are only registered on main query
  ([166](https://github.com/civicrm/civicrm-wordpress/pull/166))**

- **Fix E_NOTICE for is_required in address form
  ([15423](https://github.com/civicrm/civicrm-core/pull/15423))**

- **Customfields of type Multiselect attached to an Address do not render in
  profile page (appear empty)
  ([dev/core#1282](https://lab.civicrm.org/dev/core/issues/1282):
  [15375](https://github.com/civicrm/civicrm-core/pull/15375) and
  [15638](https://github.com/civicrm/civicrm-core/pull/15638))**

- **Upgrade to CiviCRM 5.20.beta fails because of MessageTemplate error
  ([marketing/civicrm-website#163](https://lab.civicrm.org/marketing/civicrm-website/issues/163):
  [15844](https://github.com/civicrm/civicrm-core/pull/15844))**

  This change allows the upgrade process to sidestep missing system workflow
  message templates rather than failing when trying to update them.

- **Link to docs.civicrm.org instead of wiki
  ([15973](https://github.com/civicrm/civicrm-core/pull/15973))**

  Outdated links to the old CiviCRM wiki that appear in upgrade messages have
  been replaced with links to the current user documentation.

- **Ensure that Relative key is not added for non Select Date is_search_range
  custom fields ([15977](https://github.com/civicrm/civicrm-core/pull/15977) and
  [16002](https://github.com/civicrm/civicrm-core/pull/16002))**

### CiviCase

- **Fix longstanding name vs label problems for case roles
  ([dev/core#1046](https://lab.civicrm.org/dev/core/issues/1046):
  [15556](https://github.com/civicrm/civicrm-core/pull/15556),
  [15483](https://github.com/civicrm/civicrm-core/pull/15483), and
  [15939](https://github.com/civicrm/civicrm-core/pull/15939))**

  Case roles are now defined in case types as relationship type names instead of
  labels.  This fixes a variety of bugs for CiviCRM instances with case roles
  that rely on relationships where the label does not match the name.  A new
  system check will alert administrators if case types stored in XML files need
  to be edited.

- **Saving a case type can give a php warning, but the warning is more hidden
  than usual so it seems like everything is ok
  ([dev/core#1335](https://lab.civicrm.org/dev/core/issues/1335):
  [15554](https://github.com/civicrm/civicrm-core/pull/15554))**

  Prevents a php warning "htmlspecialchars() expects parameter 1 to be string,
  array given" when saving case type.

- **Reinstate Case ID search field
  ([15935](https://github.com/civicrm/civicrm-core/pull/15935))**

  This resolves a regression in 5.20.beta where the case search lacked a case ID
  field.

- **Upgrade script to flip autoassignees using bidirectional relationship in
  older civicase configs
  ([15542](https://github.com/civicrm/civicrm-core/pull/15542))**

   Fixes a visual display issue for sites with configured activity autoassignees
   in a CiviCase timeline using "by relationship" with a bidirectional
   relationship (e.g. sibling) prior to 5.16 . Specifically, sites with this
   setup will see a blank on the case type edit screen. It doesn't affect
   operation, and saving the case type doesn't lose any info, but it's a visual
   confusion. This upgrade script flips the a's and b's for those settings.

- **Minor a_b/b_a mixup on case type edit screen
  ([15412](https://github.com/civicrm/civicrm-core/pull/15412))**

- **Print Merge document from case search doesn't file on correct contact.
  ([dev/core#893](https://lab.civicrm.org/dev/core/issues/893):
  [15626](https://github.com/civicrm/civicrm-core/pull/15626))**

- **Ensure that using case_start_date_high and case_start_date_low etc in url
  variables works in force=1 mode
  ([15619](https://github.com/civicrm/civicrm-core/pull/15619))**

- **Minimal fix for new enotice on case.subject
  ([15616](https://github.com/civicrm/civicrm-core/pull/15616))**

- **Clicking on a contact's cases tab gives Network Error Unable to reach the
  server ([dev/core#1381](https://lab.civicrm.org/dev/core/issues/1381):
  [15804](https://github.com/civicrm/civicrm-core/pull/15804))**

### CiviContribute

- **Respect calling code passing in 'null'  for creditnote_id.
  ([15232](https://github.com/civicrm/civicrm-core/pull/15232))**

  Fixes an issue where the contribution BAO disregards 'null' when passed in for
  'credit_note_id'.

- **Change test to use preferred methods, fix revealed money bug
  ([15622](https://github.com/civicrm/civicrm-core/pull/15622))**

  Ensures that Payment.create cleans the `total_amount` field like
  Contribution.create.

- **Membership and Event Related Contributions - shows all contributions
  ([dev/core#1435](https://lab.civicrm.org/dev/core/issues/1435):
  [16013](https://github.com/civicrm/civicrm-core/pull/16013))**

  This resolves a regression when viewing a membership or participant record
  where the related contributions show all contributions, not those related to
  the record.

- **Fix cancel payment action to reverse financial items related to cancelled
  payment ([15630](https://github.com/civicrm/civicrm-core/pull/15630))**

  Fixes a bug where the `financial_entity_trxn` entries associated with a
  canceled payment were not being reversed as they should have been.

- **Missing Financial type and Credit Account Code in Bookkeeping Transaction
  Report (Work towards
  [dev/financial#40](https://lab.civicrm.org/dev/financial/issues/40):
  [15740](https://github.com/civicrm/civicrm-core/pull/15740))**

  Fixes an issue whereby `civicrm_entity_financial_trxn` records for the
  `civicrm_financial_item` table were not created when refunding against line
  items with a quantity of zero - i.e. where there were selected check boxes &
  they were reversed.

- **Deprecate Contribute.transact api
  ([dev/financial#79](https://lab.civicrm.org/dev/financial/issues/79):
  [15564](https://github.com/civicrm/civicrm-core/pull/15564),
  [15591](https://github.com/civicrm/civicrm-core/pull/15591) and
  [15504](https://github.com/civicrm/civicrm-core/pull/15504))**

  Marks the `Contribute.transact` as deprecated in the API explorer, adds a
  noisy deprecation warning to Contribute.transact and moves it to its own file.

- **Cleanup date handling on Payment.create
  ([15687](https://github.com/civicrm/civicrm-core/pull/15687))**

  Ensures that adding a payment on the `AdditionalPaymentForm` does not change
  the Contribution `receive_date`.

- **Ensure contributionRecurID is set on processor
  ([15673](https://github.com/civicrm/civicrm-core/pull/15673))**

  Ensures that `contributionRecurID` is available to payment processors that
  need it in `cancelSubscription`.

- **fix 'balance due' on Pledge Detail for non-US installs
  ([15543](https://github.com/civicrm/civicrm-core/pull/15543))**

  Fixes a bug where the Pledge Detail report crashed when "Balance Due" was
  selected and the label of either of the pledge statuses "Completed" or
  "Canceled" had been modified.

- **Record Refund fails due to thousands separator in amount
  ([dev/core#1409](https://lab.civicrm.org/dev/core/issues/1409):
  [15889](https://github.com/civicrm/civicrm-core/pull/15889))**

  This bug was sidestepped by removing the Net Amount field on the Record Refund
  form.

- **Incorrect allocation of payment on an edited multi-line item event
  registration
  ([dev/financial#34](https://lab.civicrm.org/dev/financial/issues/34):
  [14763](https://github.com/civicrm/civicrm-core/pull/14763))**

- **Incorrect Allocation of refunded line items on Multi Event Registrations
  ([dev/financial#94](https://lab.civicrm.org/dev/financial/issues/94):
  [15664](https://github.com/civicrm/civicrm-core/pull/15664))**

- **Conditionally add contribution metadata for advanced search only if the user
  has access to CiviContribute
  ([15966](https://github.com/civicrm/civicrm-core/pull/15966))**

- **Fix ambiguous column in Contribution Search query with ORDER BY
  ([15899](https://github.com/civicrm/civicrm-core/pull/15899))**

  This fixes an issue where columns whose names are not unique in the underlying
  query of a search cause a database error when they're used as a sort column.

- **Custom Search: Find Contributors by Aggregate Totals does not return results
  if 'Choose date range' is selected and end date is empty
  ([dev/core#1297](https://lab.civicrm.org/dev/core/issues/1297):
  [15415](https://github.com/civicrm/civicrm-core/pull/15415))**

- **Custom Search: Search actions broken on Find Contributors by Aggregate
  Totals ([dev/core#1377](https://lab.civicrm.org/dev/core/issues/1377):
  [15873](https://github.com/civicrm/civicrm-core/pull/15873))**

- **Fix Sybunt to select mark rows as selected
  ([15872](https://github.com/civicrm/civicrm-core/pull/15872))**

  This resolves a bug where checking result rows on the SYBUNT custom search
  would not actually select them or increment the "selected" count of rows.

- **Remove unhelpful alert from contribution search
  ([15787](https://github.com/civicrm/civicrm-core/pull/15787))**

  This removes the "We did not recognize the search field..." warning that would
  appear when searching on certain fields even as the search would accurately
  filter on the field's value.

- **Save & Next button on Contribution Page Widgets tab does not move user to
  next step ([dev/core/1266](https://lab.civicrm.org/dev/core/issues/1266):
  [15323](https://github.com/civicrm/civicrm-core/pull/15323))**

- **Fix parameters for statusBounce in AdditionalPayment
  ([15579](https://github.com/civicrm/civicrm-core/pull/15579))**

- **Fix deprecation warning on Price Set report
  ([15952](https://github.com/civicrm/civicrm-core/pull/15952))**

- **RepeatTransaction API incorrectly calculates the total amount when recur
  payment has tax amount.
  ([dev/core#1317](https://lab.civicrm.org/dev/core/issues/1317):
  [15517](https://github.com/civicrm/civicrm-core/pull/15517))**

- **Incorrect line items recorded with contribution repeattransaction api.
  ([dev/core#1367](https://lab.civicrm.org/dev/core/issues/1367):
  [15735](https://github.com/civicrm/civicrm-core/pull/15735))**

- **Contribution Detail Report gives incorrect results when `force=1`
  ([dev/report#20](https://lab.civicrm.org/dev/report/issues/20):
  [15315](https://github.com/civicrm/civicrm-core/pull/15315))**

- **Fix typo in parameter description for PaymentProcessor.pay
  ([15476](https://github.com/civicrm/civicrm-core/pull/15476))**

- **Fix Payment.create with a negative value to create the correct financial
  items ([15705](https://github.com/civicrm/civicrm-core/pull/15705))**

- **Fix Payment.create bug whereby payment_processor_id is not being used for
  the to_account_id
  ([15640](https://github.com/civicrm/civicrm-core/pull/15640))**

- **Fix  bug whereby cidZero does not prepopulate billing details for selected
  contact for pay later.
  ([15565](https://github.com/civicrm/civicrm-core/pull/15565))**

- **Contribution Dashboard still uses broken Open Flash Charts
  ([dev/core#1309](https://lab.civicrm.org/dev/core/issues/1309):
  [15474](https://github.com/civicrm/civicrm-core/pull/15474))**

- **Fix 5.20 regression on retrieving template transaction with no logged in
  user ([15976](https://github.com/civicrm/civicrm-core/pull/15976))**

### CiviEvent

- **Event Participants actions (Print Name Badges, Export...) ignores search
  criteria ([dev/core#1422](https://lab.civicrm.org/dev/core/issues/1422):
  [15962](https://github.com/civicrm/civicrm-core/pull/15962))**

  This resolves an issue where the action would be based upon all participants
  of all events rather than all of the results of the current search.

- **Fix loading of profile fields on additional participant form
  ([15698](https://github.com/civicrm/civicrm-core/pull/15698))**

  Fixes a bug where no profile fields were loaded on the additional participant
  form of an Online Registration form configured to accept multiple
  participants.

- **Fix logic determining whether (masked) credit card details are displayed in
  event online receipts
  ([15532](https://github.com/civicrm/civicrm-core/pull/15532))**

  Fixes Event online receipts to display credit card info if available.

### CiviGrant

- **Grant in Edit mode doesn't show the associated contact and standardize all
  screens accordingly.
  ([dev/core#1065](https://lab.civicrm.org/dev/core/issues/1065):
  [15362](https://github.com/civicrm/civicrm-core/pull/15362),
  [15321](https://github.com/civicrm/civicrm-core/pull/15321) and
  [15744](https://github.com/civicrm/civicrm-core/pull/15744))**

### CiviMail

- **Add in unit test for namespaced fields in mailing reports and also fix issue
  where by mailing_name has been namespaced also in 5.20 (Follow-up to
  [dev/mail#56](https://lab.civicrm.org/dev/mail/issues/56) and
  [dev/mail#57](https://lab.civicrm.org/dev/mail/issues/57):
  [15782](https://github.com/civicrm/civicrm-core/pull/15782))**

### CiviMember

- **Duplicated inherited membership with multiple relationships when adding a
  new relationship
  ([dev/core#1361](https://lab.civicrm.org/dev/core/issues/1361):
  [15731](https://github.com/civicrm/civicrm-core/pull/15731))**

  Fixes a bug where duplicate inherited relationships were being created for the
  same membership.

- **Agile fixFix inherited membership being deleted when there is still a valid
  relationship
  ([15062](https://github.com/civicrm/civicrm-core/pull/15062))**

  Fixes a bug where contacts with two or more relationships to a member contact
  would lose their inherited relationship if one of their other relationships
  was deleted.

- **Unable to edit the membership end date for members that have a recurring
  payment ([dev/core#1126](https://lab.civicrm.org/dev/core/issues/1126):
  [15540](https://github.com/civicrm/civicrm-core/pull/15540))**

### Backdrop Integration

- **Backdrop support for adding roles and perms
  ([infra/ops#906](https://lab.civicrm.org/infra/ops/issues/906):
  [15571](https://github.com/civicrm/civicrm-core/pull/15571))**

  Ensures that one can build a Backdrop/CiviCRM site with a demo user with
  the permissions expected of a demo user.

### WordPress Integration

- **Reinstate traversal as "method of last resort" to find WordPress (Follow-up
  from [dev/core#1412](https://lab.civicrm.org/dev/core/issues/1412):
  [15929](https://github.com/civicrm/civicrm-core/pull/15929))**

  This restores code removed in 5.19.3 to resolve the location of the CiviCRM
  code in WordPress, only executing it as a fallback method if the new method
  fails.

## <a name="misc"></a>Miscellany

- **Replace jcalendar instances with datepicker
  ([dev/core#561](https://lab.civicrm.org/dev/core/issues/561):
  [15661](https://github.com/civicrm/civicrm-core/pull/15661),
  [15677](https://github.com/civicrm/civicrm-core/pull/15677),
  [15694](https://github.com/civicrm/civicrm-core/pull/15694),
  [15671](https://github.com/civicrm/civicrm-core/pull/15671),
  [15637](https://github.com/civicrm/civicrm-core/pull/15637),
  [15633](https://github.com/civicrm/civicrm-core/pull/15633),
  [15614](https://github.com/civicrm/civicrm-core/pull/15614),
  [15710](https://github.com/civicrm/civicrm-core/pull/15710),
  [15719](https://github.com/civicrm/civicrm-core/pull/15719),
  [15618](https://github.com/civicrm/civicrm-core/pull/15618),
  [15636](https://github.com/civicrm/civicrm-core/pull/15636),
  [15693](https://github.com/civicrm/civicrm-core/pull/15693),
  [15711](https://github.com/civicrm/civicrm-core/pull/15711),
  [15702](https://github.com/civicrm/civicrm-core/pull/15702) and
  [15635](https://github.com/civicrm/civicrm-core/pull/15635))**

- **Api support for deduping (Code cleanup in preparation for
  [dev/core#1230](https://lab.civicrm.org/dev/core/issues/1230):
  [15184](https://github.com/civicrm/civicrm-core/pull/15184))**

- **group.get API (v3) fails to find groups of one group_type if group has
  multiple types (Test for
  [dev/core#1321](https://lab.civicrm.org/dev/core/issues/1321):
  [15546](https://github.com/civicrm/civicrm-core/pull/15546))**

- **composer.{json,lock} - Make the "tplaner/when" exception for old PHP
  reproducible ([15732](https://github.com/civicrm/civicrm-core/pull/15732))**

- **Add in xkerman/restricted-unserialize package
  ([15730](https://github.com/civicrm/civicrm-core/pull/15730))**

- **INTL_IDNA_VARIANT_2003 deprecated in PHP_7.2
  ([266](https://github.com/civicrm/civicrm-packages/pull/266))**

- **Extract contribution search functions to help with case search improvements
  ([15373](https://github.com/civicrm/civicrm-core/pull/15373))**

- **Further cleanup and clarification on MembershipPayment
  ([15407](https://github.com/civicrm/civicrm-core/pull/15407))**

- **The loop doth process too much, methinks
  ([15473](https://github.com/civicrm/civicrm-core/pull/15473))**

- **[Membership-backoffice] Reduce reliance on multiple specific but confusing
  class variables
  ([14919](https://github.com/civicrm/civicrm-core/pull/14919))**

- **Simplify logic for displaying card details for Event online registration
  Confirm, Thankyou page
  ([15533](https://github.com/civicrm/civicrm-core/pull/15533))**

- **Fix typo in Manager.php
  ([15518](https://github.com/civicrm/civicrm-core/pull/15518))**

- **Update my organisation
  ([15469](https://github.com/civicrm/civicrm-core/pull/15469))**

- **Combine IF clause for readability.
  ([15568](https://github.com/civicrm/civicrm-core/pull/15568))**

- **Switch creation of ParticipantPayment to use API
  ([15500](https://github.com/civicrm/civicrm-core/pull/15500))**

- **Remove when package from packages
  ([264](https://github.com/civicrm/civicrm-packages/pull/264))**

- **Cast result of getContributionBalance to float to match comment block.
  ([15621](https://github.com/civicrm/civicrm-core/pull/15621))**

- **Remove obsolete supportStorageOfAccents() method.
  ([15589](https://github.com/civicrm/civicrm-core/pull/15589))**

- **Upgrade When package to the lastest version
  ([15223](https://github.com/civicrm/civicrm-core/pull/15223))**

- **Api4 explorer: Fix variable leaking to global scope
  ([15615](https://github.com/civicrm/civicrm-core/pull/15615))**

- **Improve metadata support for table civicrm_mailing_job in search
  ([15634](https://github.com/civicrm/civicrm-core/pull/15634))**

- **Change parent class on mailing_form
  ([15629](https://github.com/civicrm/civicrm-core/pull/15629))**

- **Add uniquenames for mailing_name, mailing_job_status
  ([15652](https://github.com/civicrm/civicrm-core/pull/15652))**

- **Add getQillValue fn to generalise qill string construct
  ([15667](https://github.com/civicrm/civicrm-core/pull/15667))**

- **Remove scriptFee & scriptArray params
  ([dev/event#19](https://lab.civicrm.org/dev/event/issues/19):
  [15679](https://github.com/civicrm/civicrm-core/pull/15679))**

- **Fix the relationship direction in testSingleMembershipForTwoRelationships
  ([15738](https://github.com/civicrm/civicrm-core/pull/15738))**

- **Remove recordPayment function.
  ([15684](https://github.com/civicrm/civicrm-core/pull/15684))**

- **Eliminate silly parameter
  ([15723](https://github.com/civicrm/civicrm-core/pull/15723))**

- **Use Yes-No radio instead of checkbox on search form.
  ([15669](https://github.com/civicrm/civicrm-core/pull/15669))**

- **Cleanup following smart group conversions and fix the old name of the
  relationship date relative fields for conversion and add a unit test
  ([15648](https://github.com/civicrm/civicrm-core/pull/15648))**

- **Remove a redundant call to formatParamsForPaymentProcessor in
  AdditionalPayment form
  ([15578](https://github.com/civicrm/civicrm-core/pull/15578))**

- **Remove extraneous full stop, line
  ([15531](https://github.com/civicrm/civicrm-core/pull/15531))**

- **Remove early return on joinTable
  ([15721](https://github.com/civicrm/civicrm-core/pull/15721))**

- **Remove unused, hidden subsystem for "persistent DB tpl strings"
  ([15660](https://github.com/civicrm/civicrm-core/pull/15660))**

- **Fix test setup Function to use order api
  ([15620](https://github.com/civicrm/civicrm-core/pull/15620))**

- **Delete mkdocs.yml
  ([15658](https://github.com/civicrm/civicrm-core/pull/15658))**

- **[NFC] minor simplification
  ([15425](https://github.com/civicrm/civicrm-core/pull/15425))**

- **[NFC] code formatting
  ([15424](https://github.com/civicrm/civicrm-core/pull/15424))**

- **[NFC] dev/core#1046 - minor consistency change
  ([15486](https://github.com/civicrm/civicrm-core/pull/15486))**

- **[NFC] dev/core#1046 - more accurate column heading
  ([15485](https://github.com/civicrm/civicrm-core/pull/15485))**

- **[NFC] comments tidy up …
  ([15607](https://github.com/civicrm/civicrm-core/pull/15607))**

- **[NFC] dev/core#1336 Update doc blocks for various ACL related functions
  ([15603](https://github.com/civicrm/civicrm-core/pull/15603))**

- **[NFC] Cleanup on exceptions
  ([15750](https://github.com/civicrm/civicrm-core/pull/15750))**

- **(NFC) Remove windows-specific debugging code from 11 years ago
  ([15736](https://github.com/civicrm/civicrm-core/pull/15736))**

- **[NFC] Allow users on backdrop to trigger regen.sh
  ([15717](https://github.com/civicrm/civicrm-core/pull/15717))**

- **[NFC] Fix exception thrown to std CRM_Core_Exception
  ([15716](https://github.com/civicrm/civicrm-core/pull/15716))**

- **[NFC] various code cleanup on CRM_Contact_BAO_Query
  ([15713](https://github.com/civicrm/civicrm-core/pull/15713))**

- **[NFC] Test class preliminary clean up
  ([15685](https://github.com/civicrm/civicrm-core/pull/15685))**

- **[NFC] test cleanup
  ([15683](https://github.com/civicrm/civicrm-core/pull/15683))**

- **[NFC] define variable type
  ([15681](https://github.com/civicrm/civicrm-core/pull/15681))**

- **[NFC] Remove unreachable lines
  ([15672](https://github.com/civicrm/civicrm-core/pull/15672))**

- **[NFC] Test cleanup -  switch to OrderApi in test setup, add throws, use sin…
  ([15662](https://github.com/civicrm/civicrm-core/pull/15662))**

- **[NFC] reformat BAO_Case file
  ([15627](https://github.com/civicrm/civicrm-core/pull/15627))**

- **[NFC] Add date information to MailingJob Schema
  ([15628](https://github.com/civicrm/civicrm-core/pull/15628))**

- **[NFC] Add in debugging to try and resolve E2E Cache intermitant test …
  ([15625](https://github.com/civicrm/civicrm-core/pull/15625))**

- **Fix test to be more valid
  ([15743](https://github.com/civicrm/civicrm-core/pull/15743))**

- **Add test to lock in obscure custom join handling
  ([15715](https://github.com/civicrm/civicrm-core/pull/15715))**

- **Test improvements
  ([15720](https://github.com/civicrm/civicrm-core/pull/15720))**

- **Test  calling CRM_Financial_BAO_PaymentProcessor::getPaymentProcessors
  ([15499](https://github.com/civicrm/civicrm-core/pull/15499))**

- **Update tests to simulate labels that are not the same as names
  ([15399](https://github.com/civicrm/civicrm-core/pull/15399))**

- **Add test for participant receipts, super minor consistency fix.
  ([15525](https://github.com/civicrm/civicrm-core/pull/15525))**

- **[Code-quality] remove references to where_tables, where_clause
  ([14891](https://github.com/civicrm/civicrm-core/pull/14891))**

- **REF Move ipAddress and CC expiry date to prepareParamsForPaymentProcessor
  ([15291](https://github.com/civicrm/civicrm-core/pull/15291))**

- **REF Use the new prepareParamsForPaymentProcessor function in more places
  ([15281](https://github.com/civicrm/civicrm-core/pull/15281))**

- **[REF] Remove transaction as part of minor code cleanup
  ([15460](https://github.com/civicrm/civicrm-core/pull/15460))**

- **[ref] Simplify function signature as parameter is not used
  ([15459](https://github.com/civicrm/civicrm-core/pull/15459))**

- **[REF] move definition of important values & retrieval outside payment…
  ([15458](https://github.com/civicrm/civicrm-core/pull/15458))**

- **[REF] Minor cleanup to determine taxterm with a helper function.
  ([15488](https://github.com/civicrm/civicrm-core/pull/15488))**

- **[REF] Replace deprecated function call with a more readable alternative
  ([15489](https://github.com/civicrm/civicrm-core/pull/15489))**

- **[REF] remove call to deprecated function
  ([15465](https://github.com/civicrm/civicrm-core/pull/15465))**

- **[REF] Fix typos and remove unused variables
  ([15462](https://github.com/civicrm/civicrm-core/pull/15462))**

- **[REF] Rename balanceTrxnParams variable to paymentTrxnParams
  ([15535](https://github.com/civicrm/civicrm-core/pull/15535))**

- **[REF] minor extraction with code to build dedupe arrays
  ([15519](https://github.com/civicrm/civicrm-core/pull/15519))**

- **[REF] basic extraction of sendMails functionality along with a small test
  extension ([15516](https://github.com/civicrm/civicrm-core/pull/15516))**

- **[REF] remove obsolete code.
  ([15515](https://github.com/civicrm/civicrm-core/pull/15515))**

- **[REF] Deprecate calls to createCreditNoteId
  ([15492](https://github.com/civicrm/civicrm-core/pull/15492))**

- **[REF] minor extraction in dedupe code
  ([15587](https://github.com/civicrm/civicrm-core/pull/15587))**

- **[REF] minor extraction - Extract code to update line items to paid
  ([15602](https://github.com/civicrm/civicrm-core/pull/15602))**

- **[REF] Remove usage of CRM_ACL_BAO_Cache::deleteEntry in favour of usi…
  ([15611](https://github.com/civicrm/civicrm-core/pull/15611))**

- **[REF] Remove CRM_Exception in favour of CRM_Core_Exception
  ([15610](https://github.com/civicrm/civicrm-core/pull/15610))**

- **[REF] minor refactor towards removing complexity.
  ([15594](https://github.com/civicrm/civicrm-core/pull/15594))**

- **[REF] minor tidy ups on very nasty function
  ([15722](https://github.com/civicrm/civicrm-core/pull/15722))**

- **[REF] Remove early return on joinTable
  ([15718](https://github.com/civicrm/civicrm-core/pull/15718))**

- **[REF] remove  as a return Param of getHierContactDetails
  ([15714](https://github.com/civicrm/civicrm-core/pull/15714))**

- **[REF] minor code simplification
  ([15728](https://github.com/civicrm/civicrm-core/pull/15728))**

- **[REF] Move calls to CRM_Core_BAO_FinancialTrxn::createDeferredTrxn back to
  the calling functions.
  ([15641](https://github.com/civicrm/civicrm-core/pull/15641))**

- **[REF] Refactor Smart Group Cache population code to be less intensive
  ([15588](https://github.com/civicrm/civicrm-core/pull/15588))**

- **[REF] Refactor ACL Contact Cache generation to be more efficient
  ([15592](https://github.com/civicrm/civicrm-core/pull/15592))**

- **[REF] extract chunk of code that creates the financial items for a given
  line. ([15613](https://github.com/civicrm/civicrm-core/pull/15613))**

- **[REF] Further deconstruction of updateFinancialAccounts
  ([15631](https://github.com/civicrm/civicrm-core/pull/15631))**

- **[REF] simplify definition of isARefund
  ([15601](https://github.com/civicrm/civicrm-core/pull/15601))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

a-n The Artists Information Company - William Mortada; AGH Strategies - Alice
Frumin, Andrew Hunt, Eli Lisseck; Agileware - Pengyi Zhang; Alexy
Mikhailichenko; Australian Greens - Seamus Lee; Christian Wach; CiviCoop - Jaap
Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
CompuCorp- Camilo Rodriguez, Davi Alexandre, Omar Abu Hussein; Dave D;
Electronic Frontier Foundation - Mark Burdett; Florian Kohrt; Freeform
Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; Greenpeace CEE -
Patrick Figel; iXiam - César Ramos; JMA Consulting - Monish Deb; John Kingsnorth;
Megaphone Technology Consulting - Jon Goldberg; MJCO - Mikey O'Toole; MJW
Consulting - Matthew Wire; Mountev Ltd; Richard van Oosterhout; Squiffle
Consulting - Aidan Saunders; SYSTOPIA Organisationsberatung - Björn Endres;
Tadpole Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton,
Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

a-n The Artists Information Company - William Mortada; Agileware - Justin
Freeman; Artful Robot - Rich Lott; Blackfly Solutions - Alan Dixon; Circle
Interactive - Dave Jenkins, Pradeep Nayak; CompuCorp - Jamie Novick; Coop
SymbioTIC - Mathieu Lutfy; Fuzion - Luke Stewart; iXiam - Vangelis Pantazis; JMA
Consulting - Joe Murray; Nicol Wistreich; Ray Wright; Red Hot Irons - Heather
Oliver; Skvare - Mark Hanna; OSSeed Technologies LLP - Sushant Paste

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
