*** Settings ***
Documentation       Check outlet sensors

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Ctn Generic Suite Setup
Test Timeout        120s


*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=hardware::pdu::raritan::snmp::plugin


*** Test Cases ***
outlet ${tc}
    [Tags]    hardware    pdu    raritan   outlet   sensors
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=outlet-sensors
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=hardware/pdu/raritan/snmp/raritan
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                expected_result    --
            ...      1     ${EMPTY}                                                                     OK: All 96 components are ok [12/12 activeEnergy, 12/12 activePower, 12/12 apparentPower, 12/12 frequency, 12/12 onOff, 12/12 powerFactor, 12/12 rmsCurrent, 12/12 rmsVoltage]. | 'Anonymized 102~1#hardware.sensor.outlet.activeenergy.watthour'=107881wattHour;;;; 'Anonymized 102~2#hardware.sensor.outlet.activeenergy.watthour'=330830wattHour;;;; 'Anonymized 102~3#hardware.sensor.outlet.activeenergy.watthour'=46648wattHour;;;; 'Anonymized 102~4#hardware.sensor.outlet.activeenergy.watthour'=4wattHour;;;; 'Anonymized 102~5#hardware.sensor.outlet.activeenergy.watthour'=281696wattHour;;;; 'Anonymized 102~6#hardware.sensor.outlet.activeenergy.watthour'=340154wattHour;;;; 'Anonymized 102~7#hardware.sensor.outlet.activeenergy.watthour'=293708wattHour;;;; 'Anonymized 102~8#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~9#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~10#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~11#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~12#hardware.sensor.outlet.activeenergy.watthour'=43137wattHour;;;; 'Anonymized 102~1#hardware.sensor.outlet.activepower.watt'=7W;;;; 'Anonymized 102~2#hardware.sensor.outlet.activepower.watt'=56W;;;; 'Anonymized 102~3#hardware.sensor.outlet.activepower.watt'=6W;;;; 'Anonymized 102~4#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~5#hardware.sensor.outlet.activepower.watt'=45W;;;; 'Anonymized 102~6#hardware.sensor.outlet.activepower.watt'=56W;;;; 'Anonymized 102~7#hardware.sensor.outlet.activepower.watt'=65W;;;; 'Anonymized 102~8#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~9#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~10#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~11#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~12#hardware.sensor.outlet.activepower.watt'=7W;;;; 'Anonymized 102~1#hardware.sensor.outlet.apparentpower.voltamp'=17voltamp;;;; 'Anonymized 102~2#hardware.sensor.outlet.apparentpower.voltamp'=71voltamp;;;; 'Anonymized 102~3#hardware.sensor.outlet.apparentpower.voltamp'=21voltamp;;;; 'Anonymized 102~4#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~5#hardware.sensor.outlet.apparentpower.voltamp'=78voltamp;;;; 'Anonymized 102~6#hardware.sensor.outlet.apparentpower.voltamp'=86voltamp;;;; 'Anonymized 102~7#hardware.sensor.outlet.apparentpower.voltamp'=91voltamp;;;; 'Anonymized 102~8#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~9#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~10#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~11#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~12#hardware.sensor.outlet.apparentpower.voltamp'=19voltamp;;;; 'Anonymized 102~1#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~2#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~3#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~4#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~5#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~6#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~7#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~8#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~9#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~10#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~11#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~12#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~1#hardware.sensor.outlet.powerfactor'=0.41;;;; 'Anonymized 102~2#hardware.sensor.outlet.powerfactor'=0.79;;;; 'Anonymized 102~3#hardware.sensor.outlet.powerfactor'=0.3;;;; 'Anonymized 102~5#hardware.sensor.outlet.powerfactor'=0.58;;;; 'Anonymized 102~6#hardware.sensor.outlet.powerfactor'=0.65;;;; 'Anonymized 102~7#hardware.sensor.outlet.powerfactor'=0.72;;;; 'Anonymized 102~12#hardware.sensor.outlet.powerfactor'=0.38;;;; 'Anonymized 102~1#hardware.sensor.outlet.rmscurrent.ampere'=0.074A;~:6.5;~:8;; 'Anonymized 102~2#hardware.sensor.outlet.rmscurrent.ampere'=0.303A;~:6.5;~:8;; 'Anonymized 102~3#hardware.sensor.outlet.rmscurrent.ampere'=0.091A;~:6.5;~:8;; 'Anonymized 102~4#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~5#hardware.sensor.outlet.rmscurrent.ampere'=0.333A;~:6.5;~:8;; 'Anonymized 102~6#hardware.sensor.outlet.rmscurrent.ampere'=0.371A;~:6.5;~:8;; 'Anonymized 102~7#hardware.sensor.outlet.rmscurrent.ampere'=0.389A;~:6.5;~:8;; 'Anonymized 102~8#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~9#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~10#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~11#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~12#hardware.sensor.outlet.rmscurrent.ampere'=0.081A;~:6.5;~:8;; 'Anonymized 102~1#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~2#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~3#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~4#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~5#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~6#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~7#hardware.sensor.outlet.rmsvoltage.volt'=234V;;;; 'Anonymized 102~8#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~9#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~10#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~11#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~12#hardware.sensor.outlet.rmsvoltage.volt'=234V;;;; 'hardware.activeEnergy.count'=12;;;; 'hardware.activePower.count'=12;;;; 'hardware.apparentPower.count'=12;;;; 'hardware.frequency.count'=12;;;; 'hardware.onOff.count'=12;;;; 'hardware.powerFactor.count'=12;;;; 'hardware.rmsCurrent.count'=12;;;; 'hardware.rmsVoltage.count'=12;;;;
            ...      2     --filter=powerFactor                                                         OK: All 84 components are ok [12/12 activeEnergy, 12/12 activePower, 12/12 apparentPower, 12/12 frequency, 12/12 onOff, 12/12 rmsCurrent, 12/12 rmsVoltage]. | 'Anonymized 102~1#hardware.sensor.outlet.activeenergy.watthour'=107881wattHour;;;; 'Anonymized 102~2#hardware.sensor.outlet.activeenergy.watthour'=330830wattHour;;;; 'Anonymized 102~3#hardware.sensor.outlet.activeenergy.watthour'=46648wattHour;;;; 'Anonymized 102~4#hardware.sensor.outlet.activeenergy.watthour'=4wattHour;;;; 'Anonymized 102~5#hardware.sensor.outlet.activeenergy.watthour'=281696wattHour;;;; 'Anonymized 102~6#hardware.sensor.outlet.activeenergy.watthour'=340154wattHour;;;; 'Anonymized 102~7#hardware.sensor.outlet.activeenergy.watthour'=293708wattHour;;;; 'Anonymized 102~8#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~9#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~10#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~11#hardware.sensor.outlet.activeenergy.watthour'=0wattHour;;;; 'Anonymized 102~12#hardware.sensor.outlet.activeenergy.watthour'=43137wattHour;;;; 'Anonymized 102~1#hardware.sensor.outlet.activepower.watt'=7W;;;; 'Anonymized 102~2#hardware.sensor.outlet.activepower.watt'=56W;;;; 'Anonymized 102~3#hardware.sensor.outlet.activepower.watt'=6W;;;; 'Anonymized 102~4#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~5#hardware.sensor.outlet.activepower.watt'=45W;;;; 'Anonymized 102~6#hardware.sensor.outlet.activepower.watt'=56W;;;; 'Anonymized 102~7#hardware.sensor.outlet.activepower.watt'=65W;;;; 'Anonymized 102~8#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~9#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~10#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~11#hardware.sensor.outlet.activepower.watt'=0W;;;; 'Anonymized 102~12#hardware.sensor.outlet.activepower.watt'=7W;;;; 'Anonymized 102~1#hardware.sensor.outlet.apparentpower.voltamp'=17voltamp;;;; 'Anonymized 102~2#hardware.sensor.outlet.apparentpower.voltamp'=71voltamp;;;; 'Anonymized 102~3#hardware.sensor.outlet.apparentpower.voltamp'=21voltamp;;;; 'Anonymized 102~4#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~5#hardware.sensor.outlet.apparentpower.voltamp'=78voltamp;;;; 'Anonymized 102~6#hardware.sensor.outlet.apparentpower.voltamp'=86voltamp;;;; 'Anonymized 102~7#hardware.sensor.outlet.apparentpower.voltamp'=91voltamp;;;; 'Anonymized 102~8#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~9#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~10#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~11#hardware.sensor.outlet.apparentpower.voltamp'=0voltamp;;;; 'Anonymized 102~12#hardware.sensor.outlet.apparentpower.voltamp'=19voltamp;;;; 'Anonymized 102~1#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~2#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~3#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~4#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~5#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~6#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~7#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~8#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~9#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~10#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~11#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~12#hardware.sensor.outlet.frequency.hertz'=50Hz;;;; 'Anonymized 102~1#hardware.sensor.outlet.rmscurrent.ampere'=0.074A;~:6.5;~:8;; 'Anonymized 102~2#hardware.sensor.outlet.rmscurrent.ampere'=0.303A;~:6.5;~:8;; 'Anonymized 102~3#hardware.sensor.outlet.rmscurrent.ampere'=0.091A;~:6.5;~:8;; 'Anonymized 102~4#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~5#hardware.sensor.outlet.rmscurrent.ampere'=0.333A;~:6.5;~:8;; 'Anonymized 102~6#hardware.sensor.outlet.rmscurrent.ampere'=0.371A;~:6.5;~:8;; 'Anonymized 102~7#hardware.sensor.outlet.rmscurrent.ampere'=0.389A;~:6.5;~:8;; 'Anonymized 102~8#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~9#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~10#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~11#hardware.sensor.outlet.rmscurrent.ampere'=0A;~:6.5;~:8;; 'Anonymized 102~12#hardware.sensor.outlet.rmscurrent.ampere'=0.081A;~:6.5;~:8;; 'Anonymized 102~1#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~2#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~3#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~4#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~5#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~6#hardware.sensor.outlet.rmsvoltage.volt'=233V;;;; 'Anonymized 102~7#hardware.sensor.outlet.rmsvoltage.volt'=234V;;;; 'Anonymized 102~8#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~9#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~10#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~11#hardware.sensor.outlet.rmsvoltage.volt'=0V;;;; 'Anonymized 102~12#hardware.sensor.outlet.rmsvoltage.volt'=234V;;;; 'hardware.activeEnergy.count'=12;;;; 'hardware.activePower.count'=12;;;; 'hardware.apparentPower.count'=12;;;; 'hardware.frequency.count'=12;;;; 'hardware.onOff.count'=12;;;; 'hardware.rmsCurrent.count'=12;;;; 'hardware.rmsVoltage.count'=12;;;;
            ...      3     --component=onOff                                                            OK: All 12 components are ok [12/12 onOff]. | 'hardware.onOff.count'=12;;;;
            ...      4     --component=powerFactor --threshold-overload='powerFactor,CRITICAL,absent'   CRITICAL: '4' powerFactor state is 'absent' - '8' powerFactor state is 'absent' - '9' powerFactor state is 'absent' - '10' powerFactor state is 'absent' - '11' powerFactor state is 'absent' | 'Anonymized 102~1#hardware.sensor.outlet.powerfactor'=0.41;;;; 'Anonymized 102~2#hardware.sensor.outlet.powerfactor'=0.79;;;; 'Anonymized 102~3#hardware.sensor.outlet.powerfactor'=0.3;;;; 'Anonymized 102~5#hardware.sensor.outlet.powerfactor'=0.58;;;; 'Anonymized 102~6#hardware.sensor.outlet.powerfactor'=0.65;;;; 'Anonymized 102~7#hardware.sensor.outlet.powerfactor'=0.72;;;; 'Anonymized 102~12#hardware.sensor.outlet.powerfactor'=0.38;;;; 'hardware.powerFactor.count'=12;;;;
