from __future__ import absolute_import, division, print_function

import iotbx.pdb
import mmtbx.model
from mmtbx.validation.ramalyze import ramalyze
from libtbx.utils import null_out
from mmtbx.validation.comparama import add_arrows_on_plot
from PIL import Image

pdb_str = """\
ATOM     13  CB  PHE A   1      11.914  10.410  11.811  1.00  2.00           C
ATOM     14  CG  PHE A   1      11.204   9.472  12.746  1.00  2.00           C
ATOM     15  CD1 PHE A   1      10.636   8.301  12.273  1.00  2.00           C
ATOM     16  CD2 PHE A   1      11.105   9.762  14.096  1.00  2.00           C
ATOM     17  CE1 PHE A   1       9.982   7.436  13.131  1.00  2.00           C
ATOM     18  CE2 PHE A   1      10.452   8.901  14.958  1.00  2.00           C
ATOM     19  CZ  PHE A   1       9.890   7.737  14.475  1.00  2.00           C
ATOM     20  C   PHE A   1      11.828  12.443  10.351  1.00  2.00           C
ATOM     21  O   PHE A   1      11.808  12.365   9.123  1.00  2.00           O
ATOM     22  OXT PHE A   1      12.531  13.314  10.864  1.00  2.00           O
ATOM     23  N   PHE A   1       9.929  10.880  10.444  1.00  2.00           N
ATOM     24  CA  PHE A   1      11.008  11.488  11.213  1.00  2.00           C
"""

reference_hist = [111089, 836, 637, 524, 406, 484, 368, 330, 35365, 3425, 3430,
    2874, 6621, 3319, 3814, 5685, 4456, 2546, 3099, 6959, 4282, 3118, 2946, 7024,
    3701, 4054, 6626, 3163, 4803, 2889, 7661, 3841, 3806, 3582, 3856, 3572, 4895,
    4091, 3593, 3004, 4158, 4326, 4148, 4351, 3545, 2824, 5323, 3804, 3288, 5080,
    4432, 3836, 3150, 4903, 176, 3621, 4734, 3721, 5605, 3713, 3947, 5576, 3834,
    4074, 4341, 4516, 4486, 6125, 167, 4234, 3849, 5846, 3673, 190, 4043, 5274,
    4479, 162, 5600, 5164, 5128, 5060, 197, 3880, 5616, 5074, 160, 5423, 5706,
    5613, 3979, 192, 4865, 4808, 5978, 244, 5740, 6205, 4624, 4826, 170, 5429,
    5115, 6512, 207, 5615, 6481, 5404, 150, 5902, 171, 7064, 5376, 185, 6381,
    5978, 169, 6250, 147, 6452, 6961, 189, 4390, 6728, 180, 9208, 179, 6143,
    5709, 195, 6850, 6673, 188, 8240, 223, 7655, 8523, 229, 6712, 8464, 235,
    8303, 229, 7666, 5498, 237, 8868, 8217, 231, 6255, 266, 6768, 7325, 383,
    5549, 4734, 317, 2913, 4195, 257, 5362, 7136, 8627, 8674, 190, 8008, 9467,
    10811, 9351, 213, 9642, 10356, 12179, 11535, 138, 9827, 11768, 11539, 13338,
    187, 11383, 10984, 13745, 14754, 159, 14130, 13284, 14078, 13418, 166, 16377,
    13380, 14727, 15585, 224, 16505, 17762, 18118, 15012, 16175, 36093, 18533,
    16372, 31832, 20683, 17827, 31507, 18379, 20700, 40547, 19430, 18316, 71553,
    20799, 20889, 41387, 11831, 7775, 26087, 30085, 34971, 73909, 51143, 45512,
    46024, 100879, 71774, 45164, 116843, 73022, 57321, 80118, 128338, 80769,
    42354, 63785, 119293, 155957, 142223, 187109, 319, 1472, 320, 292, 489,
    491, 514, 649983, 506, 409, 1023, 758, 554, 790, 2583, 1680397, 170342,
    828, 761, 739, 433, 353, 410, 495, 366, 330, 323, 604, 295, 280, 408, 246,
    396, 431, 488, 398, 252, 338, 278, 218, 227, 430, 240, 317, 293, 314, 317,
    378, 365, 252, 199, 277, 293, 256, 523, 234, 183, 244, 196, 192, 281, 193,
    269, 354, 601, 217, 617, 484, 472, 478, 234, 374, 862, 623, 554, 625, 484,
    537, 1276, 701, 597, 1004, 617, 1372, 1458, 1069, 936, 1478, 2077, 1447,
    2114, 1753, 2238, 200, 3458, 2838, 2926, 3669, 3284, 3391, 3349, 2694, 3184,
    3757, 3387, 3753, 3721, 2169, 4429, 2576, 3159, 4210, 3066, 4240, 3067, 2862,
    4111, 3029, 3768, 4062, 3856, 3134, 3137, 4836, 2990, 4903, 2914, 3730, 3794,
    3520, 3838, 3585, 4886, 4076, 3612, 3026, 4169, 4291, 4119, 4592, 3494, 2834,
    5275, 3912, 3410, 5111, 4570, 4040, 3220, 4932, 216, 3842, 4733, 3706, 5694,
    3576, 4013, 5624, 3951, 4243, 4396, 4528, 4516, 5991, 7891, 5887, 3609, 4028,
    5346, 4490, 5625, 10329, 5096, 3899, 5596, 5139, 5443, 5714, 5673, 8819, 4850,
    5953, 5731, 6263, 4650, 4802, 10405, 6535, 5677, 6487, 5351, 5979, 7121, 11603,
    5958, 6326, 6457, 7004, 4420, 6787, 15200, 5713, 6920, 6614, 8322, 7595, 8594,
    6892, 16694, 7687, 5515, 9014, 8259, 6298, 6773, 12730, 4627, 3057, 9466, 15676,
    8571, 17291, 20060, 19892, 23600, 21361, 24708, 22389, 44660, 14108, 27077, 29496,
    27832, 31723, 35703, 30968, 36066, 34709, 31761, 38442, 31557, 38871, 40509,
    37607, 55200, 41344, 41619, 19558, 26206, 65030, 73890, 96394, 103654, 114729,
    92341, 142022, 137028, 127952, 122462, 162141, 176165, 282054, 46617, 1221, 56,
    78, 100, 648693, 63, 81, 131, 1622289, 170322, 811, 775, 597, 387, 403, 412,
    487, 310, 267, 288, 543, 265, 325, 458, 206, 393, 356, 431, 313, 451, 223,
    383, 201, 207, 340, 213, 224, 258, 209, 185, 293, 294, 248, 309, 211, 155,
    154, 159, 284, 315, 222, 187, 183, 168, 181, 150, 309, 220, 203, 155, 269,
    233, 191, 229, 245, 181, 246, 271, 341, 238, 248, 336, 371, 267, 248, 298,
    392, 270, 219, 240, 250, 173, 181, 208, 205, 215, 186, 183, 254, 246, 251,
    320, 235, 257, 245, 224, 234, 197, 241, 133, 215, 172, 175, 173, 359, 228,
    195, 141, 248, 196, 168, 156, 291, 201, 201, 186, 648, 237, 202, 710, 511,
    169, 385, 424, 209, 207, 330, 276, 804, 551, 175, 398, 480, 127, 562, 441,
    202, 1164, 333, 486, 653, 399, 926, 601, 381, 1242, 1501, 265, 1123, 914,
    252, 1403, 2049, 192, 1413, 2348, 375, 1718, 207, 2256, 3479, 193, 2823,
    2836, 366, 6660, 3318, 3236, 2708, 6562, 3301, 3753, 5696, 4425, 2499, 3097,
    6909, 4162, 3042, 2885, 6928, 3704, 4071, 6581, 3097, 4840, 2933, 7621, 3789,
    3833, 7168, 8227, 7500, 7020, 8258, 4375, 6300, 8876, 8236, 8102, 7988, 8187,
    9143, 3606, 9467, 7685, 8709, 10326, 7945, 9378, 9171, 10006, 10194, 8837,
    10518, 10899, 9484, 9509, 11514, 10748, 10096, 27936, 11948, 18029, 17415,
    19410, 20016, 11718, 21454, 22651, 24254, 22260, 20143, 12629, 9439, 15695,
    25884, 20221, 19996, 33232, 23044, 24601, 24569, 41742, 27226, 29591, 30329,
    52218, 67382, 66303, 69768, 79329, 92447, 82589, 45118, 138564, 199941, 206843,
    278991, 250282, 338102, 328626, 1254, 196, 2270828, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5760000]

def exercise_1(prefix="tst_add_arrows_on_plot_1"):
  model = mmtbx.model.manager(
      model_input = iotbx.pdb.input(source_info=None, lines=pdb_str))
  rama = ramalyze(model.get_hierarchy(), out=null_out())
  plots = rama.get_plots(
      show_labels=True,
      point_style='bo',
      markersize=1,
      markeredgecolor="black",
      dpi=300,
      markerfacecolor="white")

  ad_testing = []
  ad_testing.append( ((60,-120), (120, -120)) )
  ad_testing.append( ((-125, 120), (-125,  179)) )
  ad_testing.append( ((-120, 120), (-120, -120)) ) # wrapping up
  ad_testing.append( ((-115, -120), (-115, 120)) ) # wrapping down
  ad_testing.append( ((120, -60), (-120, -60)) ) # wrapping right
  ad_testing.append( ((-120, -65), (120, -65)) ) # wrapping left
  ad_testing.append( ((120, 0), (-120, 60)) ) # diag right
  ad_testing.append( ((-120, 55), (120, -5)) )# diag left
  ad_testing.append( ((-60, 120), (0, -120)) ) # diag up
  ad_testing.append( ((5, -120), (-55, 120)) ) # diag up
  ad_testing.append( ((150, 150), (-150, -150)) ) # going to top right corner straight
  ad_testing.append( ((140, 155), (-130, -140)) ) # going to top right corner not straight
  ad_testing.append( ((150, -150), (-150, 150)) ) # going to bottom right corner straight
  ad_testing.append( ((140, -155), (-130, 140)) ) # going to bottom right corner not straight
  ad_testing.append( ((-150, 150), (150, -150)) ) # going to top left corner straight
  ad_testing.append( ((-140, 155), (130, -140)) ) # going to top left corner not straight
  ad_testing.append( ((-150, -150), (150, 150)) ) # going to bottom left corner straight
  ad_testing.append( ((-140, -155), (130, 140)) ) # going to bottom left corner not straight

  plot = plots[0]
  add_arrows_on_plot(
      plot,
      ad_testing,
      color="red")
  plot_file_name = "%s.png" % prefix
  plot.save_image(plot_file_name, dpi=300)

  img = Image.open(plot_file_name)
  hist = img.histogram()
  # print(hist)
  hist_ok = True
  for ref, res in zip(reference_hist, hist):
    if (ref != res) and not (0.98 < ref/res < 1.02):
      hist_ok = False
      # print (ref, res, ref/res)
  assert hist_ok

if __name__ == '__main__':
  exercise_1()
