#ifndef SIMPLISTICCOMPONENT_H
#define SIMPLISTICCOMPONENT_H

#include "CamiTKAPI.h"
#include "Component.h"
namespace  camitk {

/**
 * This class has been implemented to be able to instanciate a very basic component
 * with NO_REPRESENTATION.
 *
 * Caution !
 * The class Component has been created non instanciable on purpose !
 * This class SHOULD not replace a real Component inherited class handing data.
 * It is a helper class for those who need to use Interface node and/or Interface frame only.
 *
 * This is why this class should be final (no inheritance allowed) if it was writen in Java,
 * has no representation
 * (neither Slice nor Geometry) and reimplements addProperty
 *  to prevent from adding property (if you need a property, this means that you handle data,
 *  this means that you need a proper component).
 *
 */
class CAMITK_API SimplisticComponent : public Component {
    Q_OBJECT

public:
    static SimplisticComponent * createInstance(QString name);

    /// this component has no representation
    void initRepresentation() {}

    /// This simplistic component cannot have properties
    /// If you need properties, it means that you need a
    ///  particualr component to handle them
    bool addProperty(Property*);

private:
    SimplisticComponent(QString name);

};
}
#endif // SIMPLISTICCOMPONENT_H
