/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.i18n.MessageUtil;

public abstract class Version {
    static MessageUtil msgutil = SqlException.getMessageUtil();
    private static String SECURITY_MANAGER_NO_ACCESS_ID = "J108";
    private static String UNKNOWN_HOST_ID = "J109";

    public static String getDriverName() {
        return "Apache Derby Network Client JDBC Driver";
    }

    public static String getDriverVersion() {
        return Configuration.dncProductVersionHolder__.getVersionBuildString(true);
    }

    public static int getMajorVersion() {
        return Configuration.getProductVersionHolder().getMajorVersion();
    }

    public static int getMinorVersion() {
        return Configuration.getProductVersionHolder().getMinorVersion();
    }

    public static int getBuildNumber() {
        return Configuration.getProductVersionHolder().getBuildNumberAsInt();
    }

    public static int getProtocolMaintVersion() {
        return Configuration.getProductVersionHolder().getDrdaMaintVersion();
    }

    public static boolean isAlpha() {
        return Configuration.getProductVersionHolder().isAlpha();
    }

    public static boolean isBeta() {
        return Configuration.getProductVersionHolder().isBeta();
    }

    private static String getDriverNameAndVersion() {
        return "Apache Derby Network Client JDBC Driver " + Configuration.dncProductVersionHolder__.getVersionBuildString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDriverConfiguration(PrintWriter printWriter) {
        String string = "[derby] ";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(string + "BEGIN TRACE_DRIVER_CONFIGURATION");
            printWriter.println(string + "Driver: " + Version.getDriverNameAndVersion());
            printWriter.print(string + "Compatible JRE versions: { ");
            for (int i = 0; i < Configuration.dncCompatibleJREVersions.length; ++i) {
                printWriter.print(Configuration.dncCompatibleJREVersions[i]);
                if (i == Configuration.dncCompatibleJREVersions.length - 1) continue;
                printWriter.print(", ");
            }
            printWriter.println(" }");
            printWriter.println(string + "Range checking enabled: " + true);
            printWriter.println(string + "Bug check level: 0x" + Integer.toHexString(255));
            printWriter.println(string + "Default fetch size: " + 64);
            printWriter.println(string + "Default isolation: " + 2);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                printWriter.println(string + "No security manager detected.");
            } else {
                printWriter.println(string + "Security manager detected.");
            }
            Version.detectLocalHost(System.getSecurityManager(), printWriter);
            Version.printSystemProperty(securityManager, "JDBC 1 system property jdbc.drivers = ", "jdbc.drivers", printWriter);
            Version.printSystemProperty(securityManager, "Java Runtime Environment version ", "java.version", printWriter);
            Version.printSystemProperty(securityManager, "Java Runtime Environment vendor = ", "java.vendor", printWriter);
            Version.printSystemProperty(securityManager, "Java vendor URL = ", "java.vendor.url", printWriter);
            Version.printSystemProperty(securityManager, "Java installation directory = ", "java.home", printWriter);
            Version.printSystemProperty(securityManager, "Java Virtual Machine specification version = ", "java.vm.specification.version", printWriter);
            Version.printSystemProperty(securityManager, "Java Virtual Machine specification vendor = ", "java.vm.specification.vendor", printWriter);
            Version.printSystemProperty(securityManager, "Java Virtual Machine specification name = ", "java.vm.specification.name", printWriter);
            Version.printSystemProperty(securityManager, "Java Virtual Machine implementation version = ", "java.vm.version", printWriter);
            Version.printSystemProperty(securityManager, "Java Virtual Machine implementation vendor = ", "java.vm.vendor", printWriter);
            Version.printSystemProperty(securityManager, "Java Virtual Machine implementation name = ", "java.vm.name", printWriter);
            Version.printSystemProperty(securityManager, "Java Runtime Environment specification version = ", "java.specification.version", printWriter);
            Version.printSystemProperty(securityManager, "Java Runtime Environment specification vendor = ", "java.specification.vendor", printWriter);
            Version.printSystemProperty(securityManager, "Java Runtime Environment specification name = ", "java.specification.name", printWriter);
            Version.printSystemProperty(securityManager, "Java class format version number = ", "java.class.version", printWriter);
            Version.printSystemProperty(securityManager, "Java class path = ", "java.class.path", printWriter);
            Version.printSystemProperty(securityManager, "Java native library path = ", "java.library.path", printWriter);
            Version.printSystemProperty(securityManager, "Path of extension directory or directories = ", "java.ext.dirs", printWriter);
            Version.printSystemProperty(securityManager, "Operating system name = ", "os.name", printWriter);
            Version.printSystemProperty(securityManager, "Operating system architecture = ", "os.arch", printWriter);
            Version.printSystemProperty(securityManager, "Operating system version = ", "os.version", printWriter);
            Version.printSystemProperty(securityManager, "File separator (\"/\" on UNIX) = ", "file.separator", printWriter);
            Version.printSystemProperty(securityManager, "Path separator (\":\" on UNIX) = ", "path.separator", printWriter);
            Version.printSystemProperty(securityManager, "User's account name = ", "user.name", printWriter);
            Version.printSystemProperty(securityManager, "User's home directory = ", "user.home", printWriter);
            Version.printSystemProperty(securityManager, "User's current working directory = ", "user.dir", printWriter);
            printWriter.println(string + "END TRACE_DRIVER_CONFIGURATION");
            printWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemProperty(SecurityManager securityManager, String string, String string2, PrintWriter printWriter) {
        String string3 = "[derby] ";
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            try {
                if (securityManager != null) {
                    securityManager.checkPropertyAccess(string2);
                }
                String string4 = System.getProperty(string2);
                printWriter.println(string3 + string + string4);
                printWriter.flush();
            }
            catch (SecurityException securityException) {
                printWriter.println(string3 + msgutil.getTextMessage(SECURITY_MANAGER_NO_ACCESS_ID, string2));
                printWriter.flush();
            }
        }
    }

    private static void detectLocalHost(SecurityManager securityManager, PrintWriter printWriter) {
        String string = "[derby] ";
        if (securityManager == null) {
            try {
                printWriter.print(string + "Detected local client host: ");
                printWriter.println(InetAddress.getLocalHost().toString());
                printWriter.flush();
            }
            catch (UnknownHostException unknownHostException) {
                printWriter.println(string + msgutil.getTextMessage(UNKNOWN_HOST_ID, unknownHostException.getMessage()));
                printWriter.flush();
            }
        }
    }
}

