#!/bin/sh

oneTimeSetUp() {
	# Load the ./play.it library
	export LIB_ONLY=1
	. lib/libplayit2.sh
}

test_content_path_default() {
	local \
		content_path_default \
		CONTENT_PATH_DEFAULT \
		PLAYIT_CONTEXT_ARCHIVE CONTENT_PATH_DEFAULT_0

	CONTENT_PATH_DEFAULT='some/path'
	content_path_default=$(content_path_default)
	assertEquals \
		'content_path_default failed to get an explicitly set value from CONTENT_PATH_DEFAULT.' \
		'some/path' "$content_path_default"
	unset CONTENT_PATH_DEFAULT

	set_current_archive 'ARCHIVE_BASE_0'
	CONTENT_PATH_DEFAULT_0='some/other/path'
	content_path_default=$(content_path_default)
	assertEquals \
		'content_path_default failed to get a contextual value for CONTENT_PATH_DEFAULT.' \
		'some/other/path' "$content_path_default"
	unset ARCHIVE CONTENT_PATH_DEFAULT_0

	assertFalse \
		'content_path_default did not fail, despite no value being set for CONTENT_PATH_DEFAULT.' \
		'content_path_default'
}

test_content_path() {
	local \
		content_path \
		CONTENT_PATH_DEFAULT \
		CONTENT_GAME_DATA_PATH \
		PLAYIT_CONTEXT_ARCHIVE CONTENT_GAME_DATA_PATH_0 \
		PLAYIT_COMPATIBILITY_LEVEL \
		PLAYIT_CONTEXT_ARCHIVE ARCHIVE_GAME_DATA_PATH_MAIN

	CONTENT_PATH_DEFAULT='default/path'
	content_path=$(content_path 'GAME_DATA')
	assertEquals 'default/path' "$content_path"

	CONTENT_GAME_DATA_PATH='specific/path'
	content_path=$(content_path 'GAME_DATA')
	assertEquals 'specific/path' "$content_path"

	set_current_archive 'ARCHIVE_BASE_0'
	CONTENT_GAME_DATA_PATH_0='more/specific/path'
	content_path=$(content_path 'GAME_DATA')
	assertEquals 'more/specific/path' "$content_path"

	unset CONTENT_PATH_DEFAULT CONTENT_GAME_DATA_PATH ARCHIVE CONTENT_GAME_DATA_PATH_0

	# Test the behaviour of game scripts targeting ./play.it < 2.19

	PLAYIT_COMPATIBILITY_LEVEL='2.18'
	CONTENT_PATH_DEFAULT='default/path'
	content_path=$(content_path 'GAME_DATA')
	assertEquals 'default/path' "$content_path"

	ARCHIVE_GAME_DATA_PATH='old/path'
	content_path=$(content_path 'GAME_DATA')
	assertEquals 'old/path' "$content_path"

	## Old archive naming scheme must be used here,
	## because we target ./play.it < 2.21
	set_current_archive 'ARCHIVE_MAIN'
	ARCHIVE_GAME_DATA_PATH_MAIN='other/old/path'
	content_path=$(content_path 'GAME_DATA')
	assertEquals 'other/old/path' "$content_path"
}

test_content_files() {
	local \
		content_files content_files_expected \
		CONTENT_GAME_DATA_FILES CONTENT_GAME_DATA_FILES_0 \
		PLAYIT_CONTEXT_ARCHIVE PLAYIT_COMPATIBILITY_LEVEL \
		ARCHIVE_GAME_DATA_FILES ARCHIVE_GAME_DATA_FILES_MAIN

	content_files=$(content_files 'GAME_DATA')
	assertNull "$content_files"

	CONTENT_GAME_DATA_FILES='some
list
of
files'
	content_files=$(content_files 'GAME_DATA')
	content_files_expected='some
list
of
files'
	assertEquals "$content_files_expected" "$content_files"

	set_current_archive 'ARCHIVE_BASE_0'
	CONTENT_GAME_DATA_FILES_0='specific
list
of
files'
	content_files=$(content_files 'GAME_DATA')
	content_files_expected='specific
list
of
files'
	assertEquals "$content_files_expected" "$content_files"
	unset PLAYIT_CONTEXT_ARCHIVE

	# Test the behaviour of game scripts targeting ./play.it < 2.19

	unset CONTENT_GAME_DATA_FILES
	PLAYIT_COMPATIBILITY_LEVEL='2.18'
	content_files=$(content_files 'GAME_DATA')
	assertNull "$content_files"

	ARCHIVE_GAME_DATA_FILES='old
list
of
files'
	content_files=$(content_files 'GAME_DATA')
	content_files_expected='old
list
of
files'
	assertEquals "$content_files_expected" "$content_files"

	## Old archive naming scheme must be used here,
	## because we target ./play.it < 2.21
	set_current_archive 'ARCHIVE_MAIN'
	ARCHIVE_GAME_DATA_FILES_MAIN='other
old
list
of
files'
	content_files=$(content_files 'GAME_DATA')
	content_files_expected='other
old
list
of
files'
	assertEquals "$content_files_expected" "$content_files"

	# Fallback lists of files for Unity3D and Unreal Engine 4 games are not tested here.
}
