#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Anomaly Defenders
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250123.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='anomaly-defenders'
GAME_NAME='Anomaly Defenders'

ARCHIVE_BASE_LINUX_ZIP_0_NAME='AnomalyDefenders_Linux_1402514865.zip'
ARCHIVE_BASE_LINUX_ZIP_0_MD5='430367c8228077e4c8af2f5e7f164f4e'
ARCHIVE_BASE_LINUX_ZIP_0_SIZE='640000'
ARCHIVE_BASE_LINUX_ZIP_0_VERSION='1.0-humble'
ARCHIVE_BASE_LINUX_ZIP_0_URL='https://www.humblebundle.com/store/anomaly-defenders'

ARCHIVE_BASE_LINUX_TARGZ_0_NAME='AnomalyDefenders_Linux_1402512837.tar.gz'
ARCHIVE_BASE_LINUX_TARGZ_0_MD5='35ccd57e8650dd53a09b1f1e088307cc'
ARCHIVE_BASE_LINUX_TARGZ_0_SIZE='640000'
ARCHIVE_BASE_LINUX_TARGZ_0_VERSION='1.0-humble'
ARCHIVE_BASE_LINUX_TARGZ_0_URL='https://www.humblebundle.com/store/anomaly-defenders'

ARCHIVE_BASE_WINDOWS_0_NAME='AnomalyDefenders_Windows_Setup_1402514865.exe'
ARCHIVE_BASE_WINDOWS_0_MD5='23ebfeaf0c8b9fda0d5ce73f3a33bdae'
ARCHIVE_BASE_WINDOWS_0_TYPE='innosetup'
ARCHIVE_BASE_WINDOWS_0_SIZE='645916'
ARCHIVE_BASE_WINDOWS_0_VERSION='1.0-humble'
ARCHIVE_BASE_WINDOWS_0_URL='https://www.humblebundle.com/store/anomaly-defenders'

CONTENT_PATH_DEFAULT_LINUX='AnomalyDefenders'
CONTENT_PATH_DEFAULT_WINDOWS='app'
CONTENT_LIBS_BIN_FILES_LINUX='
libOpenAL.so'
CONTENT_GAME_BIN_FILES_LINUX='
AnomalyDefenders'
CONTENT_GAME_BIN_FILES_WINDOWS='
libcurl.dll
pctouchhelper.dll
anomalydefenders.exe'
## icon.png is only provided by the Linux build.
CONTENT_GAME_DATA_FILES='
icon.png
*.dat
*.idx'
## These documentation files are only provided by the Linux build.
CONTENT_DOC_DATA_FILES='
README
Copyright license*'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/11bitstudios/Anomaly Defenders'

APP_MAIN_EXE_LINUX='AnomalyDefenders'
APP_MAIN_EXE_WINDOWS='anomalydefenders.exe'
APP_MAIN_ICON_LINUX='icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ID="${GAME_ID}-bin"
PKG_BIN_ID_LINUX="${PKG_BIN_ID}-linux"
PKG_BIN_ID_WINDOWS="${PKG_BIN_ID}-windows"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES_LINUX='
libc.so.6
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6'
## Ensure easy upgrades from packages generated with pre-20250123.1 game scripts
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
anomaly-defenders"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Linux build - LD_PRELOAD shim working around infinite loading times

PRELOAD_HACKS_LIST_LINUX='
HACK_TIMERFIX'

HACK_TIMERFIX_NAME='timerfix'
HACK_TIMERFIX_DESCRIPTION='LD_PRELOAD shim working around infinite loading times'
HACK_TIMERFIX_PACKAGE='PKG_BIN'
HACK_TIMERFIX_SOURCE='
#define _GNU_SOURCE
#include <dlfcn.h>
#include <semaphore.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>

static int (*_realSemTimedWait)(sem_t *, const struct timespec *) = NULL;

int sem_timedwait(sem_t *sem, const struct timespec *abs_timeout) {
	if (abs_timeout->tv_nsec >= 1000000000) {
		((struct timespec *)abs_timeout)->tv_nsec -= 1000000000;
		((struct timespec *)abs_timeout)->tv_sec++;
	}
	return _realSemTimedWait(sem, abs_timeout);
}
__attribute__((constructor)) void init(void) {
	_realSemTimedWait = dlsym(RTLD_NEXT, "sem_timedwait");
}
'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Build and include the LD_PRELOAD shims

hacks_inclusion_default

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
