#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Touhou 11
# send your bug reports to contact@dotslashplay.it
###

script_version=20231005.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='touhou-11'
GAME_NAME='Touhou Chireiden ~ Subterranean Animism'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

ARCHIVE_BASE_DEMO_0_NAME='th11tr002a_setup.exe'
ARCHIVE_BASE_DEMO_0_MD5='9b7c092a529fcc1f48590f0a2b3cca87'
ARCHIVE_BASE_DEMO_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_DEMO_0_EXTRACTOR_OPTIONS='--progress=1 --silent'
ARCHIVE_BASE_DEMO_0_SIZE='140000'
ARCHIVE_BASE_DEMO_0_VERSION='0.02a-zun1'
ARCHIVE_BASE_DEMO_0_URL='https://www16.big.or.jp/~zun/html/th11top.html'

CONTENT_PATH_DEFAULT='app'
CONTENT_GAME_BIN_FILES='
*.exe'
CONTENT_GAME_DATA_FILES='
*.dat'
CONTENT_DOC_DATA_FILES='
*.txt
マニュアル'

USER_PERSISTENT_FILES='
h11.cfg
scoreth11.dat
log.txt'

APP_MAIN_EXE='th11.exe'
## Set appropriate locale before running the game
APP_MAIN_PRERUN='# Set appropriate locale before running the game
export LANG=ja_JP.UTF-8'

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_ID_DEMO="${GAME_ID_DEMO}-config"
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_NAME_DEMO="$GAME_NAME_DEMO - configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_EXE='custom.exe'
APP_CONFIG_ICON='th11.exe'
## Set appropriate locale before running the game
APP_CONFIG_PRERUN="$APP_MAIN_PRERUN"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
## TODO: The library should give the ability to set dependencies on fonts.
PKG_BIN_DEPS_DEB='fonts-wqy-microhei'
PKG_BIN_DEPS_ARCH='wqy-microhei'
PKG_BIN_DEPS_GENTOO='media-fonts/wqy-microhei'

# Convert the file names and text files to UTF-8 encoding

SCRIPT_DEPS="${SCRIPT_DEPS:-} convmv iconv"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	content_path=$(content_path_default)
	cd "${PLAYIT_WORKDIR}/gamedata/${content_path}"
	
	# Convert the file names and text files to UTF-8 encoding
	convmv -f UTF-8 -t WINDOWS-1252 --notest -r . >/dev/null
	convmv -f CP932 -t UTF-8 --notest -r . >/dev/null
	iconv_shell_command='contents=$(iconv --from-code CP932 --to-code UTF-8 "$1")'
	iconv_shell_command="$iconv_shell_command"'; printf "%s" "$contents" > "$1"'
	find . \( -name '*.txt' -o -name '*.html' \) -exec \
		sh -c "$iconv_shell_command" -- '{}' \;
)

# Include game data

PKG='PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
