/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_INSTALLEDSOFTWAREIDENTITY_H_
#define OPENDRIM_INSTALLEDSOFTWAREIDENTITY_H_

#include <Association.h>

// Direct Invocation includes, may have to be adjusted
/*
#include "cmpiCIM_System.h"
#include "CIM_SystemAccess.h"
#include "cmpiCIM_SoftwareIdentity.h"
#include "CIM_SoftwareIdentityAccess.h"
*/

const static char* OpenDRIM_InstalledSoftwareIdentity_classnames[] = {"OpenDRIM_InstalledSoftwareIdentity"};
static string OpenDRIM_InstalledSoftwareIdentity_NAMESPACE = _NAMESPACE;
const static string System_role = "System";
const static char* System_classnames[] = {"OpenDRIM_ComputerSystem"};
const static string System_NAMESPACE = _NAMESPACE;

const static string InstalledSoftware_role = "InstalledSoftware";
const static char* InstalledSoftware_classnames[] = {"OpenDRIM_SoftwareIdentity"};
const static string InstalledSoftware_NAMESPACE = _NAMESPACE;

class OpenDRIM_InstalledSoftwareIdentity {

public:
	
	Objectpath System;
	bool System_isNULL;
	
	Objectpath InstalledSoftware;
	bool InstalledSoftware_isNULL;
	
	OpenDRIM_InstalledSoftwareIdentity() {
		System_isNULL = true;
		InstalledSoftware_isNULL = true;
	}
	
	~OpenDRIM_InstalledSoftwareIdentity() {}
	
	string getKeys() const {
		return CF_toLowCase(".System=\"" + CF_quoteString(System.toString()) + "\""".InstalledSoftware=\"" + CF_quoteString(InstalledSoftware.toString()) + "\"");
	}

	int getSystem(Objectpath& value) const {
		if (System_isNULL==true)
			return NOT_FOUND;
		value = System;
		return OK;
	}
	
	int setSystem(const Objectpath& newValue) {
		System = newValue;
		System.setNamespace(System_NAMESPACE);
		System_isNULL = false;
		return OK;
	}

	int getInstalledSoftware(Objectpath& value) const {
		if (InstalledSoftware_isNULL==true)
			return NOT_FOUND;
		value = InstalledSoftware;
		return OK;
	}
	
	int setInstalledSoftware(const Objectpath& newValue) {
		InstalledSoftware = newValue;
		InstalledSoftware.setNamespace(InstalledSoftware_NAMESPACE);
		InstalledSoftware_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_INSTALLEDSOFTWAREIDENTITY_H_*/
