/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_ProcessorVoltageSensorAccess.h"

const string systemCreationClassName="OpenDRIM_ComputerSystem";
const string creationClassName="OpenDRIM_ProcessorVoltageSensor";
string systemName;

vector<_processor_topology> cpu_info_processors_information;
vector<_processor_information> SMBIOS_processors_information;

int Sensors_OpenDRIM_ProcessorVoltageSensor_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// get info from cpuinfo
	CF_assert(CPU_getProcessors("/proc/cpuinfo", cpu_info_processors_information, errorMessage));
	
	// get info from SMBIOS
	SMBIOS_getProcessorsInformation(SMBIOS_processors_information, errorMessage);
	
	// different processors count...
	if (cpu_info_processors_information.size() != SMBIOS_processors_information.size())
	{
		errorMessage="CPU count error";
		return ERROR;
	}
	
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ProcessorVoltageSensor>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	for (unsigned int i = 0; i < SMBIOS_processors_information.size(); i++)
	{
		OpenDRIM_ProcessorVoltageSensor instance;
		instance.setSystemName(systemName);
		instance.setSystemCreationClassName(systemCreationClassName);
		instance.setCreationClassName(creationClassName);
		instance.setDeviceID(CF_intToStr(i));
		
		if (SMBIOS_processors_information[i].has_voltage)
		{
			if (discriminant == "ei")
				CF_assert(Sensors_OpenDRIM_ProcessorVoltageSensor_populate(instance, i, errorMessage));
			
			result.push_back(instance);
		}
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ProcessorVoltageSensor& instance, const char** properties, string& errorMessage) {
	_E_;
	int deviceID=atoi(instance.DeviceID.c_str());
	
	if(instance.SystemName != systemName ||
		 instance.SystemCreationClassName != systemCreationClassName ||
		 instance.CreationClassName != creationClassName ||
		 !CF_isNumber(instance.DeviceID) ||
		 deviceID >= SMBIOS_processors_information.size() ||
		 deviceID < 0)
	{
		errorMessage="No instance";
		return NOT_FOUND;
	}
	
	CF_assert(Sensors_OpenDRIM_ProcessorVoltageSensor_populate(instance, deviceID, errorMessage));
	_L_;
	return OK;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& newInstance, const OpenDRIM_ProcessorVoltageSensor& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_RequestStateChange_In& in, OpenDRIM_ProcessorVoltageSensor_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_SetPowerState_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_EnableDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_OnlineDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_QuiesceDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_RestoreDefaultThresholds(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorVoltageSensor& instance, unsigned int& returnValue, const OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_In& in, OpenDRIM_ProcessorVoltageSensor_GetNonLinearFactors_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_ProcessorVoltageSensor_populate(OpenDRIM_ProcessorVoltageSensor& instance, int num, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName
	 * [X] SystemName
	 * [X] CreationClassName
	 * [X] DeviceID
	 * [X] BaseUnits
	 * [X] UnitModifier
	 * [X] RateUnits
	 * [X] CurrentReading
	 * [\] SupportedThresholds => cannot fill it
	 * [\] SettableThresholds  => cannot fill it
	 * [X] SensorType
	 * [X] PossibleStates
	 * [\] CurrentState
	 * [X] ElementName
	 * [X] EnabledState
	 * [X] RequestedState
	 * [X] OperationalStatus
	 * [X] HealthState
	 */
	
	vector<unsigned short> OperationalStatus;
	vector<string> power;
	char cmd[256];
	
	// we don't support RequestedStateChange()
	instance.setRequestedState(12);
	
	// default
	instance.setEnabledState(5); // Not Applicable
	
	OperationalStatus.push_back(0); // unknown
	instance.setOperationalStatus(OperationalStatus);
	
	instance.setHealthState(0); // unknown
	instance.setSensorType(3); // Voltage
	instance.setUnitModifier(-3);
	instance.setRateUnits(0); // none
	instance.setBaseUnits(5); // Volts
	
	// set info from SMBIOS
	instance.setCurrentReading(SMBIOS_processors_information[num].voltage);
	
	// set info from /proc/cpuinfo
	instance.setElementName(cpu_info_processors_information[num].name + " Voltage sensor");
	
	sprintf(cmd,"cat /proc/acpi/processor/CPU%d/power",0);
	
	CF_assert(CF_runCommandToLines(cmd,power,0,errorMessage));
	
	// FIXME: Need to be improved
	for(unsigned int i=0;i<power.size();i++)
	{
		vector<string> element;
		
		if(power[i].find("active state")==0)
		{
			CF_splitText(element,power[i]," ");
			instance.setCurrentState(element[2]);
		}
		else if(power[i].find("max_cstate")==0)
		{
			vector<string> states;
			
			CF_splitText(element,power[i]," ");
			unsigned int max=atoi(&(element[1].c_str()[1]));
			
			for(unsigned int j=0;j<=max;j++)
				states.push_back("C"+CF_intToStr(j));
			
			instance.setPossibleStates(states);
		}
	}
	_L_;
	return OK;
}

