/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.AssociationBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class ROIBox
extends JP2Box {
    private Property roiProp;

    public ROIBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        this.initBytesRead();
        int n = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        ArrayList<Property> arrayList = new ArrayList<Property>(n);
        JhoveBase jhoveBase = this._module.getBase();
        boolean bl = jhoveBase.getShowRawFlag();
        for (int i = 0; i < n; ++i) {
            ArrayList<Property> arrayList2 = new ArrayList<Property>(7);
            int n2 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            if (n2 > 1) {
                this._repInfo.setMessage((Message)new ErrorMessage("Invalid data in ROI", this._module.getFilePos()));
                this._repInfo.setValid(false);
            }
            arrayList2.add(this._module.addIntegerProperty("InCodestream", n2, JP2Strings.inCodestreamStr));
            int n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            if (n3 > 1) {
                this._repInfo.setMessage((Message)new ErrorMessage("Invalid region type in ROI Box", this._module.getFilePos()));
                this._repInfo.setValid(false);
            }
            arrayList2.add(this._module.addIntegerProperty("RegionType", n3, JP2Strings.roiTypeStr));
            int n4 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            arrayList2.add(new Property("CodingPriority", PropertyType.INTEGER, (Object)new Integer(n4)));
            long l = this._module.readUnsignedInt(this._dstrm);
            arrayList2.add(new Property("HorizontalLocation", PropertyType.LONG, (Object)new Long(l)));
            long l2 = this._module.readUnsignedInt(this._dstrm);
            arrayList2.add(new Property("HorizontalLocation", PropertyType.LONG, (Object)new Long(l2)));
            long l3 = this._module.readUnsignedInt(this._dstrm);
            arrayList2.add(new Property("Width", PropertyType.LONG, (Object)new Long(l3)));
            long l4 = this._module.readUnsignedInt(this._dstrm);
            arrayList2.add(new Property("Height", PropertyType.LONG, (Object)new Long(l4)));
            arrayList.add(new Property("ROI", PropertyType.PROPERTY, PropertyArity.LIST, arrayList2));
        }
        this.roiProp = new Property("ROIs", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        if (!(this._parentBox instanceof AssociationBox)) {
            if (this._parentBox instanceof CodestreamHeaderBox) {
                Codestream codestream = ((CodestreamHeaderBox)this._parentBox).getCodestream();
                codestream.setROIProperty(this.roiProp);
            } else {
                this._module.addProperty(this.roiProp);
            }
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "ROI Description Box";
    }

    @Override
    protected Property getSelfPropDesc() {
        if (this.roiProp != null) {
            return new Property("Description", PropertyType.PROPERTY, (Object)this.roiProp);
        }
        return null;
    }
}

