#
#   dvdwizard.spec 
#     - SPEC file for dvdwizard rpm creation.
#
#   Copyright (c) 2010-2011 Markus Kohm <kohm at uses.sf.net>
#   Copyright (c) 2012 Joo Martin <joomart2009 at users.sf.net>
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This package is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program. If not, see <http://www.gnu.org/licenses/>.
#

Name:           dvdwizard
Summary:        Automated creation of DVD structure
Summary(de):    Automatisierte Erzeugung einer DVD-Struktur
License:        GPL-3
Group:          Productivity/Multimedia/Video/Editors and Convertors
URL:            http://dvdwizard.sf.net
Version:        @VERSION@
Release:        4
Source0:        %{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-root
BuildArch:      noarch
Requires:       dvdauthor
Requires:       ImageMagick >= 6.3.6
Requires:       mjpegtools >= 1.8
Requires:       /usr/bin/mpeg2enc
Requires:       transcode
Requires:       sed
Requires:       bash
Requires:       bc
BuildRequires:  sed
BuildRequires:  bash

%description
DVDwizard is a collection of scripts for fully automated creation of a DVD 
structure including a title menu, chapter menus optional audio selection menu
and subtitle seclection menu from one or more DVD compatible MPEG streams. 
You may burn the generated DVD structure to a DVD, e.g. using growisofs, and
play this DVD on a stand alone DVD player.

DVDwizard is distributed under GPL 3.

%description -l de
DVDwizard ist eine Sammlung von Scripten zur vollständig automatischen 
Erzeugung einer DVD-Struktur einschließlich Titelmenü, Kapitelmenüs und
bei Bedarf Auswahlmenüs für die Audio-Spur oder für Untertitel aus einem oder 
mehreren MPEG-Streams. Die erzeugte DVD-Struktur kann dann beispielsweise mit 
growisofs auf eine DVD gebrannt werden, um auf einem DVD-Spieler abgespielt
zu werden.

DVDwizard wird unter der GPL 3 verteilt.

%prep
%setup

%build
sed -i "s|prefix *= */usr/local|prefix = /usr|g" Makefile
%{__make}

%install
%{__install} -d -m 755 %{buildroot}%{_bindir}
%{__install} -d -m 755 %{buildroot}%{_sysconfdir}
%{__install} -d -m 755 %{buildroot}%{_datadir}/%{name}
%{__install} -d -m 755 %{buildroot}%{_mandir}/man1
%{__install} -d -m 755 %{buildroot}%{_mandir}/man5
%{__install} -d -m 755 %{buildroot}%{__infodir}
%{makeinstall}
%{__rm} -rf %{buildroot}/%{_datadir}/doc/%{name}

%clean
[ "%{buildroot}" != "/" ] && %{__rm} -rf %{buildroot}

%files
%defattr(-, root, root)
%doc AUTHORS CHANGELOG COPYING CONTRIB README* TODO* TOOLS 
%doc DVDwizard.pdf DVDwizard.html dvdwizard.conf.sample
%dir %{_datadir}/%{name}
%{_bindir}/*
%{_datadir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}.conf
%{_mandir}/man1/dvdwizard.1.gz
%{_mandir}/man1/mk_vmgm.1.gz
%{_mandir}/man1/mk_vtsm.1.gz
%{_mandir}/man5/dvdwizard.conf.5.gz
%{_infodir}/DVDwizard.info.gz

%changelog
* Thu Jun 30 2011 mkohm at users.sf.net
- Workaround for ffmpeg 0.8 floating point exception

* Fri Jul 16 2010 mkohm at users.sf.net
- First version of spec file
