/*
 * Copyright 2009 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;

/**
 * This is a private interface that allows ProxyCreator to provide obfuscated
 * type names to the server components via {@link StandardSerializationPolicy}.
 * <p>
 * The particulars of the implementation are deeply tied to the specifics of the
 * RPC wire format and the code generated by TypeSerializerCreator.
 * <p>
 * This interface is not public in order to allow the API to be switched from
 * Strings to ints in a future revision.
 */
public interface TypeNameObfuscator {
  /**
   * A reserved ID for specifying the identifier for the service interface
   * itself.
   */
  String SERVICE_INTERFACE_ID = "_";

  /*
   * TODO: Replace strings with integral constants once the RPC whitelist can be
   * given as a hard requirement for deploying GWT-RPC.
   */
  /**
   * Returns the name of the class that should be instantiated based on an
   * obfuscated identifier.
   * 
   * @param id the type id that was present in the RPC payload
   * @return the name of the class, suitable for use by {@link Class#forName},
   *         to be instantiated
   * @throws SerializationException if there is no class that corresponds to the
   *           obfuscated id
   */
  String getClassNameForTypeId(String id) throws SerializationException;

  /**
   * Returns the obfuscated identifier to be used to encode a class in the RPC
   * wire format.
   * 
   * @param clazz the class to be transmitted
   * @return the obfuscated type identifier.
   * @throws SerializationException
   */
  String getTypeIdForClass(Class<?> clazz) throws SerializationException;
}
