/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.i18n.client.CurrencyData;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NumberLabelParser
implements ElementParser {
    static final String AT_MOST_ONE_SPECIFIED_FORMAT = "May have only one of format, predefinedFormat and customFormat.";
    static final String AT_MOST_ONE_SPECIFIED_CURRENCY = "May have only one of currencyData and customCode.";
    static final String NO_CURRENCY_WITH_FORMAT = "May not specify both a NumberFormat and a currency code.";
    static final String NO_CURRENCY_WITHOUT_SPECIFIED_FORMAT = "May not specify a currency code if no format is given.";
    static final String NO_CURRENCY_WITH_PREDEFINED_FORMAT = "May not specify a currency code with a predefined format (except the CURRENCY format)";
    static final String UNKNOWN_PREDEFINED_FORMAT = "Unknown predefined format: %s";
    private static final Map<String, String> predefinedFormats;

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String format;
        if (this.hasNumberFormatConstructor(writer.getOracle(), type) && (format = this.consumeFormat(elem, writer)) != null) {
            writer.setFieldInitializerAsConstructor(fieldName, type, new String[]{format});
        }
    }

    private String consumeCurrency(XMLElement elem, UiBinderWriter writer) throws UnableToCompleteException {
        String currencyData = elem.consumeAttribute("currencyData", (JType)writer.getOracle().findType(CurrencyData.class.getCanonicalName()));
        String currencyCode = elem.consumeStringAttribute("currencyCode");
        if (currencyData != null && currencyCode != null) {
            writer.die(elem, AT_MOST_ONE_SPECIFIED_CURRENCY, new Object[0]);
        }
        return currencyData != null ? currencyData : currencyCode;
    }

    private String consumeFormat(XMLElement elem, UiBinderWriter writer) throws UnableToCompleteException {
        String format = elem.consumeAttribute("format", (JType)writer.getOracle().findType(NumberFormat.class.getCanonicalName()));
        String predefinedFormat = elem.consumeRawAttribute("predefinedFormat");
        String customFormat = elem.consumeStringAttribute("customFormat");
        if (format != null) {
            if (predefinedFormat != null || customFormat != null) {
                writer.die(elem, AT_MOST_ONE_SPECIFIED_FORMAT, new Object[0]);
            }
            if (this.hasCurrency(elem)) {
                writer.die(elem, NO_CURRENCY_WITH_FORMAT, new Object[0]);
            }
            return format;
        }
        if (predefinedFormat != null) {
            String f;
            if (customFormat != null) {
                writer.die(elem, AT_MOST_ONE_SPECIFIED_FORMAT, new Object[0]);
            }
            if ("CURRENCY".equals(predefinedFormat)) {
                String currency = this.consumeCurrency(elem, writer);
                return NumberFormat.class.getCanonicalName() + ".getCurrencyFormat(" + (currency != null ? currency : "") + ")";
            }
            if (this.hasCurrency(elem)) {
                writer.die(elem, NO_CURRENCY_WITH_PREDEFINED_FORMAT, new Object[0]);
            }
            if ((f = predefinedFormats.get(predefinedFormat)) == null) {
                writer.die(elem, UNKNOWN_PREDEFINED_FORMAT, new Object[]{predefinedFormat});
            }
            return f;
        }
        if (customFormat != null) {
            String currency = this.consumeCurrency(elem, writer);
            return NumberFormat.class.getCanonicalName() + ".getFormat(" + customFormat + (currency != null ? ", " + currency : "") + ")";
        }
        if (this.hasCurrency(elem)) {
            writer.die(elem, NO_CURRENCY_WITHOUT_SPECIFIED_FORMAT, new Object[0]);
        }
        return null;
    }

    private boolean hasCurrency(XMLElement elem) {
        return elem.hasAttribute("currencyData") || elem.hasAttribute("currencyCode");
    }

    private boolean hasNumberFormatConstructor(TypeOracle typeOracle, JClassType type) {
        JClassType numberFormatType = typeOracle.findType(NumberFormat.class.getName());
        return type.findConstructor(new JType[]{numberFormatType}) != null;
    }

    static {
        String prefix = NumberFormat.class.getCanonicalName();
        HashMap<String, String> formats = new HashMap<String, String>(4);
        formats.put("DECIMAL", prefix + ".getDecimalFormat()");
        formats.put("PERCENT", prefix + ".getPercentFormat()");
        formats.put("SCIENTIFIC", prefix + ".getScientificFormat()");
        predefinedFormats = Collections.unmodifiableMap(formats);
    }
}

